/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.log.CFLogs;
import coldfusion.pdf.DataXMLGenerator;
import coldfusion.pdf.FormParamDetail;
import coldfusion.pdf.MatchedNode;
import coldfusion.pdf.PDFFormException;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class XFADataXMLGenerator
extends DataXMLGenerator {
    private static final String XFANS = "http://www.xfa.org/schema/xfa-data/1.0/";
    private static final String FORM1 = "form1";
    private static final String VALUE = "value";
    private Document doc = null;
    private ArrayList subforms = new ArrayList();
    private PDFDocument PDFdoc = null;
    boolean isCfsubformTagPresent = false;
    private HashMap formParamsMap = new HashMap();

    public XFADataXMLGenerator(PDFDocument PDFdoc) {
        this.PDFdoc = PDFdoc;
    }

    @Override
    public void createFormXMLData(boolean overwritedata) throws PDFSecurityException, PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException {
        if (overwritedata) {
            if (!this.createFormRootElement()) {
                return;
            }
        } else {
            String previousDataXML = this.getOldDataXML();
            if (previousDataXML != null) {
                StringReader stringStream = new StringReader(previousDataXML);
                SAXBuilder builder = new SAXBuilder();
                try {
                    this.doc = builder.build((Reader)stringStream);
                }
                catch (IOException ioex) {
                    throw new PDFFormException(ioex);
                }
                catch (JDOMException jdomex) {
                    throw new PDFFormException(jdomex);
                }
            } else if (this.createFormRootElement()) {
                return;
            }
        }
        for (int i = 0; i < this.formParams.size(); ++i) {
            Object[] searchNodeDetail = (Object[])this.formParams.get(i);
            MatchedNode node = this.searchNodes(this.doc, searchNodeDetail);
            if (node.getDepth() == -1) {
                node.setNode(this.doc);
            }
            this.setNodeValues(node, searchNodeDetail);
        }
    }

    @Override
    public void addChildNode(String nodeName, Object obj, int sequence) {
        Object[] navigationPath = new Object[this.subforms.size() + 1];
        for (int i = 0; i < this.subforms.size(); ++i) {
            FormParamDetail detail = (FormParamDetail)this.peekSubform(i);
            navigationPath[i] = detail;
        }
        navigationPath[this.subforms.size()] = obj instanceof List ? new FormParamDetail(nodeName, (List)obj, sequence) : new FormParamDetail(nodeName, Cast._String((Object)obj), sequence);
        this.formParams.add(navigationPath);
    }

    @Override
    public String toString() {
        byte[] DOMBytes = this.getXML();
        return new String(DOMBytes);
    }

    @Override
    public void pushSubform(String subformName, int sequence) {
        FormParamDetail detail = new FormParamDetail(subformName, sequence);
        this.subforms.add(detail);
    }

    @Override
    public Object popSubform() {
        return (FormParamDetail)this.subforms.remove(this.subforms.size() - 1);
    }

    private Object peekSubform(int i) {
        return (FormParamDetail)this.subforms.get(i);
    }

    String getOldDataXML() throws PDFSecurityException, PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XFAService.exportElement((PDFDocument)this.PDFdoc, (XFAService.XFAElement)XFAService.XFAElement.DATASETS, (OutputStream)out);
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            throw new PDFFormException(ueex);
        }
    }

    private int getNumOfSameElementWithinNode(Parent node, String elementName) {
        if (node instanceof Document) {
            node = ((Document)node).getRootElement();
        }
        List children = node.getContent();
        Iterator iterator = children.iterator();
        int xmlElementCount = 0;
        while (iterator.hasNext()) {
            Element childElem;
            Object child = iterator.next();
            if (!(child instanceof Element) || !(childElem = (Element)child).getName().equalsIgnoreCase(elementName)) continue;
            ++xmlElementCount;
        }
        return xmlElementCount;
    }

    private void setNodeValues(MatchedNode node, Object[] searchNodeDetail) {
        FormParamDetail pdfformParamDetail = (FormParamDetail)searchNodeDetail[searchNodeDetail.length - 1];
        String value = pdfformParamDetail.getValue();
        List listBoxSelection = pdfformParamDetail.getListBoxSelection();
        int sequence = pdfformParamDetail.getSequence();
        if (value == null && listBoxSelection == null) {
            throw new PDFFormException(RB.getString(PDFFormException.class, (String)"cfpdfform.invalidUseofpdfformtags"));
        }
        if (node.getDepth() == searchNodeDetail.length - 1) {
            if (sequence == 1) {
                Element elem = (Element)node.getNode();
                if (value != null || listBoxSelection != null) {
                    this.setText(elem, pdfformParamDetail);
                }
            } else {
                Parent parent = ((Parent)node.getNode()).getParent();
                List contentList = parent.getContent();
                Iterator iterator = contentList.iterator();
                Element o = null;
                int count = 0;
                while (iterator.hasNext()) {
                    Object child = iterator.next();
                    if (!(child instanceof Element)) continue;
                    Element childElem = (Element)child;
                    FormParamDetail formParamDetail = (FormParamDetail)searchNodeDetail[searchNodeDetail.length - 1];
                    if (!childElem.getName().equalsIgnoreCase(formParamDetail.getName())) continue;
                    o = childElem;
                    if (sequence != ++count) continue;
                    break;
                }
                if (count == sequence) {
                    if (value != null || listBoxSelection != null) {
                        this.setText(o, pdfformParamDetail);
                    }
                } else {
                    for (int i = 0; i < sequence - count; ++i) {
                        FormParamDetail formParamDetail = (FormParamDetail)searchNodeDetail[searchNodeDetail.length - 1];
                        Element newChild = new Element(formParamDetail.getName());
                        if (i == sequence - count - 1 && (value != null || listBoxSelection != null)) {
                            this.setText(newChild, pdfformParamDetail);
                        }
                        if (parent instanceof Document) {
                            ((Document)parent).getRootElement().addContent((Content)newChild);
                            continue;
                        }
                        if (!(parent instanceof Element)) continue;
                        ((Element)parent).addContent((Content)newChild);
                    }
                }
            }
        } else {
            FormParamDetail formParamDetail = (FormParamDetail)searchNodeDetail[node.getDepth() + 1];
            Element currentNode = null;
            currentNode = node.getNode() instanceof Document ? ((Document)node.getNode()).getRootElement() : (Element)node.getNode();
            int sameChildElementCount = this.getNumOfSameElementWithinNode((Parent)node.getNode(), formParamDetail.getName());
            for (int j = 1; j <= formParamDetail.getSequence() - sameChildElementCount; ++j) {
                currentNode = new Element(formParamDetail.getName());
                if (node.getNode() instanceof Document) {
                    Document docNode = (Document)node.getNode();
                    docNode.getRootElement().addContent((Content)currentNode);
                    continue;
                }
                if (!(node.getNode() instanceof Element)) continue;
                Element currentElem = (Element)node.getNode();
                currentElem.addContent((Content)currentNode);
            }
            for (int i = node.getDepth() + 2; i < searchNodeDetail.length; ++i) {
                formParamDetail = (FormParamDetail)searchNodeDetail[i];
                Element newNode = null;
                for (int j = 1; j <= formParamDetail.getSequence(); ++j) {
                    newNode = new Element(formParamDetail.getName());
                    currentNode.addContent((Content)newNode);
                }
                currentNode = newNode;
            }
            if (value != null || listBoxSelection != null) {
                this.setText(currentNode, pdfformParamDetail);
            }
        }
    }

    private MatchedNode searchNodes(Object o, Object[] searchDetail) {
        if (searchDetail == null) {
            throw new PDFFormException();
        }
        int depth = searchDetail.length;
        for (int i = 0; i < depth; ++i) {
            List children = null;
            boolean matched = false;
            if (o instanceof Parent) {
                children = ((Parent)o).getContent();
            }
            if (children == null) {
                return new MatchedNode(null, i - 1);
            }
            Iterator iterator = children.iterator();
            int xmlElementCount = 0;
            while (iterator.hasNext()) {
                Object child = iterator.next();
                if (child instanceof Element) {
                    Element childElem = (Element)child;
                    FormParamDetail formParamDetail = (FormParamDetail)searchDetail[i];
                    if (!childElem.getName().equalsIgnoreCase(formParamDetail.getName()) || ++xmlElementCount != formParamDetail.getSequence()) continue;
                    o = childElem;
                    matched = true;
                    break;
                }
                return new MatchedNode(null, i - 1);
            }
            if (!matched) {
                if (i == 0) {
                    Element e = new Element(((FormParamDetail)searchDetail[0]).getName());
                    this.doc = new Document(e);
                    return new MatchedNode(e, 0);
                }
                return new MatchedNode(o, i - 1);
            }
            if (i != depth - 1) continue;
            return new MatchedNode(o, i);
        }
        throw new PDFFormException();
    }

    @Override
    public byte[] getXML() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLOutputter outputter = new XMLOutputter();
        try {
            if (this.doc != null) {
                outputter.output(this.doc.getRootElement(), (OutputStream)out);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] preBytes = "<xfa:datasets xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\"><xfa:data>".getBytes();
        byte[] postBytes = "</xfa:data></xfa:datasets>".getBytes();
        byte[] pdfDocBytes = out.toByteArray();
        byte[] resultBytes = new byte[preBytes.length + postBytes.length + pdfDocBytes.length];
        System.arraycopy(preBytes, 0, resultBytes, 0, preBytes.length);
        System.arraycopy(pdfDocBytes, 0, resultBytes, preBytes.length, pdfDocBytes.length);
        System.arraycopy(postBytes, 0, resultBytes, preBytes.length + pdfDocBytes.length, postBytes.length);
        return resultBytes;
    }

    private boolean createFormRootElement() {
        if (this.formParams.size() > 0) {
            try {
                Object[] searchNodeDetail = (Object[])this.formParams.get(0);
                String pdfformparam = ((FormParamDetail)searchNodeDetail[0]).getName();
                Element e = new Element(pdfformparam);
                this.doc = new Document(e);
                return true;
            }
            catch (Exception ex) {
                CFLogs.SERVER_LOG.info((Object)"Pdforms - Data xml root element cannot be created", (Throwable)ex);
                return false;
            }
        }
        return false;
    }

    private void convertFormParam2String(Object[] searchNodeDetail) {
        StringBuffer name = new StringBuffer();
        String separator = "";
        FormParamDetail formParamDetail = null;
        for (int i = 0; i < searchNodeDetail.length; ++i) {
            formParamDetail = (FormParamDetail)searchNodeDetail[i];
            name.append(separator);
            name.append(formParamDetail.getName()).append("[").append(formParamDetail.getSequence() - 1).append("]");
            separator = ".";
        }
        this.formParamsMap.put(name.toString(), formParamDetail.getValue());
    }

    void setAllPDFFieldAppearance() {
        try {
            PDFInteractiveForm pdfinteractiveform = this.PDFdoc.getInteractiveForm();
            PDFFieldList fieldList = null;
            if (pdfinteractiveform != null) {
                fieldList = pdfinteractiveform.getChildren();
            }
            this.setPDFFieldAppearance(fieldList);
        }
        catch (Exception ex) {
            CFLogs.SERVER_LOG.info((Object)"Pdfforms - PDF Form Field Appearance could not be filled : ", (Throwable)ex);
        }
    }

    private void setPDFFieldAppearance(PDFFieldList fieldList) throws Exception {
        PDFFieldNode field2 = null;
        if (fieldList != null) {
            for (PDFFieldNode field2 : fieldList) {
                if (field2 == null) continue;
                PDFFieldList childFieldList = field2.getChildren();
                if (childFieldList == null) {
                    try {
                        int index;
                        String qualifiedFieldName = this.normalizeFieldname(field2.getQualifiedName());
                        boolean comboOrListBox = field2 instanceof PDFFieldChoice;
                        String strInMap = null;
                        for (String tempStr : this.formParamsMap.keySet()) {
                            if (comboOrListBox) {
                                tempStr = tempStr.replaceAll(".(?i)value\\[[0-9]++\\]", "");
                            }
                            if (!qualifiedFieldName.toUpperCase().endsWith(tempStr.toUpperCase()) || strInMap != null && strInMap.length() <= tempStr.length()) continue;
                            strInMap = tempStr;
                        }
                        if (strInMap == null) {
                            String remQFieldName = qualifiedFieldName.replaceAll("(?i)body\\[[0-9]++\\].", "");
                            remQFieldName = remQFieldName.replaceAll("(?i)header\\[[0-9]++\\].", "");
                            remQFieldName = remQFieldName.replaceAll("(?i)footer\\[[0-9]++\\].", "");
                            remQFieldName = remQFieldName.replaceAll("(?i)p\\[[0-9]++\\].", "");
                            remQFieldName = remQFieldName.replaceAll("(?i)i\\[[0-9]++\\].", "");
                            remQFieldName = remQFieldName.replaceAll("(?i)b\\[[0-9]++\\].", "");
                            remQFieldName = remQFieldName.replaceAll("(?i)span\\[[0-9]++  \\].", "");
                            for (String tempStr : this.formParamsMap.keySet()) {
                                if (comboOrListBox) {
                                    tempStr = tempStr.replaceAll(".(?i)value\\[[0-9]++\\]", "");
                                }
                                if (!remQFieldName.toUpperCase().endsWith(tempStr.toUpperCase()) || strInMap != null && strInMap.length() <= tempStr.length()) continue;
                                strInMap = tempStr;
                                break;
                            }
                        }
                        if (strInMap == null) {
                            Iterator formKeys1 = this.formParamsMap.keySet().iterator();
                            int maxLengthStr = 0;
                            while (formKeys1.hasNext()) {
                                String tempStr;
                                tempStr = (String)formKeys1.next();
                                if (comboOrListBox) {
                                    tempStr = tempStr.replaceAll(".(?i)value\\[[0-9]++\\]", "");
                                }
                                StringTokenizer tokens = new StringTokenizer(tempStr, ".");
                                Stack<String> stack = new Stack<String>();
                                while (tokens.hasMoreTokens()) {
                                    stack.push(tokens.nextToken());
                                }
                                PDFFieldNode tempField = field2;
                                boolean success = true;
                                block7: while (!stack.isEmpty() && tempField != null) {
                                    String tkn = (String)stack.pop();
                                    boolean doBreak = false;
                                    do {
                                        if (tempField instanceof PDFField || tempField instanceof PDFInteractiveForm) {
                                            if (tempField.getPartialName().startsWith(tkn)) {
                                                tempField = tempField.getParent();
                                                doBreak = true;
                                                continue;
                                            }
                                            success = false;
                                            break block7;
                                        }
                                        if (tempField.getPartialName().startsWith(tkn)) {
                                            tempField = tempField.getParent();
                                            doBreak = true;
                                            continue;
                                        }
                                        if ((tempField = tempField.getParent()) != null) continue;
                                        success = false;
                                        break block7;
                                    } while (!doBreak);
                                }
                                if (!success || !stack.isEmpty() || tempStr.length() <= maxLengthStr) continue;
                                strInMap = tempStr;
                                maxLengthStr = tempStr.length();
                            }
                        }
                        if (strInMap == null) continue;
                        Object obj = this.formParamsMap.get(strInMap);
                        if (obj != null && obj instanceof String) {
                            field2.setStringValue((String)this.formParamsMap.get(strInMap));
                        }
                        if (comboOrListBox) {
                            PDFFieldChoice choiceField = (PDFFieldChoice)field2;
                            if (choiceField.isMultipleSelectionAllowed()) {
                                int j = 0;
                                Object option = null;
                                ArrayList<Object> optionList = new ArrayList<Object>(5);
                                while (true) {
                                    Object v = this.formParamsMap.get(new StringBuffer(strInMap).append(".value[").append(j).append("]").toString());
                                    option = v;
                                    if (v == null) break;
                                    optionList.add(option);
                                    ++j;
                                }
                                choiceField.setListValue(optionList);
                            }
                            choiceField.setOptIndex();
                            continue;
                        }
                        if (!(field2 instanceof PDFFieldButton)) continue;
                        PDFFieldButton pdfField = (PDFFieldButton)field2;
                        if (pdfField.isCheckBox()) {
                            field2.setNameValue(ASName.create((String)((String)this.formParamsMap.get(strInMap))));
                        } else if (pdfField.isRadioButton() && (index = this.setRadiButtonAppearance(field2.getParent(), (String)this.formParamsMap.get(strInMap))) != -1) {
                            field2.setDictionaryNameValue(ASName.k_V, String.valueOf(index));
                        }
                        pdfField.setStateFromValue();
                        continue;
                    }
                    catch (ClassCastException ccex) {
                        throw new DataXMLGenerator.ListBoxValueException(ccex);
                    }
                }
                this.setPDFFieldAppearance(childFieldList);
            }
        }
    }

    void storeInFormParamsMap() {
        for (int i = 0; i < this.formParams.size(); ++i) {
            Object[] searchNodeDetail = (Object[])this.formParams.get(i);
            this.convertFormParam2String(searchNodeDetail);
        }
    }

    private String normalizeFieldname(String qualifiedfieldName) {
        String separator = "";
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(qualifiedfieldName, ".");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("#")) continue;
            sb.append(separator);
            sb.append(token);
            separator = ".";
        }
        return sb.toString();
    }

    private int setRadiButtonAppearance(PDFFieldNode field, String suppliedValue) throws PDFException {
        CosArray array = (CosArray)field.getCosDictionary().get(ASName.k_Opt);
        if (array != null) {
            return array.findString(new ASString(suppliedValue));
        }
        return -1;
    }

    private void setText(Element elem, FormParamDetail pdfformParamDetail) {
        boolean listBox = pdfformParamDetail.isListBox();
        if (listBox) {
            List listBoxSelection = pdfformParamDetail.getListBoxSelection();
            String selectedOption = null;
            Iterator iter = listBoxSelection.iterator();
            while (iter.hasNext()) {
                try {
                    selectedOption = (String)iter.next();
                }
                catch (ClassCastException classcastex) {
                    throw new DataXMLGenerator.ListBoxValueException(classcastex);
                }
                Element newChild = new Element(VALUE);
                newChild.setText(selectedOption);
                elem.addContent((Content)newChild);
            }
        } else {
            String text = pdfformParamDetail.getValue();
            elem.setText(text);
        }
    }
}

