/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.pdf.DataXMLGenerator;
import coldfusion.pdf.FormParamDetail;
import coldfusion.pdf.PDFFormException;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import java.util.ArrayList;
import java.util.List;

public class FDFDataGenerator
extends DataXMLGenerator {
    private StringBuilder mFdfContents = null;
    private FDFSubForm subforms;
    FDFSubForm curSubForm = this.subforms = new FDFSubForm(null);

    public FDFDataGenerator() {
        this.mFdfContents = new StringBuilder();
    }

    @Override
    public void addChildNode(String nodeName, Object obj, int sequence) {
        if (sequence > 1) {
            throw new PDFFormException(RB.getString(PDFFormException.class, (String)"cfpdfform.indexNotValidInAcroform"));
        }
        if (this.curSubForm == null) {
            this.curSubForm = new FDFSubForm(null);
        }
        if (obj instanceof List) {
            this.curSubForm.add(new FormParamDetail(nodeName, (List)obj, sequence));
        } else {
            this.curSubForm.add(new FormParamDetail(nodeName, Cast._String((Object)obj), sequence));
        }
    }

    @Override
    public byte[] getXML() {
        return this.toString().getBytes();
    }

    @Override
    public Object popSubform() {
        this.curSubForm = this.search(this.subforms);
        return null;
    }

    private FDFSubForm search(FDFSubForm form) {
        for (Object subform : form.subforms) {
            Object temp = subform;
            if (!(temp instanceof FDFSubForm)) continue;
            if (this.curSubForm == temp) {
                return form;
            }
            if ((temp = this.search((FDFSubForm)temp)) == null) continue;
            return (FDFSubForm)temp;
        }
        return null;
    }

    @Override
    public void pushSubform(String subformName, int index) {
        if (index > 1) {
            throw new PDFFormException(RB.getString(PDFFormException.class, (String)"cfpdfform.indexNotValidInAcroform"));
        }
        FDFSubForm form = new FDFSubForm(subformName);
        this.curSubForm.add(form);
        this.curSubForm = form;
    }

    @Override
    public void createFormXMLData(boolean overwritedata) throws Exception {
        for (Object formParam : this.subforms.subforms) {
            if (formParam instanceof FDFSubForm) {
                this.addSubFormVal((FDFSubForm)formParam);
                continue;
            }
            this.addKeyValPair(((FormParamDetail)formParam).getName(), ((FormParamDetail)formParam).getValue());
        }
    }

    private void addSubFormVal(FDFSubForm sub) {
        this.mFdfContents.append("<</Kids[");
        for (Object obj : sub.subforms) {
            if (obj instanceof FDFSubForm) {
                this.addSubFormVal((FDFSubForm)obj);
                continue;
            }
            this.addKeyValPair(((FormParamDetail)obj).getName(), ((FormParamDetail)obj).getValue());
        }
        this.mFdfContents.append("]/T(");
        this.mFdfContents.append(sub.name);
        this.mFdfContents.append(")>>");
    }

    private void addKeyValPair(Object key, Object value) {
        this.mFdfContents.append("<< /T (");
        this.mFdfContents.append(key.toString());
        this.mFdfContents.append(")");
        this.mFdfContents.append(" /V ");
        if (value instanceof Boolean) {
            if (value == Boolean.TRUE) {
                this.mFdfContents.append("/Yes");
            } else {
                this.mFdfContents.append("/Off");
            }
        } else {
            this.mFdfContents.append("(");
            this.mFdfContents.append(value.toString().replace('\n', '\r'));
            this.mFdfContents.append(")>>\n");
        }
    }

    @Override
    public String toString() {
        return this.getFdfContent();
    }

    public String getFdfContent() {
        StringBuffer contents = new StringBuffer();
        contents.append("%FDF-1.2\n");
        contents.append("%\u00e2\u00e3\u00cf\u00d3\n");
        contents.append("1 0 obj\n");
        contents.append("<< /FDF << /Fields 2 0 R >>\n");
        contents.append(">>\nendobj\n");
        contents.append("2 0 obj\n");
        contents.append("[\n");
        contents.append(this.mFdfContents.toString());
        contents.append("]\n");
        contents.append(">>\nendobj\ntrailer\n<<\n/Root 1 0 R\n>>\n%%EOF\n");
        return contents.toString();
    }

    class FDFSubForm {
        ArrayList subforms = null;
        String name = null;

        public FDFSubForm(String name) {
            this.name = name;
            this.subforms = new ArrayList();
        }

        public void add(Object obj) {
            this.subforms.add(obj);
        }
    }
}

