/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.codecs;

import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentReferenceImpl;
import coldfusion.cloud.gcp.firestore.util.FirestoreUtils;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.CaseSensitiveStruct;
import coldfusion.runtime.Cast;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.Blob;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.GeoPoint;
import java.util.List;
import java.util.Map;

public class FirestoreDeserializer {
    public static CaseSensitiveStruct deSerializeMap(Map<String, Object> fields) {
        CaseSensitiveStruct itemMap = new CaseSensitiveStruct();
        fields.forEach((key, value) -> itemMap.put(key, FirestoreDeserializer.deSerialize(value)));
        return itemMap;
    }

    public static Array deSerializeList(List<?> objectList) {
        Array itemList = new Array();
        objectList.forEach(value -> itemList.add(FirestoreDeserializer.deSerialize(value)));
        return itemList;
    }

    public static Object deSerialize(Object value) {
        if (value instanceof Boolean) {
            return new CFBoolean(((Boolean)value).toString(), ((Boolean)value).booleanValue());
        }
        if (value instanceof Double) {
            return new CFDouble(((Double)value).doubleValue(), Cast._String((Object)value));
        }
        if (value instanceof Map) {
            return FirestoreDeserializer.deSerializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(value));
        }
        if (value instanceof Blob) {
            return ((Blob)value).toBytes();
        }
        if (value instanceof List) {
            return FirestoreDeserializer.deSerializeList((List)value);
        }
        if (value instanceof DocumentReference) {
            return new FirestoreDocumentReferenceImpl((DocumentReference)value);
        }
        if (value instanceof GeoPoint) {
            return ((GeoPoint)value).toString();
        }
        if (value instanceof Timestamp) {
            return FirestoreUtils.getPrecisedDate((Timestamp)value);
        }
        return value;
    }
}

