/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ContactAddress;
import coldfusion.exchange.ContactFilterInfo;
import coldfusion.exchange.ContactOtherDetails;
import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.ExchangeContact;
import coldfusion.exchange.webdav.Utils;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Struct;
import coldfusion.tagext.net.exchange.ContactConstants;
import coldfusion.tagext.net.exchange.ContactQuery;
import coldfusion.tagext.net.exchange.ExchangeContactTag;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.validation.RequiredAttributesException;
import java.util.ArrayList;
import java.util.Map;

public class ContactTagHelper
implements ContactConstants {
    public static void getContacts(ExchangeContactTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        ContactFilterInfo filter = tag.getFilterInfo();
        ArrayList results = null;
        try {
            results = con.getContacts(filter);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        ContactQuery queryResult = new ContactQuery();
        queryResult.populate(results);
        tag.getPageContext().setAttribute(tag.getName(), (Object)queryResult);
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void saveContact(ExchangeContactTag tag, Map contact, boolean isNew) {
        String uidVarName;
        ContactAddress addr;
        if (!isNew && tag.getUid() != null && tag.getUid().indexOf(44) != -1) {
            ExchangeExceptions.throwMultipleUIDsInModifyActionException("cfexchangecontact");
        }
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        ExchangeContact ct = new ExchangeContact();
        ct.setFirstName(tag.getStringAttribute(contact, "FirstName", false));
        ct.setLastName(tag.getStringAttribute(contact, "LastName", false));
        ct.setMiddleName(tag.getStringAttribute(contact, "MiddleName", false));
        ct.setCompany(tag.getStringAttribute(contact, "Company", false));
        ct.setDescription(tag.getStringAttribute(contact, "Description", false));
        ct.setDislpayName(tag.getStringAttribute(contact, "DisplayAs", false));
        ct.setEMail1(tag.getStringAttribute(contact, "Email1", false));
        ct.setEMail2(tag.getStringAttribute(contact, "Email2", false));
        ct.setEMail3(tag.getStringAttribute(contact, "Email3", false));
        ct.setBusinessFax(tag.getStringAttribute(contact, "businessFax", false));
        String mailingType = tag.getStringAttribute(contact, "mailingAddressType", false);
        if (mailingType != null) {
            int type = ExchangeContactTag.parseMailingAddressType(mailingType);
            if (type == -1) {
                ExchangeExceptions.throwInvalidMailingAddressType("mailingAddressType");
            }
            ct.setMailingAdressType(type);
        }
        ct.setHomePhone(tag.getStringAttribute(contact, "HomePhoneNumber", false));
        ct.setBusinessPhone(tag.getStringAttribute(contact, "BusinessPhoneNumber", false));
        ct.setJobTitle(tag.getStringAttribute(contact, "JobTitle", false));
        ct.setMobilePhone(tag.getStringAttribute(contact, "MobilePhoneNumber", false));
        ct.setPager(tag.getStringAttribute(contact, "Pager", false));
        ct.setCategories(tag.getStringAttribute(contact, "Categories", false));
        ct.setBusinessHomePage(tag.getStringAttribute(contact, "WebPage", false));
        ct.setOtherPhone(tag.getStringAttribute(contact, "OtherPhoneNumber", false));
        Object tmpObj = contact.get("HomeAddress");
        Struct stAddr = null;
        if (tmpObj != null) {
            if (!CFPage.IsStruct(tmpObj)) {
                ExchangeExceptions.throwInvalidStructValueException("HomeAddress");
            }
            stAddr = (Struct)tmpObj;
            addr = tag.mapToContactAddress((Map)stAddr, "HomeAddress");
            ct.setHomeAddress(addr);
        }
        if ((tmpObj = contact.get("BusinessAddress")) != null) {
            if (!CFPage.IsStruct(tmpObj)) {
                ExchangeExceptions.throwInvalidStructValueException("BusinessAddress");
            }
            stAddr = (Struct)tmpObj;
            addr = tag.mapToContactAddress((Map)stAddr, "BusinessAddress");
            ct.setBusinessAddress(addr);
        }
        if ((tmpObj = contact.get("OtherAddress")) != null) {
            if (!CFPage.IsStruct(tmpObj)) {
                ExchangeExceptions.throwInvalidStructValueException("OtherAddress");
            }
            stAddr = (Struct)tmpObj;
            addr = tag.mapToContactAddress((Map)stAddr, "OtherAddress");
            ct.setOtherAddress(addr);
        }
        ContactOtherDetails dtls = new ContactOtherDetails();
        dtls.setOffice(tag.getStringAttribute(contact, "Office", false));
        dtls.setProfession(tag.getStringAttribute(contact, "Profession", false));
        dtls.setManager(tag.getStringAttribute(contact, "Manager", false));
        dtls.setAssistant(tag.getStringAttribute(contact, "Assistant", false));
        dtls.setNickname(tag.getStringAttribute(contact, "NickName", false));
        dtls.setPartner(tag.getStringAttribute(contact, "SpouseName", false));
        dtls.setDepartment(tag.getStringAttribute(contact, "Department", false));
        ct.setDetails(dtls);
        String attachmentPaths = tag.getStringAttribute(contact, "attachments", false);
        String[] attachedFileNames = null;
        Object[] attachedFilecontent = null;
        if (attachmentPaths != null) {
            Object[] tmpArray = tag.readAttachmentFiles(attachmentPaths);
            attachedFileNames = (String[])tmpArray[0];
            attachedFilecontent = (Object[])tmpArray[1];
        }
        if (!isNew) {
            String id = tag.getUid();
            if (id == null) {
                throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
            }
            ct.setId(id);
        } else if (ct.getDislpayName() == null) {
            String firstName = ct.getFirstName();
            String lastName = ct.getLastName();
            if (lastName != null && firstName != null) {
                ct.setDislpayName(lastName + "," + firstName);
            } else if (lastName == null && firstName != null) {
                ct.setDislpayName(firstName);
            } else if (lastName != null) {
                ct.setDislpayName(lastName);
            }
        }
        try {
            if (isNew) {
                if (attachmentPaths != null) {
                    con.createContact(ct, attachedFileNames, attachedFilecontent);
                } else {
                    con.createContact(ct);
                }
            } else if (attachmentPaths != null) {
                con.modifyContact(ct, attachedFileNames, attachedFilecontent);
            } else {
                con.modifyContacts(new String[]{ct.getId()}, ct);
            }
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (isNew && (uidVarName = tag.getResult()) != null) {
            tag.getPageContext().setAttribute(uidVarName, (Object)ct.getId());
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    static void deleteContacts(ExchangeContactTag tag) {
        String uids;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        if ((uids = tag.getUid()) == null) {
            throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
        }
        String[] uidArray = Utils.splitString(uids);
        try {
            con.deleteContacts(uidArray);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }
}

