/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.cms.CompressedData;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSUtils;

public class CMSCompressedData {
    ContentInfo contentInfo;

    public CMSCompressedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSCompressedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSCompressedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
    }

    public byte[] getContent() throws CMSException {
        CompressedData compressedData = CompressedData.getInstance((Object)this.contentInfo.getContent());
        ContentInfo contentInfo = compressedData.getEncapContentInfo();
        ASN1OctetString aSN1OctetString = (ASN1OctetString)contentInfo.getContent();
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(aSN1OctetString.getOctets()));
        try {
            return CMSUtils.streamToByteArray(inflaterInputStream);
        }
        catch (IOException iOException) {
            throw new CMSException("exception reading compressed stream.", iOException);
        }
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

