/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webservice;

import coldfusion.exchange.ExchangeLoginInfo;

public class EWSLoginInfo
extends ExchangeLoginInfo {
    private static final String EWS_EXCHANGE_ASMX = "/ews/Exchange.asmx";

    public EWSLoginInfo(String serverVersion) {
        this.setExchangeVersion(serverVersion);
    }

    @Override
    public String getExchangeUrl() {
        StringBuilder buf = new StringBuilder(this.getProtocol());
        buf.append("://");
        buf.append(this.getExchangeHost());
        int port = this.getPort();
        if (port != -1) {
            buf.append(":" + port);
        }
        buf.append(EWS_EXCHANGE_ASMX);
        return buf.toString();
    }

    @Override
    public String getUrlForFormedBasedAuthentication() {
        if (this.getFormBasedAuthenticationUrl() != null) {
            return this.getFormBasedAuthenticationUrl();
        }
        StringBuilder buf = new StringBuilder(this.getProtocol());
        buf.append("://");
        buf.append(this.getExchangeHost());
        int port = this.getPort();
        if (port != -1) {
            buf.append(":" + port);
        }
        buf.append("/owa/auth/logon.aspx");
        return buf.toString();
    }
}

