/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webdav;

import coldfusion.exchange.AppointmentFilterInfo;
import coldfusion.exchange.ContactFilterInfo;
import coldfusion.exchange.DeleteType;
import coldfusion.exchange.ExchangeAppointment;
import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.ExchangeContact;
import coldfusion.exchange.ExchangeFolder;
import coldfusion.exchange.ExchangeFolderExtendedInfo;
import coldfusion.exchange.ExchangeLoginInfo;
import coldfusion.exchange.ExchangeMessage;
import coldfusion.exchange.ExchangeTask;
import coldfusion.exchange.FolderFilterInfo;
import coldfusion.exchange.MessageFilterInfo;
import coldfusion.exchange.TaskFilterInfo;
import coldfusion.exchange.webdav.CFWebDAVResource;
import coldfusion.exchange.webdav.CalendarManager;
import coldfusion.exchange.webdav.ContactManager;
import coldfusion.exchange.webdav.MessageManager;
import coldfusion.exchange.webdav.TaskManager;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webdav.WebDAVFolderManager;
import coldfusion.exchange.webdav.WebDAVLoginInfo;
import coldfusion.exchange.webservice.AvailabilityData;
import coldfusion.exchange.webservice.CFConversationFilter;
import coldfusion.exchange.webservice.CFUserAvailability;
import coldfusion.exchange.webservice.EmailAddress;
import coldfusion.util.RB;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.webdav.lib.WebdavResource;

public class WebDAVConnection
extends ExchangeConnection {
    WebdavResource webDavResource = null;
    private String cookiePath = "/exchange";
    public static boolean debugWebDAV = false;
    public static final String webDAVDebugPropertyName = "DEBUG_EXCHANGE";

    public WebDAVConnection(ExchangeLoginInfo loginInfo) {
        super(loginInfo);
    }

    protected void finalize() throws Throwable {
        this.closeConnection();
        super.finalize();
    }

    public static void setExchangeDebug(boolean debug) {
        debugWebDAV = debug;
    }

    @Override
    public void closeConnection() {
        try {
            if (this.webDavResource != null) {
                this.webDavResource.close();
                this.webDavResource = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public WebDAVLoginInfo getWebDAVLoginInfo() {
        if (this.loginInfo == null) {
            return null;
        }
        return (WebDAVLoginInfo)this.loginInfo;
    }

    @Override
    public void login() throws Throwable {
        this.login(true);
    }

    public void login(boolean retry) throws Throwable {
        WebDAVLoginInfo loginInfo = this.getWebDAVLoginInfo();
        String exchangeAppName = loginInfo.getExchangeAppName();
        this.cookiePath = "/" + exchangeAppName;
        boolean formBasedAuth = loginInfo.isFormBasedAuthentication();
        String cookies = null;
        if (formBasedAuth) {
            cookies = this.formBasedLogin();
        }
        String url = loginInfo.getExchangeUrl();
        Object httpUrl = null;
        httpUrl = loginInfo.getProtocol().equalsIgnoreCase("https") ? new HttpsURL(url) : new HttpURL(url);
        httpUrl.setUserinfo(loginInfo.getMailId(), loginInfo.getUserPassword());
        if (cookies == null) {
            try {
                this.webDavResource = new CFWebDAVResource((HttpURL)httpUrl, loginInfo, debugWebDAV);
            }
            catch (HttpException he) {
                int status = he.getReasonCode();
                if (retry && status == 440 && !formBasedAuth) {
                    try {
                        loginInfo.setFormBasedAuthentication(true);
                        this.login(false);
                    }
                    catch (Throwable t) {
                        loginInfo.setFormBasedAuthentication(false);
                        throw he;
                    }
                }
                throw he;
            }
        } else {
            this.webDavResource = new CFWebDAVResource((HttpURL)httpUrl, cookies, loginInfo, this.cookiePath, debugWebDAV);
        }
    }

    @Override
    public void logoff() {
        this.closeConnection();
        this.loginInfo = null;
    }

    public WebdavResource getWebDAVResournce() {
        return this.webDavResource;
    }

    @Override
    public void createAppointment(ExchangeAppointment apt, boolean sendNotification) throws Throwable {
        CalendarManager cal = new CalendarManager(this);
        cal.createAppointment(apt, sendNotification);
    }

    @Override
    public ArrayList getAppointments(AppointmentFilterInfo filter) throws Throwable {
        CalendarManager cal = new CalendarManager(this);
        return cal.getAppointments(filter);
    }

    @Override
    public void deleteAppointments(String[] uids, boolean notify, String message) throws Throwable {
        CalendarManager cal = new CalendarManager(this);
        cal.deleteAppointments(uids, notify, message);
    }

    @Override
    public void deleteAppointment(String href) throws Throwable {
        CalendarManager cal = new CalendarManager(this);
        cal.deleteAppointment(href);
    }

    @Override
    public void modifyAppointments(AppointmentFilterInfo filterInfo, String[] uids, ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        CalendarManager cal = new CalendarManager(this);
        cal.modifyAppointments(filterInfo, uids, apt, attachedFileNames, attachedFileContents, sendNotification);
    }

    public String findMeetingUID(String href) throws Throwable {
        CalendarManager cal = new CalendarManager(this);
        return cal.findMeetingUID(href);
    }

    public String getExchangeTimeZone() throws Throwable {
        return String.valueOf(Utils.guessCDOTimeZoneId(Calendar.getInstance().getTimeZone()));
    }

    @Override
    public void responseToMeetingRequest(String uid, int responseCode, boolean sendResponse, String responseMessage) throws Throwable {
        CalendarManager cal = new CalendarManager(this);
        cal.responseToMeetingRequest(uid, responseCode, sendResponse, responseMessage);
    }

    @Override
    public void modifyAppointment(AppointmentFilterInfo filterInfo, ExchangeAppointment apt, boolean sendNotification) throws Throwable {
        CalendarManager cal = new CalendarManager(this);
        cal.modifyAppointment(filterInfo, apt, sendNotification);
    }

    @Override
    public void modifyAppointment(AppointmentFilterInfo filterInfo, ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        CalendarManager cal = new CalendarManager(this);
        cal.modifyAppointment(filterInfo, apt, attachedFileNames, attachedFileContents, sendNotification);
    }

    @Override
    public ArrayList getAppointmentAttachments(String uid, boolean getContent) throws Throwable {
        CalendarManager mgr = new CalendarManager(this);
        return mgr.getAttachments(uid, getContent);
    }

    @Override
    public void deleteAppointmentAttachments(String uid, String[] fileNames) throws Throwable {
        CalendarManager mgr = new CalendarManager(this);
        mgr.deleteAttachments(uid, fileNames);
    }

    @Override
    public ArrayList getContacts(ContactFilterInfo filter) throws Throwable {
        ContactManager mgr = new ContactManager(this);
        return mgr.getContacts(filter);
    }

    @Override
    public void createContact(ExchangeContact contact) throws Throwable {
        ContactManager mgr = new ContactManager(this);
        mgr.createContact(contact);
    }

    @Override
    public void modifyContacts(String[] uids, ExchangeContact contact) throws Throwable {
        ContactManager mgr = new ContactManager(this);
        mgr.modifyContacts(uids, contact);
    }

    @Override
    public void deleteContacts(String[] uids) throws Throwable {
        ContactManager mgr = new ContactManager(this);
        mgr.deleteContacts(uids);
    }

    @Override
    public void addContactAttachments(String uid, String[] fileNames, Object[] contents) throws Throwable {
        ContactManager mgr = new ContactManager(this);
        mgr.addAttachments(uid, fileNames, contents);
    }

    @Override
    public ArrayList getContactAttachments(String uid, boolean getContent) throws Throwable {
        ContactManager mgr = new ContactManager(this);
        return mgr.getAttachments(uid, getContent);
    }

    @Override
    public void deleteContactAttachments(String uid, String[] fileNames) throws Throwable {
        ContactManager mgr = new ContactManager(this);
        mgr.deleteAttachments(uid, fileNames);
    }

    @Override
    public void modifyContact(ExchangeContact ct, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        ContactManager mgr = new ContactManager(this);
        mgr.modifyContact(ct, attachedFileNames, attachedFileContents);
    }

    @Override
    public void createContact(ExchangeContact ct, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        ContactManager mgr = new ContactManager(this);
        mgr.createContact(ct, attachedFileNames, attachedFileContents);
    }

    @Override
    public void createAppointment(ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        CalendarManager mgr = new CalendarManager(this);
        mgr.createAppointment(apt, attachedFileNames, attachedFileContents, sendNotification);
    }

    @Override
    public ArrayList getTasks(TaskFilterInfo filter) throws Throwable {
        TaskManager mgr = new TaskManager(this);
        return mgr.getTasks(filter);
    }

    @Override
    public void modifyTask(ExchangeTask task) throws Throwable {
        TaskManager mgr = new TaskManager(this);
        mgr.modifyTask(task);
    }

    @Override
    public void modifyTask(ExchangeTask task, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        TaskManager mgr = new TaskManager(this);
        mgr.modifyTask(task, attachedFileNames, attachedFileContents);
    }

    @Override
    public void createTask(ExchangeTask task) throws Throwable {
        TaskManager mgr = new TaskManager(this);
        mgr.createTask(task);
    }

    @Override
    public void createTask(ExchangeTask task, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        TaskManager mgr = new TaskManager(this);
        mgr.createTask(task, attachedFileNames, attachedFileContents);
    }

    @Override
    public void deleteTasks(String[] uids) throws Throwable {
        TaskManager mgr = new TaskManager(this);
        mgr.deleteTasks(uids);
    }

    @Override
    public void addTaskAttachments(String href, String[] fileNames, Object[] inStreams) throws Throwable {
        TaskManager mgr = new TaskManager(this);
        mgr.addAttachments(href, fileNames, inStreams);
    }

    @Override
    public ArrayList getTaskAttachments(String uid, boolean getContent) throws Throwable {
        TaskManager mgr = new TaskManager(this);
        return mgr.getAttachments(uid, getContent);
    }

    @Override
    public void deleteTaskAttachments(String uid, String[] fileNames) throws Throwable {
        TaskManager mgr = new TaskManager(this);
        mgr.deleteAttachments(uid, fileNames);
    }

    @Override
    public ArrayList getMessages(MessageFilterInfo filter) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        return mgr.getMessages(filter);
    }

    @Override
    public void createMessage(ExchangeMessage msg, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        mgr.createMessage(msg, attachedFileNames, attachedFileContents);
    }

    @Override
    public void modifyMessage(ExchangeMessage msg) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        mgr.modifyMessage(msg);
    }

    @Override
    public void modifyMessage(ExchangeMessage msg, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        mgr.modifyMessage(msg, attachedFileNames, attachedFileContents);
    }

    @Override
    public void deleteMessages(String[] uids) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        mgr.deleteMessages(uids);
    }

    @Override
    public void deleteMessages(String[] uids, String folder) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        mgr.deleteMessages(uids, folder);
    }

    @Override
    public void addMessageAttachments(String href, String[] fileNames, Object[] inStreams) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        mgr.addAttachments(href, fileNames, inStreams);
    }

    @Override
    public ArrayList getMessageAttachments(String uid, boolean getContent) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        return mgr.getAttachments(uid, getContent);
    }

    @Override
    public ArrayList getMessageAttachments(String uid, boolean getContent, String messageFolder) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        return mgr.getAttachments(uid, getContent, messageFolder);
    }

    @Override
    public void deleteMessageAttachments(String uid, String[] fileNames) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        mgr.deleteAttachments(uid, fileNames);
    }

    @Override
    public void deleteMessageAttachments(String uid, String[] fileNames, String messageFolder) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        mgr.deleteAttachments(uid, fileNames, messageFolder);
    }

    @Override
    public ArrayList getMessageMeetingInfo(String meetingUID, String mailUID) throws Throwable {
        MessageManager mgr = new MessageManager(this);
        return mgr.getMeetingInfo(meetingUID, mailUID);
    }

    @Override
    public boolean isOpen() {
        return this.webDavResource != null;
    }

    @Override
    public ArrayList getSubFolders(String folderName, boolean recurse) throws Throwable {
        WebDAVFolderManager folderMgr = new WebDAVFolderManager(this);
        return folderMgr.getFolders(this, folderName, recurse);
    }

    @Override
    public void moveMessages(MessageFilterInfo filter, String destinationFolder) throws Throwable {
        MessageManager msgMgr = new MessageManager(this);
        msgMgr.moveMessages(filter, destinationFolder);
    }

    @Override
    public void createFolder(String parentFolderId, ExchangeFolderExtendedInfo folder) throws Throwable {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public ExchangeFolder getExchangeFolderInfo(String folderIdentifier, boolean needsResolution, String pathSeparatorRegex) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public ExchangeFolderExtendedInfo getExchangeExtendedFolderInfo(String folderIdentifier, boolean needsResolution, String pathSeparatorRegex) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public ArrayList getSubFolders(String parentFolderId, FolderFilterInfo filter) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public String copyFolder(String sourceFolderId, String destinationFolderId) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public void deleteFolder(String[] folderIds, DeleteType type) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public String moveFolder(String sourceFolderId, String destinationFolderId) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public void updateFolder(String folderId, ExchangeFolderExtendedInfo folder) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public void emptyFolder(String folderId, DeleteType type, boolean deleteSubFolder) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public ArrayList getRoomList() {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public ArrayList getRooms(EmailAddress emailAddress) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public CFUserAvailability getUserAvailability(List<String> attendees, Date startDate, Date endDate, AvailabilityData type) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public ArrayList getConversations(String folderId, CFConversationFilter filter) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public void copyConversations(String conversationFolderId, String destinationFolderId, String conversationId) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public void moveConversations(String conversationFolderId, String destinationFolderId, String conversationId) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public void setReadStateToConversations(String conversationFolderId, String conversationId, boolean read) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public void deleteConversations(String conversationFolderId, String conversationId, DeleteType deleteType) {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    @Override
    public ArrayList getAppointmentOccurences(AppointmentFilterInfo filter) throws Throwable {
        throw new UnsupportedOperationException(RB.getString((Object)this, (String)"WebDAVConnection.UnsupportedOperation"));
    }

    static {
        String tmpObj = System.getProperty(webDAVDebugPropertyName);
        if (tmpObj != null && tmpObj.toString().toLowerCase().equals("true")) {
            debugWebDAV = true;
        }
    }
}

