/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf.builder.types;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import macromedia.graphics.images.LosslessImage;
import macromedia.swf.builder.tags.DefineBitsLosslessBuilder;
import macromedia.swf.builder.types.MatrixBuilder;
import macromedia.swf.tags.DefineBitsLossless;
import macromedia.swf.types.FillStyle;
import macromedia.swf.types.GradRecord;
import macromedia.swf.types.Matrix;
import macromedia.util.SwfUtils;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;

public final class FillStyleBuilder {
    private FillStyleBuilder() {
    }

    public static FillStyle build(Paint paint, Rectangle2D bounds, AffineTransform transform) {
        FillStyle fs = null;
        if (paint != null) {
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            if (paint instanceof Color) {
                fs = new FillStyle(SwfUtils.colorToInt((Color)((Color)paint)));
            } else if (paint instanceof GradientPaint) {
                GradientPaint gp = (GradientPaint)paint;
                AffineTransform gt = FillStyleBuilder.objectBoundingBoxTransform(transform.transform(gp.getPoint1(), null), transform.transform(gp.getPoint2(), null), width, height, width, height);
                fs = new FillStyle();
                fs.matrix = MatrixBuilder.build(gt);
                fs.type = 16;
                fs.gradient = new GradRecord[2];
                fs.gradient[0] = new GradRecord(0, SwfUtils.colorToInt((Color)gp.getColor1()));
                fs.gradient[1] = new GradRecord(255, SwfUtils.colorToInt((Color)gp.getColor2()));
            } else if (paint instanceof LinearGradientPaint) {
                LinearGradientPaint lgp = (LinearGradientPaint)paint;
                Point2D start = lgp.getStartPoint();
                Point2D end = lgp.getEndPoint();
                AffineTransform gt = FillStyleBuilder.objectBoundingBoxTransform(start, end, width, height, width, height);
                fs = new FillStyle();
                fs.matrix = MatrixBuilder.build(gt);
                Color[] colors = lgp.getColors();
                float[] ratios = lgp.getFractions();
                if (colors.length == 0 || colors.length != ratios.length) {
                    return null;
                }
                if (colors.length == 1) {
                    return new FillStyle(SwfUtils.colorToInt((Color)colors[0]));
                }
                fs.type = 16;
                int len = ratios.length;
                if (len > 8) {
                    len = 8;
                }
                fs.gradient = new GradRecord[len];
                int i = 0;
                while (i < len) {
                    fs.gradient[i] = new GradRecord((int)Math.rint(255.0f * ratios[i]), SwfUtils.colorToInt((Color)colors[i]));
                    ++i;
                }
            } else if (paint instanceof RadialGradientPaint) {
                RadialGradientPaint rgp = (RadialGradientPaint)paint;
                double diameter = (double)rgp.getRadius() * 2.0;
                double outerX = diameter * rgp.getTransform().getScaleX();
                double outerY = diameter * rgp.getTransform().getScaleY();
                AffineTransform gt = FillStyleBuilder.objectBoundingBoxTransform(null, null, width, height, outerX, outerY);
                fs = new FillStyle();
                fs.matrix = MatrixBuilder.build(gt);
                fs.type = 18;
                Color[] colors = rgp.getColors();
                float[] ratios = rgp.getFractions();
                fs.gradient = new GradRecord[ratios.length <= 8 ? ratios.length : 8];
                int i = 0;
                while (i < ratios.length && i < 8) {
                    fs.gradient[i] = new GradRecord((int)Math.rint(255.0f * ratios[i]), SwfUtils.colorToInt((Color)colors[i]));
                    ++i;
                }
            } else if (paint instanceof TexturePaint) {
                TexturePaint tp = (TexturePaint)paint;
                BufferedImage image = tp.getImage();
                DefineBitsLossless tag = DefineBitsLosslessBuilder.build(new LosslessImage((Image)image));
                AffineTransform at = new AffineTransform();
                at.setToScale(20.0, 20.0);
                Matrix matrix = MatrixBuilder.build(at);
                fs = new FillStyle(64, matrix, tag);
            }
        }
        return fs;
    }

    private static AffineTransform objectBoundingBoxTransform(Point2D gp1, Point2D gp2, double width, double height, double scaleWidth, double scaleHeight) {
        AffineTransform at = new AffineTransform();
        at.translate(width / 2.0, height / 2.0);
        at.scale(scaleWidth * 20.0 / 32768.0, scaleHeight * 20.0 / 32768.0);
        if (gp1 != null && gp2 != null && gp2.getX() - gp1.getX() != 0.0) {
            double mx = gp2.getX() - gp1.getX();
            double my = gp2.getY() - gp1.getY();
            double gradient = my / mx;
            double angle = Math.atan(gradient);
            if (mx < 0.0) {
                angle += Math.PI;
            } else if (my < 0.0) {
                angle += Math.PI * 2;
            }
            if (angle != 0.0) {
                at.rotate(angle);
            }
        }
        return at;
    }
}

