/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import macromedia.swf.Action;
import macromedia.swf.actions.Label;
import macromedia.swf.actions.Push;
import macromedia.swf.actions.StoreRegister;
import macromedia.swf.actions.StrictMode;
import macromedia.swf.actions.WaitForFrame;
import macromedia.swf.debug.LineRecord;
import macromedia.swf.debug.RegisterRecord;
import macromedia.swf.types.ActionList;

public final class ActionFactory {
    public static final Object UNDEFINED = new Object(){

        public String toString() {
            return "undefined";
        }
    };
    public static final Object STACKTOP = new Object(){

        public String toString() {
            return "stack";
        }
    };
    private static final Action[] actionFlyweights = new Action[128];
    private static final Push[] pushCpoolFlyweights = new Push[256];
    private static final Push[] pushRegisterFlyweights = new Push[256];
    private static final StoreRegister[] storeRegisterFlyweights = new StoreRegister[256];
    private static final Push pushTrueFlyweight = new Push(Boolean.TRUE);
    private static final Push pushFalseFlyweight = new Push(Boolean.FALSE);
    private static final Push pushUndefinedFlyweight = new Push(UNDEFINED);
    private static final Push pushNullFlyweight = new Push(null);
    private static final Push pushFloat0Flyweight = new Push(new Float(0.0f));
    private static final Push pushInteger0Flyweight = new Push(new Integer(0));
    private static final Push pushDouble0Flyweight = new Push(new Double(0.0));
    private static final Action callFlyweight = new Action(158);
    private static final StrictMode strictTrueFlyweight = new StrictMode(true);
    private static final StrictMode strictFalseFlyweight = new StrictMode(false);
    private final int startOffset;
    private final int startCount;
    private final Action[] actions;
    private final Label[] labels;
    private final LineRecord[] lines;
    private final RegisterRecord[] registers;
    private final int[] actionOffsets;
    private int count;
    private List skipRecords;

    public static Action createAction(int code) {
        return actionFlyweights[code];
    }

    public static Push createPushCpool(int index) {
        return index < pushCpoolFlyweights.length ? pushCpoolFlyweights[index] : new Push(new Short((short)index));
    }

    public static Push createPush(String s) {
        return new Push(s);
    }

    public static Push createPush(float fvalue) {
        return fvalue == 0.0f ? pushFloat0Flyweight : new Push(new Float(fvalue));
    }

    public static Push createPushNull() {
        return pushNullFlyweight;
    }

    public static Push createPushUndefined() {
        return pushUndefinedFlyweight;
    }

    public static Push createPushRegister(int regno) {
        return pushRegisterFlyweights[regno];
    }

    public static Push createPush(boolean b) {
        return b ? pushTrueFlyweight : pushFalseFlyweight;
    }

    public static Push createPush(double dvalue) {
        return dvalue == 0.0 ? pushDouble0Flyweight : new Push(new Double(dvalue));
    }

    public static Push createPush(int ivalue) {
        return ivalue == 0 ? pushInteger0Flyweight : new Push(new Integer(ivalue));
    }

    public static StoreRegister createStoreRegister(int register) {
        return storeRegisterFlyweights[register];
    }

    public static Action createCall() {
        return callFlyweight;
    }

    public static StrictMode createStrictMode(boolean mode) {
        return mode ? strictTrueFlyweight : strictFalseFlyweight;
    }

    public ActionFactory(int length, int startOffset, int startCount) {
        this.startOffset = startOffset;
        this.startCount = startCount;
        this.labels = new Label[length + 1];
        this.lines = new LineRecord[length];
        this.registers = new RegisterRecord[length];
        this.actions = new Action[length];
        this.actionOffsets = new int[length + 1];
        this.skipRecords = new ArrayList();
    }

    public void setLine(int offset, LineRecord line) {
        int i = offset - this.startOffset;
        if (this.lines[i] == null) {
            ++this.count;
        }
        this.lines[i] = line;
    }

    public void setRegister(int offset, RegisterRecord record) {
        int i = offset - this.startOffset;
        if (this.registers[i] == null) {
            ++this.count;
        }
        this.registers[i] = record;
    }

    public void setAction(int offset, Action a) {
        int i = offset - this.startOffset;
        if (this.actions[i] == null) {
            ++this.count;
        }
        this.actions[i] = a;
    }

    public Label getLabel(int target) {
        int i = target - this.startOffset;
        Label label = this.labels[i];
        if (label == null) {
            this.labels[i] = label = new Label();
            ++this.count;
        }
        return label;
    }

    public void setActionOffset(int actionCount, int offset) {
        this.actionOffsets[actionCount - this.startCount] = offset;
    }

    public ActionList createActionList(boolean keepOffsets) {
        this.processSkipEntries();
        ActionList list = new ActionList(keepOffsets);
        list.grow(this.count);
        int length = this.actions.length;
        if (keepOffsets) {
            Action a;
            int i = 0;
            while (i < length) {
                int offset = this.startOffset + i;
                a = this.actions[i];
                if (a != null) {
                    list.insert(offset, a);
                }
                if ((a = this.lines[i]) != null) {
                    list.insert(offset, a);
                }
                if ((a = this.registers[i]) != null) {
                    list.insert(offset, a);
                }
                if ((a = this.labels[i]) != null) {
                    list.insert(offset, a);
                }
                ++i;
            }
            a = this.labels[length];
            if (a != null) {
                list.insert(this.startOffset + length, a);
            }
        } else {
            Action a;
            int i = 0;
            while (i < length) {
                a = this.labels[i];
                if (a != null) {
                    list.append(a);
                }
                if ((a = this.lines[i]) != null) {
                    list.append(a);
                }
                if ((a = this.registers[i]) != null) {
                    list.append(a);
                }
                if ((a = this.actions[i]) != null) {
                    list.append(a);
                }
                ++i;
            }
            a = this.labels[length];
            if (a != null) {
                list.append(a);
            }
        }
        return list;
    }

    private void processSkipEntries() {
        Iterator i = this.skipRecords.iterator();
        while (i.hasNext()) {
            SkipEntry skipRecord = (SkipEntry)i.next();
            int labelOffset = this.actionOffsets[skipRecord.skipTarget - this.startCount];
            skipRecord.action.skipTarget = this.getLabel(labelOffset);
        }
    }

    public void addSkipEntry(WaitForFrame a, int skipTarget) {
        this.skipRecords.add(new SkipEntry(a, skipTarget));
    }

    static {
        int i = 0;
        while (i < 128) {
            ActionFactory.actionFlyweights[i] = new Action(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < 256) {
            ActionFactory.pushRegisterFlyweights[i2] = new Push(new Byte((byte)i2));
            ActionFactory.pushCpoolFlyweights[i2] = new Push(new Short((short)i2));
            ActionFactory.storeRegisterFlyweights[i2] = new StoreRegister(i2);
            ++i2;
        }
    }

    private static class SkipEntry {
        WaitForFrame action;
        int skipTarget;

        public SkipEntry(WaitForFrame action, int skipTarget) {
            this.action = action;
            this.skipTarget = skipTarget;
        }
    }
}

