/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.request.RetrySettingsRequest;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.CFBooleanValidator;
import coldfusion.cloud.validator.CFNonNegativeDoubleValidator;
import coldfusion.cloud.validator.CFNonNegativeIntegerValidator;
import java.util.Collections;

public enum RetrySettingsConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<RetrySettingsRequest> consumerMap = new ConsumerMap();

    private RetrySettingsConsumer() {
        this.consumerMap.put((Object)"initialRetryDelay", new ConsumerValidator((retrySettingsBuilder, value) -> retrySettingsBuilder.setInitialRetryDelay(this.cast.getDurationProperty(value, "initialRetryDelay")), Collections.emptyList()));
        this.consumerMap.put((Object)"initialRpcTimeout", new ConsumerValidator((retrySettingsBuilder, value) -> retrySettingsBuilder.setInitialRpcTimeout(this.cast.getDurationProperty(value, "initialRpcTimeout")), Collections.emptyList()));
        this.consumerMap.put((Object)"enableJittered", new ConsumerValidator((retrySettingsBuilder, value) -> retrySettingsBuilder.setEnableJittered(this.cast.getBooleanProperty(value)), Collections.singletonList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"maxAttempts", new ConsumerValidator((retrySettingsBuilder, value) -> retrySettingsBuilder.setMaxAttempts(this.cast.getIntegerProperty(value)), Collections.singletonList(new CFNonNegativeIntegerValidator("maxAttempts"))));
        this.consumerMap.put((Object)"maxRetryDelay", new ConsumerValidator((retrySettingsBuilder, value) -> retrySettingsBuilder.setMaxRetryDelay(this.cast.getDurationProperty(value, "maxRetryDelay")), Collections.emptyList()));
        this.consumerMap.put((Object)"maxRpcTimeout", new ConsumerValidator((retrySettingsBuilder, value) -> retrySettingsBuilder.setMaxRpcTimeout(this.cast.getDurationProperty(value, "maxRpcTimeout")), Collections.emptyList()));
        this.consumerMap.put((Object)"retryDelayMultiplier", new ConsumerValidator((retrySettingsBuilder, value) -> retrySettingsBuilder.setRetryDelayMultiplier(this.cast.getDoubleProperty(value)), Collections.singletonList(new CFNonNegativeDoubleValidator("retryDelayMultiplier"))));
        this.consumerMap.put((Object)"rpcTimeoutMultiplier", new ConsumerValidator((retrySettingsBuilder, value) -> retrySettingsBuilder.setRpcTimeoutMultiplier(this.cast.getDoubleProperty(value)), Collections.singletonList(new CFNonNegativeDoubleValidator("rpcTimeoutMultiplier"))));
        this.consumerMap.put((Object)"totalTimeout", new ConsumerValidator((retrySettingsBuilder, value) -> retrySettingsBuilder.setTotalTimeout(this.cast.getDurationProperty(value, "totalTimeout")), Collections.emptyList()));
    }

    public ConsumerMap<RetrySettingsRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

