/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.config;

import coldfusion.cloud.CloudService;
import coldfusion.cloud.CloudServiceProducer;
import coldfusion.cloud.gcp.GCPCredential;
import coldfusion.cloud.gcp.config.AbstractGCPServiceConfig;
import coldfusion.cloud.gcp.pubsub.PubSubClient;
import coldfusion.cloud.gcp.pubsub.config.PubSubClientServiceConfig;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PubSubServiceProducer
implements CloudServiceProducer<GCPCredential, AbstractGCPServiceConfig> {
    private static Map<String, PubSubClient> pubsubClientServiceMap = new ConcurrentHashMap<String, PubSubClient>();

    public CloudService getServiceHandle(GCPCredential credential, AbstractGCPServiceConfig serviceConfig) {
        PubSubClientServiceConfig config = (PubSubClientServiceConfig)serviceConfig;
        int credentialHC = credential != null ? PubSubServiceUtils.getHashcode(credential.hashCode()) : 0;
        int configHC = config != null ? PubSubServiceUtils.getHashcode(config.hashCode()) : 0;
        String id = credentialHC + "-" + configHC;
        PubSubClient pubsubClient = pubsubClientServiceMap.get(id);
        if (pubsubClient == null) {
            pubsubClient = new PubSubClientImpl(credential, config, id);
            pubsubClientServiceMap.put(id, pubsubClient);
        }
        return pubsubClient;
    }
}

