/*
 * Decompiled with CFR 0.152.
 */
package macromedia.pool;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import macromedia.jdbc.extensions.ExtConnection;
import macromedia.jdbc.extensions.ExtPooledConnection;
import macromedia.pool.PooledConnectionHolder;

class ConnectionPool {
    private List free;
    private List cache;
    private ConnectionPoolDataSource ds;
    private int initialPoolSize;
    private int minPoolSize;
    private int maxPoolSize;
    private String user;
    private String password;
    private static String footprint = "$Revision: #1 $";
    private String groupName;
    private boolean tracing;
    private boolean logTimestamp;
    private boolean logTName;
    private String reauthentication;
    private boolean reauthenticationChecked;
    private String maxPoolSizeBehavior;
    private PrintWriter traceWriter = new PrintWriter(System.out, true);

    ConnectionPool(String string, ConnectionPoolDataSource connectionPoolDataSource, int n, int n2, int n3, boolean bl, String string2, String string3) throws SQLException {
        this(string, connectionPoolDataSource, n, n2, n3, bl, string2, string3, null, null);
    }

    ConnectionPool(String string, ConnectionPoolDataSource connectionPoolDataSource, int n, int n2, int n3, boolean bl, String string2, String string3, String string4, String string5) throws SQLException {
        this.cache = new LinkedList();
        this.free = new LinkedList();
        this.ds = connectionPoolDataSource;
        this.groupName = string;
        this.initialPoolSize = n;
        this.minPoolSize = n2;
        if (n3 != 0) {
            this.maxPoolSize = Math.max(n2, n3);
        }
        this.user = string4;
        this.password = string5;
        this.tracing = bl;
        this.reauthentication = string2;
        this.reauthenticationChecked = false;
        this.maxPoolSizeBehavior = string3;
        this.writeTrace("*** ConnectionPool Created(" + string + ", " + connectionPoolDataSource + ", " + n + ", " + n2 + ", " + n3 + ", " + string4 + ", " + "*******" + ")");
        this.enforceMinimum(n);
    }

    Connection getConnection() throws SQLException {
        return this.getCachedConnection().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(String string, String string2) throws SQLException {
        Object object;
        int n;
        int n2;
        if (this.maxPoolSizeBehavior.equalsIgnoreCase("HardCap")) {
            int n3 = 0;
            n2 = this.ds.getLoginTimeout() * 1000;
            n = 0;
            while (true) {
                object = this;
                synchronized (object) {
                    if (n2 == 0 || n3 < n2) {
                        if (this.cache.size() < this.maxPoolSize || !this.free.isEmpty()) {
                            break;
                        }
                    } else {
                        throw new SQLException("Login has timed out", "HYT00");
                    }
                    n = 1;
                }
                if (n == 0) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    throw new SQLException(exception.getMessage());
                }
                n3 += 500;
            }
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            PooledConnection pooledConnection;
            PooledConnectionHolder pooledConnectionHolder;
            n2 = this.free.size();
            for (n = 0; n < n2; ++n) {
                pooledConnectionHolder = (PooledConnectionHolder)this.free.remove(0);
                pooledConnection = pooledConnectionHolder.pc;
                object = ((ExtPooledConnection)((Object)pooledConnection)).getCurrentUser();
                if (string.equals(object)) {
                    pooledConnectionHolder.reset();
                    this.writeTrace("Reused free connection.");
                    return pooledConnection.getConnection();
                }
                if (n >= n2 - 1) {
                    try {
                        ((ExtPooledConnection)((Object)pooledConnection)).setCurrentUser(string);
                        pooledConnectionHolder.reset();
                        this.writeTrace("Reused free connection.");
                        this.writeTrace("Switch the user of the existing connection to " + string);
                        return pooledConnection.getConnection();
                    }
                    catch (Exception exception) {
                        this.free.add(pooledConnectionHolder);
                        pooledConnectionHolder = this.createCachedConnection(string, string2);
                        this.writeTrace("Created new connection.");
                        pooledConnection = pooledConnectionHolder.getPooledConnection();
                        return pooledConnection.getConnection();
                    }
                }
                this.free.add(pooledConnectionHolder);
            }
            pooledConnectionHolder = this.createCachedConnection(string, string2);
            this.writeTrace("Created new connection.");
            pooledConnection = pooledConnectionHolder.getPooledConnection();
            return pooledConnection.getConnection();
        }
    }

    synchronized void connectionClosed(PooledConnectionHolder pooledConnectionHolder) {
        pooledConnectionHolder.free();
        this.free.add(pooledConnectionHolder);
        this.writeTrace("Connection was closed and added to the cache.");
    }

    synchronized void connectionErrorOccurred(PooledConnectionHolder pooledConnectionHolder) {
        PooledConnection pooledConnection = pooledConnectionHolder.getPooledConnection();
        this.cache.remove(pooledConnectionHolder);
        try {
            pooledConnection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.writeTrace("Connection error occured.");
    }

    synchronized void doMaintenance(long l) {
        if (l != 0L) {
            LinkedList<PooledConnectionHolder> linkedList = new LinkedList<PooledConnectionHolder>();
            Iterator iterator = this.free.iterator();
            long l2 = System.currentTimeMillis();
            while (iterator.hasNext()) {
                PooledConnectionHolder pooledConnectionHolder = (PooledConnectionHolder)iterator.next();
                if (pooledConnectionHolder.timeIdle(l2) < l) continue;
                linkedList.add(pooledConnectionHolder);
            }
            for (PooledConnectionHolder pooledConnectionHolder : linkedList) {
                this.free.remove(pooledConnectionHolder);
                pooledConnectionHolder.pc.removeConnectionEventListener((ConnectionEventListener)pooledConnectionHolder);
                this.cache.remove(pooledConnectionHolder);
                try {
                    pooledConnectionHolder.pc.close();
                    this.writeTrace("Dumped free connection.");
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            this.enforceMinimum(this.minPoolSize);
        }
        catch (SQLException sQLException) {
            this.writeTrace("SQLException ocurred during maintenance:");
            this.writeTrace("se.getMessage()");
            this.writeTrace("se.getStackTrace()");
        }
        this.enforceMaximum(this.maxPoolSize);
    }

    synchronized void close() {
        this.writeTrace("Closing a pool of the group " + this.groupName);
        this.minPoolSize = 0;
        this.maxPoolSize = 0;
        while (!this.cache.isEmpty()) {
            PooledConnectionHolder pooledConnectionHolder = (PooledConnectionHolder)this.cache.remove(0);
            this.free.remove(pooledConnectionHolder);
            PooledConnection pooledConnection = pooledConnectionHolder.getPooledConnection();
            try {
                pooledConnection.close();
            }
            catch (SQLException sQLException) {
                this.writeTrace("SQLException ocurred while removing the connection from the cache:");
                this.writeTrace("se.getMessage()");
                this.writeTrace("se.getStackTrace()");
            }
        }
        this.writeTrace("Pool closed");
    }

    int getNrPooledConnections() {
        return this.cache.size();
    }

    int getNrFreeConnections() {
        return this.free.size();
    }

    boolean isEmpty() {
        return this.cache.size() == 0;
    }

    void setTracing(boolean bl) {
        this.tracing = bl;
    }

    void setLogTimestamp(boolean bl) {
        this.logTimestamp = bl;
    }

    void setLogTName(boolean bl) {
        this.logTName = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledConnection getCachedConnection() throws SQLException {
        if (this.maxPoolSizeBehavior.equalsIgnoreCase("HardCap")) {
            int n = 0;
            int n2 = this.ds.getLoginTimeout() * 1000;
            boolean bl = false;
            while (true) {
                ConnectionPool connectionPool = this;
                synchronized (connectionPool) {
                    if (n2 == 0 || n < n2) {
                        if (this.cache.size() < this.maxPoolSize || !this.free.isEmpty()) {
                            break;
                        }
                    } else {
                        throw new SQLException("Login has timed out", "HYT00");
                    }
                    bl = true;
                }
                if (!bl) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    throw new SQLException(exception.getMessage());
                }
                n += 500;
            }
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (!this.free.isEmpty()) {
                PooledConnectionHolder pooledConnectionHolder = (PooledConnectionHolder)this.free.remove(0);
                pooledConnectionHolder.reset();
                this.writeTrace("Reused free connection.");
                return pooledConnectionHolder.pc;
            }
            PooledConnectionHolder pooledConnectionHolder = this.createCachedConnection();
            this.writeTrace("Created new connection.");
            return pooledConnectionHolder.getPooledConnection();
        }
    }

    private void enforceMinimum(int n) throws SQLException {
        int n2;
        if (this.maxPoolSizeBehavior.equalsIgnoreCase("HardCap")) {
            n = this.cache.size() >= this.maxPoolSize ? 0 : Math.min(n, this.maxPoolSize - this.cache.size());
        }
        for (int i = n2 = this.getNrFreeConnections(); i < n; ++i) {
            PooledConnectionHolder pooledConnectionHolder = this.createCachedConnection();
            pooledConnectionHolder.free();
            this.free.add(pooledConnectionHolder);
        }
        this.writeTrace("Enforced minimum!\nNrFreeConnections was: " + n2);
    }

    private void enforceMaximum(int n) {
        if (n != 0) {
            int n2;
            for (int i = n2 = this.getNrFreeConnections(); i > n; --i) {
                PooledConnectionHolder pooledConnectionHolder = (PooledConnectionHolder)this.free.remove(0);
                PooledConnection pooledConnection = pooledConnectionHolder.getPooledConnection();
                this.cache.remove(pooledConnectionHolder);
                try {
                    pooledConnection.close();
                    continue;
                }
                catch (SQLException sQLException) {
                    this.writeTrace("SQLException ocurred while removing the connection from the cache:");
                    this.writeTrace("se.getMessage()");
                    this.writeTrace("se.getStackTrace()");
                }
            }
            this.writeTrace("Enforced maximum!\nNrFreeConnections was: " + n2);
        }
    }

    private PooledConnectionHolder createCachedConnection() throws SQLException {
        return this.createCachedConnection(null, null);
    }

    private PooledConnectionHolder createCachedConnection(String string, String string2) throws SQLException {
        PooledConnectionHolder pooledConnectionHolder = null;
        PooledConnection pooledConnection = string == null ? (this.user == null ? this.ds.getPooledConnection() : this.ds.getPooledConnection(this.user, this.password)) : this.ds.getPooledConnection(string, string2);
        try {
            Connection connection = pooledConnection.getConnection();
            if (this.reauthentication.equalsIgnoreCase("enable") && !this.reauthenticationChecked) {
                if (!((ExtConnection)((Object)connection)).supportsReauthentication()) {
                    throw new UnsupportedOperationException("Reauthentication is not supported.");
                }
                this.reauthenticationChecked = true;
            }
            CallableStatement callableStatement = connection.prepareCall("--!ddtc!\n{call ddtc(?)}");
            long l = new Random().nextLong();
            callableStatement.setLong(1, l);
            callableStatement.execute();
            long l2 = callableStatement.getLong(1);
            callableStatement.close();
            connection.close();
            if (l2 == (l ^ 0x1B69B4BE052FAB1L) / 3L) {
                pooledConnectionHolder = new PooledConnectionHolder(this, pooledConnection);
                pooledConnection.addConnectionEventListener((ConnectionEventListener)pooledConnectionHolder);
                this.cache.add(pooledConnectionHolder);
                pooledConnectionHolder.reset();
                return pooledConnectionHolder;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        throw new SQLException("The Pool Manager is unable to create a pooled connection!");
    }

    int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    int getMinPoolSize() {
        return this.minPoolSize;
    }

    private void writeTrace(String string) {
        if (!this.tracing) {
            return;
        }
        String string2 = null;
        if (this.logTName) {
            string2 = "(" + Thread.currentThread().getName() + ")";
        }
        StringBuilder stringBuilder = new StringBuilder(25);
        if (this.logTimestamp) {
            Date date = new Date();
            stringBuilder.append('(');
            stringBuilder.append(date.getYear() + 1900);
            stringBuilder.append('/');
            int n = date.getMonth() + 1;
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
            stringBuilder.append('/');
            n = date.getDate();
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
            stringBuilder.append(' ');
            n = date.getHours();
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
            stringBuilder.append(':');
            n = date.getMinutes();
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
            stringBuilder.append(':');
            n = date.getSeconds();
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
            stringBuilder.append('.');
            long l = date.getTime();
            n = (int)(l % 1000L);
            if (n < 100) {
                stringBuilder.append('0');
            }
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
            stringBuilder.append(')');
        }
        String string3 = this.reauthentication.equalsIgnoreCase("enable") ? this.groupName + string2 + stringBuilder + ": " : (this.user != null ? (this.password != null ? this.user + "/" + "********" + "@" + this.groupName + string2 + stringBuilder + ": " : this.user + "@" + this.groupName + string2 + stringBuilder + ": ") : this.groupName + string2 + stringBuilder + ": ");
        this.traceWriter.println();
        this.traceWriter.println(string3 + string);
        this.traceWriter.println(string3 + "Number pooled connections = " + this.getNrPooledConnections() + ".");
        this.traceWriter.println(string3 + "Number free connections = " + this.getNrFreeConnections() + ".");
        this.traceWriter.println();
    }
}

