/*
 * Decompiled with CFR 0.152.
 */
package com.ddtek.portal.logging;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;

public class Capture
implements Closeable {
    private final PrintStream stdout;
    private final PrintStream stderr;
    private final ByteArrayOutputStream baosOut;
    private final ByteArrayOutputStream baosErr;
    private final PrintStream psOut;
    private final PrintStream psErr;
    private final String[] asStrings;
    private final byte[][] asBytes;

    public Capture(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            throw new IllegalArgumentException("result[] array must have at least two elements, for stdout and stderr");
        }
        this.asStrings = stringArray;
        this.asBytes = null;
        this.baosOut = new ByteArrayOutputStream();
        this.baosErr = new ByteArrayOutputStream();
        this.psOut = new PrintStream(this.baosOut);
        this.psErr = new PrintStream(this.baosErr);
        this.stdout = System.out;
        this.stderr = System.err;
        System.setOut(this.psOut);
        System.setErr(this.psErr);
    }

    public Capture(byte[][] byArray) {
        if (byArray == null || byArray.length < 2) {
            throw new IllegalArgumentException("result[] array must have at least two elements, for stdout and stderr");
        }
        this.asStrings = null;
        this.asBytes = byArray;
        this.baosOut = new ByteArrayOutputStream();
        this.baosErr = new ByteArrayOutputStream();
        this.psOut = new PrintStream(this.baosOut);
        this.psErr = new PrintStream(this.baosErr);
        this.stdout = System.out;
        this.stderr = System.err;
        System.setOut(this.psOut);
        System.setErr(this.psErr);
    }

    @Override
    public void close() throws IOException {
        this.psOut.flush();
        this.psErr.flush();
        System.setOut(this.stdout);
        System.setErr(this.stderr);
        this.psOut.close();
        this.psErr.close();
        if (this.asBytes == null) {
            this.asStrings[0] = this.baosOut.toString();
            this.asStrings[1] = this.baosErr.toString();
        } else {
            this.asBytes[0] = this.baosOut.toByteArray();
            this.asBytes[1] = this.baosErr.toByteArray();
        }
        this.baosOut.close();
        this.baosErr.close();
    }
}

