/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.StampContent;
import com.lowagie.text.pdf.collection.PdfCollection;
import com.lowagie.text.pdf.internal.PdfViewerPreferencesImp;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class PdfStamperImp
extends PdfWriter {
    HashMap readers2intrefs = new HashMap();
    HashMap readers2file = new HashMap();
    RandomAccessFileOrArray file;
    PdfReader reader;
    IntHashtable myXref = new IntHashtable();
    HashMap pagesToContent = new HashMap();
    boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;
    protected boolean flatFreeText = false;
    protected int[] namePtr = new int[]{0};
    protected HashSet partialFlattening = new HashSet();
    protected boolean useVp = false;
    protected PdfViewerPreferencesImp viewerPreferences = new PdfViewerPreferencesImp();
    protected HashMap fieldTemplates = new HashMap();
    protected boolean fieldsAdded = false;
    protected int sigFlags = 0;
    protected boolean append;
    protected IntHashtable marked;
    protected int initialXrefSize;
    protected PdfAction openAction;

    PdfStamperImp(PdfReader pdfReader, OutputStream outputStream, char c, boolean bl) throws DocumentException, IOException {
        super(new PdfDocument(), outputStream);
        if (!pdfReader.isOpenedWithFullPermissions()) {
            throw new IllegalArgumentException("PdfReader not opened with owner password");
        }
        if (pdfReader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        pdfReader.setTampered(true);
        this.reader = pdfReader;
        this.file = pdfReader.getSafeFile();
        this.append = bl;
        if (bl) {
            int n;
            if (pdfReader.isRebuilt()) {
                throw new DocumentException("Append mode requires a document without errors even if recovery was possible.");
            }
            if (pdfReader.isEncrypted()) {
                this.crypto = new PdfEncryption(pdfReader.getDecrypt());
            }
            this.pdf_version.setAppendmode(true);
            this.file.reOpen();
            byte[] byArray = new byte[8192];
            while ((n = this.file.read(byArray)) > 0) {
                this.os.write(byArray, 0, n);
            }
            this.file.close();
            this.prevxref = pdfReader.getLastXref();
            pdfReader.setAppendable(true);
        } else if (c == '\u0000') {
            super.setPdfVersion(pdfReader.getPdfVersion());
        } else {
            super.setPdfVersion(c);
        }
        super.open();
        this.pdf.addWriter(this);
        if (bl) {
            this.body.setRefnum(pdfReader.getXrefSize());
            this.marked = new IntHashtable();
            if (pdfReader.isNewXrefType()) {
                this.fullCompression = true;
            }
            if (pdfReader.isHybridXref()) {
                this.fullCompression = false;
            }
        }
        this.initialXrefSize = pdfReader.getXrefSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(HashMap hashMap) throws IOException {
        Object object;
        PdfObject pdfObject;
        Object object2;
        PdfObject pdfObject2;
        byte[] byArray;
        if (this.closed) {
            return;
        }
        if (this.useVp) {
            this.reader.setViewerPreferences(this.viewerPreferences);
            this.markUsed(this.reader.getTrailer().get(PdfName.ROOT));
        }
        if (this.flat) {
            this.flatFields();
        }
        if (this.flatFreeText) {
            this.flatFreeTextFields();
        }
        this.addFieldResources();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM), this.reader.getCatalog());
        if (this.acroFields != null && this.acroFields.getXfa().isChanged()) {
            this.markUsed(pdfDictionary);
            if (!this.flat) {
                this.acroFields.getXfa().setXfa(this);
            }
        }
        if (this.sigFlags != 0 && pdfDictionary != null) {
            pdfDictionary.put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
            this.markUsed(pdfDictionary);
        }
        this.closed = true;
        this.addSharedObjectsToBody();
        this.setOutlines();
        this.setJavaScript();
        this.addFileAttachments();
        PdfDictionary pdfDictionary2 = this.reader.getCatalog();
        if (this.openAction != null) {
            pdfDictionary2.put(PdfName.OPENACTION, this.openAction);
        }
        if (this.pdf.pageLabels != null) {
            pdfDictionary2.put(PdfName.PAGELABELS, this.pdf.pageLabels.getDictionary(this));
        }
        if ((byArray = this.xmpMetadata) == null && (pdfObject2 = PdfReader.getPdfObject(pdfDictionary2.get(PdfName.METADATA))) != null && pdfObject2.isStream()) {
            byArray = PdfReader.getStreamBytesRaw((PRStream)pdfObject2);
            PdfReader.killIndirect(pdfObject2);
        }
        if (byArray != null) {
            pdfObject2 = new PdfStream(byArray);
            ((PdfDictionary)pdfObject2).put(PdfName.TYPE, PdfName.METADATA);
            ((PdfDictionary)pdfObject2).put(PdfName.SUBTYPE, PdfName.XML);
            if (this.crypto != null && !this.crypto.isMetadataEncrypted()) {
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(PdfName.CRYPT);
                ((PdfDictionary)pdfObject2).put(PdfName.FILTER, pdfArray);
            }
            pdfDictionary2.put(PdfName.METADATA, this.body.add(pdfObject2).getIndirectReference());
            this.markUsed(pdfDictionary2);
        }
        pdfObject2 = null;
        try {
            this.file.reOpen();
            this.alterContents();
            pdfObject2 = (PRIndirectReference)this.reader.trailer.get(PdfName.INFO);
            int n = -1;
            if (pdfObject2 != null) {
                n = ((PdfIndirectReference)pdfObject2).getNumber();
            }
            int n2 = ((PRIndirectReference)this.reader.trailer.get(PdfName.ROOT)).getNumber();
            if (this.append) {
                int n3;
                object2 = this.marked.getKeys();
                for (n3 = 0; n3 < ((int[])object2).length; ++n3) {
                    int n4 = object2[n3];
                    pdfObject = this.reader.getPdfObjectRelease(n4);
                    if (pdfObject == null || n == n4 || n4 >= this.initialXrefSize) continue;
                    this.addToBody(pdfObject, n4, n4 != n2);
                }
                for (n3 = this.initialXrefSize; n3 < this.reader.getXrefSize(); ++n3) {
                    PdfObject pdfObject3 = this.reader.getPdfObject(n3);
                    if (pdfObject3 == null) continue;
                    this.addToBody(pdfObject3, this.getNewObjectNumber(this.reader, n3, 0));
                }
            } else {
                for (int i = 1; i < this.reader.getXrefSize(); ++i) {
                    PdfObject pdfObject4 = this.reader.getPdfObjectRelease(i);
                    if (pdfObject4 == null || n == i) continue;
                    this.addToBody(pdfObject4, this.getNewObjectNumber(this.reader, i, 0), i != n2);
                }
            }
        }
        finally {
            try {
                this.file.close();
            }
            catch (Exception exception) {}
        }
        PdfIndirectReference pdfIndirectReference = null;
        PdfObject pdfObject5 = null;
        if (this.crypto != null) {
            if (this.append) {
                pdfIndirectReference = this.reader.getCryptoRef();
            } else {
                object2 = this.addToBody((PdfObject)this.crypto.getEncryptionDictionary(), false);
                pdfIndirectReference = ((PdfIndirectObject)object2).getIndirectReference();
            }
            pdfObject5 = this.crypto.getFileID();
        } else {
            pdfObject5 = PdfEncryption.createInfoId(PdfEncryption.createDocumentId());
        }
        object2 = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        PdfIndirectReference pdfIndirectReference2 = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, ((PdfIndirectReference)object2).getNumber(), 0));
        PdfIndirectReference pdfIndirectReference3 = null;
        pdfObject = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
        PdfDictionary pdfDictionary3 = new PdfDictionary();
        if (pdfObject != null) {
            for (PdfName object3 : ((PdfDictionary)pdfObject).getKeys()) {
                object = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(object3));
                pdfDictionary3.put(object3, (PdfObject)object);
            }
        }
        if (hashMap != null) {
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (String)entry.getKey();
                PdfName pdfName = new PdfName((String)object);
                String string = (String)entry.getValue();
                if (string == null) {
                    pdfDictionary3.remove(pdfName);
                    continue;
                }
                pdfDictionary3.put(pdfName, new PdfString(string, "UnicodeBig"));
            }
        }
        if (this.append) {
            pdfIndirectReference3 = pdfObject2 == null ? this.addToBody((PdfObject)pdfDictionary3, false).getIndirectReference() : this.addToBody((PdfObject)pdfDictionary3, ((PdfIndirectReference)pdfObject2).getNumber(), false).getIndirectReference();
        } else if (!pdfDictionary3.getKeys().isEmpty()) {
            pdfIndirectReference3 = this.addToBody((PdfObject)pdfDictionary3, false).getIndirectReference();
        }
        this.body.writeCrossReferenceTable(this.os, pdfIndirectReference2, pdfIndirectReference3, pdfIndirectReference, pdfObject5, this.prevxref);
        if (this.fullCompression) {
            this.os.write(PdfStamperImp.getISOBytes("startxref\n"));
            this.os.write(PdfStamperImp.getISOBytes(String.valueOf(this.body.offset())));
            this.os.write(PdfStamperImp.getISOBytes("\n%%EOF\n"));
        } else {
            PdfWriter.PdfTrailer pdfTrailer = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectReference2, pdfIndirectReference3, pdfIndirectReference, pdfObject5, this.prevxref);
            pdfTrailer.toPdf(this, this.os);
        }
        this.os.flush();
        if (this.isCloseStream()) {
            this.os.close();
        }
        this.reader.close();
    }

    void applyRotation(PdfDictionary pdfDictionary, ByteBuffer byteBuffer) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
        int n = rectangle.getRotation();
        switch (n) {
            case 90: {
                byteBuffer.append(PdfContents.ROTATE90);
                byteBuffer.append(rectangle.getTop());
                byteBuffer.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                byteBuffer.append(PdfContents.ROTATE180);
                byteBuffer.append(rectangle.getRight());
                byteBuffer.append(' ');
                byteBuffer.append(rectangle.getTop());
                byteBuffer.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                byteBuffer.append(PdfContents.ROTATE270);
                byteBuffer.append('0').append(' ');
                byteBuffer.append(rectangle.getRight());
                byteBuffer.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    void alterContents() throws IOException {
        for (PageStamp pageStamp : this.pagesToContent.values()) {
            PdfDictionary pdfDictionary = pageStamp.pageN;
            this.markUsed(pdfDictionary);
            PdfArray pdfArray = null;
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS), pdfDictionary);
            if (pdfObject == null) {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else if (pdfObject.isArray()) {
                pdfArray = (PdfArray)pdfObject;
                this.markUsed(pdfArray);
            } else if (pdfObject.isStream()) {
                pdfArray = new PdfArray();
                pdfArray.add(pdfDictionary.get(PdfName.CONTENTS));
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            }
            ByteBuffer byteBuffer = new ByteBuffer();
            if (pageStamp.under != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(pageStamp.under.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            if (pageStamp.over != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
            }
            PdfStream pdfStream = new PdfStream(byteBuffer.toByteArray());
            pdfStream.flateCompress();
            pdfArray.addFirst(this.addToBody(pdfStream).getIndirectReference());
            byteBuffer.reset();
            if (pageStamp.over != null) {
                byteBuffer.append(' ');
                byteBuffer.append(PdfContents.RESTORESTATE);
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(pageStamp.over.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
                pdfStream = new PdfStream(byteBuffer.toByteArray());
                pdfStream.flateCompress();
                pdfArray.add(this.addToBody(pdfStream).getIndirectReference());
            }
            this.alterResources(pageStamp);
        }
    }

    void alterResources(PageStamp pageStamp) {
        pageStamp.pageN.put(PdfName.RESOURCES, pageStamp.pageResources.getResources());
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        IntHashtable intHashtable = (IntHashtable)this.readers2intrefs.get(pdfReader);
        if (intHashtable != null) {
            int n3 = intHashtable.get(n);
            if (n3 == 0) {
                n3 = this.getIndirectReferenceNumber();
                intHashtable.put(n, n3);
            }
            return n3;
        }
        if (this.currentPdfReaderInstance == null) {
            if (this.append && n < this.initialXrefSize) {
                return n;
            }
            int n4 = this.myXref.get(n);
            if (n4 == 0) {
                n4 = this.getIndirectReferenceNumber();
                this.myXref.put(n, n4);
            }
            return n4;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
            if (randomAccessFileOrArray != null) {
                return randomAccessFileOrArray;
            }
            return pdfReader.getSafeFile();
        }
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    public void registerReader(PdfReader pdfReader, boolean bl) throws IOException {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.put(pdfReader, new IntHashtable());
        if (bl) {
            RandomAccessFileOrArray randomAccessFileOrArray = pdfReader.getSafeFile();
            this.readers2file.put(pdfReader, randomAccessFileOrArray);
            randomAccessFileOrArray.reOpen();
        }
    }

    public void unRegisterReader(PdfReader pdfReader) {
        if (!this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.remove(pdfReader);
        RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
        if (randomAccessFileOrArray == null) {
            return;
        }
        this.readers2file.remove(pdfReader);
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void findAllObjects(PdfReader pdfReader, PdfObject pdfObject, IntHashtable intHashtable) {
        if (pdfObject == null) {
            return;
        }
        switch (pdfObject.type()) {
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                if (pdfReader != pRIndirectReference.getReader()) {
                    return;
                }
                if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                    return;
                }
                intHashtable.put(pRIndirectReference.getNumber(), 1);
                PdfStamperImp.findAllObjects(pdfReader, PdfReader.getPdfObject(pdfObject), intHashtable);
                return;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    PdfStamperImp.findAllObjects(pdfReader, (PdfObject)arrayList.get(i), intHashtable);
                }
                return;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                for (PdfName pdfName : pdfDictionary.getKeys()) {
                    PdfStamperImp.findAllObjects(pdfReader, pdfDictionary.get(pdfName), intHashtable);
                }
                return;
            }
        }
    }

    public void addComments(FdfReader fdfReader) throws IOException {
        PdfObject pdfObject;
        PdfObject pdfObject2;
        int n;
        PdfObject pdfObject3;
        PdfObject pdfObject4;
        if (this.readers2intrefs.containsKey(fdfReader)) {
            return;
        }
        PdfDictionary pdfDictionary = fdfReader.getCatalog();
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FDF))) == null) {
            return;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
        if (pdfArray == null || pdfArray.size() == 0) {
            return;
        }
        this.registerReader(fdfReader, false);
        IntHashtable intHashtable = new IntHashtable();
        HashMap<String, PdfObject> hashMap = new HashMap<String, PdfObject>();
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        ArrayList arrayList2 = pdfArray.getArrayList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            PdfObject pdfObject5 = (PdfObject)arrayList2.get(i);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfObject5);
            pdfObject4 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.PAGE));
            if (pdfObject4 == null || ((PdfNumber)pdfObject4).intValue() >= this.reader.getNumberOfPages()) continue;
            PdfStamperImp.findAllObjects(fdfReader, pdfObject5, intHashtable);
            arrayList.add(pdfObject5);
            if (pdfObject5.type() != 10 || (pdfObject3 = PdfReader.getPdfObject(pdfDictionary2.get(PdfName.NM))) == null || pdfObject3.type() != 3) continue;
            hashMap.put(pdfObject3.toString(), pdfObject5);
        }
        int[] nArray = intHashtable.getKeys();
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            pdfObject4 = fdfReader.getPdfObject(n2);
            if (pdfObject4.type() == 6 && (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject4).get(PdfName.IRT))) != null && pdfObject3.type() == 3 && (pdfObject2 = (PdfObject)hashMap.get(pdfObject3.toString())) != null) {
                pdfObject = new PdfDictionary();
                ((PdfDictionary)pdfObject).merge((PdfDictionary)pdfObject4);
                ((PdfDictionary)pdfObject).put(PdfName.IRT, pdfObject2);
                pdfObject4 = pdfObject;
            }
            this.addToBody(pdfObject4, this.getNewObjectNumber(fdfReader, n2, 0));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            PdfObject pdfObject6 = (PdfObject)arrayList.get(n);
            pdfObject4 = (PdfDictionary)PdfReader.getPdfObject(pdfObject6);
            pdfObject3 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)pdfObject4).get(PdfName.PAGE));
            pdfObject2 = this.reader.getPageN(((PdfNumber)pdfObject3).intValue() + 1);
            pdfObject = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.ANNOTS), pdfObject2);
            if (pdfObject == null) {
                pdfObject = new PdfArray();
                ((PdfDictionary)pdfObject2).put(PdfName.ANNOTS, pdfObject);
                this.markUsed(pdfObject2);
            }
            this.markUsed(pdfObject);
            ((PdfArray)pdfObject).add(pdfObject6);
        }
    }

    PageStamp getPageStamp(int n) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PageStamp pageStamp = (PageStamp)this.pagesToContent.get(pdfDictionary);
        if (pageStamp == null) {
            pageStamp = new PageStamp(this, this.reader, pdfDictionary);
            this.pagesToContent.put(pdfDictionary, pageStamp);
        }
        return pageStamp;
    }

    PdfContentByte getUnderContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.under == null) {
            pageStamp.under = new StampContent(this, pageStamp);
        }
        return pageStamp.under;
    }

    PdfContentByte getOverContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.over == null) {
            pageStamp.over = new StampContent(this, pageStamp);
        }
        return pageStamp.over;
    }

    void correctAcroFieldPages(int n) {
        if (this.acroFields == null) {
            return;
        }
        if (n > this.reader.getNumberOfPages()) {
            return;
        }
        HashMap hashMap = this.acroFields.getFields();
        for (AcroFields.Item item : hashMap.values()) {
            ArrayList arrayList = item.page;
            for (int i = 0; i < arrayList.size(); ++i) {
                int n2 = (Integer)arrayList.get(i);
                if (n2 < n) continue;
                arrayList.set(i, new Integer(n2 + 1));
            }
        }
    }

    void insertPage(int n, Rectangle rectangle) {
        PdfObject pdfObject;
        PdfDictionary pdfDictionary;
        PRIndirectReference pRIndirectReference;
        PdfObject pdfObject2;
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n2 = rectangle2.getRotation() % 360;
        PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.PAGE);
        PdfDictionary pdfDictionary3 = new PdfDictionary();
        PdfArray pdfArray = new PdfArray();
        pdfArray.add(PdfName.PDF);
        pdfArray.add(PdfName.TEXT);
        pdfArray.add(PdfName.IMAGEB);
        pdfArray.add(PdfName.IMAGEC);
        pdfArray.add(PdfName.IMAGEI);
        pdfDictionary3.put(PdfName.PROCSET, pdfArray);
        pdfDictionary2.put(PdfName.RESOURCES, pdfDictionary3);
        pdfDictionary2.put(PdfName.ROTATE, new PdfNumber(n2));
        pdfDictionary2.put(PdfName.MEDIABOX, new PdfRectangle(rectangle2, n2));
        PRIndirectReference pRIndirectReference2 = this.reader.addPdfObject(pdfDictionary2);
        if (n > this.reader.getNumberOfPages()) {
            pdfObject2 = this.reader.getPageNRelease(this.reader.getNumberOfPages());
            pRIndirectReference = (PRIndirectReference)((PdfDictionary)pdfObject2).get(PdfName.PARENT);
            pRIndirectReference = new PRIndirectReference(this.reader, pRIndirectReference.getNumber());
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            pdfObject = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS), pdfDictionary);
            ((PdfArray)pdfObject).add(pRIndirectReference2);
            this.markUsed(pdfObject);
            this.reader.pageRefs.insertPage(n, pRIndirectReference2);
        } else {
            if (n < 1) {
                n = 1;
            }
            pdfObject2 = this.reader.getPageN(n);
            pdfObject = this.reader.getPageOrigRef(n);
            this.reader.releasePage(n);
            pRIndirectReference = (PRIndirectReference)((PdfDictionary)pdfObject2).get(PdfName.PARENT);
            pRIndirectReference = new PRIndirectReference(this.reader, pRIndirectReference.getNumber());
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            PdfArray pdfArray2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS), pdfDictionary);
            ArrayList arrayList = pdfArray2.getArrayList();
            int n3 = arrayList.size();
            int n4 = ((PdfIndirectReference)pdfObject).getNumber();
            for (int i = 0; i < n3; ++i) {
                PRIndirectReference pRIndirectReference3 = (PRIndirectReference)arrayList.get(i);
                if (n4 != pRIndirectReference3.getNumber()) continue;
                arrayList.add(i, pRIndirectReference2);
                break;
            }
            if (n3 == arrayList.size()) {
                throw new RuntimeException("Internal inconsistence.");
            }
            this.markUsed(pdfArray2);
            this.reader.pageRefs.insertPage(n, pRIndirectReference2);
            this.correctAcroFieldPages(n);
        }
        pdfDictionary2.put(PdfName.PARENT, pRIndirectReference);
        while (pdfDictionary != null) {
            this.markUsed(pdfDictionary);
            pdfObject2 = (PdfNumber)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.COUNT));
            pdfDictionary.put(PdfName.COUNT, new PdfNumber(((PdfNumber)pdfObject2).intValue() + 1));
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.PARENT));
        }
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean bl) {
        this.rotateContents = bl;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean bl) {
        this.flat = bl;
    }

    void setFreeTextFlattening(boolean bl) {
        this.flatFreeText = bl;
    }

    boolean partialFormFlattening(String string) {
        this.getAcroFields();
        if (this.acroFields.getXfa().isXfaPresent()) {
            throw new UnsupportedOperationException("Partial form flattening is not supported with XFA forms.");
        }
        if (!this.acroFields.getFields().containsKey(string)) {
            return false;
        }
        this.partialFlattening.add(string);
        return true;
    }

    void flatFields() {
        PdfObject pdfObject;
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.append) {
            throw new IllegalArgumentException("Field flattening is not supported in append mode.");
        }
        this.getAcroFields();
        HashMap hashMap = this.acroFields.getFields();
        if (this.fieldsAdded && this.partialFlattening.isEmpty()) {
            object4 = hashMap.keySet().iterator();
            while (object4.hasNext()) {
                this.partialFlattening.add(object4.next());
            }
        }
        object4 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        ArrayList arrayList = null;
        if (object4 != null && (object3 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.FIELDS), (PdfObject)object4)) != null) {
            arrayList = ((PdfArray)object3).getArrayList();
        }
        for (Map.Entry object5 : hashMap.entrySet()) {
            object2 = (String)object5.getKey();
            if (!this.partialFlattening.isEmpty() && !this.partialFlattening.contains(object2)) continue;
            object = (AcroFields.Item)object5.getValue();
            for (n = 0; n < ((AcroFields.Item)object).merged.size(); ++n) {
                PdfObject pdfObject2;
                Object object6;
                Object object7;
                PdfObject pdfObject3;
                pdfObject = (PdfDictionary)((AcroFields.Item)object).merged.get(n);
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.F));
                int n2 = 0;
                if (pdfNumber != null) {
                    n2 = pdfNumber.intValue();
                }
                int n3 = (Integer)((AcroFields.Item)object).page.get(n);
                PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.AP));
                if (pdfDictionary != null && (n2 & 4) != 0 && (n2 & 2) == 0) {
                    Object object8;
                    pdfObject3 = pdfDictionary.get(PdfName.N);
                    object7 = null;
                    if (pdfObject3 != null) {
                        object6 = PdfReader.getPdfObject(pdfObject3);
                        if (pdfObject3 instanceof PdfIndirectReference && !pdfObject3.isIndirect()) {
                            object7 = new PdfAppearance((PdfIndirectReference)pdfObject3);
                        } else if (object6 instanceof PdfStream) {
                            ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                            object7 = new PdfAppearance((PdfIndirectReference)pdfObject3);
                        } else if (object6 != null && ((PdfObject)object6).isDictionary() && (object8 = (PdfName)PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.AS))) != null && (pdfObject2 = (PdfIndirectReference)((PdfDictionary)object6).get((PdfName)object8)) != null) {
                            object7 = new PdfAppearance((PdfIndirectReference)pdfObject2);
                            if (pdfObject2.isIndirect()) {
                                object6 = PdfReader.getPdfObject(pdfObject2);
                                ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                            }
                        }
                    }
                    if (object7 != null) {
                        object6 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.RECT)));
                        object8 = this.getOverContent(n3);
                        ((PdfContentByte)object8).setLiteral("Q ");
                        ((PdfContentByte)object8).addTemplate((PdfTemplate)object7, ((Rectangle)object6).getLeft(), ((Rectangle)object6).getBottom());
                        ((PdfContentByte)object8).setLiteral("q ");
                    }
                }
                if (this.partialFlattening.isEmpty() || (object7 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)(pdfObject3 = this.reader.getPageN(n3))).get(PdfName.ANNOTS))) == null) continue;
                object6 = ((PdfArray)object7).getArrayList();
                block3: for (int i = 0; i < ((ArrayList)object6).size(); ++i) {
                    PdfObject pdfObject4;
                    pdfObject2 = (PdfObject)((ArrayList)object6).get(i);
                    if (!pdfObject2.isIndirect() || !(pdfObject4 = (PdfObject)((AcroFields.Item)object).widget_refs.get(n)).isIndirect() || ((PRIndirectReference)pdfObject2).getNumber() != ((PRIndirectReference)pdfObject4).getNumber()) continue;
                    ((ArrayList)object6).remove(i--);
                    PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject4;
                    while (true) {
                        PdfObject pdfObject5;
                        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
                        PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary2.get(PdfName.PARENT);
                        PdfReader.killIndirect(pRIndirectReference);
                        if (pRIndirectReference2 == null) {
                            for (int j = 0; j < arrayList.size(); ++j) {
                                pdfObject5 = (PdfObject)arrayList.get(j);
                                if (!pdfObject5.isIndirect() || ((PRIndirectReference)pdfObject5).getNumber() != pRIndirectReference.getNumber()) continue;
                                arrayList.remove(j);
                                --j;
                            }
                            continue block3;
                        }
                        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference2);
                        pdfObject5 = (PdfArray)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.KIDS));
                        ArrayList arrayList2 = ((PdfArray)pdfObject5).getArrayList();
                        for (int j = 0; j < arrayList2.size(); ++j) {
                            PdfObject pdfObject6 = (PdfObject)arrayList2.get(j);
                            if (!pdfObject6.isIndirect() || ((PRIndirectReference)pdfObject6).getNumber() != pRIndirectReference.getNumber()) continue;
                            arrayList2.remove(j);
                            --j;
                        }
                        if (!arrayList2.isEmpty()) continue block3;
                        pRIndirectReference = pRIndirectReference2;
                    }
                }
                if (!((ArrayList)object6).isEmpty()) continue;
                PdfReader.killIndirect(((PdfDictionary)pdfObject3).get(PdfName.ANNOTS));
                ((PdfDictionary)pdfObject3).remove(PdfName.ANNOTS);
            }
        }
        if (!this.fieldsAdded && this.partialFlattening.isEmpty()) {
            for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
                PdfDictionary pdfDictionary = this.reader.getPageN(i);
                object2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
                if (object2 == null) continue;
                object = ((PdfArray)object2).getArrayList();
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    pdfObject = PdfReader.getPdfObject((PdfObject)((ArrayList)object).get(n));
                    if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || pdfObject.isDictionary() && !PdfName.WIDGET.equals(((PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                    ((ArrayList)object).remove(n);
                    --n;
                }
                if (!((ArrayList)object).isEmpty()) continue;
                PdfReader.killIndirect(pdfDictionary.get(PdfName.ANNOTS));
                pdfDictionary.remove(PdfName.ANNOTS);
            }
            this.eliminateAcroformObjects();
        }
    }

    void eliminateAcroformObjects() {
        PdfObject pdfObject = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (pdfObject == null) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
        this.reader.killXref(pdfDictionary.get(PdfName.XFA));
        pdfDictionary.remove(PdfName.XFA);
        PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIELDS);
        if (pdfObject2 != null) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.put(PdfName.KIDS, pdfObject2);
            this.sweepKids(pdfDictionary2);
            PdfReader.killIndirect(pdfObject2);
            pdfDictionary.put(PdfName.FIELDS, new PdfArray());
        }
    }

    void sweepKids(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.killIndirect(pdfObject);
        if (pdfObject2 == null || !pdfObject2.isDictionary()) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
        PdfArray pdfArray = (PdfArray)PdfReader.killIndirect(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            return;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.sweepKids((PdfObject)arrayList.get(i));
        }
    }

    private void flatFreeTextFields() {
        if (this.append) {
            throw new IllegalArgumentException("FreeText flattening is not supported in append mode.");
        }
        for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
            PdfDictionary pdfDictionary;
            PdfObject pdfObject;
            int n;
            PdfDictionary pdfDictionary2 = this.reader.getPageN(i);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ANNOTS));
            if (pdfArray == null) continue;
            ArrayList arrayList = pdfArray.getArrayList();
            for (n = 0; n < arrayList.size(); ++n) {
                Object object;
                Object object2;
                PdfObject pdfObject2;
                int n2;
                pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || !((PdfName)(pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE)).equals(PdfName.FREETEXT)) continue;
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F));
                int n3 = n2 = pdfNumber != null ? pdfNumber.intValue() : 0;
                if ((n2 & 4) == 0 || (n2 & 2) != 0 || (pdfObject2 = pdfDictionary.get(PdfName.AP)) == null) continue;
                PdfDictionary pdfDictionary3 = pdfObject2 instanceof PdfIndirectReference ? (PdfDictionary)PdfReader.getPdfObject(pdfObject2) : (PdfDictionary)pdfObject2;
                PdfObject pdfObject3 = pdfDictionary3.get(PdfName.N);
                PdfAppearance pdfAppearance = null;
                PdfObject pdfObject4 = PdfReader.getPdfObject(pdfObject3);
                if (pdfObject3 instanceof PdfIndirectReference && !pdfObject3.isIndirect()) {
                    pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                } else if (pdfObject4 instanceof PdfStream) {
                    ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                    pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                } else if (pdfObject4.isDictionary() && (object2 = (PdfName)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.AS))) != null && (object = (PdfIndirectReference)((PdfDictionary)pdfObject4).get((PdfName)object2)) != null) {
                    pdfAppearance = new PdfAppearance((PdfIndirectReference)object);
                    if (((PdfObject)object).isIndirect()) {
                        pdfObject4 = PdfReader.getPdfObject((PdfObject)object);
                        ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                    }
                }
                if (pdfAppearance == null) continue;
                object2 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT)));
                object = this.getOverContent(i);
                ((PdfContentByte)object).setLiteral("Q ");
                ((PdfContentByte)object).addTemplate(pdfAppearance, ((Rectangle)object2).getLeft(), ((Rectangle)object2).getBottom());
                ((PdfContentByte)object).setLiteral("q ");
            }
            for (n = 0; n < arrayList.size(); ++n) {
                pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                if (pdfObject == null || !pdfObject.isDictionary() || !PdfName.FREETEXT.equals((pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                arrayList.remove(n);
                --n;
            }
            if (!arrayList.isEmpty()) continue;
            PdfReader.killIndirect(pdfDictionary2.get(PdfName.ANNOTS));
            pdfDictionary2.remove(PdfName.ANNOTS);
        }
    }

    public PdfIndirectReference getPageReference(int n) {
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n);
        if (pRIndirectReference == null) {
            throw new IllegalArgumentException("Invalid page number " + n);
        }
        return pRIndirectReference;
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ACROFORM), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.ACROFORM, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FIELDS), pdfDictionary2)) == null) {
            pdfArray = new PdfArray();
            pdfDictionary2.put(PdfName.FIELDS, pdfArray);
            this.markUsed(pdfDictionary2);
        }
        if (!pdfDictionary2.contains(PdfName.DA)) {
            pdfDictionary2.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(pdfDictionary2);
        }
        pdfArray.add(pdfIndirectReference);
        this.markUsed(pdfArray);
    }

    void addFieldResources() throws IOException {
        Object object;
        PdfDictionary pdfDictionary;
        if (this.fieldTemplates.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary2 = this.reader.getCatalog();
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ACROFORM), pdfDictionary2);
        if (pdfDictionary3 == null) {
            pdfDictionary3 = new PdfDictionary();
            pdfDictionary2.put(PdfName.ACROFORM, pdfDictionary3);
            this.markUsed(pdfDictionary2);
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.DR), pdfDictionary3)) == null) {
            pdfDictionary = new PdfDictionary();
            pdfDictionary3.put(PdfName.DR, pdfDictionary);
            this.markUsed(pdfDictionary3);
        }
        this.markUsed(pdfDictionary);
        Object object2 = this.fieldTemplates.keySet().iterator();
        while (object2.hasNext()) {
            object = (PdfTemplate)object2.next();
            PdfFormField.mergeResources(pdfDictionary, (PdfDictionary)((PdfTemplate)object).getResources(), this);
        }
        if (pdfDictionary.get(PdfName.ENCODING) == null) {
            pdfDictionary.put(PdfName.ENCODING, PdfName.WIN_ANSI_ENCODING);
        }
        if ((object2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONT))) == null) {
            object2 = new PdfDictionary();
            pdfDictionary.put(PdfName.FONT, (PdfObject)object2);
        }
        if (!((PdfDictionary)object2).contains(PdfName.HELV)) {
            object = new PdfDictionary(PdfName.FONT);
            ((PdfDictionary)object).put(PdfName.BASEFONT, PdfName.HELVETICA);
            ((PdfDictionary)object).put(PdfName.ENCODING, PdfName.WIN_ANSI_ENCODING);
            ((PdfDictionary)object).put(PdfName.NAME, PdfName.HELV);
            ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.TYPE1);
            ((PdfDictionary)object2).put(PdfName.HELV, this.addToBody((PdfObject)object).getIndirectReference());
        }
        if (!((PdfDictionary)object2).contains(PdfName.ZADB)) {
            object = new PdfDictionary(PdfName.FONT);
            ((PdfDictionary)object).put(PdfName.BASEFONT, PdfName.ZAPFDINGBATS);
            ((PdfDictionary)object).put(PdfName.NAME, PdfName.ZADB);
            ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.TYPE1);
            ((PdfDictionary)object2).put(PdfName.ZADB, this.addToBody((PdfObject)object).getIndirectReference());
        }
        if (pdfDictionary3.get(PdfName.DA) == null) {
            pdfDictionary3.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(pdfDictionary3);
        }
    }

    void expandFields(PdfFormField pdfFormField, ArrayList arrayList) {
        arrayList.add(pdfFormField);
        ArrayList arrayList2 = pdfFormField.getKids();
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.expandFields((PdfFormField)arrayList2.get(i), arrayList);
            }
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, PdfDictionary pdfDictionary) {
        try {
            ArrayList<PdfAnnotation> arrayList = new ArrayList<PdfAnnotation>();
            if (pdfAnnotation.isForm()) {
                this.fieldsAdded = true;
                this.getAcroFields();
                PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
                if (pdfFormField.getParent() != null) {
                    return;
                }
                this.expandFields(pdfFormField, arrayList);
            } else {
                arrayList.add(pdfAnnotation);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                pdfAnnotation = (PdfAnnotation)arrayList.get(i);
                if (pdfAnnotation.getPlaceInPage() > 0) {
                    pdfDictionary = this.reader.getPageN(pdfAnnotation.getPlaceInPage());
                }
                if (pdfAnnotation.isForm()) {
                    if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.getTemplates()) != null) {
                        this.fieldTemplates.putAll(object);
                    }
                    if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                        this.addDocumentField(((PdfAnnotation)object).getIndirectReference());
                    }
                }
                if (pdfAnnotation.isAnnotation()) {
                    PdfRectangle pdfRectangle;
                    object = PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS), pdfDictionary);
                    PdfArray pdfArray = null;
                    if (object == null || !((PdfObject)object).isArray()) {
                        pdfArray = new PdfArray();
                        pdfDictionary.put(PdfName.ANNOTS, pdfArray);
                        this.markUsed(pdfDictionary);
                    } else {
                        pdfArray = (PdfArray)object;
                    }
                    pdfArray.add(pdfAnnotation.getIndirectReference());
                    this.markUsed(pdfArray);
                    if (!(pdfAnnotation.isUsed() || (pdfRectangle = (PdfRectangle)pdfAnnotation.get(PdfName.RECT)) == null || pdfRectangle.left() == 0.0f && pdfRectangle.right() == 0.0f && pdfRectangle.top() == 0.0f && pdfRectangle.bottom() == 0.0f)) {
                        int n = this.reader.getPageRotation(pdfDictionary);
                        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
                        switch (n) {
                            case 90: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.getTop() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.getTop() - pdfRectangle.top(), pdfRectangle.right()));
                                break;
                            }
                            case 180: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.getRight() - pdfRectangle.left(), rectangle.getTop() - pdfRectangle.bottom(), rectangle.getRight() - pdfRectangle.right(), rectangle.getTop() - pdfRectangle.top()));
                                break;
                            }
                            case 270: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.getRight() - pdfRectangle.left(), pdfRectangle.top(), rectangle.getRight() - pdfRectangle.right()));
                            }
                        }
                    }
                }
                if (pdfAnnotation.isUsed()) continue;
                pdfAnnotation.setUsed();
                this.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.getIndirectReference());
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        this.addAnnotation(pdfAnnotation, this.reader.getPageN(n));
    }

    private void outlineTravel(PRIndirectReference pRIndirectReference) {
        while (pRIndirectReference != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pRIndirectReference);
            PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary.get(PdfName.FIRST);
            if (pRIndirectReference2 != null) {
                this.outlineTravel(pRIndirectReference2);
            }
            PdfReader.killIndirect(pdfDictionary.get(PdfName.DEST));
            PdfReader.killIndirect(pdfDictionary.get(PdfName.A));
            PdfReader.killIndirect(pRIndirectReference);
            pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.NEXT);
        }
    }

    void deleteOutlines() {
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.OUTLINES);
        if (pRIndirectReference == null) {
            return;
        }
        this.outlineTravel(pRIndirectReference);
        PdfReader.killIndirect(pRIndirectReference);
        pdfDictionary.remove(PdfName.OUTLINES);
        this.markUsed(pdfDictionary);
    }

    void setJavaScript() throws IOException {
        HashMap hashMap = this.pdf.getDocumentLevelJS();
        if (hashMap.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        PdfDictionary pdfDictionary3 = PdfNameTree.writeTree(hashMap, this);
        pdfDictionary2.put(PdfName.JAVASCRIPT, this.addToBody(pdfDictionary3).getIndirectReference());
    }

    void addFileAttachments() throws IOException {
        HashMap hashMap = this.pdf.getDocumentFileAttachment();
        if (hashMap.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        HashMap hashMap2 = PdfNameTree.readTree((PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.EMBEDDEDFILES)));
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            int n = 0;
            String string2 = string;
            while (hashMap2.containsKey(string2)) {
                string2 = string2 + " " + ++n;
            }
            hashMap2.put(string2, entry.getValue());
        }
        PdfDictionary pdfDictionary3 = PdfNameTree.writeTree(hashMap2, this);
        pdfDictionary2.put(PdfName.EMBEDDEDFILES, this.addToBody(pdfDictionary3).getIndirectReference());
    }

    void makePackage(PdfCollection pdfCollection) {
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        pdfDictionary.put(PdfName.COLLECTION, pdfCollection);
    }

    void setOutlines() throws IOException {
        if (this.newBookmarks == null) {
            return;
        }
        this.deleteOutlines();
        if (this.newBookmarks.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        boolean bl = pdfDictionary.get(PdfName.DESTS) != null;
        this.writeOutlines(pdfDictionary, bl);
        this.markUsed(pdfDictionary);
    }

    public void setViewerPreferences(int n) {
        this.useVp = true;
        this.viewerPreferences.setViewerPreferences(n);
    }

    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        this.useVp = true;
        this.viewerPreferences.addViewerPreference(pdfName, pdfObject);
    }

    public void setSigFlags(int n) {
        this.sigFlags |= n;
    }

    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setPageAction(PdfName pdfName, PdfAction pdfAction, int n) throws PdfException {
        if (!pdfName.equals(PAGE_OPEN) && !pdfName.equals(PAGE_CLOSE)) {
            throw new PdfException("Invalid page additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AA), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.AA, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        pdfDictionary2.put(pdfName, pdfAction);
        this.markUsed(pdfDictionary2);
    }

    public void setDuration(int n) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    public void setTransition(PdfTransition pdfTransition) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setDuration(int n, int n2) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        if (n < 0) {
            pdfDictionary.remove(PdfName.DUR);
        } else {
            pdfDictionary.put(PdfName.DUR, new PdfNumber(n));
        }
        this.markUsed(pdfDictionary);
    }

    void setTransition(PdfTransition pdfTransition, int n) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        if (pdfTransition == null) {
            pdfDictionary.remove(PdfName.TRANS);
        } else {
            pdfDictionary.put(PdfName.TRANS, pdfTransition.getTransitionDictionary());
        }
        this.markUsed(pdfDictionary);
    }

    protected void markUsed(PdfObject pdfObject) {
        if (this.append && pdfObject != null) {
            PRIndirectReference pRIndirectReference = null;
            pRIndirectReference = pdfObject.type() == 10 ? (PRIndirectReference)pdfObject : pdfObject.getIndRef();
            if (pRIndirectReference != null) {
                this.marked.put(pRIndirectReference.getNumber(), 1);
            }
        }
    }

    protected void markUsed(int n) {
        if (this.append) {
            this.marked.put(n, 1);
        }
    }

    boolean isAppend() {
        return this.append;
    }

    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new PdfException("Invalid additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.AA));
        if (pdfDictionary == null) {
            if (pdfAction == null) {
                return;
            }
            pdfDictionary = new PdfDictionary();
            this.reader.getCatalog().put(PdfName.AA, pdfDictionary);
        }
        this.markUsed(pdfDictionary);
        if (pdfAction == null) {
            pdfDictionary.remove(pdfName);
        } else {
            pdfDictionary.put(pdfName, pdfAction);
        }
    }

    public void setOpenAction(PdfAction pdfAction) {
        this.openAction = pdfAction;
    }

    public void setOpenAction(String string) {
        throw new UnsupportedOperationException("Open actions by name are not supported.");
    }

    public void setThumbnail(Image image) {
        throw new UnsupportedOperationException("Use PdfStamper.setThumbnail().");
    }

    void setThumbnail(Image image, int n) throws PdfException, DocumentException {
        PdfIndirectReference pdfIndirectReference = this.getImageReference(this.addDirectImageSimple(image));
        this.reader.resetReleasePage();
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        pdfDictionary.put(PdfName.THUMB, pdfIndirectReference);
        this.reader.resetReleasePage();
    }

    public PdfContentByte getDirectContentUnder() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }

    public PdfContentByte getDirectContent() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }

    static class PageStamp {
        PdfDictionary pageN;
        StampContent under;
        StampContent over;
        PageResources pageResources;

        PageStamp(PdfStamperImp pdfStamperImp, PdfReader pdfReader, PdfDictionary pdfDictionary) {
            this.pageN = pdfDictionary;
            this.pageResources = new PageResources();
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RESOURCES));
            this.pageResources.setOriginalResources(pdfDictionary2, pdfStamperImp.namePtr);
        }
    }
}

