/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.server.jetty;

import coldfusion.debugger.CFDebuggerLogger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class CFJettyDebugServer {
    public static final int DEFAULT_MAX_DEBUG_SESSIONS = 5;

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            System.err.println("Please specify debugger host and the port and optionally server port");
            System.exit(0);
        }
        String debugHost = null;
        String strDebugPort = null;
        String strServerPort = null;
        String strMaxDebugSessions = null;
        String ctxRoot = null;
        String canonicalCtxRoot = null;
        int debugPort = -1;
        int serverPort = 8090;
        if (args.length == 1) {
            strDebugPort = args[0];
        } else if (args.length == 2) {
            debugHost = args[0];
            strDebugPort = args[1];
        } else if (args.length == 3) {
            debugHost = args[0];
            strDebugPort = args[1];
            strServerPort = args[2];
        } else if (args.length == 4) {
            debugHost = args[0];
            strDebugPort = args[1];
            strServerPort = args[2];
            strMaxDebugSessions = args[3];
        } else if (args.length == 5) {
            debugHost = args[0];
            strDebugPort = args[1];
            strServerPort = args[2];
            strMaxDebugSessions = args[3];
            ctxRoot = args[4];
        } else {
            debugHost = args[0];
            strDebugPort = args[1];
            strServerPort = args[2];
            strMaxDebugSessions = args[3];
            ctxRoot = args[4];
            canonicalCtxRoot = args[5];
        }
        try {
            debugPort = Integer.parseInt(strDebugPort);
        }
        catch (NumberFormatException ne) {
            CFDebuggerLogger.log(ne);
            System.exit(0);
        }
        try {
            serverPort = Integer.parseInt(strServerPort);
        }
        catch (NumberFormatException ne) {
            CFDebuggerLogger.log("Please specify valid server port number");
            System.exit(0);
        }
        try {
            if (strMaxDebugSessions != null) {
                Integer.parseInt(strMaxDebugSessions);
            } else {
                strMaxDebugSessions = String.valueOf(5);
            }
        }
        catch (NumberFormatException nfe) {
            System.out.println("Invalid argument value for max debug sessions. Expecting integer value.");
        }
        Server server = new Server();
        ServerConnector serverConnector = new ServerConnector(server);
        serverConnector.setPort(serverPort);
        serverConnector.setIdleTimeout(90000000L);
        server.addConnector((Connector)serverConnector);
        ServletHandler handler = new ServletHandler();
        server.setHandler((Handler)handler);
        handler.addServletWithMapping("coldfusion.debugger.rds.RdsFrontEndServlet", "/CFIDE/main/ide.cfm");
        ServletHolder[] holders = handler.getServlets();
        ServletHolder aHolder = holders[0];
        String traceValue = System.getProperty("DEBUGGER_TRACE");
        if (debugHost != null) {
            aHolder.setInitParameter("DEBUG_HOST", debugHost);
        }
        if (debugPort > 0) {
            aHolder.setInitParameter("DEBUG_PORT", String.valueOf(debugPort));
        }
        if (strMaxDebugSessions != null) {
            aHolder.setInitParameter("MAX_DEBUG_SESSIONS", strMaxDebugSessions);
        }
        if (ctxRoot != null) {
            aHolder.setInitParameter("CTX_ROOT", ctxRoot);
        }
        if (canonicalCtxRoot != null) {
            aHolder.setInitParameter("CANONICAL_CTX_ROOT", canonicalCtxRoot);
        }
        aHolder.setInitParameter("DEBUGGER_TRACE", traceValue);
        server.start();
        server.join();
    }
}

