/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.CFDebuggerUtils;
import coldfusion.debugger.CFJVMDebugManager;
import coldfusion.debugger.ClientDebugSession;
import coldfusion.debugger.DebugEventHandler;
import coldfusion.debugger.DummyLineLocation;
import coldfusion.debugger.JVMDebugThread;
import coldfusion.debugger.JVMDebugThreadManager;
import coldfusion.debugger.LocatableEventWrapper;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ExceptionBreakpointHandler
extends DebugEventHandler {
    public ExceptionBreakpointHandler(CFJVMDebugManager debugManager) {
        super(debugManager);
    }

    @Override
    public void handleEvent(Event evt, Map eventContext) throws Throwable {
        ClassType exceptionClassType;
        ExceptionEvent exEvt = (ExceptionEvent)evt;
        LocatableEvent locEvent = exEvt;
        ThreadReference thr = exEvt.thread();
        JVMDebugThread debugThread = JVMDebugThreadManager.getThread(thr);
        if (debugThread != null && (debugThread.isProcessingBPException() || debugThread.isProcessingBpOrStepEvent())) {
            thr.resume();
            return;
        }
        if (debugThread.isInCFParam() && CFDebuggerUtils.isClassInstanceOf(exceptionClassType = (ClassType)exEvt.exception().referenceType(), "coldfusion.runtime.UndefinedVariableException")) {
            thr.resume();
            return;
        }
        Location loc = null;
        String sourcePath = null;
        int lineNum = 0;
        try {
            loc = exEvt.location();
            sourcePath = loc.sourcePath();
            lineNum = loc.lineNumber();
        }
        catch (Throwable t) {
            thr.resume();
            return;
        }
        ClientDebugSession session = this.findDebugSession(locEvent.thread());
        if (session == null || !session.isBreakOnException()) {
            thr.resume();
            return;
        }
        Object[] traces = JVMDebugThreadManager.getThread(locEvent.thread().name()).getJavaStackTrace();
        ArrayList cfTrace = (ArrayList)traces[1];
        ArrayList javaTrace = (ArrayList)traces[0];
        try {
            Object[] traceObjs;
            ObjectReference excpObjRef = ExceptionBreakpointHandler.getRootException(exEvt.exception(), exEvt.thread());
            if (excpObjRef == null) {
                excpObjRef = exEvt.exception();
            }
            if ((traceObjs = CFDebuggerUtils.getExceptionStackTrace(excpObjRef, thr)) != null && traceObjs.length >= 2) {
                javaTrace = (ArrayList)traceObjs[0];
                cfTrace = (ArrayList)traceObjs[1];
            }
        }
        catch (Throwable excpObjRef) {
            // empty catch block
        }
        if (cfTrace == null || cfTrace.size() == 0) {
            thr.resume();
            return;
        }
        String topTrace = (String)cfTrace.get(0);
        int index = topTrace.lastIndexOf(58);
        sourcePath = topTrace.substring(0, index);
        lineNum = Integer.parseInt(topTrace.substring(index + 1));
        locEvent = new LocatableEventWrapper(exEvt, new DummyLineLocation(sourcePath, lineNum, this.debugManager.getVm()), 3);
        JVMDebugThreadManager.setLastLocation(locEvent.thread().name(), locEvent.location());
        if (cfTrace != null && debugThread != null) {
            if (cfTrace.get(0).equals(debugThread.getLastExcpetionBPTrace())) {
                thr.resume();
                return;
            }
            debugThread.setExceptionTraces(new Object[]{javaTrace, cfTrace});
            debugThread.setProcessingBPException(true);
        }
        session.onExceptionEvent(locEvent);
    }

    private static ObjectReference getRootException(ObjectReference expObj, ThreadReference th) {
        String exceptionClassName = expObj.referenceType().name();
        if (exceptionClassName.equals("coldfusion.debug.DebuggerExceptionWrapper")) {
            try {
                expObj = (ObjectReference)CFDebuggerUtils.invokeMethod(expObj, "getRootException", null, th, "()Ljava/lang/Throwable;");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return expObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map getExceptionDetails(LocatableEvent evt) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put("EXCEPTION_CLASS", "Unknown");
        retMap.put("EXCEPTION_MESSAGE", "Unknown");
        try {
            ObjectReference expObj = null;
            ThreadReference th = evt.thread();
            if (evt instanceof ExceptionEvent) {
                expObj = ((ExceptionEvent)((Object)expObj)).exception();
            } else {
                if (!(evt instanceof LocatableEventWrapper)) return retMap;
                LocatableEventWrapper evtWrapper = (LocatableEventWrapper)evt;
                if (!evtWrapper.isExceptionEvent()) return retMap;
                expObj = ((ExceptionEvent)evtWrapper.getWrappedEvent()).exception();
            }
            String exceptionClassName = expObj.referenceType().name();
            if (exceptionClassName.equals("coldfusion.debug.DebuggerExceptionWrapper")) {
                expObj = ExceptionBreakpointHandler.getRootException(expObj, th);
                exceptionClassName = expObj.referenceType().name();
            }
            String message = "";
            Value val = null;
            try {
                val = CFDebuggerUtils.invokeMethod(expObj, "getMessage", null, th, "()Ljava/lang/String;");
            }
            catch (Throwable t) {
                try {
                    val = CFDebuggerUtils.invokeMethod(expObj, "toString", null, th, "()Ljava/lang/String;");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (val != null) {
                message = ((StringReference)val).value();
            }
            retMap.put("EXCEPTION_CLASS", exceptionClassName);
            retMap.put("EXCEPTION_MESSAGE", message);
            return retMap;
        }
        catch (Throwable t) {
            CFDebuggerLogger.log(t);
            return retMap;
        }
    }

    private ClientDebugSession findDebugSession(ThreadReference thr) throws Throwable {
        ClientDebugSession session = this.findClientSession(thr, null, true);
        if (session == null) {
            ClientDebugSession[] sessions = this.debugManager.getClientSessions();
            if (sessions == null || sessions.length == 0) {
                return null;
            }
            ArrayList<ClientDebugSession> sessionsWithExceptionOn = new ArrayList<ClientDebugSession>();
            for (int i = 0; i < sessions.length; ++i) {
                if (!sessions[i].isBreakOnException()) continue;
                sessionsWithExceptionOn.add(sessions[i]);
            }
            if (sessionsWithExceptionOn.size() == 0) {
                return null;
            }
            this.attachClientSessionWithRequest((ClientDebugSession)sessionsWithExceptionOn.get(0), thr);
            return (ClientDebugSession)sessionsWithExceptionOn.get(0);
        }
        return session.isBreakOnException() ? session : null;
    }
}

