/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debug.buildersession;

import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import java.io.File;
import java.net.Socket;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;

public class CFBuilderSession
extends TimerTask {
    private HashSet<String> listOfFolders = new HashSet();
    private String ipOfJettyServer;
    private Timer selfTimer;
    private boolean isPhoneGapBuildSession = false;

    public CFBuilderSession(String ip) {
        this.ipOfJettyServer = ip;
    }

    public CFBuilderSession(String ip, boolean isPGSession) {
        this.ipOfJettyServer = ip;
        this.isPhoneGapBuildSession = isPGSession;
    }

    public void addFoldertoSession(String folder) {
        this.listOfFolders.add(folder);
    }

    public boolean isFileinThisSession(String file) {
        for (String key : this.listOfFolders) {
            if (key.equals(file)) {
                return true;
            }
            String folderTobeChecked = key.endsWith(File.separator) ? key : key + File.separator;
            if (!file.contains(folderTobeChecked)) continue;
            return true;
        }
        return false;
    }

    public void initializeTimer() {
        this.selfTimer = new Timer();
        this.selfTimer.schedule((TimerTask)this, 2000L, 30000L);
    }

    public void shutDownTimer() {
        this.selfTimer.cancel();
    }

    public String getIp() {
        return this.ipOfJettyServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isPhoneGapBuildSession) {
            return;
        }
        DebuggingService service = ServiceFactory.getDebuggingService();
        Socket socket = null;
        try {
            String ip = this.ipOfJettyServer.substring(7, this.ipOfJettyServer.lastIndexOf(":"));
            int port = Integer.parseInt(this.ipOfJettyServer.substring(this.ipOfJettyServer.lastIndexOf(":") + 1, this.ipOfJettyServer.lastIndexOf("/")));
            socket = new Socket(ip, port);
            if (!socket.isConnected()) {
                service.removeCFBuilderSession(this.ipOfJettyServer);
            }
        }
        catch (Exception e) {
            service.removeCFBuilderSession(this.ipOfJettyServer);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    service.removeCFBuilderSession(this.ipOfJettyServer);
                }
            }
        }
    }
}

