/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.proxy;

import coldfusion.log.CFLogs;
import coldfusion.tagext.net.websocket.server.proxy.ProxyConnection;
import coldfusion.tagext.net.websocket.server.proxy.WSProxyConnectionManager;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedDeque;

public class WSProxyMessageWriter {
    private Thread writeMessageMonitor;
    private ConcurrentLinkedDeque<Object[]> messageQ;

    public WSProxyMessageWriter(ConcurrentLinkedDeque<Object[]> messageQ) {
        this.messageQ = messageQ;
        this.initializeWriteMessageMonitor();
    }

    private void initializeWriteMessageMonitor() {
        this.writeMessageMonitor = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    block5: while (true) {
                        if (WSProxyMessageWriter.this.messageQ.isEmpty()) {
                            ConcurrentLinkedDeque concurrentLinkedDeque = WSProxyMessageWriter.this.messageQ;
                            synchronized (concurrentLinkedDeque) {
                                WSProxyMessageWriter.this.messageQ.wait();
                            }
                        }
                        while (true) {
                            if (WSProxyMessageWriter.this.messageQ.size() == 0) continue block5;
                            Object[] data = (Object[])WSProxyMessageWriter.this.messageQ.pop();
                            this.writeMessage((String)data[0], (byte[])data[1], (String)data[2]);
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMessage(String clientId, byte[] msgBytes, String msg) {
                ProxyConnection connection = WSProxyConnectionManager.getInstance().getConnection(clientId, msgBytes);
                if (connection == null) {
                    CFLogs.WEBSOCKETPROXY_LOG.info((Object)"Failed getting the connections from connectionpool.");
                    return;
                }
                ProxyConnection proxyConnection = connection;
                synchronized (proxyConnection) {
                    if (connection.getState() == 1) {
                        connection.addToClientsPendingMessages(new Object[]{msgBytes, msg});
                        CFLogs.WEBSOCKETPROXY_LOG.info((Object)("Adding message to pending message queue from client. Message : " + msg + ". ConnectionId :" + connection.getConnectionId()));
                    } else if (connection.getState() == 2 || connection.getState() == 0) {
                        connection.setState(1);
                        WSProxyConnectionManager.getInstance().updateClientMaps(clientId, connection);
                        CFLogs.WEBSOCKETPROXY_LOG.info((Object)("Writing message to proxy for client. Message : " + msg + ". ConnectionId :" + connection.getConnectionId()));
                        connection.write(ByteBuffer.wrap(msgBytes));
                    }
                }
            }
        });
        this.writeMessageMonitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.messageQ.clear();
        ConcurrentLinkedDeque<Object[]> concurrentLinkedDeque = this.messageQ;
        synchronized (concurrentLinkedDeque) {
            this.messageQ.notify();
        }
    }
}

