/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.core;

import java.util.HashMap;
import java.util.Map;

public class TokenMap {
    private Map<String, Object> tokens = new HashMap<String, Object>();

    public TokenMap() {
    }

    public TokenMap(String type) {
        this.setType(type);
    }

    public TokenMap(Map tokenMap) {
        this.tokens = tokenMap;
    }

    public void put(String key, Object value) {
        this.tokens.put(key, value);
    }

    public Object get(String key) {
        return this.tokens.get(key);
    }

    public String getString(String key) {
        return (String)this.tokens.get(key);
    }

    public String getString(String key, String defaultValue) {
        String value = (String)this.tokens.get(key);
        return value != null ? value : defaultValue;
    }

    public void setString(String key, String value) {
        this.tokens.put(key, value);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.tokens.get(key);
    }

    public Integer getInteger(String key) {
        return (Integer)this.tokens.get(key);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Integer value = (Integer)this.tokens.get(key);
        return value != null ? value : defaultValue;
    }

    public void setInteger(String key, int value) {
        this.tokens.put(key, new Integer(value));
    }

    public Map getMap() {
        return this.tokens;
    }

    public String getType() {
        return (String)this.tokens.get("type");
    }

    public void setType(String type) {
        this.tokens.put("type", type);
    }

    public void setMessage(Object message) {
        this.tokens.put("msg", message);
    }

    public void removeMessage() {
        this.tokens.remove("msg");
    }

    public void setMap(Map map) {
        this.tokens = map;
    }
}

