/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.messaging;

import coldfusion.CfmServlet;
import coldfusion.cfc.CFCProxy;
import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.cfc.DummyHttpServletResponse;
import coldfusion.compiler.ExprClassLoader;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.SecurityScopeTracker;
import coldfusion.runtime.SecurityTable;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateProxy;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.net.websocket.WebSocketUtil;
import coldfusion.tagext.net.websocket.messaging.ChannelException;
import coldfusion.tagext.net.websocket.messaging.ChannelRequestHeader;
import coldfusion.tagext.net.websocket.messaging.ChannelRequestProcessor;
import coldfusion.tagext.net.websocket.messaging.ChannelscopePropertyResolver;
import coldfusion.tagext.net.websocket.server.core.AbstractClientConnection;
import coldfusion.tagext.net.websocket.server.core.TokenMap;
import coldfusion.util.RB;
import coldfusion.xml.rpc.CFCServlet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Logger;

public class ChannelUtil {
    private static Logger mLog = Logger.getLogger(ChannelRequestProcessor.class);

    public static ChannelRequestHeader parseRequestHeader(TokenMap aToken) {
        String mChannelId = aToken.getString("channel");
        Map customOptions = (Map)aToken.get("customOptions");
        return ChannelUtil.parseRequestHeader(mChannelId, customOptions);
    }

    public static ChannelRequestHeader parseRequestHeader(String aChannelName, Map customOptions) {
        String selectorExpression;
        ChannelRequestHeader lRequestHeader = new ChannelRequestHeader();
        Struct lSubscriberInfo = new Struct();
        lSubscriberInfo.put((Object)"channelname", (Object)aChannelName);
        if (customOptions != null) {
            lSubscriberInfo.putAll(customOptions);
        }
        lRequestHeader.setCustomOptionMap(lSubscriberInfo);
        if (customOptions != null && (selectorExpression = (String)customOptions.get("selector")) != null) {
            lRequestHeader.setSelectorExpression(ExprClassLoader.compileStatementForWebSokcet((String)selectorExpression));
            lRequestHeader.setPropertyResolver(new ChannelscopePropertyResolver());
        }
        return lRequestHeader;
    }

    public static void resolveAndSetCFAuthToWSClient(AbstractClientConnection aConnector, String cfAuthkey, String appName) {
        SecurityTable sTable;
        SecurityScopeTracker _securityScopeTracker = SecurityScopeTracker.getInstance();
        FusionContext oldContext = FusionContext.getCurrent();
        if (oldContext == null) {
            FusionContext fContext = new FusionContext();
            FusionContext.setCurrent((FusionContext)fContext);
            fContext.setApplicationName(appName);
        }
        if ((sTable = _securityScopeTracker.getSecurity(cfAuthkey)) != null) {
            Struct mConnectionInfo = aConnector.getConnectionInfo();
            mConnectionInfo.put((Object)"authenticated", (Object)true);
            mConnectionInfo.put((Object)"username", (Object)sTable.getUserName());
            Set roleSet = sTable.keySet();
            mConnectionInfo.put((Object)"roles", (Object)ArrayUtil.ArrayToList((Collection)roleSet, (String)","));
        }
        if (oldContext == null) {
            FusionContext.setCurrent(null);
        }
    }

    public static boolean callWSAuthenticateOnAppCFC(AbstractClientConnection aConnector, String appName, String userName, String password) throws Throwable {
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope((String)appName);
        Object[] args = new Object[]{userName, password, aConnector.getConnectionInfo()};
        FusionContext fc = ChannelUtil.getFusionContext(appName, appScope.getApplicationPath());
        fc.SymTab_initForRequest(true);
        if (appScope != null) {
            FusionContext.SymTab_setApplicationScope((Object)appScope);
        }
        fc.setPagePath(appScope.getApplicationPath());
        try {
            return appScope.getEventInvoker().onWebsocketAuthenticate(args, fc);
        }
        catch (Throwable e) {
            mLog.error((Object)e.getMessage(), e);
            throw new ChannelException(RB.getString(ChannelUtil.class, (String)"AuthenticateMethodInvocationError", (Object)e.getMessage()), e);
        }
    }

    private static String sanitizePath(String path) {
        if (path != null && File.separatorChar == '\\') {
            path = path.replaceAll("/", "\\\\");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callCFCFunction(String appName, TemplateProxy proxy, String cfcMethod, String cfcPath, Object[] args, Lock lock) throws Throwable {
        FusionContext fusionContext = ChannelUtil.getFusionContext(appName, cfcPath);
        fusionContext.SymTab_initForRequest(true);
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope((String)appName);
        if (appScope != null) {
            FusionContext.SymTab_setApplicationScope((Object)appScope);
        }
        String userName = fusionContext.getSecureUsername();
        String password = fusionContext.getSecurePassword();
        if (userName != null) {
            fusionContext.setSecureCredentials(userName, password);
        }
        boolean oldRemoting = fusionContext.isRemoting();
        fusionContext.setIsRemoting(false);
        try {
            lock.lock();
            Object object = proxy.invoke(cfcMethod, args, (PageContext)fusionContext.pageContext);
            return object;
        }
        finally {
            lock.unlock();
            fusionContext.setIsRemoting(oldRemoting);
        }
    }

    public static FusionContext getFusionContext(String appName, String cfcPath) {
        FusionContext fusionContext = FusionContext.getCurrent();
        DummyHttpServletRequest req = new DummyHttpServletRequest(ChannelUtil.sanitizePath(cfcPath));
        ServletContext servletContext = ServiceFactory.getWebsocketService().getServletContext();
        if (fusionContext == null) {
            fusionContext = new FusionContext();
            FusionContext.setCurrent((FusionContext)fusionContext);
            fusionContext.setUseMappings(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DummyHttpServletResponse resp = new DummyHttpServletResponse((OutputStream)baos);
            CFCServlet servlet = CFCServlet.getCFCServlet();
            if (servlet == null) {
                servlet = CfmServlet.getCfmServlet();
            }
            fusionContext.setServletObjects(servletContext, (Servlet)servlet, (ServletRequest)req, (ServletResponse)resp);
        } else {
            fusionContext.setServletObjects(servletContext, fusionContext.getServlet(), (ServletRequest)req, (ServletResponse)fusionContext.getResponse());
        }
        fusionContext.setApplicationName(appName);
        return fusionContext;
    }

    public static Object callCFCFunction(ServletContext aServletContext, String appName, AbstractClientConnection clientConnection, String cfcPath, String cfcMethod, Object[] args, String referrer) {
        ServletContext lServletContext = aServletContext;
        if (lServletContext == null) {
            lServletContext = ServiceFactory.getWebsocketService().getServletContext();
        }
        try {
            FusionContext fusionContext = ChannelUtil.getFusionContext(lServletContext, appName, clientConnection, cfcPath, referrer);
            fusionContext.SymTab_initForRequest(true);
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope((String)appName);
            if (appScope != null) {
                FusionContext.SymTab_setApplicationScope((Object)appScope);
            }
            if (referrer == null) {
                referrer = "/";
            }
            String baseTemplatePath = ChannelUtil.resolveRealPath(clientConnection.getWebRootPath(), referrer);
            fusionContext.setPagePath(baseTemplatePath);
            WebSocketUtil.getWSThreadContext().setBaseTemplatePath(baseTemplatePath);
            FusionContext.getCurrent().setWsClientId(clientConnection.getConnectionId());
            fusionContext.setIsRemoting(true);
            CFCProxy cfcproxy = new CFCProxy(cfcPath, true);
            cfcproxy.setAutoFlush(false);
            return cfcproxy.invoke(cfcMethod, args);
        }
        catch (CfJspPage.NoSuchTemplateException invalidTemplateException) {
            throw new ChannelException(RB.getString(ChannelUtil.class, (String)"NoSuchTemplateException", (Object)cfcPath), invalidTemplateException);
        }
        catch (TemplateProxy.InvalidMethodNameException invalidFunctionException) {
            throw new ChannelException(RB.getString(ChannelUtil.class, (String)"InvalidFunctionException", (Object)cfcMethod, (Object)cfcPath), invalidFunctionException);
        }
        catch (TemplateProxy.InvalidRemoteAccessException ex) {
            throw new ChannelException(RB.getString(ChannelUtil.class, (String)"InvalidRemoteAccessException", (Object)cfcMethod, (Object)cfcPath), ex);
        }
        catch (Throwable e) {
            throw new ChannelException(RB.getString(ChannelUtil.class, (String)"CFCInvocationError", (Object)cfcMethod, (Object)cfcPath), e);
        }
    }

    public static FusionContext getFusionContext(ServletContext aServletContext, String appName, AbstractClientConnection clientConnection, String cfcPath, String referrer) {
        FusionContext fusionContext = FusionContext.getCurrent();
        if (fusionContext == null) {
            fusionContext = new FusionContext();
            FusionContext.setCurrent((FusionContext)fusionContext);
            fusionContext.setUseMappings(false);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DummyHttpServletResponse resp = new DummyHttpServletResponse((OutputStream)baos);
            CFCServlet servlet = CFCServlet.getCFCServlet();
            if (referrer == null) {
                referrer = "/";
            }
            fusionContext.setPagePath(ChannelUtil.resolveRealPath(clientConnection.getWebRootPath(), referrer));
            if (servlet == null) {
                servlet = CfmServlet.getCfmServlet();
            }
            cfcPath = referrer.substring(0, referrer.lastIndexOf("/") + 1) + cfcPath.replace(".", File.separator) + ".cfc";
            fusionContext.application = aServletContext;
            String cfcFilePath = ChannelUtil.resolveRealPath(clientConnection.getWebRootPath(), cfcPath);
            DummyHttpServletRequest req = new DummyHttpServletRequest(ChannelUtil.sanitizePath(cfcFilePath));
            fusionContext.setServletObjects(aServletContext, (Servlet)servlet, (ServletRequest)req, (ServletResponse)resp);
        } else {
            cfcPath = referrer.substring(0, referrer.lastIndexOf("/") + 1) + cfcPath.replace(".", File.separator) + ".cfc";
            String cfcFilePath = ChannelUtil.resolveRealPath(clientConnection.getWebRootPath(), cfcPath);
            DummyHttpServletRequest req = new DummyHttpServletRequest(ChannelUtil.sanitizePath(cfcFilePath));
            fusionContext.setServletObjects(aServletContext, fusionContext.getServlet(), (ServletRequest)req, (ServletResponse)fusionContext.getResponse());
        }
        fusionContext.setApplicationName(appName);
        return fusionContext;
    }

    private static String resolveRealPath(String webRoot, String uriPath) {
        String resolvedPath = webRoot;
        if (uriPath.startsWith("/")) {
            uriPath = uriPath.substring(1);
            resolvedPath = webRoot + uriPath;
        }
        return resolvedPath;
    }
}

