/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbcx.sybase;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import macromedia.jdbc.sybasebase.BaseConnection;
import macromedia.jdbc.sybasebase.ddaj;
import macromedia.jdbcx.sybase.SybaseXid;
import macromedia.jdbcx.sybasebase.ddk;
import macromedia.sybaseutil.dda7;

public class SybaseImplXAResource
extends ddk {
    private static String footprint = "$Revision$";
    ddaj connectProps;
    int timeout;
    Xid currentTxnXid;
    boolean recursiveMode = false;
    CallableStatement beginRpcStmt = null;
    CallableStatement attachRpcStmt = null;
    CallableStatement detachRpcStmt = null;
    CallableStatement commitRpcStmt = null;
    CallableStatement rollbackRpcStmt = null;
    CallableStatement prepareRpcStmt = null;
    CallableStatement forgetRpcStmt = null;
    CallableStatement transactionStatusRpcStmt = null;

    public SybaseImplXAResource(BaseConnection baseConnection) {
        this.a = baseConnection;
        this.connectProps = baseConnection.t();
        this.currentTxnXid = null;
        this.recursiveMode = false;
    }

    private final CallableStatement prepCall(String string) throws XAException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.a.prepareCall(string);
        }
        catch (SQLException sQLException) {
            XAException xAException = new XAException(sQLException.getMessage());
            xAException.errorCode = -3;
            throw xAException;
        }
        return callableStatement;
    }

    protected void close() throws SQLException {
        try {
            if (this.beginRpcStmt != null) {
                this.beginRpcStmt.close();
                this.beginRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.attachRpcStmt != null) {
                this.attachRpcStmt.close();
                this.attachRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.detachRpcStmt != null) {
                this.detachRpcStmt.close();
                this.detachRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.commitRpcStmt != null) {
                this.commitRpcStmt.close();
                this.commitRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.rollbackRpcStmt != null) {
                this.rollbackRpcStmt.close();
                this.rollbackRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.prepareRpcStmt != null) {
                this.prepareRpcStmt.close();
                this.prepareRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.forgetRpcStmt != null) {
                this.forgetRpcStmt.close();
                this.forgetRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void start(Xid xid, int n2) throws XAException {
        int n3 = 0;
        try {
            this.a.setTransactionIsolation(2112);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if ((n2 & 0x8200000) == 0) {
            if (this.beginRpcStmt == null) {
                this.beginRpcStmt = this.prepCall("{?= call $beginSybDtmXact (?, ?, ?, ?)}");
            }
            SybaseImplXAResource sybaseImplXAResource = this;
            sybaseImplXAResource.executeXaRpc(sybaseImplXAResource.beginRpcStmt, "{?= call $beginSybDtmXact (?, ?, ?, ?)}", xid, 1, 16);
        } else {
            if (this.attachRpcStmt == null) {
                this.attachRpcStmt = this.prepCall("{?= call $attachSybDtmXact (?, ?, ?)}");
            }
            SybaseImplXAResource sybaseImplXAResource = this;
            n3 = sybaseImplXAResource.executeXaRpc(sybaseImplXAResource.attachRpcStmt, "{?= call $attachSybDtmXact (?, ?, ?)}", xid, 1, 0);
            if (!this.recursiveMode && (n2 & 0x8000000) != 0 && n3 != 3 || (n2 & 0x200000) != 0 && n3 == 101) {
                try {
                    if (this.detachRpcStmt == null) {
                        this.detachRpcStmt = this.prepCall("{?= call $detachSybDtmXact (?, ?, ?)}");
                    }
                    SybaseImplXAResource sybaseImplXAResource2 = this;
                    sybaseImplXAResource2.executeXaRpc(sybaseImplXAResource2.detachRpcStmt, "{?= call $detachSybDtmXact (?, ?, ?)}", xid, n3, 0);
                }
                catch (XAException xAException) {
                    // empty catch block
                }
                throw new XAException(-6);
            }
        }
        this.setCurrentTransaction(xid);
    }

    protected void end(Xid xid, int n2) throws XAException {
        this.clearCurrentTransaction(xid);
        int n3 = 2;
        if ((n2 & 0x2000000) != 0) {
            n3 = 3;
        } else if ((n2 & 0x20000000) != 0) {
            n3 = 101;
        }
        if (this.detachRpcStmt == null) {
            this.detachRpcStmt = this.prepCall("{?= call $detachSybDtmXact (?, ?, ?)}");
        }
        SybaseImplXAResource sybaseImplXAResource = this;
        sybaseImplXAResource.executeXaRpc(sybaseImplXAResource.detachRpcStmt, "{?= call $detachSybDtmXact (?, ?, ?)}", xid, n3, 0);
    }

    protected int prepare(Xid xid) throws XAException {
        if (this.prepareRpcStmt == null) {
            this.prepareRpcStmt = this.prepCall("{?= call $prepareSybDtmXact (?, ?, ?)}");
        }
        SybaseImplXAResource sybaseImplXAResource = this;
        int n2 = sybaseImplXAResource.executeXaRpc(sybaseImplXAResource.prepareRpcStmt, "{?= call $prepareSybDtmXact (?, ?, ?)}", xid, 7, 24576);
        this.resumeCurrentTransaction(xid);
        if (n2 == -256) {
            return 3;
        }
        return 0;
    }

    protected void commit(Xid xid, boolean bl) throws XAException {
        int n2 = 24576;
        if (bl) {
            n2 |= 0x20;
        }
        if (this.commitRpcStmt == null) {
            this.commitRpcStmt = this.prepCall("{?= call $commitSybDtmXact (?, ?, ?)}");
        }
        SybaseImplXAResource sybaseImplXAResource = this;
        sybaseImplXAResource.executeXaRpc(sybaseImplXAResource.commitRpcStmt, "{?= call $commitSybDtmXact (?, ?, ?)}", xid, 100, n2);
        this.resumeCurrentTransaction(xid);
    }

    protected void rollback(Xid xid) throws XAException {
        if (this.rollbackRpcStmt == null) {
            this.rollbackRpcStmt = this.prepCall("{?= call $rollbackSybDtmXact (?, ?, ?)}");
        }
        SybaseImplXAResource sybaseImplXAResource = this;
        sybaseImplXAResource.executeXaRpc(sybaseImplXAResource.rollbackRpcStmt, "{?= call $rollbackSybDtmXact (?, ?, ?)}", xid, 101, 24576);
        this.resumeCurrentTransaction(xid);
    }

    protected void forget(Xid xid) throws XAException {
        if (this.forgetRpcStmt == null) {
            this.forgetRpcStmt = this.prepCall("{?= call $forgetSybDtmXact (?, ?, ?)}");
        }
        SybaseImplXAResource sybaseImplXAResource = this;
        sybaseImplXAResource.executeXaRpc(sybaseImplXAResource.forgetRpcStmt, "{?= call $forgetSybDtmXact (?, ?, ?)}", xid, 102, 24576);
        this.resumeCurrentTransaction(xid);
    }

    protected Xid[] recover(int n2) throws XAException {
        dda7 dda72 = new dda7();
        ResultSet resultSet = null;
        try {
            if (this.transactionStatusRpcStmt == null) {
                this.transactionStatusRpcStmt = this.prepCall("{?= call sp_transactions (?)}");
            }
            this.transactionStatusRpcStmt.registerOutParameter(1, 4);
            this.transactionStatusRpcStmt.setString(2, "xa_recover");
            boolean bl = this.transactionStatusRpcStmt.execute();
            int n3 = 0;
            while (true) {
                if (bl) {
                    resultSet = this.transactionStatusRpcStmt.getResultSet();
                    while (resultSet.next()) {
                        String string = resultSet.getString("xactname");
                        dda72.add(new SybaseXid(string));
                    }
                    break;
                }
                n3 = this.transactionStatusRpcStmt.getUpdateCount();
                if (n3 == -1) {
                    break;
                }
                bl = this.transactionStatusRpcStmt.getMoreResults();
            }
        }
        catch (SQLException sQLException) {
            throw new XAException(-3);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        if (dda72.size() == 0) {
            return null;
        }
        Object[] objectArray = new SybaseXid[dda72.size()];
        dda72.a(objectArray);
        return objectArray;
    }

    protected boolean setTransactionTimeout(int n2) throws XAException {
        if (n2 < 0) {
            throw new XAException(-5);
        }
        this.timeout = n2;
        return false;
    }

    protected int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    protected String getRmIdentification() throws XAException {
        String string = this.connectProps.a("serverName");
        String string2 = this.connectProps.a("portNumber");
        String string3 = this.connectProps.a("databaseName");
        String string4 = "";
        if (this.connectProps.m()) {
            string4 = new String(this.connectProps.h());
        }
        return string + "_" + string2 + "_" + string3 + "_" + string4;
    }

    private final int executeXaRpc(CallableStatement callableStatement, String string, Xid xid, int n2, int n3) throws XAException {
        int n4 = 0;
        SybaseXid sybaseXid = xid instanceof SybaseXid ? (SybaseXid)xid : new SybaseXid(xid);
        String string2 = sybaseXid.getEncodedString();
        try {
            callableStatement.registerOutParameter(1, 4);
            callableStatement.setString(2, string2);
            callableStatement.setInt(3, n2);
            callableStatement.setInt(4, n3);
            if (callableStatement.equals(this.beginRpcStmt)) {
                callableStatement.setInt(5, 196608);
            }
            callableStatement.executeUpdate();
            n4 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            XAException xAException = new XAException(sQLException.getMessage());
            xAException.errorCode = -3;
            throw xAException;
        }
        this.verifyReturnCode(string, n4);
        return n4;
    }

    private final void verifyReturnCode(String string, int n2) throws XAException {
        if (n2 >= 0) {
            return;
        }
        int n3 = -3;
        String string2 = null;
        switch (n2) {
            case -1: {
                n3 = -3;
                string2 = "XACTRV_RM_ERR, XA Error: XAER_RMERR";
                break;
            }
            case -2: {
                n3 = -4;
                string2 = "XACTRV_NOXID_ERR, XA Error = XAER_NOTA";
                break;
            }
            case -3: {
                n3 = -8;
                string2 = "XACTRV_DUPXID_ERR, XA Error = XAER_DUPID";
                break;
            }
            case -4: {
                n3 = -7;
                string2 = "XACTRV_DUPXID_ERR, XA Error = XAER_RMFAIL";
                break;
            }
            case -5: {
                n3 = -5;
                string2 = "XACTRV_INVLDPRM_ERR, XA Error = XAER_INVAL";
                break;
            }
            case -6: {
                n3 = -6;
                string2 = "XACTRV_NOPERM_ERR, XA Error = XAER_PROTO";
                break;
            }
            case -128: {
                n3 = -6;
                string2 = "XACTRV_NOPERM_ERR, XA Error = XAER_PROTO";
                break;
            }
            case -256: {
                return;
            }
            default: {
                n3 = -3;
                string2 = "Unrecognized return code from server: " + n2;
            }
        }
        int n4 = string.indexOf(36);
        int n5 = string.indexOf("Xact");
        String string3 = string.substring(n4, n5 + 4);
        string2 = string3 + ": " + string2;
        XAException xAException = new XAException(string2);
        xAException.errorCode = n3;
        throw xAException;
    }

    final void setCurrentTransaction(Xid xid) {
        if (this.recursiveMode) {
            return;
        }
        this.currentTxnXid = xid;
    }

    final void clearCurrentTransaction(Xid xid) {
        if (this.recursiveMode || this.currentTxnXid == null || !this.currentTxnXid.equals(xid)) {
            return;
        }
        this.currentTxnXid = null;
    }

    final void resumeCurrentTransaction(Xid xid) throws XAException {
        if (this.currentTxnXid == null || this.currentTxnXid.equals(xid)) {
            return;
        }
        this.recursiveMode = true;
        SybaseImplXAResource sybaseImplXAResource = this;
        sybaseImplXAResource.start(sybaseImplXAResource.currentTxnXid, 0x8000000);
        this.recursiveMode = false;
    }
}

