/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.presentation;

import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.document.AuthenticationFailedException;
import coldfusion.document.DocumentMargin;
import coldfusion.document.DocumentPageLayout;
import coldfusion.document.DocumentProcessor;
import coldfusion.document.OpenOfficeUNOHelper;
import coldfusion.document.PowerPointReaderException;
import coldfusion.document.SlideData;
import coldfusion.document.presentation.core.PresentationExceptions;
import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.Exporter;
import coldfusion.document.spi.core.URLConnectionSettings;
import coldfusion.presentation.PPTDocumentProperties;
import coldfusion.presentation.PowerPointProcessor;
import coldfusion.presentation.PowerPointReader;
import coldfusion.presentation.SlideExporter;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.net.ResolvePage;
import coldfusion.tagext.presentation.PresentationTag;
import coldfusion.util.IOUtils;
import coldfusion.util.MP3File;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import macromedia.swf.Header;
import macromedia.swf.TagDecoder;
import macromedia.swf.types.Rect;
import org.apache.commons.httpclient.HttpURL;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;

public class PresentationSlideTag
extends ChildTag
implements BodyTag {
    private static final String AUTO = "auto";
    private static final String NEVER = "never";
    private static final String CLICK = "click";
    private PresentationTag presentationTag;
    private PowerPointReader pptreader;
    private String src;
    private String title;
    private String audio;
    private int duration;
    private String presenter;
    private String notes;
    private String video;
    private String advance;
    private String slides;
    private String format = "";
    private boolean useExternalProgram = true;
    private double scale;
    private int marginTop = -1;
    private int marginBottom = -1;
    private int marginLeft = -1;
    private int marginRight = -1;
    private String authUser;
    private String authPassword;
    private String userAgent;
    private boolean showTitle;
    private URL baseurl;
    private String name;
    private DocumentProperties docProps;
    private PPTDocumentProperties docPPTProps;
    private String wrapper;
    private File slideFile;
    private HSLFSlideShow ppt;
    private final String PPTIMAGE_TEMP_DIR = "_pptimages";

    public PresentationSlideTag() {
        super(PresentationTag.class);
    }

    public void setAncestor(Tag ancestor) {
        this.presentationTag = (PresentationTag)ancestor;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        if ((src = src.trim()).length() == 0) {
            throw new PresentationExceptions.InvalidSrcException(src);
        }
        this.src = src;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAudio() {
        return this.audio;
    }

    public void setAudio(String audio) {
        this.audio = audio.trim();
        if (this.audio.length() == 0) {
            throw new PresentationExceptions.InvalidAudioFileException(audio);
        }
        if (!this.audio.toLowerCase().endsWith(".mp3")) {
            throw new PresentationExceptions.InvalidAudioFileException(audio);
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public String getPresenter() {
        return this.presenter;
    }

    public void setPresenter(String presenter) {
        this.presenter = presenter;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getVideo() {
        return this.video;
    }

    public void setVideo(String video) {
        this.video = video.trim();
        if (this.video.length() == 0) {
            throw new PresentationExceptions.InvalidVideoFileException(video);
        }
        String lvideo = this.video.toLowerCase();
        if (!lvideo.endsWith(".flv") && !lvideo.endsWith(".swf")) {
            throw new PresentationExceptions.InvalidVideoFileException(video);
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public String getName() {
        return this.name;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setUseExternalProgram(boolean externalProgram) {
        this.useExternalProgram = externalProgram;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getAdvance() {
        return this.advance;
    }

    public void setAdvance(String advance) {
        if (!((advance = advance.trim().toLowerCase()).equals(AUTO) || advance.equals(NEVER) || advance.equals(CLICK))) {
            throw new PresentationExceptions.InvalidAdvanceTypeException(advance);
        }
        this.advance = advance;
    }

    public void setSlides(String slides) {
        this.slides = slides;
    }

    public int doStartTag() throws JspException {
        if (this.src != null && this.src.toLowerCase().endsWith(".pptx")) {
            throw new PresentationExceptions.PPTXNotSupportedException();
        }
        this.onTagStart();
        this.presentationTag.incrementSlideCount();
        this.format = this.presentationTag.getFormat();
        return 2;
    }

    private void validateAttributes() {
        if (System.getSecurityManager() == null) {
            this._validateAttributes();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PresentationSlideTag.this._validateAttributes();
                    return null;
                }
            });
        }
    }

    private void _validateAttributes() {
        this.validateAudioFile();
        this.validateVideoFile();
    }

    private void validateAudioFile() {
        if (this.audio != null) {
            File audioFile = VFSFileFactory.getFileObject((String)Utils.expandPath((String)this.audio, (PageContext)this.pageContext));
            if (new File(this.audio).exists()) {
                audioFile = new File(this.audio);
            }
            if (!audioFile.exists()) {
                audioFile = VFSFileFactory.getFileObject((String)this.audio);
                if (audioFile.isAbsolute() && audioFile.exists()) {
                    throw new PresentationExceptions.PathNotAccessibleException();
                }
                throw new PresentationExceptions.AudioFileNotFoundException(this.audio);
            }
            if (this.presentationTag.getDirectory() != null) {
                File destAudioFile = VFSFileFactory.getFileObject((File)this.presentationTag.getDataDirectory(), (String)audioFile.getName());
                if (destAudioFile.exists() && !this.presentationTag.isOverWrite()) {
                    throw new PresentationExceptions.FileAlreadyExistsException(destAudioFile.getAbsolutePath());
                }
                try {
                    IOUtils.copyFile((File)audioFile, (File)this.presentationTag.getDataDirectory());
                }
                catch (IOException e) {
                    throw new PresentationExceptions.InvalidAudioFileException(this.audio);
                }
            }
            if (this.duration == 0) {
                try {
                    MP3File mp3file = new MP3File(audioFile.getAbsolutePath());
                    this.duration = (int)mp3file.getDuration();
                }
                catch (MP3File.InvalidMP3FormatException e) {
                    throw new PresentationExceptions.InvalidAudioFileException(this.audio, (Throwable)e);
                }
                catch (IOException e) {
                    throw new PresentationExceptions.InvalidAudioFileException(this.audio, (Throwable)e);
                }
            }
        }
    }

    private void validateVideoFile() {
        if (this.video != null) {
            File videoFile = VFSFileFactory.getFileObject((String)Utils.expandPath((String)this.video, (PageContext)this.pageContext));
            if (!videoFile.exists()) {
                videoFile = VFSFileFactory.getFileObject((String)this.video);
                if (videoFile.isAbsolute() && videoFile.exists()) {
                    throw new PresentationExceptions.PathNotAccessibleException();
                }
                throw new PresentationExceptions.VideoFileNotFoundException(this.video);
            }
            if (this.presentationTag.getDirectory() != null) {
                File destVideoFile = VFSFileFactory.getFileObject((File)this.presentationTag.getDataDirectory(), (String)videoFile.getName());
                if (destVideoFile.exists() && !this.presentationTag.isOverWrite()) {
                    throw new PresentationExceptions.FileAlreadyExistsException(destVideoFile.getAbsolutePath());
                }
                try {
                    IOUtils.copyFile((File)videoFile, (File)this.presentationTag.getDataDirectory());
                }
                catch (IOException e) {
                    throw new PresentationExceptions.InvalidVideoFileException(this.video);
                }
            }
        }
    }

    public URL getBaseURL() throws MalformedURLException {
        if (this.baseurl == null) {
            if (this.request instanceof DummyHttpServletRequest) {
                String url = this.request.getPathTranslated();
                this.baseurl = VFSFileFactory.getFileObject((String)url).toURL();
            } else {
                String url = HttpUtils.getRequestURL((HttpServletRequest)this.request).toString();
                this.baseurl = new URL(url);
            }
        }
        return this.baseurl;
    }

    public URLConnectionSettings getURLConnectionSettings() {
        URLConnectionSettings urlConnectionSettings = this.presentationTag.getURLConnectionSettings();
        if (this.authUser != null || this.userAgent != null) {
            urlConnectionSettings = (URLConnectionSettings)urlConnectionSettings.clone();
            if (this.authUser != null) {
                urlConnectionSettings.setAuthUserName(this.authUser);
                urlConnectionSettings.setAuthPassword(this.authPassword);
            }
            if (this.userAgent != null) {
                urlConnectionSettings.setUserAgent(this.userAgent);
            }
        }
        return urlConnectionSettings;
    }

    public String getHTMLString(String files) {
        return "<img src=\"file:///" + files + "\"></BR>";
    }

    public String getHTMLStringSimple(String files) {
        return "<div align=\"center\">\n<img src=\"" + VFSFileFactory.getFileObject((String)files).getName() + "\"></div></BR>";
    }

    private void _exportToPPT(final String content) {
        if (System.getSecurityManager() == null) {
            this.exportToPPT(content);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PresentationSlideTag.this.exportToPPT(content);
                    return null;
                }
            });
        }
    }

    public void exportToPPT(String content) {
        this.ppt = this.presentationTag.getPPTObject();
        try {
            Dimension pgsize = this.ppt.getPageSize();
            DocumentPageLayout pageLayout = new DocumentPageLayout();
            this.marginBottom = 0;
            this.marginLeft = 0;
            this.marginRight = 0;
            this.marginTop = 0;
            if (this.title != null) {
                this.marginTop = 50;
            }
            DocumentMargin margin = new DocumentMargin();
            margin.setTop((double)this.marginTop);
            margin.setBottom((double)this.marginBottom);
            margin.setLeft((double)this.marginLeft);
            margin.setRight((double)this.marginRight);
            int height = pgsize.height - this.marginTop;
            pageLayout.setPageheight((double)height);
            pageLayout.setPagewidth((double)pgsize.width);
            pageLayout.setMargin(margin);
            String backgroundColor = this.presentationTag.getBackgroundColor();
            Color color = null;
            if (backgroundColor != null) {
                color = Color.decode(backgroundColor);
            }
            this.docPPTProps = new PPTDocumentProperties(pageLayout, this.ppt, this.title, color);
            this.docPPTProps.setScale(this.scale);
            this.processDocument(content, this.docPPTProps);
        }
        catch (DocumentProcessor.AuthenticationFailedException ae) {
            throw new AuthenticationFailedException(ae.getURL());
        }
        catch (Exception e) {
            if (e instanceof ApplicationException) {
                throw (ApplicationException)e;
            }
            throw new PresentationExceptions.PresentationException((Throwable)e);
        }
    }

    public void processSlideContent(String content, int slideno) {
        this.name = "slide" + this.presentationTag.getSlideCount() + "_" + slideno + ".swf";
        this.slideFile = VFSFileFactory.getFileObject((File)this.presentationTag.getDataDirectory(), (String)this.name);
        this.checkSlideFile(this.slideFile);
        try {
            DocumentPageLayout pageLayout = new DocumentPageLayout();
            pageLayout.setPageheight(540.0);
            pageLayout.setPagewidth(720.0);
            this.marginTop = this.marginTop == -1 ? this.presentationTag.getMarginTop() : this.marginTop;
            this.marginBottom = this.marginBottom == -1 ? this.presentationTag.getMarginBottom() : this.marginBottom;
            this.marginLeft = this.marginLeft == -1 ? this.presentationTag.getMarginLeft() : this.marginLeft;
            this.marginRight = this.marginRight == -1 ? this.presentationTag.getMarginRight() : this.marginRight;
            DocumentMargin margin = new DocumentMargin();
            margin.setTop((double)this.marginTop);
            margin.setBottom((double)this.marginBottom);
            margin.setLeft((double)this.marginLeft);
            margin.setRight((double)this.marginRight);
            pageLayout.setMargin(margin);
            String backgroundColor = this.presentationTag.getBackgroundColor();
            Color color = null;
            if (backgroundColor != null) {
                color = Color.decode(backgroundColor);
            }
            this.docPPTProps = new PPTDocumentProperties(pageLayout, this.ppt, this.title, color);
            this.docPPTProps.setScale(this.scale);
            this.processDocument(content, this.docProps);
        }
        catch (DocumentProcessor.AuthenticationFailedException ae) {
            throw new AuthenticationFailedException(ae.getURL());
        }
        catch (Exception e) {
            if (e instanceof ApplicationException) {
                throw (ApplicationException)e;
            }
            throw new PresentationExceptions.PresentationException((Throwable)e);
        }
        this.presentationTag.addSlides(this._buildSlideData());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processDocument(String content, DocumentProperties docprop) throws Exception {
        boolean hasContent;
        boolean bl = hasContent = content != null && content.length() > 0;
        if (!hasContent && this.src == null) {
            throw new PresentationExceptions.EmptySlideException();
        }
        DocumentProcessor processor = new DocumentProcessor(this.getURLConnectionSettings());
        processor.setDocumentProperties(docprop);
        processor.setExporter((Exporter)new SlideExporter());
        if (ServiceFactory.getRuntimeService().timeoutRequests()) {
            long requestTimeOut = ServiceFactory.getRuntimeService().getRequestTimeoutLimit() * 1000L;
            processor.setRequestTimeOut(requestTimeOut);
        }
        if (this.src != null && this.slides != null) {
            File pptfile = VFSFileFactory.getFileObject((String)this.src);
            FileInputStream is = new FileInputStream(pptfile);
            HSLFSlideShow srcPPT = new HSLFSlideShow((InputStream)is);
            int slidenumber = new Integer(this.slides);
            if (srcPPT.getSlides().size() < slidenumber) {
                throw new PresentationExceptions.InvalidSlideNumberException(slidenumber);
            }
        }
        String charset = null;
        charset = this.request.getCharacterEncoding();
        if (charset == null) {
            charset = RuntimeServiceImpl.getDefaultCharset();
        }
        if (hasContent) {
            processor.processContent(content, this.getBaseURL(), charset, null);
            return;
        }
        File file = VFSFileFactory.getFileObject((String)this.src);
        if (file.isAbsolute()) {
            if (!file.isFile()) throw new PresentationExceptions.InvalidSrcException(this.src);
            processor.processContent(file, charset, "text/html", null, null);
            return;
        }
        try {
            URL srcUrl = new URL(this.resolveURL(this.src));
            processor.processContent(srcUrl, charset, "text/html", null, null);
            return;
        }
        catch (MalformedURLException e) {
            throw new PresentationExceptions.InvalidSrcException(this.src);
        }
    }

    public void cleanImageFiles(File dir) {
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            VFSFileFactory.getFileObject((File)dir, (String)files[i]).delete();
        }
        File parent = dir.getParentFile();
        dir.delete();
        parent.delete();
    }

    public void cleanImageFiles(File dir, String[] files) {
        for (int i = 0; i < files.length; ++i) {
            VFSFileFactory.getFileObject((File)dir, (String)files[i]).delete();
        }
        dir.delete();
    }

    public static ArrayList<Integer> doProcessList(String list) {
        ArrayList<Integer> rangeval = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(list, "\t\n,");
            rangeval = new ArrayList<Integer>();
            while (stringTokenizer.hasMoreElements()) {
                String token = stringTokenizer.nextToken();
                if (token.contains("-")) {
                    int[] v = PresentationSlideTag.doProcessRange(token);
                    int start = v[0];
                    int end = v[1];
                    for (int i = start; i <= end; ++i) {
                        rangeval.add(i);
                    }
                    continue;
                }
                rangeval.add(new Integer(token.trim()));
            }
        }
        catch (NumberFormatException e) {
            throw new PowerPointReaderException(e.getMessage());
        }
        return rangeval;
    }

    public static int[] doProcessRange(String range) {
        int[] v = new int[2];
        int start = 0;
        int end = 0;
        try {
            if (range.contains("-")) {
                int dot = range.indexOf("-");
                start = new Integer(range.substring(0, dot));
                end = new Integer(range.substring(dot + 1, range.length()));
            }
            if (end < start) {
                throw new PowerPointReaderException("Starting slide number should be less than ending slide number");
            }
            v[0] = start;
            v[1] = end;
        }
        catch (NumberFormatException e) {
            throw new PowerPointReaderException(e.getMessage());
        }
        return v;
    }

    private void _exportPPTtoHTML() {
        if (System.getSecurityManager() == null) {
            this.exportPPTtoHTML();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PresentationSlideTag.this.exportPPTtoHTML();
                    return null;
                }
            });
        }
    }

    private void copyImages(File src, File dest) {
        File[] files;
        JPEGFilter filter = new JPEGFilter();
        for (File f : files = src.listFiles(filter)) {
            try {
                IOUtils.copyFile((File)f, (File)dest);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String[] getImageFiles(File outdir, String basename) {
        Object[] imageFiles = outdir.listFiles(new JPEGFilter());
        Arrays.sort(imageFiles);
        String[] list = new String[imageFiles.length];
        int index = 0;
        int currentSlide = this.presentationTag.getHTMLSlideCount();
        for (Object f : imageFiles) {
            String name = ((File)f).getName();
            name = basename + "_slide_" + currentSlide + "_" + name;
            ++currentSlide;
            File newfile = VFSFileFactory.getFileObject((File)outdir, (String)name);
            ((File)f).renameTo(newfile);
            list[index++] = newfile.getAbsolutePath();
        }
        return list;
    }

    private void exportPPTtoHTML() {
        int slidecount = 0;
        String[] html = null;
        if (this.isUseExternalProgram() && this.isOpenOfficeAvailable()) {
            String name = PowerPointProcessor.getBaseName(VFSFileFactory.getFileObject((String)this.src));
            File outdir = this.getOutputDir(name);
            OpenOfficeUNOHelper officehelper = new OpenOfficeUNOHelper(this.src, outdir.getPath() + "/index.html");
            officehelper.setIsHtml(true);
            ArrayList<Integer> range = this.getSlideRange();
            officehelper.setPageRange(range);
            officehelper.doExport();
            Object[] files = this.getImageFiles(outdir, name);
            this.slides = null;
            if (files != null) {
                slidecount = files.length;
                if (slidecount == 0) {
                    throw new PresentationExceptions.EmptySlideException();
                }
                html = new String[slidecount];
                if (range != null) {
                    int i;
                    Integer[] orig = new Integer[range.size()];
                    range.toArray(orig);
                    Collections.sort(range);
                    HashMap<Integer, Object> map = new HashMap<Integer, Object>();
                    for (i = 0; i < range.size(); ++i) {
                        map.put(range.get(i), files[i]);
                    }
                    for (i = 0; i < orig.length; ++i) {
                        String imgname = (String)map.get(orig[i]);
                        html[i] = this.getHTMLStringSimple(outdir.getPath() + "/" + imgname);
                    }
                } else {
                    Arrays.sort(files);
                    for (int i = 0; i < files.length; ++i) {
                        html[i] = this.getHTMLStringSimple(outdir.getPath() + "/" + (String)files[i]);
                    }
                }
                File presodir = this.presentationTag.getPresentationDirectory();
                this.copyImages(outdir, presodir);
                this.cleanImageFiles(outdir);
            }
        } else {
            PowerPointProcessor pptprocessor = new PowerPointProcessor();
            File presodir = this.presentationTag.getPresentationDirectory();
            pptprocessor.setOutputDirectory(presodir);
            File pptfile = VFSFileFactory.getFileObject((String)this.src);
            if (this.slides == null) {
                html = pptprocessor.processPPT(pptfile);
            } else if (this.slides.contains(",")) {
                ArrayList<Integer> slidenumbers = PresentationSlideTag.doProcessList(this.slides);
                html = new String[slidenumbers.size()];
                for (int i = 0; i < slidenumbers.size(); ++i) {
                    html[i] = pptprocessor.processPPT(pptfile, slidenumbers.get(i));
                }
            } else if (this.slides.contains("-") && !this.slides.contains(",")) {
                int[] v = PresentationSlideTag.doProcessRange(this.slides);
                int startslide = v[0];
                int endslide = v[1];
                int index = 0;
                html = new String[endslide - startslide + 1];
                for (int i = startslide; i <= endslide; ++i) {
                    html[index] = pptprocessor.processPPT(pptfile, i);
                    ++index;
                }
            } else {
                int slidenumber = new Integer(this.slides);
                html = new String[]{pptprocessor.processPPT(pptfile, slidenumber)};
            }
        }
        if (html != null) {
            this.presentationTag.setSlideCount(slidecount);
            this.presentationTag.addHTMLSlides(html);
        }
    }

    private int _exportPPTSlides(final String filename) {
        int count = 0;
        count = System.getSecurityManager() == null ? this.exportPPTSlides(filename) : ((Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PresentationSlideTag.this.exportPPTSlides(filename);
            }
        })).intValue();
        return count;
    }

    private File getOutputDir(String name) {
        String tempDir = Utils.getTempDir((PageContext)this.pageContext);
        Random r = new Random();
        String tmpdir = tempDir + "/" + "_pptimages" + "_" + r.nextInt(10000) + "/" + name;
        File outdir = VFSFileFactory.getFileObject((String)tmpdir);
        outdir.mkdirs();
        return outdir;
    }

    private File setupOutputDirectory(String filename) {
        String name = PowerPointProcessor.getBaseName(VFSFileFactory.getFileObject((String)filename));
        File outdir = this.getOutputDir(name);
        this.pptreader.setupOutputDir(outdir);
        return outdir;
    }

    private boolean isUseExternalProgram() {
        return this.useExternalProgram;
    }

    private boolean isOpenOfficeAvailable() {
        return OpenOfficeUNOHelper.isOOAvailable();
    }

    private ArrayList<Integer> getSlideRange() {
        ArrayList<Integer> range = null;
        if (this.slides != null) {
            if (this.slides.contains(",")) {
                range = PresentationSlideTag.doProcessList(this.slides);
            } else if (this.slides.contains("-") && !this.slides.contains(",")) {
                int[] v = PresentationSlideTag.doProcessRange(this.slides);
                int startslide = v[0];
                int endslide = v[1];
                int scount = endslide - startslide;
                range = new ArrayList();
                for (int i = 0; i <= scount; ++i) {
                    int count = startslide + i;
                    range.add(count);
                }
            } else {
                int slidenum = new Integer(this.slides);
                range = new ArrayList();
                range.add(slidenum);
            }
        }
        return range;
    }

    private String[] getImageFiles(File dir) {
        JPEGFilter filter = new JPEGFilter();
        return dir.list(filter);
    }

    public int exportPPTSlides(String filename) {
        String[] files;
        int slidecount = 0;
        if (this.isUseExternalProgram() && this.isOpenOfficeAvailable()) {
            String name = PowerPointProcessor.getBaseName(VFSFileFactory.getFileObject((String)filename));
            final File outdir = this.getOutputDir(name);
            OpenOfficeUNOHelper officehelper = new OpenOfficeUNOHelper(filename, outdir.getPath() + "/index.html");
            officehelper.setIsHtml(true);
            ArrayList<Integer> range = this.getSlideRange();
            officehelper.setPageRange(range);
            officehelper.doExport();
            String[] files2 = this.getImageFiles(outdir);
            this.slides = null;
            if (files2 != null) {
                slidecount = files2.length;
                if (slidecount == 0) {
                    throw new PresentationExceptions.EmptySlideException();
                }
                if (range != null) {
                    int i;
                    Integer[] orig = new Integer[range.size()];
                    range.toArray(orig);
                    Collections.sort(range);
                    HashMap<Integer, String> map = new HashMap<Integer, String>();
                    for (i = 0; i < range.size(); ++i) {
                        map.put(range.get(i), files2[i]);
                    }
                    for (i = 0; i < orig.length; ++i) {
                        String imgname = (String)map.get(orig[i]);
                        String html = this.getHTMLString(outdir.getPath() + "/" + imgname);
                        this.processSlideContent(html, i);
                    }
                } else {
                    Arrays.sort(files2, new Comparator<String>(){

                        @Override
                        public int compare(String f1, String f2) {
                            return Long.valueOf(VFSFileFactory.getFileObject((String)(outdir.getPath() + "/" + f1)).lastModified()).compareTo(VFSFileFactory.getFileObject((String)(outdir.getPath() + "/" + f2)).lastModified());
                        }
                    });
                    for (int i = 0; i < files2.length; ++i) {
                        String html = this.getHTMLString(outdir.getPath() + "/" + files2[i]);
                        this.processSlideContent(html, i);
                    }
                }
                this.cleanImageFiles(outdir);
            }
            return slidecount;
        }
        this.pptreader = new PowerPointReader(filename);
        File outdir = this.setupOutputDirectory(filename);
        if (this.slides == null) {
            files = this.pptreader.exportSlides();
        } else if (this.slides.contains(",")) {
            ArrayList<Integer> slidenumbers = PresentationSlideTag.doProcessList(this.slides);
            files = this.pptreader.exportSlides(slidenumbers);
        } else if (this.slides.contains("-") && !this.slides.contains(",")) {
            int[] v = PresentationSlideTag.doProcessRange(this.slides);
            int startslide = v[0];
            int endslide = v[1];
            files = this.pptreader.exportSlides(startslide, endslide);
        } else {
            int slidenum = new Integer(this.slides);
            files = new String[]{this.pptreader.exportSlides(slidenum)};
        }
        this.slides = null;
        if (files != null) {
            slidecount = files.length;
            if (slidecount == 0) {
                throw new PresentationExceptions.EmptySlideException();
            }
            for (int i = 0; i < files.length; ++i) {
                String html = this.getHTMLString(files[i]);
                this.processSlideContent(html, i);
            }
            this.cleanImageFiles(outdir, files);
        }
        return slidecount;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int doAfterBody() throws JspException {
        this.validateAttributes();
        if (this.presentationTag.getDirectory() != null && System.getSecurityManager() != null) {
            AccessController.checkPermission(new FilePermission(this.presentationTag.getDataDirectory().getAbsolutePath(), "write"));
        }
        if (this.format.equalsIgnoreCase("PPT")) {
            String content = this.mobileContent;
            if (this.bodyContent != null) {
                content = this.bodyContent.getString().trim();
                this.bodyContent.clearBody();
            }
            this._exportToPPT(content);
            return 0;
        }
        if (this.format.equalsIgnoreCase("html")) {
            if (PresentationTag.isPPT(this.src)) {
                if (this.presentationTag.getDirectory() != null && System.getSecurityManager() != null) {
                    AccessController.checkPermission(new FilePermission(this.presentationTag.getPresentationDirectory().getAbsolutePath(), "write"));
                }
                this._exportPPTtoHTML();
                return 0;
            }
        }
        if (this.format.equalsIgnoreCase("html")) {
            if (!PresentationTag.isPPT(this.src)) {
                boolean hasContent;
                String content = this.mobileContent;
                if (this.bodyContent != null) {
                    content = this.bodyContent.getString().trim();
                    this.bodyContent.clearBody();
                }
                boolean bl = hasContent = content != null && content.length() > 0;
                if (!hasContent && this.src == null) {
                    throw new PresentationExceptions.EmptySlideException();
                }
                String[] html = new String[]{content};
                this.presentationTag.incrementSlideCount();
                this.presentationTag.addHTMLSlides(html);
                return 0;
            }
        }
        if (!PresentationTag.isPPT(this.src)) throw new PresentationExceptions.FormatInvalidException();
        throw new PresentationExceptions.FormatInvalidException();
    }

    private void _processSlideContent(final String content, final int slideno) {
        if (System.getSecurityManager() == null) {
            this.processSlideContent(content, slideno);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PresentationSlideTag.this.processSlideContent(content, slideno);
                    return null;
                }
            });
        }
    }

    private void _copyDummySwfFile(final File file) {
        if (System.getSecurityManager() == null) {
            this.copyDummySwfFile(file);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PresentationSlideTag.this.copyDummySwfFile(file);
                    return null;
                }
            });
        }
    }

    public void checkSlideFile(final File slideFile) {
        if (System.getSecurityManager() == null) {
            this._checkSlideFile(slideFile);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PresentationSlideTag.this._checkSlideFile(slideFile);
                    return null;
                }
            });
        }
    }

    private void _checkSlideFile(File slideFile) {
        if (this.presentationTag.getDirectory() != null && !this.presentationTag.isOverWrite() && slideFile.exists()) {
            throw new PresentationExceptions.FileAlreadyExistsException(slideFile.getAbsolutePath());
        }
    }

    private File _getSwfFile() {
        if (System.getSecurityManager() == null) {
            return this.getSwfFile();
        }
        return (File)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PresentationSlideTag.this.getSwfFile();
            }
        });
    }

    private File getSwfFile() {
        File swfFile = new File(this.src);
        if (!swfFile.isAbsolute()) {
            swfFile = new File(Utils.expandPath((String)this.src, (PageContext)this.pageContext));
        }
        if (!swfFile.exists()) {
            throw new PresentationExceptions.InvalidSrcException(this.src);
        }
        return swfFile;
    }

    private void doPrivilegedCopy(final File srcFile, final File destFile) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    IOUtils.copyFile((File)srcFile, (File)destFile);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private SlideData _buildSlideData() {
        if (System.getSecurityManager() == null) {
            return this.buildSlideData();
        }
        return (SlideData)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PresentationSlideTag.this.buildSlideData();
            }
        });
    }

    private void copySourceSwfFile(File slideFile) {
        File swfFile = this._getSwfFile();
        if (System.getSecurityManager() != null) {
            AccessController.checkPermission(new FilePermission(swfFile.getAbsolutePath(), "read"));
        }
        try {
            if (System.getSecurityManager() == null) {
                IOUtils.copyFile((File)swfFile, (File)slideFile);
            } else {
                this.doPrivilegedCopy(swfFile, slideFile);
            }
        }
        catch (IOException e) {
            throw new PresentationExceptions.PresentationException((Throwable)e);
        }
    }

    private void copyDummySwfFile(File file) {
        String templateDir = this.presentationTag.getTemplateDir();
        File dummySwf = new File(templateDir, "dummy.swf");
        try {
            IOUtils.copyFile((File)dummySwf, (File)file);
        }
        catch (IOException e) {
            throw new PresentationExceptions.PresentationException((Throwable)e);
        }
    }

    private String resolveURL(String src) {
        ResolvePage rp = new ResolvePage();
        String baseUrlStr = null;
        try {
            baseUrlStr = this.getBaseURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String parentUrl = rp.prepareUrl(baseUrlStr);
        String actualBaseUrl = rp.baseUrl(baseUrlStr);
        String contextUrl = actualBaseUrl + this.request.getContextPath();
        String resolvedUrl = rp.resolveUrl(src, parentUrl, contextUrl);
        return resolvedUrl == null ? src : resolvedUrl;
    }

    public OutputStream getOutputStream(final File slideFile) throws Exception {
        if (System.getSecurityManager() == null) {
            return VFSFileFactory.getOutputStream((File)slideFile);
        }
        return (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return VFSFileFactory.getOutputStream((File)slideFile);
            }
        });
    }

    public int doEndTag() throws JspException {
        this.onTagEnd();
        return 6;
    }

    public String getURI(String path) {
        path = path.replace('\\', '/');
        try {
            String requestURI = this.request.getRequestURI();
            String contextPath = this.request.getContextPath();
            if (contextPath.length() > 0) {
                requestURI = requestURI.substring(contextPath.length());
            }
            URI pageUri = new URI(requestURI);
            path = new HttpURL(path).getEscapedURI();
            String relPath = pageUri.resolve(path).toString();
            return "../../../.." + relPath;
        }
        catch (Exception e) {
            File file = new File(path);
            return file.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlideData buildSlideData() {
        SlideData slideData = new SlideData();
        slideData.setTitle(this.title);
        slideData.setUrl(this.name);
        if (this.wrapper != null) {
            slideData.setWrapper(this.wrapper);
            InputStream in = null;
            try {
                in = VFSFileFactory.getInputStream((File)this.slideFile);
                TagDecoder decoder = new TagDecoder(in);
                Header header = decoder.decodeHeader();
                Rect rect = header.size;
                int width = rect.getWidth() / 20;
                int height = rect.getHeight() / 20;
                slideData.setDimension(width, height);
                if (this.duration == 0) {
                    this.duration = header.framecount / header.rate;
                }
            }
            catch (Throwable e) {
                slideData.setDimension(720, 540);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException decoder) {}
            }
        }
        if (this.duration == 0) {
            this.duration = 10;
        }
        slideData.setDuration(this.duration);
        if (this.audio != null) {
            if (this.presentationTag.getDirectory() != null) {
                slideData.setAudioUrl(new File(this.audio).getName());
            } else {
                slideData.setAudioUrl(this.getURI(this.audio));
            }
        }
        if (this.video != null) {
            if (this.presentationTag.getDirectory() != null) {
                slideData.setVideoUrl(new File(this.video).getName());
            } else {
                slideData.setVideoUrl(this.getURI(this.video));
            }
        }
        if (this.presenter != null) {
            int indexOfPresenter = this.presentationTag.getIndexOfPresenter(this.presenter);
            if (indexOfPresenter == -1) {
                throw new PresentationExceptions.PresenterNotFoundException(this.presenter);
            }
            slideData.setSpeakerIndex(indexOfPresenter);
        }
        slideData.setBackgroundIndex(0);
        slideData.setNotes(this.notes);
        if (this.advance == null) {
            this.advance = this.presentationTag.isAutoPlay() ? AUTO : NEVER;
        }
        slideData.setAdvance(this.advance);
        if (this.docPPTProps != null) {
            String textContent = ((Object)((Object)this.docPPTProps)).toString();
            slideData.setTextContent(textContent);
        }
        return slideData;
    }

    public void release() {
        this.presentationTag = null;
        this.pptreader = null;
        this.src = null;
        this.title = null;
        this.audio = null;
        this.duration = 0;
        this.presenter = null;
        this.notes = null;
        this.video = null;
        this.advance = null;
        this.scale = 0.0;
        this.slides = null;
        this.marginTop = -1;
        this.marginBottom = -1;
        this.marginLeft = -1;
        this.marginRight = -1;
        this.authUser = null;
        this.authPassword = null;
        this.useExternalProgram = true;
        this.userAgent = null;
        this.showTitle = false;
        this.baseurl = null;
        this.name = null;
        this.docProps = null;
        this.slideFile = null;
        this.wrapper = null;
        super.release();
    }

    class JPEGFilter
    implements FilenameFilter {
        JPEGFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jpg");
        }
    }
}

