/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import macromedia.sequelink.util.UnSyncVectorEnumerator;

public class UnSyncVector
implements Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public UnSyncVector(int n2, int n3) {
        this.elementData = new Object[n2];
        this.capacityIncrement = n3;
    }

    public UnSyncVector(int n2) {
        this(n2, 0);
    }

    public UnSyncVector() {
        this(10);
    }

    public final void copyInto(Object[] objectArray) {
        int n2 = this.elementCount;
        while (n2-- > 0) {
            objectArray[n2] = this.elementData[n2];
        }
    }

    public final void trimToSize() {
        int n2 = this.elementData.length;
        if (this.elementCount < n2) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void ensureCapacity(int n2) {
        if (n2 > this.elementData.length) {
            this.ensureCapacityHelper(n2);
        }
    }

    private void ensureCapacityHelper(int n2) {
        int n3;
        int n4 = this.elementData.length;
        Object[] objectArray = this.elementData;
        int n5 = n3 = this.capacityIncrement > 0 ? n4 + this.capacityIncrement : n4 * 2;
        if (n3 < n2) {
            n3 = n2;
        }
        this.elementData = new Object[n3];
        System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
    }

    public final void setSize(int n2) {
        if (n2 > this.elementCount && n2 > this.elementData.length) {
            this.ensureCapacityHelper(n2);
        } else {
            for (int i2 = n2; i2 < this.elementCount; ++i2) {
                this.elementData[i2] = null;
            }
        }
        this.elementCount = n2;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final Enumeration elements() {
        return new UnSyncVectorEnumerator(this);
    }

    public final boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public final int indexOf(Object object, int n2) {
        for (int i2 = n2; i2 < this.elementCount; ++i2) {
            if (!object.equals(this.elementData[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public final int lastIndexOf(Object object, int n2) {
        for (int i2 = n2; i2 >= 0; --i2) {
            if (!object.equals(this.elementData[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final Object elementAt(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n2 + " < 0");
        }
    }

    public final Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final void setElementAt(Object object, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        this.elementData[n2] = object;
    }

    public final void removeElementAt(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final void insertElementAt(Object object, int n2) {
        int n3 = this.elementCount + 1;
        if (n2 >= n3) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.elementCount);
        }
        if (n3 > this.elementData.length) {
            this.ensureCapacityHelper(n3);
        }
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        this.elementData[n2] = object;
        ++this.elementCount;
    }

    public final void addElement(Object object) {
        int n2 = this.elementCount + 1;
        if (n2 > this.elementData.length) {
            this.ensureCapacityHelper(n2);
        }
        this.elementData[this.elementCount++] = object;
    }

    public final boolean removeElement(Object object) {
        int n2 = this.indexOf(object);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public final void removeAllElements() {
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = null;
        }
        this.elementCount = 0;
    }

    public Object clone() {
        try {
            UnSyncVector unSyncVector = (UnSyncVector)super.clone();
            unSyncVector.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, unSyncVector.elementData, 0, this.elementCount);
            return unSyncVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final String toString() {
        int n2 = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        stringBuffer.append("[");
        for (int i2 = 0; i2 <= n2; ++i2) {
            String string = enumeration.nextElement().toString();
            stringBuffer.append(string);
            if (i2 >= n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

