/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import macromedia.jdbc.slbase.BaseCharStreamOnFileChunk;
import macromedia.jdbc.slbase.BaseColumn;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseImplBlob;
import macromedia.jdbc.slbase.BaseImplClob;
import macromedia.jdbc.slbase.BaseImplResultSetService;
import macromedia.jdbc.slbase.BaseInputStreamOnFileChunk;
import macromedia.slutil.UtilTempFile;

public final class BaseImplResultSetClientSideInsensitiveMemory
extends BaseImplResultSetService {
    private ArrayList resultSetData = new ArrayList();
    private BaseData[] rowData;
    protected File longDataFileHandle;
    private RandomAccessFile longDataFile;
    private ArrayList longDataFileResultSetMap;
    boolean tempFilesAreReady = false;
    private int rowsFetchedFromSubResultSet = 0;
    private boolean endOfResultSetReached = false;
    private int maxLongDataSize;
    private BaseConnection connection;

    public void postSetupInitialize() throws SQLException {
        this.tempFilesAreReady = false;
        super.postSetupInitialize();
        this.fetchAtPosition(1);
    }

    void setMaxLongDataFieldCacheSize(int n2) {
        this.maxLongDataSize = n2;
    }

    private void setupTempFiles() throws SQLException {
        if (this.tempFilesAreReady) {
            return;
        }
        try {
            this.longDataFileHandle = UtilTempFile.createTempFile("scb_");
            try {
                this.longDataFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new RandomAccessFile(BaseImplResultSetClientSideInsensitiveMemory.this.longDataFileHandle, "rw");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            this.tempFilesAreReady = true;
            this.longDataFileResultSetMap = new ArrayList();
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6038, "TMPDIR");
        }
    }

    public void close() throws SQLException {
        super.close();
        try {
            this.longDataFile.close();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    BaseImplResultSetClientSideInsensitiveMemory.this.longDataFileHandle.delete();
                    return null;
                }
            });
            this.resultSetData = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getScrollType() {
        return 1004;
    }

    public int getColumnAccess() {
        return 2;
    }

    public void setCursorPosition(int n2) {
        this.cursorPosition = n2;
    }

    public boolean fetchAtPosition(int n2) throws SQLException {
        boolean bl2 = true;
        if (n2 > this.rowsFetchedFromSubResultSet) {
            bl2 = this.fetchAndCache(n2 - this.rowsFetchedFromSubResultSet);
        }
        if (bl2 && n2 + 1 > this.rowsFetchedFromSubResultSet) {
            this.fetchAndCache(1);
        }
        return bl2;
    }

    boolean fetchAndCache(int n2) throws SQLException {
        boolean bl2 = true;
        for (int i2 = 0; bl2 && i2 < n2; ++i2) {
            bl2 = this.endOfResultSetReached ? false : this.subImplResultSet.next();
            if (bl2) {
                ++this.rowsFetchedFromSubResultSet;
                this.cacheCurrentRow();
                continue;
            }
            this.endOfResultSetReached = true;
            this.maxCursorPosition = this.rowsFetchedFromSubResultSet;
        }
        return bl2;
    }

    void cacheCurrentRow() throws SQLException {
        try {
            int n2 = this.columns.count(0);
            this.rowData = new BaseData[n2];
            block10: for (int i2 = 0; i2 < n2; ++i2) {
                BaseColumn baseColumn = this.columns.get(i2 + 1);
                BaseData baseData = this.subImplResultSet.getData(i2 + 1, baseColumn.baseDataType);
                if (this.connection == null) {
                    this.connection = baseData.connection;
                }
                if (baseData.isNull()) {
                    this.rowData[i2] = new BaseData(baseData.getType(), baseData.getObject(), this.connection);
                    continue;
                }
                if (baseData.getType() > 100 && baseData.getType() < 200) {
                    this.rowData[i2] = new BaseData(baseData.getType(), baseData.getBytesNoConvert(), this.connection);
                    if (baseData.getType() == 110) {
                        this.rowData[i2].setOracleTZScale(baseData.getOracleTZScale());
                        this.rowData[i2].setOracleFetchTSWTZasTimestamp(baseData.getOracleFetchTSWTZasTimestamp());
                        continue;
                    }
                    if (baseData.getType() != 111) continue;
                    this.rowData[i2].setOracleTZHours(baseData.getOracleTZHours());
                    this.rowData[i2].setOracleTZMinutes(baseData.getOracleTZMinutes());
                    continue;
                }
                if (baseData.getType() > 200) {
                    this.rowData[i2] = new BaseData(baseData.getType(), baseData.getStringNoConvert(), this.connection);
                    continue;
                }
                switch (baseData.getType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 21: {
                        this.rowData[i2] = new BaseData(baseData.getType(), baseData.getObject(), this.connection);
                        continue block10;
                    }
                    case 14: 
                    case 15: {
                        this.rowData[i2] = null;
                        this.cacheBinaryStream(this.rowsFetchedFromSubResultSet, i2, baseData.getType(), (InputStream)baseData.getObject());
                        continue block10;
                    }
                    case 19: {
                        this.rowData[i2] = null;
                        this.cacheBlob(this.rowsFetchedFromSubResultSet, i2, (BaseImplBlob)baseData.getObject());
                        continue block10;
                    }
                    case 18: {
                        this.rowData[i2] = null;
                        this.cacheCharacterStream(this.rowsFetchedFromSubResultSet, i2, 18, (Reader)baseData.getObject());
                        continue block10;
                    }
                    case 20: {
                        this.rowData[i2] = null;
                        this.cacheClob(this.rowsFetchedFromSubResultSet, i2, (BaseImplClob)baseData.getObject());
                    }
                }
            }
            this.resultSetData.add(this.rowData);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039, "TMPDIR");
        }
    }

    private void cacheBinaryStream(int n2, int n3, int n4, InputStream inputStream) throws IOException, SQLException {
        this.setupTempFiles();
        BaseLongDataCacheIndex baseLongDataCacheIndex = new BaseLongDataCacheIndex();
        baseLongDataCacheIndex.row = n2;
        baseLongDataCacheIndex.column = n3;
        baseLongDataCacheIndex.position = this.longDataFile.length();
        long l2 = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n5 = this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024;
        byte[] byArray = new byte[n5];
        int n6 = inputStream.read(byArray, 0, n5);
        while (n6 != -1) {
            this.longDataFile.write(byArray, 0, n6);
            l2 += (long)n6;
            if (this.maxLongDataSize != 0) {
                if (n6 >= n5) break;
                n5 = this.maxLongDataSize - (int)l2;
            }
            n6 = inputStream.read(byArray, 0, n5);
        }
        baseLongDataCacheIndex.length = l2;
        baseLongDataCacheIndex.baseDataType = n4;
        this.longDataFileResultSetMap.add(baseLongDataCacheIndex);
    }

    private void cacheCharacterStream(int n2, int n3, int n4, Reader reader) throws IOException, SQLException {
        this.setupTempFiles();
        BaseLongDataCacheIndex baseLongDataCacheIndex = new BaseLongDataCacheIndex();
        baseLongDataCacheIndex.row = n2;
        baseLongDataCacheIndex.column = n3;
        baseLongDataCacheIndex.position = this.longDataFile.length();
        long l2 = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n5 = this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024;
        char[] cArray = new char[n5];
        int n6 = reader.read(cArray, 0, n5);
        while (n6 != -1) {
            for (int i2 = 0; i2 < n6; ++i2) {
                this.longDataFile.writeChar(cArray[i2]);
            }
            l2 += (long)(n6 * 2);
            if (this.maxLongDataSize != 0) {
                if (n6 >= n5) break;
                n5 = this.maxLongDataSize - (int)(l2 / 2L);
            }
            n6 = reader.read(cArray, 0, n5);
        }
        baseLongDataCacheIndex.length = l2;
        baseLongDataCacheIndex.baseDataType = 18;
        this.longDataFileResultSetMap.add(baseLongDataCacheIndex);
    }

    private void cacheBlob(int n2, int n3, BaseImplBlob baseImplBlob) throws SQLException, IOException {
        this.setupTempFiles();
        BaseLongDataCacheIndex baseLongDataCacheIndex = new BaseLongDataCacheIndex();
        baseLongDataCacheIndex.row = n2;
        baseLongDataCacheIndex.column = n3;
        baseLongDataCacheIndex.position = this.longDataFile.length();
        baseLongDataCacheIndex.baseDataType = 19;
        this.longDataFile.seek(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeBlob(this.longDataFile, baseImplBlob);
        this.longDataFileResultSetMap.add(baseLongDataCacheIndex);
    }

    private void cacheClob(int n2, int n3, BaseImplClob baseImplClob) throws SQLException, IOException {
        this.setupTempFiles();
        BaseLongDataCacheIndex baseLongDataCacheIndex = new BaseLongDataCacheIndex();
        baseLongDataCacheIndex.row = n2;
        baseLongDataCacheIndex.column = n3;
        baseLongDataCacheIndex.position = this.longDataFile.length();
        baseLongDataCacheIndex.baseDataType = 20;
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeClob(this.longDataFile, baseImplClob);
        this.longDataFileResultSetMap.add(baseLongDataCacheIndex);
    }

    private BaseData getCachedBinaryStream(BaseLongDataCacheIndex baseLongDataCacheIndex) throws SQLException {
        try {
            BaseInputStreamOnFileChunk baseInputStreamOnFileChunk = new BaseInputStreamOnFileChunk(this.longDataFile, baseLongDataCacheIndex.position, baseLongDataCacheIndex.length);
            return new BaseData(baseLongDataCacheIndex.baseDataType, baseInputStreamOnFileChunk, this.connection);
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    private BaseData getCachedCharStream(BaseLongDataCacheIndex baseLongDataCacheIndex) throws SQLException {
        try {
            BaseCharStreamOnFileChunk baseCharStreamOnFileChunk = new BaseCharStreamOnFileChunk(this.longDataFile, baseLongDataCacheIndex.position, baseLongDataCacheIndex.length);
            return new BaseData(18, baseCharStreamOnFileChunk, this.connection);
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    private BaseData getCachedBlob(BaseLongDataCacheIndex baseLongDataCacheIndex) throws SQLException {
        try {
            this.longDataFile.seek(baseLongDataCacheIndex.position);
            return new BaseData(19, this.subImplResultSet.readBlob(this.longDataFile), this.connection);
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    private BaseData getCachedClob(BaseLongDataCacheIndex baseLongDataCacheIndex) throws SQLException {
        try {
            this.longDataFile.seek(baseLongDataCacheIndex.position);
            return new BaseData(20, this.subImplResultSet.readClob(this.longDataFile), this.connection);
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    public BaseData getData(int n2, int n3) throws SQLException {
        this.rowData = (BaseData[])this.resultSetData.get(this.cursorPosition - 1);
        BaseData baseData = this.rowData[n2 - 1];
        if (baseData == null) {
            BaseLongDataCacheIndex baseLongDataCacheIndex = null;
            int n4 = 0;
            while (baseLongDataCacheIndex == null) {
                baseLongDataCacheIndex = (BaseLongDataCacheIndex)this.longDataFileResultSetMap.get(n4++);
                if (this.cursorPosition == baseLongDataCacheIndex.row && n2 == baseLongDataCacheIndex.column + 1) continue;
                baseLongDataCacheIndex = null;
            }
            switch (baseLongDataCacheIndex.baseDataType) {
                case 14: 
                case 15: {
                    baseData = this.getCachedBinaryStream(baseLongDataCacheIndex);
                    break;
                }
                case 19: {
                    baseData = this.getCachedBlob(baseLongDataCacheIndex);
                    break;
                }
                case 18: {
                    baseData = this.getCachedCharStream(baseLongDataCacheIndex);
                    break;
                }
                case 20: {
                    baseData = this.getCachedClob(baseLongDataCacheIndex);
                }
            }
        }
        return baseData;
    }

    protected boolean setupForNextResultSetInMultipleResult(int n2) throws SQLException {
        this.fetchAndCache(Integer.MAX_VALUE);
        return true;
    }

    class BaseLongDataCacheIndex {
        public int row;
        public int column;
        public long position;
        public long length;
        public int baseDataType;

        BaseLongDataCacheIndex() {
        }
    }
}

