/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import com.merant.SlExtensionInterface;
import com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import macromedia.jdbc.extensions.ExtConnection;
import macromedia.jdbc.slbase.BaseCallableStatement;
import macromedia.jdbc.slbase.BaseCallbleStatement;
import macromedia.jdbc.slbase.BaseClassUtility;
import macromedia.jdbc.slbase.BaseConnectionProperties;
import macromedia.jdbc.slbase.BaseConnectionStartup;
import macromedia.jdbc.slbase.BaseDatabaseMetaData;
import macromedia.jdbc.slbase.BaseDriverPropertyInfos;
import macromedia.jdbc.slbase.BaseEscapeTranslator;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseImplConnection;
import macromedia.jdbc.slbase.BaseImplDatabaseMetaData;
import macromedia.jdbc.slbase.BaseLicenseUtility;
import macromedia.jdbc.slbase.BasePreparedStatement;
import macromedia.jdbc.slbase.BaseSQLScanner;
import macromedia.jdbc.slbase.BaseSQLToken;
import macromedia.jdbc.slbase.BaseSavepoints;
import macromedia.jdbc.slbase.BaseStatement;
import macromedia.jdbc.slbase.BaseStatementPool;
import macromedia.jdbc.slbase.BaseURLParser;
import macromedia.jdbc.slbase.BaseWarnings;
import macromedia.slutil.UtilDebug;
import macromedia.slutil.UtilException;

public abstract class BaseConnection
implements Connection,
ExtConnection,
com.ddtek.jdbc.extensions.ExtEmbeddedConnection,
ExtEmbeddedConnection,
com.ddtek.jdbc.extensions.SlExtensionInterface,
SlExtensionInterface {
    protected String driverName;
    protected BaseConnectionProperties connectProps;
    UtilDebug debug;
    BaseImplConnection implConnection;
    private boolean pingServerDuringIsClosed = false;
    private BaseDatabaseMetaData databaseMetaData;
    private boolean actualAutoCommitMode;
    public boolean exposedAutoCommitMode = true;
    boolean manualTxnWorkStarted = false;
    private boolean readOnlyMode;
    private String currentCatalog;
    private String originalCatalog;
    private int currentTransactionIsolation = -1;
    private int originalTransactionIsolation = -1;
    protected BaseWarnings warnings;
    protected BaseExceptions exceptions;
    protected boolean lockedEmbedding;
    protected boolean isEval;
    protected boolean isEmbedded;
    protected boolean requireCPUCheck;
    BaseStatementPool statementPool;
    private int supportsSavepoints = -1;
    private BaseSavepoints savepoints;
    protected boolean isXAConnection;
    private int supportsTransactions = -1;
    BaseEscapeTranslator escapeTranslator;
    private boolean autoGeneratedKeysRequested = false;
    boolean isJavaDoubleToString;
    int dateTimeBehavior = 0;
    String loadLibraryPath = null;
    public int workarounds = 0;
    public static final int WA_HIBERNATE_GENERATED_KEYS = 1;
    public static final int WA_SQLSERVER_SETSAVEPOINT = 2;
    protected int prepareExecuteMode = 0;
    private String clientAppName = "";
    private String clientHostName = "";
    private String clientUser = "";
    private String clientAcctInfo = "";
    Calendar cal = Calendar.getInstance();
    char[] buff = new char[10];
    boolean loginTimedOut = false;
    Object loginTimedOutSync;
    public int convertNull = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseDriverPropertyInfos getPropertyInfo() {
        BaseDriverPropertyInfos baseDriverPropertyInfos = new BaseDriverPropertyInfos();
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.getImplPropertyInfo(baseDriverPropertyInfos);
        }
        baseDriverPropertyInfos.put("alternateServers", "List of server connection information used to attempt an alternate connections.", "", null, false);
        if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
            baseDriverPropertyInfos.put("batchPerformanceWorkaround", "Batch Performance Workaround", "false", null, false);
        }
        baseDriverPropertyInfos.put("maxPooledStatements", "Maximum number of PreparedStatement objects to pool.", "0", null, false);
        baseDriverPropertyInfos.put("insensitiveResultSetBufferSize", "Maxiumn memory in KB to use for client-side insensitive scrolling.", "2048", null, false);
        baseDriverPropertyInfos.put("connectionRetryCount", "Max number of times to attempt to retry a connection.", "5", null, false);
        baseDriverPropertyInfos.put("connectionRetryDelay", "Time to delay before retrying connection.", "1", null, false);
        baseDriverPropertyInfos.put("loadBalancing", "Specifies whether to perform load balancing.", "false", null, false);
        baseDriverPropertyInfos.put("resultsetMetaDataOptions", "Integer bit mask for configuring the information returned in ResultSetMetaData resultsets.", "0", null, false);
        baseDriverPropertyInfos.put("javaDoubleToString", "Specifies whether the Java Double to String conversion algorithm should be used.", "false", null, false);
        baseDriverPropertyInfos.put("initializationString", "SQL executed after a connection is established.", "", null, false);
        baseDriverPropertyInfos.put("loadLibraryPath", "Fully qualified path to the type 2 security dll.", "", null, false);
        baseDriverPropertyInfos.put("workarounds", "Specify workarounds for third party applications.", "0", null, false);
        baseDriverPropertyInfos.put("convertNull", "Convert Null.", "1", null, false);
        baseDriverPropertyInfos.put("queryTimeout", "Sets the default queryTimeout for all Statements on this Connection", "0", null, false);
        return baseDriverPropertyInfos;
    }

    protected void doUnlock() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(BaseConnectionProperties baseConnectionProperties, BaseExceptions baseExceptions, UtilDebug utilDebug) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            int n2;
            this.driverName = BaseClassUtility.getRootName(this);
            this.connectProps = baseConnectionProperties;
            this.exceptions = baseExceptions;
            this.exceptions.setConnection(this);
            this.debug = utilDebug;
            this.warnings = new BaseWarnings(baseExceptions.getMessages());
            this.readOnlyMode = false;
            this.actualAutoCommitMode = true;
            if (baseConnectionProperties.get("validateIsClosed") != null) {
                this.pingServerDuringIsClosed = baseConnectionProperties.get("validateIsClosed").equalsIgnoreCase("true");
            }
            int n3 = 0;
            if (baseConnectionProperties.get("loginTimeout") != null) {
                n3 = Integer.valueOf(baseConnectionProperties.get("loginTimeout"));
            }
            this.loadLibraryPath = baseConnectionProperties.get("loadLibraryPath");
            if (baseConnectionProperties.get("workarounds") != null) {
                this.workarounds = Integer.valueOf(baseConnectionProperties.get("workarounds"));
            }
            this.implConnection = this.setupImplConnection(n3);
            String string = baseConnectionProperties.get("maxPooledStatements");
            if (string != null && (n2 = Integer.parseInt(string)) > 0) {
                this.statementPool = new BaseStatementPool(n2);
            }
            this.isJavaDoubleToString = new Boolean(baseConnectionProperties.get("javaDoubleToString"));
            String string2 = baseConnectionProperties.get("dateTimeBehavior");
            if (string2 != null) {
                if (string2.equalsIgnoreCase("0")) {
                    this.dateTimeBehavior = 0;
                } else if (string2.equalsIgnoreCase("1")) {
                    this.dateTimeBehavior = 1;
                } else if (string2.equalsIgnoreCase("2")) {
                    this.dateTimeBehavior = 2;
                }
            }
            this.convertNull = Integer.parseInt(baseConnectionProperties.get("convertNull"));
            this.lockedEmbedding = false;
            this.isEval = false;
            this.isEmbedded = false;
            this.requireCPUCheck = true;
            this.executeInitializationString();
            this.lockedEmbedding = BaseLicenseUtility.isLocked(this);
            int n4 = Integer.parseInt(baseConnectionProperties.get("queryTimeout"));
            if (n4 > 0 && !this.implConnection.supportsCancel() && !this.implConnection.supportsQueryTimeout()) {
                throw baseExceptions.getException(6119);
            }
            if (n4 < 0 && n4 != -1) {
                throw baseExceptions.getException(6120);
            }
        }
    }

    public void executeInitializationString() throws SQLException {
        try {
            boolean bl2 = false;
            String string = this.connectProps.get("initializationString");
            if (string != null && string.length() > 0) {
                Statement statement = this.createStatement();
                BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
                String string2 = "";
                if (string.charAt(0) == '(') {
                    int n2 = string.length() - 1;
                    baseSQLScanner.setup(string.substring(1, n2), '\'', '\"');
                } else {
                    baseSQLScanner.setup(string, '\'', '\"');
                }
                BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
                while (baseSQLToken.type != 6) {
                    if (baseSQLToken.type == 15) {
                        statement.addBatch(string2);
                        bl2 = true;
                        string2 = "";
                    } else {
                        string2 = string2 + baseSQLToken.value;
                    }
                    baseSQLToken = baseSQLScanner.getNextToken();
                }
                if ((string2 = string2.trim()).length() > 0) {
                    statement.addBatch(string2);
                    bl2 = true;
                    string2 = "";
                }
                if (bl2) {
                    statement.executeBatch();
                }
            }
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException(sQLException, 0, 6110);
        }
    }

    public final synchronized void reset() throws SQLException {
        if (this.implConnection != null) {
            this.commonCloseReset();
            this.commonReset(true);
        }
    }

    public final synchronized void resetXA(boolean bl2) throws SQLException {
        if (this.implConnection != null) {
            this.commonCloseResetXA(bl2);
            this.commonReset(true);
        }
    }

    private BaseImplConnection setupImplConnection(int n2) throws SQLException {
        this.implConnection = this.createImplConnection(this.connectProps);
        this.implConnection.setup(this.connectProps, this.warnings, this.exceptions, this.debug);
        if ((this.connectProps.get("user") == null || this.connectProps.get("user").length() == 0) && this.implConnection.requiresUserId()) {
            throw this.exceptions.getException(6094);
        }
        this.implConnection.setReadOnly(this.readOnlyMode);
        if (n2 > 0) {
            this.loginTimedOutSync = new Object();
            final BaseConnection baseConnection = this;
            final int n3 = n2;
            final BaseExceptions baseExceptions = this.exceptions;
            try {
                BaseConnectionStartup baseConnectionStartup = (BaseConnectionStartup)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SQLException {
                        return new BaseConnectionStartup(baseConnection, n3, baseExceptions);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (SQLException)privilegedActionException.getException();
            }
        } else {
            this.connect();
        }
        return this.implConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimedOut() {
        Object object = this.loginTimedOutSync;
        synchronized (object) {
            this.loginTimedOut = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loginTimedOut() {
        if (this.loginTimedOutSync == null) {
            return false;
        }
        Object object = this.loginTimedOutSync;
        synchronized (object) {
            return this.loginTimedOut;
        }
    }

    void connect() throws SQLException {
        Object object;
        if (this.isXAConnection) {
            this.implConnection.prepareForXA();
        }
        String string = this.connectProps.get("alternateServers");
        int n2 = 1 + Integer.parseInt(this.connectProps.get("connectionRetryCount"));
        int n3 = Integer.parseInt(this.connectProps.get("connectionRetryDelay"));
        boolean bl2 = false;
        if (string != null && string.length() > 0 && (object = this.connectProps.get("loadBalancing")) != null && ((String)object).equalsIgnoreCase("true")) {
            bl2 = true;
        }
        object = null;
        Throwable throwable = null;
        SQLException sQLException = null;
        String string2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = this.getConnectPropList((ArrayList)object, this.connectProps, string, bl2);
            int n4 = ((ArrayList)object).size();
            boolean bl3 = false;
            for (int i3 = 0; i3 < n4; ++i3) {
                BaseConnectionProperties baseConnectionProperties = (BaseConnectionProperties)((ArrayList)object).get(i3);
                if (baseConnectionProperties == null) continue;
                try {
                    if (this.loginTimedOut()) {
                        return;
                    }
                    this.implConnection.connectProps = baseConnectionProperties;
                    this.implConnection.setConnectionStatus(2);
                    this.implConnection.open();
                    while (throwable != null) {
                        String[] stringArray = new String[]{throwable.getMessage()};
                        this.warnings.add(6001, stringArray, ((SQLException)throwable).getSQLState(), ((SQLException)throwable).getErrorCode());
                        throwable = ((SQLException)throwable).getNextException();
                    }
                    return;
                }
                catch (SQLException sQLException2) {
                    String[] stringArray = new String[]{this.connectProps.get("serverName")};
                    string2 = new UtilException(1021, stringArray).getMessage();
                    if (sQLException2.getSQLState().startsWith("08")) {
                        if (sQLException2.getMessage().indexOf(string2) != -1) {
                            bl3 = true;
                            ((ArrayList)object).set(i3, null);
                        }
                        if (throwable == null) {
                            throwable = sQLException2;
                        }
                        if (sQLException != null) {
                            sQLException.setNextException(sQLException2);
                        }
                        sQLException = sQLException2;
                        continue;
                    }
                    throw sQLException2;
                }
            }
            if (bl3 && n4 == 1) {
                throw throwable;
            }
            if (n3 <= 0) continue;
            try {
                Thread.sleep(n3 * 1000);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw throwable;
    }

    private ArrayList getConnectPropList(ArrayList arrayList, BaseConnectionProperties baseConnectionProperties, String string, boolean bl2) throws SQLException {
        ArrayList<Object> arrayList2;
        Object object;
        ArrayList<BaseConnectionProperties> arrayList3 = arrayList;
        if (arrayList == null) {
            arrayList3 = new ArrayList<BaseConnectionProperties>();
            arrayList3.add(baseConnectionProperties);
            if (string != null && string.length() > 0) {
                BaseConnectionProperties baseConnectionProperties2 = new BaseConnectionProperties();
                object = new StringTokenizer(string, "(),");
                arrayList2 = new ArrayList();
                while (((StringTokenizer)object).hasMoreElements()) {
                    arrayList2.add(((StringTokenizer)object).nextElement());
                }
                String string2 = BaseClassUtility.getRootName(this);
                BaseURLParser baseURLParser = BaseClassUtility.getURLParser(string2);
                int n2 = arrayList2.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    BaseConnectionProperties baseConnectionProperties3 = baseConnectionProperties.copy();
                    StringBuffer stringBuffer = new StringBuffer("jdbc:datadirect:");
                    stringBuffer.append(string2);
                    stringBuffer.append("://");
                    stringBuffer.append((String)arrayList2.get(i2));
                    if (!baseURLParser.parse(string2, stringBuffer.toString(), baseConnectionProperties2)) {
                        throw this.exceptions.getException(6098);
                    }
                    this.implConnection.mergeAlternateConnectProps(baseConnectionProperties2, baseConnectionProperties3);
                    arrayList3.add(baseConnectionProperties3);
                }
            }
        }
        int n3 = arrayList3.size();
        if (bl2 && n3 > 1) {
            int n4;
            object = new Random();
            arrayList2 = new ArrayList<Object>(n3);
            for (n4 = 0; n4 < n3; ++n4) {
                arrayList2.add(null);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = ((Random)object).nextInt(n3);
                while (true) {
                    if (arrayList2.get(n5) == null) break;
                    n5 = (n5 + 1) % n3;
                }
                arrayList2.set(n5, arrayList3.get(n4));
            }
            arrayList3 = arrayList2;
        }
        return arrayList3;
    }

    public final synchronized void clearWarnings() throws SQLException {
        this.warnings.clear();
    }

    public final synchronized void close() throws SQLException {
        if (this.implConnection != null) {
            this.commonCloseReset();
            this.commonClose();
        }
    }

    public final void abortConnection() throws SQLException {
        if (this.implConnection != null) {
            Socket socket = this.implConnection.getQueryTimeoutSocket();
            if (socket == null) {
                throw this.exceptions.getException(6111);
            }
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.implConnection = null;
        }
    }

    public final synchronized void closeXA(boolean bl2) throws SQLException {
        if (this.implConnection != null && !this.lockedEmbedding) {
            this.commonCloseResetXA(bl2);
            this.commonClose();
        }
    }

    final void commonClose() throws SQLException {
        if (this.statementPool != null) {
            this.statementPool.empty();
            this.statementPool = null;
        }
        this.implConnection.close();
        this.implConnection = null;
    }

    final void commonReset(boolean bl2) throws SQLException {
        this.clientAppName = "";
        this.clientHostName = "";
        this.clientUser = "";
        this.clientAcctInfo = "";
        if (this.originalCatalog != null && this.currentCatalog != null && !this.originalCatalog.equals(this.currentCatalog)) {
            this.setCatalog(this.originalCatalog);
        }
        if (this.originalTransactionIsolation != -1 && this.originalTransactionIsolation != this.currentTransactionIsolation) {
            this.setTransactionIsolation(this.originalTransactionIsolation);
        }
        if (bl2) {
            this.setAutoCommit(true);
        }
        this.setReadOnly(false);
        this.implConnection.reset();
    }

    final void commonCloseReset() throws SQLException {
        this.clearWarnings();
        if (!this.actualAutoCommitMode) {
            try {
                this.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    final void commonCloseResetXA(boolean bl2) throws SQLException {
        this.clearWarnings();
        if (!bl2 && !this.actualAutoCommitMode) {
            try {
                this.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    final void validateSavepoint(String string, Savepoint savepoint, boolean bl2) throws SQLException {
        if (this.supportsSavepoints == -1) {
            int n2 = this.supportsSavepoints = this.getMetaData().supportsSavepoints() ? 1 : 0;
        }
        if (this.supportsSavepoints == 0) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6003, stringArray);
        }
        if (this.savepoints == null) {
            this.savepoints = new BaseSavepoints(this.exceptions, this);
        }
        if (savepoint != null && !this.savepoints.isValid(savepoint, bl2)) {
            throw this.exceptions.getException(6082);
        }
    }

    public final synchronized void commit() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (!this.exposedAutoCommitMode && !this.actualAutoCommitMode) {
            if (this.savepoints != null) {
                this.savepoints.remove();
            }
            this.implConnection.commitTransaction();
            this.manualTxnWorkStarted = false;
        }
    }

    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public final synchronized Statement createStatement(int n2, int n3) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.validateTypeAndConcurrency("createStatement", n2, n3);
        BaseStatement baseStatement = new BaseStatement(this, n2, n3);
        this.postDownGradeWarnings(baseStatement, n2, n3);
        return baseStatement;
    }

    final void validateTypeAndConcurrency(String string, int n2, int n3) throws SQLException {
        boolean bl2 = false;
        switch (n2) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                bl2 = true;
            }
        }
        switch (n3) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                bl2 = true;
            }
        }
        if (bl2) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6002, stringArray);
        }
    }

    private void postDownGradeWarnings(Statement statement, int n2, int n3) throws SQLException {
        if (n2 != statement.getResultSetType()) {
            this.warnings.add(6046, "01000");
        }
        if (n3 != statement.getResultSetConcurrency()) {
            this.warnings.add(6047, "01000");
        }
    }

    public final synchronized boolean getAutoCommit() throws SQLException {
        return this.exposedAutoCommitMode;
    }

    public final synchronized boolean getActualAutoCommit() {
        return this.actualAutoCommitMode;
    }

    public final synchronized boolean getManualTxnWorkStarted() {
        return this.manualTxnWorkStarted;
    }

    public final synchronized String getCatalog() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.currentCatalog == null) {
            this.currentCatalog = this.implConnection.getCatalog();
            if (this.originalCatalog == null) {
                this.originalCatalog = this.currentCatalog;
            }
        }
        return this.currentCatalog;
    }

    public boolean getIsJavaDoubleToString() {
        return this.isJavaDoubleToString;
    }

    public int getDateTimeBehavior() {
        return this.dateTimeBehavior;
    }

    public String getLoadLibraryPath() {
        return this.loadLibraryPath;
    }

    public final synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.databaseMetaData == null) {
            BaseImplDatabaseMetaData baseImplDatabaseMetaData = this.createImplDatabaseMetaData(this.connectProps);
            baseImplDatabaseMetaData.setup(this);
            this.databaseMetaData = new BaseDatabaseMetaData(this, baseImplDatabaseMetaData);
        }
        return this.databaseMetaData;
    }

    public final synchronized int getTransactionIsolation() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.currentTransactionIsolation == -1) {
            this.currentTransactionIsolation = this.implConnection.getTransactionIsolation();
            if (this.originalTransactionIsolation == -1) {
                this.originalTransactionIsolation = this.currentTransactionIsolation;
            }
        }
        return this.currentTransactionIsolation;
    }

    public final Map getTypeMap() throws SQLException {
        return new HashMap();
    }

    public final synchronized SQLWarning getWarnings() {
        return this.warnings.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        boolean bl2;
        boolean bl3 = bl2 = this.implConnection == null;
        if (!bl2) {
            BaseConnection baseConnection = this;
            synchronized (baseConnection) {
                switch (this.implConnection.getConnectionStatus()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        if (!this.pingServerDuringIsClosed) break;
                        Statement statement = null;
                        try {
                            statement = this.createStatement();
                            statement.execute("Test Server Connectivity");
                            break;
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                                bl2 = true;
                                String[] stringArray = new String[]{sQLException.getMessage()};
                                this.warnings.add(6001, stringArray, sQLException.getSQLState());
                            }
                            if (statement == null) break;
                            try {
                                statement.close();
                                break;
                            }
                            catch (SQLException sQLException2) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return bl2;
    }

    public final synchronized boolean isReadOnly() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        return this.readOnlyMode;
    }

    public final String nativeSQL(String string) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        return string;
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        if (string != null && string.charAt(0) == '-' && string.charAt(2) == '!' && string.equals("--!ddtc!\n{call ddtc(?)}")) {
            return new BaseCallbleStatement(this);
        }
        return this.prepareCall(string, 1003, 1007);
    }

    public final synchronized CallableStatement prepareCall(String string, int n2, int n3) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.validateTypeAndConcurrency("prepareCall", n2, n3);
        CallableStatement callableStatement = null;
        if (this.statementPool != null) {
            callableStatement = this.statementPool.getCallableStatement(string, n2, n3);
        }
        if (callableStatement == null) {
            BaseCallableStatement baseCallableStatement = new BaseCallableStatement(this, string, n2, n3);
            callableStatement = this.statementPool != null ? this.statementPool.makeCallableStatementPoolable(baseCallableStatement) : baseCallableStatement;
        }
        this.postDownGradeWarnings(callableStatement, n2, n3);
        return callableStatement;
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public final synchronized PreparedStatement prepareStatement(String string, int n2, int n3) throws SQLException {
        this.finalizeTxnMode(false);
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.validateTypeAndConcurrency("prepareStatement", n2, n3);
        PreparedStatement preparedStatement = null;
        if (this.statementPool != null) {
            preparedStatement = this.statementPool.getPreparedStatement(string, n2, n3);
        }
        if (preparedStatement == null) {
            BasePreparedStatement basePreparedStatement = new BasePreparedStatement(this, string, n2, n3, this.autoGeneratedKeysRequested);
            preparedStatement = this.statementPool != null ? this.statementPool.makePreparedStatementPoolable(basePreparedStatement) : basePreparedStatement;
        }
        this.postDownGradeWarnings(preparedStatement, n2, n3);
        return preparedStatement;
    }

    public final synchronized void rollback() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (!this.exposedAutoCommitMode && !this.actualAutoCommitMode) {
            if (this.savepoints != null) {
                this.savepoints.remove();
            }
            this.implConnection.rollbackTransaction();
            this.manualTxnWorkStarted = false;
        }
    }

    public final synchronized void setAutoCommit(boolean bl2) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.ValidateSupportsTransactions(bl2);
        if (this.manualTxnWorkStarted && bl2) {
            this.setAutoCommitInternal(true);
            this.manualTxnWorkStarted = false;
        }
        this.exposedAutoCommitMode = bl2;
    }

    public final synchronized void setActualAutoCommit(boolean bl2) throws SQLException {
        this.setAutoCommitInternal(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAutoCommitInternal(boolean bl2) throws SQLException {
        boolean bl3 = this.actualAutoCommitMode;
        boolean bl4 = false;
        if (bl2) {
            if (this.actualAutoCommitMode) return;
            try {
                this.actualAutoCommitMode = true;
                this.implConnection.stopManualTransactionMode();
                bl4 = true;
                if (this.savepoints == null) return;
                this.savepoints.remove();
                return;
            }
            finally {
                if (!bl4) {
                    this.actualAutoCommitMode = bl3;
                }
            }
        }
        if (!this.actualAutoCommitMode) return;
        try {
            this.actualAutoCommitMode = false;
            this.implConnection.startManualTransactionMode();
            bl4 = true;
            return;
        }
        finally {
            if (!bl4) {
                this.actualAutoCommitMode = bl3;
            }
        }
    }

    synchronized boolean finalizeTxnMode(boolean bl2) throws SQLException {
        if (this.exposedAutoCommitMode != this.actualAutoCommitMode) {
            try {
                this.setAutoCommitInternal(this.exposedAutoCommitMode);
            }
            catch (SQLException sQLException) {
                throw this.exceptions.getException(sQLException, 6096);
            }
        }
        boolean bl3 = this.manualTxnWorkStarted;
        if (!this.exposedAutoCommitMode && bl2) {
            this.manualTxnWorkStarted = true;
        }
        return bl3;
    }

    public final synchronized void setCatalog(String string) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.currentCatalog != null && this.currentCatalog.equals(string)) {
            return;
        }
        if (this.originalCatalog == null) {
            this.originalCatalog = this.getCatalog();
        }
        this.implConnection.setCatalog(string);
        this.currentCatalog = new String(string);
    }

    public final synchronized void setReadOnly(boolean bl2) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.readOnlyMode = bl2;
        this.implConnection.setReadOnly(bl2);
    }

    public final synchronized void setTransactionIsolation(int n2) throws SQLException {
        if (n2 == 2112) {
            this.lockedEmbedding = false;
            return;
        }
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.finalizeTxnMode(false);
        if (this.originalTransactionIsolation == -1) {
            this.originalTransactionIsolation = this.implConnection.getTransactionIsolation();
        }
        this.implConnection.setTransactionIsolation(n2);
        this.currentTransactionIsolation = n2;
    }

    public final void setTypeMap(Map map) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(String string) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            if (this.lockedEmbedding) {
                this.lockedEmbedding = !BaseLicenseUtility.unlock(string);
            }
            return !this.lockedEmbedding;
        }
    }

    public void setOemId(String string) throws SQLException {
        String[] stringArray = new String[]{"Connection.setOemId"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void setApplicationId(String string) throws SQLException {
        String[] stringArray = new String[]{"Connection.setApplicationId"};
        throw this.exceptions.getException(6003, stringArray);
    }

    protected abstract void getImplPropertyInfo(BaseDriverPropertyInfos var1);

    protected abstract BaseImplConnection createImplConnection(BaseConnectionProperties var1) throws SQLException;

    public abstract BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties var1) throws SQLException;

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return null;
    }

    public final BaseEscapeTranslator getEscapeTranslator() throws SQLException {
        if (this.escapeTranslator == null) {
            this.escapeTranslator = this.createEscapeTranslator();
        }
        return this.escapeTranslator;
    }

    public boolean getBatchIsJDBCCompliant() {
        return true;
    }

    public static Properties makeSpyProperties(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf(61);
            if (n2 == -1) continue;
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            properties.put(string3, string4);
        }
        return properties;
    }

    public final BaseConnectionProperties getConnectProperties() {
        return this.connectProps;
    }

    public void setHoldability(int n2) throws SQLException {
        int n3 = this.getHoldability();
        if (n3 != n2) {
            throw this.exceptions.getException(6109);
        }
    }

    public int getHoldability() throws SQLException {
        int n2 = this.implConnection.getHoldability();
        if (n2 == -1) {
            n2 = this.getMetaData().getResultSetHoldability();
        }
        return n2;
    }

    public BaseExceptions getExceptions() {
        return this.exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Savepoint setSavepoint() throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("Connection.setSavepoint", null, false);
            this.finalizeTxnMode(false);
            Savepoint savepoint = null;
            if (!this.actualAutoCommitMode) {
                savepoint = this.savepoints.createSavepoint(null);
                try {
                    this.implConnection.setSavepoint(this.savepoints.getName(savepoint));
                }
                catch (SQLException sQLException) {
                    this.savepoints.remove(savepoint, false);
                    throw sQLException;
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
            return savepoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Savepoint setSavepoint(String string) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("Connection.setSavepoint", null, false);
            this.finalizeTxnMode(false);
            Savepoint savepoint = null;
            if (!this.actualAutoCommitMode) {
                savepoint = this.savepoints.get(string);
                if (savepoint != null) {
                    this.implConnection.implicitReleaseSavepoint(string);
                    savepoint = null;
                }
                savepoint = this.savepoints.createSavepoint(string);
                try {
                    this.implConnection.setSavepoint(string);
                }
                catch (SQLException sQLException) {
                    this.savepoints.remove(savepoint, false);
                    throw sQLException;
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
            return savepoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback(Savepoint savepoint) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("Connection.rollback(Savepoint)", savepoint, true);
            if (!this.exposedAutoCommitMode) {
                if (!this.actualAutoCommitMode) {
                    String string = this.savepoints.getName(savepoint);
                    this.savepoints.remove(savepoint, true);
                    this.implConnection.rollbackTransaction(string);
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("releaseSavepoint.rollback", savepoint, true);
            if (!this.exposedAutoCommitMode) {
                if (!this.actualAutoCommitMode) {
                    String string = this.savepoints.getName(savepoint);
                    this.savepoints.remove(savepoint, true);
                    this.implConnection.releaseSavepoint(string);
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
        }
    }

    public Statement createStatement(int n2, int n3, int n4) throws SQLException {
        String[] stringArray = new String[]{"Connection.createStatement"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) throws SQLException {
        String[] stringArray = new String[]{"Connection.prepareStatement"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public CallableStatement prepareCall(String string, int n2, int n3, int n4) throws SQLException {
        String[] stringArray = new String[]{"Connection.prepareCall"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public PreparedStatement prepareStatement(String string, int n2) throws SQLException {
        try {
            if (n2 == 2) {
                PreparedStatement preparedStatement = this.prepareStatement(string);
                return preparedStatement;
            }
            if (n2 != 1) {
                String[] stringArray = new String[]{"Connection.prepareStatement"};
                throw this.exceptions.getException(6069, stringArray);
            }
            if (this.getMetaData().supportsGetGeneratedKeys()) {
                this.autoGeneratedKeysRequested = true;
                PreparedStatement preparedStatement = this.prepareStatement(string);
                return preparedStatement;
            }
            String[] stringArray = new String[]{"Connection.prepareStatement"};
            throw this.exceptions.getException(6003, stringArray);
        }
        finally {
            this.autoGeneratedKeysRequested = false;
        }
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.getMetaData().supportsGetGeneratedKeys() && (this.workarounds & 1) > 0) {
            if (nArray == null) {
                String[] stringArray = new String[]{"Connection.prepareStatement(String, int[])"};
                throw this.exceptions.getException(6069, stringArray);
            }
            if (nArray.length != 1) {
                String[] stringArray = new String[]{"indexes"};
                throw this.exceptions.getException(6118, stringArray);
            }
            return this.prepareStatement(string, 1);
        }
        String[] stringArray = new String[]{"Connection.prepareStatement(String, int[])"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.getMetaData().supportsGetGeneratedKeys() && (this.workarounds & 1) > 0) {
            if (stringArray == null) {
                String[] stringArray2 = new String[]{"Connection.prepareStatement(String, String[])"};
                throw this.exceptions.getException(6069, stringArray2);
            }
            if (stringArray.length != 1) {
                String[] stringArray3 = new String[]{"names"};
                throw this.exceptions.getException(6118, stringArray3);
            }
            return this.prepareStatement(string, 1);
        }
        String[] stringArray4 = new String[]{"Connection.prepareStatement(String, String[])"};
        throw this.exceptions.getException(6003, stringArray4);
    }

    public void prepareForXA() {
        this.isXAConnection = true;
    }

    public synchronized void setClientApplicationName(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientApplicationName"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientApplicationName(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientAppName = string2;
    }

    public synchronized String getClientApplicationName() throws SQLException {
        return this.clientAppName;
    }

    public synchronized void setClientHostName(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientHostName"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientHostName(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientHostName = string2;
    }

    public synchronized String getClientHostName() throws SQLException {
        return this.clientHostName;
    }

    public synchronized void setClientUser(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientUser"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientUser(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientUser = string2;
    }

    public synchronized String getClientUser() throws SQLException {
        return this.clientUser;
    }

    public synchronized void setClientAccountingInfo(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientAccountingInfo"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientAccountingInfo(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientAcctInfo = string2;
    }

    public synchronized String getClientAccountingInfo() throws SQLException {
        return this.clientAcctInfo;
    }

    final void ValidateSupportsTransactions(boolean bl2) throws SQLException {
        if (this.supportsTransactions == -1) {
            int n2 = this.supportsTransactions = this.getMetaData().supportsTransactions() ? 1 : 0;
        }
        if (!bl2 && this.supportsTransactions == 0) {
            throw this.exceptions.getException(6113, "HYC00");
        }
    }
}

