/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.commitments;

import java.security.SecureRandom;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.Commitment;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.Committer;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.Digest;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.ExtendedDigest;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;

public class HashCommitter
implements Committer {
    private final Digest digest;
    private final int byteLength;
    private final SecureRandom random;

    public HashCommitter(ExtendedDigest extendedDigest, SecureRandom secureRandom) {
        this.digest = extendedDigest;
        this.byteLength = extendedDigest.getByteLength();
        this.random = secureRandom;
    }

    @Override
    public Commitment commit(byte[] byArray) {
        if (byArray.length > this.byteLength / 2) {
            throw new DataLengthException("Message to be committed to too large for digest.");
        }
        byte[] byArray2 = new byte[this.byteLength - byArray.length];
        this.random.nextBytes(byArray2);
        return new Commitment(byArray2, this.calculateCommitment(byArray2, byArray));
    }

    @Override
    public boolean isRevealed(Commitment commitment, byte[] byArray) {
        if (byArray.length + commitment.getSecret().length != this.byteLength) {
            throw new DataLengthException("Message and witness secret lengths do not match.");
        }
        byte[] byArray2 = this.calculateCommitment(commitment.getSecret(), byArray);
        return Arrays.constantTimeAreEqual(commitment.getCommitment(), byArray2);
    }

    private byte[] calculateCommitment(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[this.digest.getDigestSize()];
        this.digest.update(byArray, 0, byArray.length);
        this.digest.update(byArray2, 0, byArray2.length);
        this.digest.doFinal(byArray3, 0);
        return byArray3;
    }
}

