/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle;

import java.io.Reader;
import java.sql.SQLException;
import macromedia.jdbc.oracle.OracleColumn;
import macromedia.jdbc.oracle.OracleDataBufferMemory;
import macromedia.jdbc.oracle.OracleDataBufferPaged;
import macromedia.jdbc.oracle.OracleImplConnection;
import macromedia.jdbc.oracle.OracleImplStatement;
import macromedia.jdbc.oracle.OracleUtility;
import macromedia.jdbc.oracle.OracleVNU;
import macromedia.jdbc.oracle.base.BaseExceptions;
import macromedia.jdbc.oracle.base.g;
import macromedia.jdbc.oracle.base.gz;
import macromedia.jdbc.oracle.net8.d;
import macromedia.jdbc.oracle.util.UtilDebug;
import macromedia.jdbc.oracle.util.ak;
import macromedia.jdbc.oracle.util.bf;
import macromedia.jdbc.oracle.util.cl;
import macromedia.jdbc.oracle.util.cn;

public abstract class OracleDataBuffer {
    private static String footprint = "$Revision$";
    static final int dv = 250;
    static final int dw = 65520;
    static final byte dx = 60;
    static final byte dy = 12;
    static final byte dz = 28;
    static final byte dA = 9;
    static final byte dB = 3;
    static final byte dC = 6;
    static final byte dD = 8;
    static final byte dE = 0;
    static final byte dF = 4;
    static int dG = 255;
    static final int dH = -1;
    static final int dI = 100;
    static final int dJ = 200;
    public static final int dK = 300;
    protected OracleColumn[] dL;
    protected OracleImplConnection dM;
    protected BaseExceptions dN;
    protected g dO;
    protected int[] dR;
    protected int dS;
    protected int[][] dT;
    protected int[] dU;
    protected byte[] dV;
    protected int dW;
    protected int dX;
    protected int dY;
    protected int dZ;
    protected byte ea;
    protected BulkAccessor[] eb;

    public static OracleDataBuffer a(OracleImplConnection oracleImplConnection, OracleColumn[] oracleColumnArray, BaseExceptions baseExceptions, g g2, int[] nArray, int n2, int n3) throws SQLException {
        OracleDataBuffer oracleDataBuffer;
        int n4;
        boolean bl2 = false;
        for (n4 = 0; n4 < oracleColumnArray.length; ++n4) {
            if (oracleColumnArray[n4].eG <= 4000) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            n4 = 8192;
            if (n2 != 0 && n2 < n4) {
                n4 = n2;
            }
            oracleDataBuffer = new OracleDataBufferPaged(oracleImplConnection, oracleColumnArray, baseExceptions, g2, nArray, n4, n3);
        } else {
            n4 = oracleImplConnection.hZ * 1024;
            long l2 = OracleImplStatement.a(oracleColumnArray, false, 0);
            int n5 = l2 == 0L ? 1 : (l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2);
            int n6 = n4 / n5;
            if (n6 == 0) {
                n6 = 1;
            }
            if (n2 != 0 && n2 < n6) {
                n6 = n2;
            } else {
                n6 += n6 / 2;
                if (n2 != 0 && n2 < n6) {
                    n6 = n2;
                }
            }
            oracleDataBuffer = new OracleDataBufferMemory(oracleImplConnection, oracleColumnArray, baseExceptions, g2, nArray, n6, n5, n3);
        }
        return oracleDataBuffer;
    }

    protected OracleDataBuffer(OracleImplConnection oracleImplConnection, OracleColumn[] oracleColumnArray, BaseExceptions baseExceptions, g g2, int[] nArray, int n2, int n3) throws SQLException {
        this.dM = oracleImplConnection;
        this.dL = oracleColumnArray;
        this.dO = g2;
        this.dR = nArray;
        this.dN = baseExceptions;
        this.dS = n2;
        this.dW = n3;
        this.dT = new int[this.dL.length][this.dS];
        this.dU = new int[this.dS];
        this.dV = new byte[this.dS];
        this.eb = new BulkAccessor[this.dL.length];
        this.X();
    }

    protected void k(int n2) {
        int n3;
        int n4 = this.dY / this.dS;
        int n5 = n2 / n4;
        n5 += n5 / 10;
        int[][] nArray = new int[this.dL.length][n5];
        for (int i2 = 0; i2 < this.dL.length; ++i2) {
            for (n3 = 0; n3 < this.dS; ++n3) {
                nArray[i2][n3] = this.dT[i2][n3];
            }
        }
        this.dT = nArray;
        int[] nArray2 = new int[n5];
        for (n3 = 0; n3 < this.dS; ++n3) {
            nArray2[n3] = this.dU[n3];
        }
        this.dU = nArray2;
        byte[] byArray = new byte[n5];
        for (int i3 = 0; i3 < this.dS; ++i3) {
            byArray[i3] = this.dV[i3];
        }
        this.dV = byArray;
        this.dS = n5;
    }

    int b(int n2, int n3) {
        return this.dT[n3][n2];
    }

    private byte l(int n2) {
        return this.dV[n2];
    }

    public int S() {
        return this.dX;
    }

    public int T() {
        return this.dZ;
    }

    public int m(int n2) {
        return this.dU[n2];
    }

    public abstract boolean U();

    public void clear() throws ak {
        this.dX = 0;
        this.dY = 0;
        this.dZ = 0;
    }

    public void close() throws ak {
    }

    public void V() throws ak {
        int n2 = this.ea;
        int n3 = 0;
        for (int i2 = 0; i2 < this.dL.length; ++i2) {
            int n4 = this.dT[i2][this.dX];
            if (this.dW != 300) {
                n4 = n4 == -1 ? 2 : (n4 += 2);
            } else if (n4 == -1) {
                n4 = 1;
            } else if (n4 <= 250) {
                ++n4;
            } else {
                UtilDebug.h("not expecting large chunks", n4 <= 65520);
                n4 += 3;
            }
            n3 += n4;
        }
        if (n3 > 65516 && n2 == 60) {
            n2 = 12;
        }
        if (this.dL.length > dG) {
            n2 = 8;
            n3 += this.dL.length / dG * 2;
            if (this.dL.length % dG != 0) {
                n3 += 2;
            }
        } else {
            n3 = n2 != 12 ? (n3 += 4) : (n3 += 2);
        }
        this.dZ += n3;
        this.dU[this.dX] = n3;
        this.dV[this.dX] = n2;
        ++this.dX;
    }

    public abstract void W() throws SQLException;

    public abstract void a(int var1, byte[] var2, int var3, int var4) throws ak;

    public void a(d d2) throws ak {
        int n2 = this.dX;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            int n5;
            int n6;
            int n7;
            nArray2[0] = 0;
            byte by2 = this.l(i2);
            d2.d(by2);
            nArray2[0] = nArray2[0] + 1;
            int n8 = this.dL.length;
            if (by2 == 9) {
                n7 = this.n(i2);
                n6 = this.b(i2, 0);
                n5 = this.a(d2, i2, 1, n7, n6, nArray, nArray2);
                n4 = n7;
                byte[] byArray = new byte[1];
                do {
                    int n9 = this.a(i2, n4, n5, byArray);
                    d2.d(byArray[0]);
                    nArray2[0] = nArray2[0] + 1;
                    n5 = this.a(d2, i2, n4, n9, n5, nArray, nArray2);
                    n4 += n9 - 1;
                } while (byArray[0] == 3);
            } else {
                if (by2 != 12 && by2 != 8) {
                    n7 = this.m(i2);
                    d2.cY(n7);
                    nArray2[0] = nArray2[0] + 2;
                }
                for (n7 = 0; n7 < n8; n7 += n6) {
                    n6 = n8 - n7 > dG ? dG : n8 - n7;
                    if (n7 != 0) {
                        if (n7 + n6 < n8) {
                            d2.d((byte)0);
                        } else {
                            d2.d((byte)4);
                        }
                    }
                    d2.d((byte)n6);
                    nArray2[0] = nArray2[0] + 1;
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.b(i2, n7 + n5);
                        if (this.dW == 300) {
                            if (n4 == -1) {
                                d2.d((byte)-1);
                                nArray2[0] = nArray2[0] + 1;
                                n4 = 0;
                            } else if (n4 <= 250) {
                                d2.d((byte)n4);
                                d2.a(this, nArray[0], n4);
                                nArray2[0] = nArray2[0] + (n4 + 1);
                            } else {
                                d2.d((byte)-2);
                                d2.cY(n4);
                                d2.a(this, nArray[0], n4);
                                nArray2[0] = nArray2[0] + (n4 + 3);
                            }
                        } else if (n4 == -1) {
                            d2.d((byte)-1);
                            d2.d((byte)-1);
                            nArray2[0] = nArray2[0] + 2;
                            n4 = 0;
                        } else {
                            d2.cY(n4);
                            d2.a(this, nArray[0], n4);
                            nArray2[0] = nArray2[0] + (n4 + 2);
                        }
                        nArray[0] = nArray[0] + n4;
                    }
                }
            }
            UtilDebug.h("unexpected row length", nArray2[0] == this.m(i2));
            n3 += nArray2[0];
        }
        UtilDebug.h("unexpected total length", n3 == this.dZ);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int a(d d2, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) throws ak {
        int n6 = n5;
        int n7 = 0;
        int n8 = 0;
        if (d2 != null) {
            d2.d((byte)n4);
        }
        nArray2[0] = nArray2[0] + 1;
        while (true) {
            block19: {
                block20: {
                    ++n8;
                    if (this.dW == 300) break block20;
                    if (n6 == -1) {
                        if (d2 != null) {
                            d2.d((byte)-1);
                            d2.d((byte)-1);
                        }
                        nArray2[0] = nArray2[0] + 2;
                        n6 = 0;
                        break block19;
                    } else if (n6 <= 65520) {
                        if (d2 != null) {
                            d2.cY(n6);
                            d2.a(this, nArray[0], n6);
                        }
                        nArray2[0] = nArray2[0] + (n6 + 2);
                        break block19;
                    } else {
                        UtilDebug.h("unexpected columns written", n8 == n4);
                        if (d2 != null) {
                            d2.cY(65520);
                            d2.a(this, nArray[0], 65520);
                        }
                        nArray2[0] = nArray2[0] + 65522;
                        nArray[0] = nArray[0] + 65520;
                        return n6 - 65520;
                    }
                }
                if (n6 == -1) {
                    if (d2 != null) {
                        d2.d((byte)-1);
                    }
                    nArray2[0] = nArray2[0] + 1;
                    n6 = 0;
                } else if (n6 <= 250) {
                    if (d2 != null) {
                        d2.d((byte)n6);
                        d2.a(this, nArray[0], n6);
                    }
                    nArray2[0] = nArray2[0] + (n6 + 1);
                } else if (n6 <= 65520) {
                    if (d2 != null) {
                        d2.d((byte)-2);
                        d2.cY(n6);
                        d2.a(this, nArray[0], n6);
                    }
                    nArray2[0] = nArray2[0] + (n6 + 3);
                } else {
                    UtilDebug.h("unexpected columns written", n8 == n4);
                    if (d2 != null) {
                        d2.d((byte)-2);
                        d2.cY(65520);
                        d2.a(this, nArray[0], 65520);
                    }
                    nArray2[0] = nArray2[0] + 65523;
                    nArray[0] = nArray[0] + 65520;
                    return n6 - 65520;
                }
            }
            nArray[0] = nArray[0] + n6;
            if (n8 >= n4) return n7;
            n6 = this.b(n2, n3);
            ++n3;
        }
    }

    protected int n(int n2) {
        int n3 = this.dL.length > dG ? dG : this.dL.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.b(n2, i2);
            if (n4 <= 65520) continue;
            return i2 + 1;
        }
        if (n3 != this.dL.length) {
            return n3;
        }
        return Integer.MAX_VALUE;
    }

    protected int a(int n2, int n3, int n4, byte[] byArray) {
        int n5 = 1;
        byArray[0] = 3;
        if (n4 > 65520) {
            return n5;
        }
        for (int i2 = n3; i2 < this.dL.length; ++i2) {
            ++n5;
            int n6 = this.b(n2, i2);
            if (n6 > 65520) {
                return n5;
            }
            if (n5 <= dG) continue;
            return dG;
        }
        byArray[0] = 6;
        return n5;
    }

    private void X() throws SQLException {
        int n2 = this.dO.cY();
        for (int i2 = 0; i2 < this.dL.length; ++i2) {
            int n3 = this.dR[i2];
            OracleColumn oracleColumn = this.dL[i2];
            BulkAccessor bulkAccessor = null;
            if (n3 >= n2) {
                this.eb[i2] = bulkAccessor = new BulkAccessorNullValue();
                continue;
            }
            boolean bl2 = this.dO.dd() == 1;
            int n4 = this.dO.getColumnType(n3);
            switch (oracleColumn.ce) {
                case 8: 
                case 112: {
                    bulkAccessor = new BulkAccessorReaderToCLOB();
                    break;
                }
                case 1: {
                    if (bl2) {
                        bulkAccessor = new BulkAccessorCharsToVarChar();
                        break;
                    }
                    bulkAccessor = new BulkAccessorStringToVarChar();
                    break;
                }
                case 96: {
                    if (bl2) {
                        bulkAccessor = new BulkAccessorCharsToChar();
                        break;
                    }
                    bulkAccessor = new BulkAccessorStringToChar();
                    break;
                }
                case 2: {
                    if (n4 == -7 || n4 == 16) {
                        bulkAccessor = new BulkAccessorIntToVNU();
                        break;
                    }
                    bulkAccessor = new BulkAccessorStringToVNU();
                    break;
                }
                case 12: {
                    bulkAccessor = new BulkAccessorTimestampToORADate();
                    break;
                }
                case 180: {
                    bulkAccessor = new BulkAccessorTimestampToORATimestamp();
                    break;
                }
                case 181: {
                    if (n4 == 93) {
                        bulkAccessor = new BulkAccessorTimestampToORATimestampTZ();
                        break;
                    }
                    bulkAccessor = new BulkAccessorStringToORATimestampTZ();
                    break;
                }
                case 231: {
                    bulkAccessor = new BulkAccessorTimestampToORATimestampLTZ();
                    break;
                }
                case 100: {
                    bulkAccessor = new BulkAccessorFloatToBinaryFloat();
                    break;
                }
                case 101: {
                    bulkAccessor = new BulkAccessorDoubleToBinaryDouble();
                    break;
                }
                case 24: 
                case 113: {
                    bulkAccessor = new BulkAccessorBytesToBLOB();
                    break;
                }
                case 23: {
                    bulkAccessor = new BulkAccessorBytesToRaw();
                    break;
                }
                default: {
                    throw this.dN.bm(6024);
                }
            }
            bulkAccessor.ec = oracleColumn;
            bulkAccessor.dM = this.dM;
            bulkAccessor.ed = n3;
            bulkAccessor.dN = this.dN;
            bulkAccessor.initialize(this.dW);
            this.eb[i2] = bulkAccessor;
        }
    }

    private class BulkAccessorBytesToBLOB
    extends BulkAccessor {
        final int ef = 65536;

        private BulkAccessorBytesToBLOB() {
            this.ef = 65536;
        }

        @Override
        int b(byte[] byArray, int n2) throws SQLException {
            throw this.dN.bm(6024);
        }

        @Override
        int a(bf bf2, int n2) throws ak, SQLException {
            byte[] byArray = this.dM.q(65536);
            int n3 = 0;
            try {
                int n4;
                do {
                    if ((n4 = (int)OracleDataBuffer.this.dO.a(this.ed, (long)n3, byArray, 0, 65536)) == 0) continue;
                    bf2.c((long)(n2 + n3), byArray, 0, n4);
                    n3 += n4;
                } while (n4 == 65536);
            }
            catch (Exception exception) {
                throw this.dN.b(exception);
            }
            return n3;
        }
    }

    private class BulkAccessorBytesToRaw
    extends BulkAccessor {
        private BulkAccessorBytesToRaw() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            return (int)OracleDataBuffer.this.dO.a(this.ed, 0L, byArray, n2, this.ec.cg);
        }

        @Override
        int ad() {
            return this.ec.cg;
        }
    }

    private class BulkAccessorTimestampToORATimestampLTZ
    extends BulkAccessor {
        private BulkAccessorTimestampToORATimestampLTZ() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            gz gz2 = OracleDataBuffer.this.dO.S(this.ed);
            gz gz3 = this.dM.a(gz2);
            int n3 = OracleUtility.a(gz3, byArray, n2);
            return n3 + OracleUtility.a(gz3.oO(), byArray, n2 + n3);
        }
    }

    private class BulkAccessorTimestampToORATimestampTZ
    extends BulkAccessor {
        private BulkAccessorTimestampToORATimestampTZ() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            gz gz2 = OracleDataBuffer.this.dO.S(this.ed);
            gz gz3 = this.dM.b(gz2);
            int n3 = OracleUtility.a(gz3, byArray, n2);
            n3 += OracleUtility.a(gz3.oO(), byArray, n2 + n3);
            byArray[n2 + n3++] = (byte)(20 - this.dM.bc());
            byArray[n2 + n3++] = (byte)(60 - this.dM.bd());
            return n3;
        }
    }

    private class BulkAccessorStringToORATimestampTZ
    extends BulkAccessor {
        private BulkAccessorStringToORATimestampTZ() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            String string = OracleDataBuffer.this.dO.getString(this.ed);
            int[] nArray = new int[2];
            gz gz2 = this.dM.a(string, nArray);
            int n3 = OracleUtility.a(gz2, byArray, n2);
            n3 += OracleUtility.a(gz2.oO(), byArray, n2 + n3);
            byArray[n2 + n3++] = (byte)(20 + nArray[0]);
            byArray[n2 + n3++] = (byte)(60 + nArray[1]);
            return n3;
        }
    }

    private class BulkAccessorTimestampToORATimestamp
    extends BulkAccessor {
        private BulkAccessorTimestampToORATimestamp() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            gz gz2 = OracleDataBuffer.this.dO.S(this.ed);
            int n3 = OracleUtility.a(gz2, byArray, n2);
            return n3 + OracleUtility.a(gz2.oO(), byArray, n2 + n3);
        }
    }

    private class BulkAccessorTimestampToORADate
    extends BulkAccessor {
        private BulkAccessorTimestampToORADate() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            gz gz2 = OracleDataBuffer.this.dO.S(this.ed);
            return OracleUtility.a(gz2, byArray, n2);
        }
    }

    private class BulkAccessorDoubleToBinaryDouble
    extends BulkAccessor {
        private BulkAccessorDoubleToBinaryDouble() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            double d2 = OracleDataBuffer.this.dO.getDouble(this.ed);
            return OracleUtility.a(d2, byArray, n2);
        }
    }

    private class BulkAccessorFloatToBinaryFloat
    extends BulkAccessor {
        private BulkAccessorFloatToBinaryFloat() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            float f2 = OracleDataBuffer.this.dO.getFloat(this.ed);
            return OracleUtility.a(f2, byArray, n2);
        }
    }

    private class BulkAccessorIntToVNU
    extends BulkAccessor {
        private BulkAccessorIntToVNU() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            int n3 = OracleDataBuffer.this.dO.R(this.ed);
            return OracleVNU.e(byArray, n2, n3);
        }
    }

    private class BulkAccessorStringToVNU
    extends BulkAccessor {
        private BulkAccessorStringToVNU() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            String string = OracleDataBuffer.this.dO.getString(this.ed);
            return OracleVNU.a(byArray, n2, string, this.dM, this.dN);
        }
    }

    private class BulkAccessorReaderToCLOB
    extends BulkAccessorChars {
        final int ef = 65536;
        cl ei;
        int ej;

        private BulkAccessorReaderToCLOB() {
            this.ef = 65536;
        }

        @Override
        void initialize(int n2) {
            this.ei = this.ec.er;
            if (this.ec.ce == 112 && this.dM.hB > 1 && this.ec.cj != 2) {
                this.ei = new cn();
                if (n2 >= 300 || this.dM.aP()) {
                    ((cn)this.ei).tn();
                } else {
                    ((cn)this.ei).to();
                }
            }
            this.ej = this.ec.er.cR();
        }

        @Override
        int b(byte[] byArray, int n2) throws SQLException {
            throw this.dN.bm(6024);
        }

        @Override
        int a(bf bf2, int n2) throws ak, SQLException {
            if (OracleDataBuffer.this.dO.V(this.ed)) {
                byte[] byArray = this.dM.q(65536);
                int n3 = 0;
                try {
                    int n4;
                    do {
                        if ((n4 = (int)OracleDataBuffer.this.dO.b(this.ed, n3, byArray, 0, 65536)) == 0) continue;
                        bf2.c((long)(n2 + n3), byArray, 0, n4);
                        n3 += n4;
                    } while (n4 == 65536);
                }
                catch (Exception exception) {
                    throw this.dN.b(exception);
                }
                return n3;
            }
            int n5 = 0;
            char[] cArray = this.dM.r(65536);
            byte[] byArray = this.dM.q(cArray.length * this.ej);
            int n6 = 0;
            Reader reader = OracleDataBuffer.this.dO.U(this.ed);
            try {
                int n7 = reader.read(cArray);
                while (n7 > 0) {
                    int n8 = this.ei.b(cArray, 0, n7, byArray, 0);
                    bf2.c((long)(n2 + n6), byArray, 0, n8);
                    n5 += n7;
                    n6 += n8;
                    n7 = reader.read(cArray);
                }
            }
            catch (Exception exception) {
                throw this.dN.b(exception);
            }
            return n6;
        }
    }

    private class BulkAccessorCharsToVarChar
    extends BulkAccessorChars {
        private BulkAccessorCharsToVarChar() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            if (OracleDataBuffer.this.dO.V(this.ed)) {
                return (int)OracleDataBuffer.this.dO.b(this.ed, 0L, byArray, n2, this.ec.cg);
            }
            int n3 = (int)OracleDataBuffer.this.dO.a(this.ed, 0L, this.eh, 0, this.eg);
            if (n3 > this.eg) {
                n3 = this.eg;
            }
            return this.ec.er.b(this.eh, 0, n3, byArray, n2);
        }

        @Override
        int ad() {
            return this.ec.cg;
        }
    }

    private class BulkAccessorCharsToChar
    extends BulkAccessorChars {
        private BulkAccessorCharsToChar() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            if (OracleDataBuffer.this.dO.V(this.ed)) {
                long l2 = OracleDataBuffer.this.dO.b(this.ed, 0L, byArray, n2, this.ec.cg);
                if (l2 != (long)this.eg) {
                    if (l2 > (long)this.eg) {
                        l2 = this.eg;
                    } else {
                        for (long i2 = l2; i2 < (long)this.eg; ++i2) {
                            byArray[n2 + (int)i2] = 32;
                        }
                    }
                }
                return this.eg;
            }
            long l3 = OracleDataBuffer.this.dO.a(this.ed, 0L, this.eh, 0, this.eg);
            if (l3 != (long)this.eg) {
                if (l3 > (long)this.eg) {
                    l3 = this.eg;
                } else {
                    for (long i3 = l3; i3 < (long)this.eg; ++i3) {
                        this.eh[(int)i3] = 32;
                    }
                }
            }
            return this.ec.er.b(this.eh, 0, this.eg, byArray, n2);
        }
    }

    private class BulkAccessorStringToVarChar
    extends BulkAccessorString {
        private BulkAccessorStringToVarChar() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            String string = OracleDataBuffer.this.dO.getString(this.ed);
            int n3 = string.length();
            if (string.length() > this.eg) {
                n3 = this.eg;
            }
            return this.ec.er.b(string, byArray, n2);
        }

        @Override
        int ad() {
            return this.ec.cg;
        }
    }

    private class BulkAccessorStringToChar
    extends BulkAccessorString {
        private BulkAccessorStringToChar() {
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            String string = OracleDataBuffer.this.dO.getString(this.ed);
            int n3 = string.length();
            int n4 = this.ec.er.b(string, byArray, n2);
            int n5 = this.ek.length * Math.min(this.ec.su - n3, (this.eg - n4) / this.ek.length);
            for (int i2 = 0; i2 < n5; ++i2) {
                byArray[n2 + n4 + i2] = this.ek[i2 % this.ek.length];
            }
            return n4 + n5;
        }
    }

    private class BulkAccessorNullValue
    extends BulkAccessor {
        private BulkAccessorNullValue() {
        }

        @Override
        boolean ac() throws SQLException {
            return true;
        }

        @Override
        int b(byte[] byArray, int n2) throws ak, SQLException {
            return 0;
        }
    }

    private abstract class BulkAccessorChars
    extends BulkAccessor {
        protected int eg;
        char[] eh;

        private BulkAccessorChars() {
        }

        @Override
        void initialize(int n2) {
            this.eg = this.ec.cg;
            this.eh = new char[this.eg];
        }
    }

    private abstract class BulkAccessorString
    extends BulkAccessor {
        protected int eg;
        protected byte[] ek;

        private BulkAccessorString() {
        }

        @Override
        void initialize(int n2) {
            this.eg = this.ec.cg;
            try {
                this.ek = this.ec.er.dk(" ");
            }
            catch (ak ak2) {
                this.ek = new byte[]{32};
            }
        }
    }

    abstract class BulkAccessor {
        protected OracleColumn ec;
        protected int ed;
        protected OracleImplConnection dM;
        protected BaseExceptions dN;

        BulkAccessor() {
        }

        private OracleImplConnection Y() {
            return this.dM;
        }

        private void a(OracleImplConnection oracleImplConnection) {
            this.dM = oracleImplConnection;
        }

        private g Z() {
            return OracleDataBuffer.this.dO;
        }

        private void a(g g2) {
            OracleDataBuffer.this.dO = g2;
        }

        private OracleColumn aa() {
            return this.ec;
        }

        private void a(OracleColumn oracleColumn) {
            this.ec = oracleColumn;
        }

        private int ab() {
            return this.ed;
        }

        private void o(int n2) {
            this.ed = n2;
        }

        abstract int b(byte[] var1, int var2) throws ak, SQLException;

        boolean ac() throws SQLException {
            return OracleDataBuffer.this.dO.isNull(this.ed);
        }

        int a(bf bf2, int n2) throws ak, SQLException {
            int n3 = this.ad();
            byte[] byArray = this.dM.q(n3);
            int n4 = this.b(byArray, 0);
            bf2.c((long)n2, byArray, 0, n4);
            return n4;
        }

        int ad() {
            return 4000;
        }

        void initialize(int n2) {
        }
    }
}

