/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc.module;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoException;
import coldfusion.security.ESAPIUtils;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.xml.rpc.ArrayDelegate;
import coldfusion.xml.rpc.DocumentDelegate;
import coldfusion.xml.rpc.InvalidWSDLStyleException;
import coldfusion.xml.rpc.QueryBean;
import coldfusion.xml.rpc.StructDelegate;
import coldfusion.xml.rpc.WebServiceUtil;
import coldfusion.xml.rpc.module.CFDeploymentFileData;
import coldfusion.xml.rpc.module.CFRPCMessageReceiver;
import coldfusion.xml.rpc.module.ParserUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.classloader.MultiParentClassLoader;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.POJODeployer;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.axis2.description.java2wsdl.DocLitBareSchemaGenerator;
import org.apache.axis2.description.java2wsdl.SchemaGenerator;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jsr181.JSR181Helper;
import org.apache.axis2.jsr181.WebMethodAnnotation;
import org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CFCDeployer
extends POJODeployer {
    private ConfigurationContext configCtx;

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        CFDeploymentFileData data = (CFDeploymentFileData)deploymentFileData;
        HttpServletRequest req = data.getReq();
        try {
            String serviceName = WebServiceUtil.getServiceName((String)req.getRequestURL().toString());
            Object serviceObject = data.getServiceObject();
            ClassLoader bootstrapClassloader = this.configCtx.getAxisConfiguration().getSystemClassLoader();
            ClassLoader skeletonClassLoader = serviceObject.getClass().getClassLoader();
            ClassLoader classLoader = this.getClassLoader(bootstrapClassloader, skeletonClassLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
            String className = serviceObject.getClass().getName();
            CFLogs.WEBSERVICE_LOG.info((Object)RB.getString((Object)((Object)this), (String)"CFCDeployer.deployingCFC", (Object)req.getRequestURL().toString()));
            AttributeCollection metadata = (AttributeCollection)req.getAttribute("cfcMetadata");
            AxisService axisService = this.createAxisServiceUsingAnnogen(className, classLoader, ((CFDeploymentFileData)deploymentFileData).getServiceObject(), serviceName, metadata, req);
            this.configCtx.getAxisConfiguration().addService(axisService);
        }
        catch (Throwable t) {
            CFLogs.WEBSERVICE_LOG.error((Object)RB.getString((Object)((Object)this), (String)"CFCDeployer.faultyService", (Object)req.getRequestURL().toString()), t);
            this.storeFaultyService(req, t);
        }
        finally {
            if (threadClassLoader != null) {
                Thread.currentThread().setContextClassLoader(threadClassLoader);
            }
        }
    }

    private ClassLoader getClassLoader(final ClassLoader bootStrapClassLoader, final ClassLoader skeletonClassLoader) throws DeploymentException {
        final URL[] urllist = new URL[]{};
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new MultiParentClassLoader(urllist, new ClassLoader[]{bootStrapClassLoader, skeletonClassLoader});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void storeFaultyService(HttpServletRequest req, Throwable t) {
        StringWriter errorWriter = new StringWriter();
        PrintWriter ptintWriter = new PrintWriter(errorWriter);
        t.printStackTrace(ptintWriter);
        String error = "Error:\n" + errorWriter.toString();
        this.configCtx.getAxisConfiguration().getFaultyServices().put(req.getRequestURL().toString(), error);
        Parameter cfcFaults = this.configCtx.getAxisConfiguration().getParameter("cfcFaults");
        if (null == cfcFaults) {
            Class<CFCDeployer> clazz = CFCDeployer.class;
            // MONITORENTER : coldfusion.xml.rpc.module.CFCDeployer.class
            cfcFaults = this.configCtx.getAxisConfiguration().getParameter("cfcFaults");
            if (null == cfcFaults) {
                cfcFaults = new Parameter();
                cfcFaults.setName("cfcFaults");
                cfcFaults.setValue(new ConcurrentHashMap());
                try {
                    this.configCtx.getAxisConfiguration().addParameter(cfcFaults);
                }
                catch (AxisFault axisFault) {
                    // empty catch block
                }
            }
            // MONITOREXIT : clazz
        }
        Map cfcFaultMap = (Map)cfcFaults.getValue();
        String message = t.getMessage();
        if (t instanceof NeoException && ((NeoException)t).getDetail() != null) {
            message = message + ((NeoException)t).getDetail();
        }
        try {
            message = ESAPIUtils.encodeForHTML((String)message, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cfcFaultMap.put(WebServiceUtil.getServiceName((String)req.getRequestURL().toString()), message);
    }

    private AxisService createAxisServiceUsingAnnogen(String className, ClassLoader classLoader, Object serviceObject, String serviceName, AttributeCollection metadata, HttpServletRequest req) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, IOException, WSDLException {
        Object schemaGenerator;
        boolean bIncludeCFTypes;
        String wsdlFilePath;
        String portTypeName;
        String bindingName;
        String portName;
        String hint;
        String style;
        Map wssettings;
        Map appSettings;
        HashMap<String, MessageReceiver> messageReciverMap = new HashMap<String, MessageReceiver>();
        RPCInOnlyMessageReceiver messageReceiver = new RPCInOnlyMessageReceiver();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-only", (MessageReceiver)messageReceiver);
        CFRPCMessageReceiver inOutmessageReceiver = new CFRPCMessageReceiver();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-out", (MessageReceiver)inOutmessageReceiver);
        messageReciverMap.put("http://www.w3.org/ns/wsdl/robust-in-only", (MessageReceiver)inOutmessageReceiver);
        AxisConfiguration axisConfiguration = this.configCtx.getAxisConfiguration();
        ArrayList excludeOpeartion = new ArrayList();
        AxisService service = new AxisService();
        service.setParent((AxisDescription)axisConfiguration);
        service.setName(serviceName);
        String includeCFTypes = null;
        String appLevelStyle = null;
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope((String)FusionContext.getCurrent().getApplicationName());
        if (appScope != null && (appSettings = appScope.getApplicationSettingsMap()) != null && null != (wssettings = (Map)appSettings.get("wssettings"))) {
            includeCFTypes = (String)wssettings.get("includeCFTypesInWsdl");
            appLevelStyle = (String)wssettings.get("style");
        }
        if (null == includeCFTypes) {
            includeCFTypes = "true";
        }
        if (null == (style = (String)metadata.get((Object)"style"))) {
            style = appLevelStyle;
        }
        this.validateStyleAttribute(style, req);
        if (style != null && style.equalsIgnoreCase("document")) {
            Parameter styleParameter = new Parameter("doclitBare", (Object)"true");
            service.addParameter(styleParameter);
        }
        if (null != (hint = (String)metadata.get((Object)"hint")) && hint.trim().length() > 0) {
            service.setDocumentation(hint);
        }
        if (null != (portName = (String)metadata.get((Object)"serviceportname")) && portName.trim().length() > 0) {
            if (portName.startsWith("{")) {
                String[] portNameValuePairs;
                for (String portNameValuePair : portNameValuePairs = portName.substring(1, portName.length() - 1).split(",")) {
                    String[] split = portNameValuePair.split("=");
                    if (split.length != 2) continue;
                    String portType = split[0].trim();
                    String portname = split[1].trim();
                    if (!"SOAP11EndPoint".equalsIgnoreCase(portType) && !"SOAP12EndPoint".equalsIgnoreCase(portType)) continue;
                    service.addParameter(new Parameter(portType, (Object)portname));
                }
            } else {
                service.addParameter(new Parameter("CommonEndPointName", (Object)portName));
            }
        }
        if (null != (bindingName = (String)metadata.get((Object)"bindingname")) && bindingName.trim().length() > 0) {
            if (bindingName.startsWith("{")) {
                String[] bindingNameValuePairs;
                for (String bindingNameValuePair : bindingNameValuePairs = bindingName.substring(1, bindingName.length() - 1).split(",")) {
                    String[] split = bindingNameValuePair.split("=");
                    if (split.length != 2) continue;
                    String bindingType = split[0].trim();
                    String bindingname = split[1].trim();
                    if ("SOAP11BindingName".equalsIgnoreCase(bindingType)) {
                        service.addParameter(new Parameter("soap11BindingName", (Object)bindingname));
                        continue;
                    }
                    if (!"SOAP12BindingName".equalsIgnoreCase(bindingType)) continue;
                    service.addParameter(new Parameter("soap12BindingName", (Object)bindingname));
                }
            } else {
                service.addParameter(new Parameter("soap11BindingName", (Object)(bindingName + "Soap11Binding")));
                service.addParameter(new Parameter("soap12BindingName", (Object)(bindingName + "Soap12Binding")));
            }
        }
        if (null != (portTypeName = (String)metadata.get((Object)"porttypename")) && portTypeName.trim().length() > 0) {
            service.addParameter(new Parameter("PortTypeName", (Object)portTypeName));
        }
        if (null != (wsdlFilePath = (String)metadata.get((Object)"wsdlfile")) && wsdlFilePath.trim().length() > 0) {
            Parameter useOriginalWSDLParam = new Parameter("useOriginalwsdl", (Object)"true");
            service.addParameter(useOriginalWSDLParam);
            Parameter wsdlDefinition = new Parameter("wsdl4jDefinition", (Object)this.getWSDLDefinition(wsdlFilePath, req));
            service.addParameter(wsdlDefinition);
        }
        StringBuffer cfcClassNames = new StringBuffer();
        if (null != includeCFTypes && 0 != includeCFTypes.trim().length() && (bIncludeCFTypes = Cast._boolean((String)includeCFTypes))) {
            cfcClassNames.append(StructDelegate.class.getName());
            cfcClassNames.append(",");
            cfcClassNames.append(QueryBean.class.getName());
            cfcClassNames.append(",");
            cfcClassNames.append(DocumentDelegate.class.getName());
            cfcClassNames.append(",");
            cfcClassNames.append(ArrayDelegate.class.getName());
        }
        if (cfcClassNames.length() > 0) {
            Parameter extraCFCsParam = new Parameter();
            extraCFCsParam.setName("extraClass");
            extraCFCsParam.setValue((Object)cfcClassNames.toString());
            service.addParameter(extraCFCsParam);
        }
        String namespace = (String)metadata.get((Object)"namespace");
        try {
            Parameter generateBare = service.getParameter("doclitBare");
            schemaGenerator = generateBare != null && "true".equals(generateBare.getValue()) ? new DocLitBareSchemaGenerator(classLoader, className, namespace, "ns", service) : new DefaultSchemaGenerator(classLoader, className, namespace, "ns", service);
            schemaGenerator.setElementFormDefault("qualified");
            org.apache.axis2.deployment.util.Utils.addExcludeMethods(excludeOpeartion);
            schemaGenerator.setExcludeMethods(excludeOpeartion);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        Parameter disableRestParam = new Parameter();
        disableRestParam.setName("disableREST");
        disableRestParam.setValue((Object)true);
        service.addParameter(disableRestParam);
        AxisService axisService = this.createService(className, serviceName, axisConfiguration, messageReciverMap, null, classLoader, (SchemaGenerator)schemaGenerator, service);
        axisService.addParameter("ServiceObjectSupplier", (Object)"coldfusion.xml.rpc.module.CFServiceObjectSupplier");
        axisService.addParameter("serviceObject", serviceObject);
        return axisService;
    }

    private AxisService createService(String implClass, String serviceName, AxisConfiguration axisConfiguration, Map<String, MessageReceiver> messageReceiverClassMap, String targetNamespace, ClassLoader loader, SchemaGenerator schemaGenerator, AxisService axisService) throws AxisFault {
        Parameter parameter = new Parameter("ServiceClass", (Object)implClass);
        OMElement paraElement = org.apache.axis2.deployment.util.Utils.getParameter((String)"ServiceClass", (String)implClass, (boolean)false);
        parameter.setParameterElement(paraElement);
        axisService.setUseDefaultChains(false);
        axisService.addParameter(parameter);
        axisService.setName(serviceName);
        axisService.setClassLoader(loader);
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNamespaceMap(map);
        org.apache.axis2.deployment.util.Utils.processBeanPropertyExclude((AxisService)axisService);
        try {
            axisService.addSchema(schemaGenerator.generateSchema());
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        axisService.setSchemaTargetNamespace(schemaGenerator.getSchemaTargetNameSpace());
        axisService.setTypeTable(schemaGenerator.getTypeTable());
        if (targetNamespace == null) {
            targetNamespace = schemaGenerator.getSchemaTargetNameSpace();
        }
        if (targetNamespace != null && !"".equals(targetNamespace)) {
            axisService.setTargetNamespace(targetNamespace);
        }
        Method[] method = schemaGenerator.getMethods();
        PhasesInfo pinfo = axisConfiguration.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            MessageReceiver mr;
            Method jmethod = method[i];
            String methodName = jmethod.getName();
            WebMethodAnnotation methodAnnon = JSR181Helper.INSTANCE.getWebMethodAnnotation(jmethod);
            if (methodAnnon != null && methodAnnon.getOperationName() != null) {
                methodName = methodAnnon.getOperationName();
            }
            AxisOperation operation = axisService.getOperation(new QName(methodName));
            String mep = operation.getMessageExchangePattern();
            if (messageReceiverClassMap != null) {
                if (messageReceiverClassMap.get(mep) != null) {
                    MessageReceiver obj = messageReceiverClassMap.get(mep);
                    if (obj instanceof MessageReceiver) {
                        mr = obj;
                        operation.setMessageReceiver(mr);
                    } else {
                        CFLogs.WEBSERVICE_LOG.error((Object)"Object is not an instance of MessageReceiver, thus, default MessageReceiver has been set");
                        mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                        operation.setMessageReceiver(mr);
                    }
                } else {
                    CFLogs.WEBSERVICE_LOG.error((Object)"Required MessageReceiver couldn't be found, thus, default MessageReceiver has been used");
                    mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                    operation.setMessageReceiver(mr);
                }
            } else {
                CFLogs.WEBSERVICE_LOG.error((Object)"MessageRecevierClassMap couldn't be found, thus, default MessageReceiver has been used");
                mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                operation.setMessageReceiver(mr);
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
        }
        String endpointName = axisService.getEndpointName();
        if ((endpointName == null || endpointName.length() == 0) && axisService.getAxisConfiguration() != null) {
            org.apache.axis2.deployment.util.Utils.addEndpointsToService((AxisService)axisService, (AxisConfiguration)axisService.getAxisConfiguration());
        }
        return axisService;
    }

    private Definition getWSDLDefinition(String wsdlFilePath, HttpServletRequest req) throws ParserConfigurationException, SAXException, IOException, WSDLException {
        File wsdlFile = new File(wsdlFilePath);
        if (!wsdlFile.exists()) {
            String realPath = FusionContext.getCurrent().getServletContext().getRealPath(Utils.getServletPath((HttpServletRequest)req));
            String dir = new File(realPath).getParent();
            wsdlFile = new File(dir + File.separator + wsdlFilePath);
        }
        DocumentBuilderFactory factory = ParserUtils.createSecureDocumentBuilderFactory();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        Document wsdlDocument = documentBuilder.parse(wsdlFile);
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.importDocuments", true);
        return reader.readWSDL(null, wsdlDocument);
    }

    private void validateStyleAttribute(String style, HttpServletRequest request) {
        if (null != style && !(style.equalsIgnoreCase("document") || style.equalsIgnoreCase("wrapped"))) {
            throw new InvalidWSDLStyleException(style, Utils.getServletPath((HttpServletRequest)request), "document, wrapped");
        }
    }
}

