/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.ftp;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.io.FileUtils;
import coldfusion.tagext.net.FtpInterface;
import coldfusion.tagext.net.FtpTag;
import coldfusion.tagext.net.ftp.FTPClientWrapper;
import coldfusion.tagext.net.ftp.FtpTagTableMetaData;
import coldfusion.util.DateUtils;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.jsp.PageContext;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.apache.commons.net.io.CopyStreamException;

public class FtpHandler
implements FtpInterface {
    private FtpTag ftpTag;
    private PageContext pageContext = null;
    private FTPClientWrapper mConnection;

    public FtpHandler(FtpTag ftptagObj, PageContext pageContextObj) {
        this.ftpTag = ftptagObj;
        this.pageContext = pageContextObj;
    }

    public void createConnection() {
        this.mConnection = this.getConnection();
        if (this.mConnection.isConnected()) {
            this.setConnectionProperty(this.mConnection);
        }
    }

    public void closeConnection() {
        try {
            if (this.mConnection != null) {
                this.close(this.mConnection);
            }
        }
        catch (IOException se) {
            this.checkError((RuntimeException)((Object)new FtpOperationException("CLOSE", se)));
        }
    }

    public void setConnectionResult() {
        if (this.mConnection.isConnected()) {
            this.setFtpTagResult(true, this.mConnection);
        }
    }

    private void setFtpTagResult(boolean success, FTPClient conn) {
        Struct r = new Struct();
        String ErrorText = conn.getReplyString();
        if (ErrorText == null) {
            ErrorText = "";
        }
        r.put((Object)"Succeeded", (Object)(success ? Boolean.TRUE : Boolean.FALSE));
        r.put((Object)"ReturnValue", (Object)ErrorText);
        r.put((Object)"ErrorCode", (Object)new Integer(conn.getReplyCode()));
        r.put((Object)"ErrorText", (Object)ErrorText);
        this.pageContext.setAttribute(this.ftpTag.getResult(), (Object)r);
    }

    private void setFtpTagResult(boolean success, FTPClient conn, String ReturnValue) {
        Struct r = new Struct();
        String ErrorText = conn.getReplyString();
        if (ErrorText == null) {
            ErrorText = "";
        }
        r.put((Object)"Succeeded", (Object)(success ? Boolean.TRUE : Boolean.FALSE));
        r.put((Object)"ReturnValue", (Object)ReturnValue);
        r.put((Object)"ErrorCode", (Object)new Integer(conn.getReplyCode()));
        r.put((Object)"ErrorText", (Object)ErrorText);
        this.pageContext.setAttribute(this.ftpTag.getResult(), (Object)r);
    }

    private void setFtpTagResult(boolean success, FTPClient conn, boolean rc) {
        Struct r = new Struct();
        String ErrorText = conn.getReplyString();
        if (ErrorText == null) {
            ErrorText = "";
        }
        r.put((Object)"Succeeded", (Object)(success ? Boolean.TRUE : Boolean.FALSE));
        r.put((Object)"ReturnValue", (Object)(rc ? Boolean.TRUE : Boolean.FALSE));
        r.put((Object)"ErrorCode", (Object)new Integer(conn.getReplyCode()));
        r.put((Object)"ErrorText", (Object)ErrorText);
        this.pageContext.setAttribute(this.ftpTag.getResult(), (Object)r);
    }

    private void setFtpTagResult(boolean success, Throwable e) {
        Struct r = new Struct();
        r.put((Object)"Succeeded", (Object)(success ? Boolean.TRUE : Boolean.FALSE));
        r.put((Object)"ReturnValue", (Object)(success ? Boolean.TRUE : Boolean.FALSE));
        r.put((Object)"ErrorCode", (Object)(success ? new Integer(0) : new Integer(-1)));
        if (e.getLocalizedMessage() != null && e.getLocalizedMessage().length() > 0) {
            r.put((Object)"ErrorText", (Object)e.getLocalizedMessage());
        } else {
            r.put((Object)"ErrorText", (Object)e.toString());
        }
        this.pageContext.setAttribute(this.ftpTag.getResult(), (Object)r);
    }

    private void setFtpTagResult(boolean success, int code, String str) {
        Struct r = new Struct();
        r.put((Object)"Succeeded", (Object)(success ? Boolean.TRUE : Boolean.FALSE));
        r.put((Object)"ReturnValue", (Object)(Integer.toString(code) + " " + str));
        r.put((Object)"ErrorCode", (Object)new Integer(code));
        r.put((Object)"ErrorText", (Object)str);
        this.pageContext.setAttribute(this.ftpTag.getResult(), (Object)r);
    }

    public void checkError(RuntimeException ex) {
        if (this.ftpTag.isStoponerror()) {
            throw ex;
        }
        this.setFtpTagResult(false, ex);
    }

    public void checkError(String action, IOException ex) {
        this.checkError((RuntimeException)((Object)new FtpOperationException(action, ex)));
    }

    private void checkError(int FtpStatusCode, String FtpStatusString) {
        if (this.ftpTag.isStoponerror()) {
            throw new FtpOperationException(this.ftpTag.getAction(), FtpStatusString);
        }
        this.setFtpTagResult(false, FtpStatusCode, FtpStatusString);
    }

    private FTPClientWrapper getConnection() {
        FTPClientWrapper conn = null;
        String mConnectionName = this.ftpTag.getConnection();
        if (mConnectionName != null && "".equals(mConnectionName)) {
            throw new FtpInvalidConnectionException(mConnectionName);
        }
        String systemType = null;
        String fileNameEncoding = null;
        if (mConnectionName != null) {
            Object o = null;
            try {
                o = this.pageContext.findAttribute(mConnectionName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (o instanceof FTPClient) {
                conn = (FTPClientWrapper)((Object)o);
            } else if (o != null && !"Open".equalsIgnoreCase(this.ftpTag.getAction())) {
                throw new FtpInvalidConnectionException(mConnectionName);
            }
            if (conn != null && !conn.isConnected()) {
                try {
                    this.pageContext.removeAttribute(mConnectionName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                systemType = conn.getsystemType();
                fileNameEncoding = conn.getFileNameEncoding();
                conn = null;
            }
            if (conn == null && (this.ftpTag.getServer() == null || this.ftpTag.getUsername() == null || this.ftpTag.getPassword() == null)) {
                throw new FtpInvalidConnectionException(mConnectionName);
            }
        }
        if (conn == null) {
            if (this.ftpTag.getProxyserver() != null) {
                Properties prop = System.getProperties();
                prop.put("ftpProxySet", "true");
                prop.put("ftp.proxyHost", this.ftpTag.getProxyserver());
                prop.put("ftp.proxyPort", Integer.toString(this.ftpTag.getPort()));
            }
            conn = new FTPClientWrapper(systemType == null ? this.ftpTag.getSystemType() : systemType, fileNameEncoding == null ? this.ftpTag.getFileNameEncoding() : fileNameEncoding);
            if (this.ftpTag.isDebug()) {
                conn.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out)));
            }
            IOException lastException = null;
            try {
                conn.setDefaultTimeout((int)this.ftpTag.getTimeout());
                conn.setStrictReplyParsing(false);
                conn.connect(this.ftpTag.getServer(), this.ftpTag.getPort());
                int reply = conn.getReplyCode();
                String replystring = conn.getReplyString();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    conn.disconnect();
                    if (this.ftpTag.isStoponerror()) {
                        throw new FtpConnectionException(new Exception(replystring));
                    }
                    this.setFtpTagResult(false, reply, replystring);
                }
            }
            catch (IOException e) {
                lastException = e;
                if (conn.isConnected()) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException replystring) {
                        // empty catch block
                    }
                }
                FtpConnectionException fe = new FtpConnectionException(e);
                this.checkError((RuntimeException)((Object)fe));
            }
            if (lastException == null) {
                try {
                    int retries = this.ftpTag.getRetrycount();
                    while (retries-- > 0 && !conn.login(this.ftpTag.getUsername(), this.ftpTag.getPassword())) {
                        String tempReplyStr = conn.getReplyString();
                        int tempReplyCode = conn.getReplyCode();
                        conn.logout();
                        if (this.ftpTag.isStoponerror()) {
                            throw new FtpConnectionException(new Exception(tempReplyStr));
                        }
                        this.setFtpTagResult(false, tempReplyCode, tempReplyStr);
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception e) {
                    if (conn.isConnected()) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.ftpTag.isStoponerror()) {
                        throw new FtpConnectionException(e);
                    }
                    this.setFtpTagResult(false, e);
                }
            }
        }
        if (mConnectionName != null && conn != null) {
            this.pageContext.setAttribute(mConnectionName, (Object)conn);
        }
        return conn;
    }

    private void setConnectionProperty(FTPClient conn) {
        conn.setDataTimeout((int)this.ftpTag.getTimeout());
        try {
            conn.setSoTimeout((int)this.ftpTag.getTimeout());
        }
        catch (SocketException e) {
            throw new FtpConnectionException(e);
        }
        int mode = conn.getDataConnectionMode();
        if (this.isPassiveSet()) {
            if (this.ftpTag.getPassive() && mode != 2) {
                conn.enterLocalPassiveMode();
            }
            if (!this.ftpTag.getPassive() && mode != 0) {
                conn.enterLocalActiveMode();
            }
        }
    }

    private boolean close(FTPClient conn) throws IOException {
        if (conn.isConnected()) {
            conn.quit();
            conn.disconnect();
        }
        if (this.ftpTag.getConnection() != null) {
            this.pageContext.removeAttribute(this.ftpTag.getConnection());
        }
        this.setFtpTagResult(true, conn);
        return true;
    }

    public boolean changeDir(String Directory) throws IOException {
        boolean rc = this.mConnection.changeWorkingDirectory(Directory);
        if (rc) {
            this.setFtpTagResult(true, this.mConnection);
        } else {
            this.checkError(this.mConnection.getReplyCode(), this.mConnection.getReplyString());
        }
        return rc;
    }

    public boolean createDir(String Directory) throws IOException {
        boolean rc = this.mConnection.makeDirectory(Directory);
        if (rc) {
            this.setFtpTagResult(true, this.mConnection);
        } else {
            this.checkError(this.mConnection.getReplyCode(), this.mConnection.getReplyString());
        }
        return rc;
    }

    public boolean listDir(String Directory, String Name) throws IOException {
        boolean rc = false;
        FtpTagTable results = new FtpTagTable();
        FTPFile[] files = this.listFiles(Directory);
        Vector<FTPFile> FilesVec = new Vector<FTPFile>();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null || files[i].getName().compareTo(".") == 0 || files[i].getName().compareTo("..") == 0) continue;
                FilesVec.add(files[i]);
            }
            results.populate(FilesVec, this.ftpTag.getDirectory(), this.ftpTag.getUsername(), this.ftpTag.getPassword(), this.mConnection.getRemoteAddress().getHostName(), this.ftpTag.getPort());
            this.pageContext.setAttribute(Name, (Object)results);
            int tempReplyCode = this.mConnection.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)tempReplyCode)) {
                this.checkError(tempReplyCode, this.mConnection.getReplyString());
            } else {
                this.setFtpTagResult(true, this.mConnection);
            }
        } else {
            this.checkError(this.mConnection.getReplyCode(), this.mConnection.getReplyString());
        }
        return rc;
    }

    public boolean removeDir(String directory) throws IOException {
        boolean rc = this.mConnection.removeDirectory(directory);
        if (rc) {
            this.setFtpTagResult(true, this.mConnection);
        } else {
            this.checkError(this.mConnection.getReplyCode(), this.mConnection.getReplyString());
        }
        return rc;
    }

    public boolean site(String param) throws IOException {
        boolean rc = this.mConnection.sendSiteCommand(param);
        if (rc) {
            this.setFtpTagResult(true, this.mConnection);
        } else {
            this.checkError(this.mConnection.getReplyCode(), this.mConnection.getReplyString());
        }
        return rc;
    }

    public boolean quote(String param) throws IOException {
        boolean rc = false;
        int tempCommand = -1;
        try {
            tempCommand = Integer.parseInt(param);
        }
        catch (NumberFormatException nfe) {
            tempCommand = -1;
        }
        int tempReplyCode = tempCommand != -1 ? this.mConnection.sendCommand(tempCommand) : this.mConnection.sendCommand(param);
        if (FTPReply.isPositiveCompletion((int)tempReplyCode)) {
            this.setFtpTagResult(true, this.mConnection);
            rc = true;
        } else {
            this.checkError(this.mConnection.getReplyCode(), this.mConnection.getReplyString());
        }
        return rc;
    }

    public boolean acct(String param) throws IOException {
        boolean rc = false;
        int tempReplyCode = this.mConnection.acct(param);
        if (FTPReply.isPositiveCompletion((int)tempReplyCode)) {
            this.setFtpTagResult(true, this.mConnection);
            rc = true;
        } else {
            this.checkError(this.mConnection.getReplyCode(), this.mConnection.getReplyString());
        }
        return rc;
    }

    public boolean allo(int param) throws IOException {
        boolean rc = false;
        int tempReplyCode = this.mConnection.allo(param);
        if (FTPReply.isPositiveCompletion((int)tempReplyCode)) {
            this.setFtpTagResult(true, this.mConnection);
            rc = true;
        } else {
            this.checkError(this.mConnection.getReplyCode(), this.mConnection.getReplyString());
        }
        return rc;
    }

    public void setBufferSize(int param) throws IOException {
        if (param > -1 && this.mConnection != null && this.mConnection.isConnected()) {
            this.mConnection.setBufferSize(param);
        }
    }

    /*
     * Loose catch block
     */
    public boolean getFile(final String remoteFile) throws IOException {
        boolean rc;
        block29: {
            FTPTimer timer = new FTPTimer((int)this.ftpTag.getTimeout());
            timer.start();
            File f = VFSFileFactory.getFileObject((String)Utils.getFileFullPath((String)this.ftpTag.getLocalfile(), (PageContext)this.pageContext));
            if (f.exists() && this.ftpTag.isFailifexists()) {
                this.checkError(18, RB.getString(FtpTag.class, (String)"FtpTag.LocalfileExists", (Object)this.ftpTag.getLocalfile()));
                return false;
            }
            final OutputStream out = VFSFileFactory.getOutputStream((File)f);
            this.mConnection.setFileType(this.getFileType(f));
            rc = true;
            try {
                if (System.getSecurityManager() == null) {
                    rc = this.mConnection.retrieveFile(remoteFile, out);
                } else {
                    try {
                        rc = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                return FtpHandler.this.mConnection.retrieveFile(remoteFile, out);
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw (IOException)pae.getException();
                    }
                }
                out.close();
                timer.killthread();
                if (rc) {
                    try {
                        String lmd;
                        SimpleDateFormat sdf;
                        java.util.Date dt;
                        String lmdReply = this.mConnection.getModificationTime(remoteFile);
                        if (lmdReply != null && lmdReply.split(" ").length == 2 && (dt = (sdf = new SimpleDateFormat("yyyyMMddHHmmss")).parse(lmd = lmdReply.split(" ")[1])) != null) {
                            FileUtils.setLastModified((String)f.getCanonicalPath(), (java.util.Date)DateUtils.convertDate((String)"utc2local", (java.util.Date)dt));
                        }
                    }
                    catch (ParseException lmdReply) {
                        // empty catch block
                    }
                    this.setFtpTagResult(true, this.mConnection);
                    break block29;
                }
                f.delete();
                this.checkError(this.mConnection.getReplyCode(), this.mConnection.getReplyString());
            }
            catch (FTPConnectionClosedException e) {
                boolean bl = this.checkErrorTimeOut(rc, this.ftpTag.getAction());
                return bl;
            }
            catch (NullPointerException e) {
                boolean bl = this.checkErrorTimeOut(rc, this.ftpTag.getAction());
                return bl;
            }
            catch (IOException io) {
                if (io instanceof CopyStreamException) {
                    if (((CopyStreamException)io).getIOException() != null) {
                        this.checkError(this.ftpTag.getAction(), ((CopyStreamException)io).getIOException());
                    }
                    this.checkError(this.ftpTag.getAction(), io);
                }
                if (io instanceof SocketTimeoutException) {
                    this.checkErrorTimeOut(rc, this.ftpTag.getAction());
                }
                throw io;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                timer.killthread();
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rc;
    }

    private boolean checkErrorTimeOut(boolean rc, String operation) {
        if (this.ftpTag.isStoponerror()) {
            throw new FtpOperationTimeoutException(operation);
        }
        this.setFtpTagResult(false, (Throwable)((Object)new FtpOperationTimeoutException(operation)));
        return rc;
    }

    /*
     * Exception decompiling
     */
    public boolean putFile(String remoteFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean rename(String ExistingName, String NewName) throws IOException {
        boolean rc = this.mConnection.rename(ExistingName, NewName);
        if (rc) {
            this.setFtpTagResult(true, this.mConnection);
        } else {
            this.checkError(this.mConnection.getReplyCode(), this.mConnection.getReplyString());
        }
        return rc;
    }

    public boolean remove(String item) throws IOException {
        boolean rc = this.mConnection.deleteFile(item);
        if (rc) {
            this.setFtpTagResult(true, this.mConnection);
        } else {
            this.checkError(this.mConnection.getReplyCode(), this.mConnection.getReplyString());
        }
        return rc;
    }

    public boolean getCurrentDir() throws IOException {
        this.setFtpTagResult(true, (FTPClient)this.mConnection, this.mConnection.printWorkingDirectory());
        return true;
    }

    public boolean getCurrentURL() throws IOException {
        boolean rc = true;
        StringBuffer buf = new StringBuffer("ftp://");
        buf.append(this.mConnection.getRemoteAddress().getHostName());
        String dir = this.mConnection.printWorkingDirectory();
        if (!dir.startsWith("/")) {
            buf.append("/");
        }
        buf.append(dir);
        this.setFtpTagResult(true, (FTPClient)this.mConnection, buf.toString());
        return rc;
    }

    public boolean existsDir(String Directory) throws IOException {
        String currentDir = this.mConnection.printWorkingDirectory();
        boolean rc = this.mConnection.changeWorkingDirectory(Directory);
        this.mConnection.changeWorkingDirectory(currentDir);
        this.setFtpTagResult(rc, (FTPClient)this.mConnection, rc);
        return rc;
    }

    public boolean existsFile(String RemoteFile) throws IOException {
        boolean rc = true;
        boolean ReturnValue = false;
        FTPFile[] files = this.listFiles(RemoteFile);
        if (files != null && files.length == 1 && files[0].isFile()) {
            ReturnValue = true;
        }
        this.setFtpTagResult(rc, (FTPClient)this.mConnection, ReturnValue);
        return rc;
    }

    public boolean exists(String RemoteFile) throws IOException {
        boolean rc = true;
        boolean ReturnValue = false;
        FTPFile[] files = this.listFiles(RemoteFile);
        if (files != null && files.length != 0) {
            ReturnValue = true;
        }
        this.setFtpTagResult(rc, (FTPClient)this.mConnection, ReturnValue);
        return rc;
    }

    private FTPFile[] listFiles(final String RemoteFile) throws IOException {
        FTPFile[] files;
        block7: {
            files = null;
            if (System.getSecurityManager() == null) {
                try {
                    files = this.mConnection.listFiles(this.ftpTag.getSystemType(), RemoteFile);
                }
                catch (ParserInitializationException e) {
                    String systemType;
                    if (this.isParserKeyGiven() || (systemType = this.mConnection.getSystemName()) == null) {
                        throw e;
                    }
                    if (systemType.toUpperCase().indexOf("WIN32") != -1) {
                        files = this.mConnection.listFiles("org.apache.commons.net.ftp.parser.UnixFTPEntryParser", RemoteFile);
                    }
                    break block7;
                }
            }
            try {
                files = (FTPFile[])AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        try {
                            return FtpHandler.this.mConnection.listFiles(FtpHandler.this.ftpTag.getSystemType(), RemoteFile);
                        }
                        catch (ParserInitializationException e) {
                            String systemType;
                            if (FtpHandler.this.isParserKeyGiven() || (systemType = FtpHandler.this.mConnection.getSystemName()) == null) {
                                throw e;
                            }
                            if (systemType.toUpperCase().indexOf("WIN32") != -1) {
                                return FtpHandler.this.mConnection.listFiles("org.apache.commons.net.ftp.parser.UnixFTPEntryParser", RemoteFile);
                            }
                            return null;
                        }
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }
        return files;
    }

    private boolean isParserKeyGiven() {
        return this.ftpTag.getSystemType() != null || this.mConnection.getsystemType() != null;
    }

    public void setFtptag(FtpTag tag) {
        this.ftpTag = tag;
    }

    public boolean isPassive() {
        if (this.ftpTag != null) {
            return this.ftpTag.getPassive();
        }
        return false;
    }

    public boolean isPassiveSet() {
        if (this.ftpTag != null) {
            return this.ftpTag.isPassiveSet();
        }
        return false;
    }

    private int getFileType(File file) {
        String mTransfermode = this.ftpTag.getTransfermode();
        String mAsciiExtensionList = this.ftpTag.getAsciiextensionlist();
        if ("auto".equalsIgnoreCase(mTransfermode)) {
            if (mAsciiExtensionList.indexOf(this.getFileExtension(file)) == -1) {
                return 2;
            }
            return 0;
        }
        if ("binary".equalsIgnoreCase(mTransfermode)) {
            return 2;
        }
        if ("ascii".equalsIgnoreCase(mTransfermode)) {
            return 0;
        }
        return 0;
    }

    private String getFileExtension(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public String getDefaultFileNameEncoding() {
        return "ISO-8859-1";
    }

    public String getFileNameEncoding() {
        String encoding;
        String string = encoding = this.ftpTag.getFileNameEncoding() != null ? this.ftpTag.getFileNameEncoding() : this.mConnection.getFileNameEncoding();
        if (encoding == null) {
            return FtpTag.DEFAULT_CHARSET;
        }
        return encoding;
    }

    class FtpTagTable
    extends QueryTable {
        FtpTagTable() {
        }

        public void populate(Vector files, String workingDir, String username, String password, String server, int port) {
            this.meta = new FtpTagTableMetaData();
            this.col_count = this.meta.getColumnCount();
            this.col_names = this.meta.getColumnLabels();
            if (files == null) {
                this.row_count = 0;
                return;
            }
            if (!workingDir.endsWith("/")) {
                workingDir = workingDir + "/";
            }
            for (int i = 0; i < files.size(); ++i) {
                Object[] col_data = new Object[this.col_count];
                FTPFile file = (FTPFile)files.get(i);
                String encfilename = null;
                try {
                    encfilename = new String(file.getName().getBytes(FtpHandler.this.getDefaultFileNameEncoding()), FtpTag.DEFAULT_CHARSET);
                }
                catch (Exception e) {
                    encfilename = file.getName();
                }
                col_data[0] = encfilename;
                col_data[1] = workingDir + encfilename;
                col_data[2] = "ftp://" + server + workingDir + encfilename;
                col_data[3] = new Long(file.getSize());
                if (file.getTimestamp() != null) {
                    try {
                        col_data[4] = file.getTimestamp().getTime();
                    }
                    catch (Exception iae) {
                        col_data[4] = new Date(0L);
                    }
                } else {
                    col_data[4] = new Date(0L);
                }
                col_data[5] = "";
                col_data[6] = file.isDirectory() ? "YES" : "NO";
                col_data[7] = "not currently supported";
                this.addRow(col_data);
            }
        }
    }

    class PrintCommandListener
    implements ProtocolCommandListener {
        private PrintWriter __writer;

        public PrintCommandListener(PrintWriter writer) {
            this.__writer = writer;
        }

        public void protocolCommandSent(ProtocolCommandEvent event) {
            this.__writer.print(event.getMessage());
            this.__writer.flush();
        }

        public void protocolReplyReceived(ProtocolCommandEvent event) {
            this.__writer.print(event.getMessage());
            this.__writer.flush();
        }
    }

    class FTPTimer
    extends Thread {
        protected int m_rate = 100;
        private int m_length;
        private int m_elapsed;
        private boolean runThread = true;

        public FTPTimer(int length) {
            this.m_length = length;
        }

        public synchronized void reset() {
            this.m_elapsed = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.runThread) {
                try {
                    Thread.sleep(this.m_rate);
                }
                catch (InterruptedException ioe) {
                    continue;
                }
                FTPTimer fTPTimer = this;
                synchronized (fTPTimer) {
                    this.m_elapsed += this.m_rate;
                    if (this.m_elapsed > this.m_length) {
                        this.timeout();
                    }
                }
            }
        }

        public void timeout() {
            try {
                FtpHandler.this.mConnection.disconnect();
                this.killthread();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void killthread() {
            this.runThread = false;
        }
    }

    public class FtpInvalidConnectionException
    extends ApplicationException {
        public String ConnectionName = null;

        FtpInvalidConnectionException(String conn) {
            this.ConnectionName = "'" + conn + "'";
        }
    }

    public class FtpConnectionException
    extends ApplicationException {
        public String Cause;

        FtpConnectionException(Throwable ex) {
            super(ex);
            this.Cause = ex.getLocalizedMessage();
        }
    }

    public class FtpOperationTimeoutException
    extends ApplicationException {
        public String Action;
        public String Cause;

        FtpOperationTimeoutException(String action) {
            this.Action = action;
        }
    }

    public class FtpOperationException
    extends ApplicationException {
        public String Action;
        public String Cause;

        FtpOperationException(String action, String cause) {
            this.Action = action;
            this.Cause = cause;
        }

        FtpOperationException(String a, Throwable ex) {
            super(ex);
            this.Action = a;
            this.Cause = ex.getLocalizedMessage();
        }
    }
}

