/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.attachments.utils.IOUtils;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;
import org.apache.axiom.util.stax.XMLStreamWriterUtils;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.i18n.ADBMessages;
import org.apache.axis2.databinding.types.Day;
import org.apache.axis2.databinding.types.Duration;
import org.apache.axis2.databinding.types.Entities;
import org.apache.axis2.databinding.types.Entity;
import org.apache.axis2.databinding.types.HexBinary;
import org.apache.axis2.databinding.types.IDRef;
import org.apache.axis2.databinding.types.IDRefs;
import org.apache.axis2.databinding.types.Id;
import org.apache.axis2.databinding.types.Language;
import org.apache.axis2.databinding.types.Month;
import org.apache.axis2.databinding.types.MonthDay;
import org.apache.axis2.databinding.types.NCName;
import org.apache.axis2.databinding.types.NMToken;
import org.apache.axis2.databinding.types.NMTokens;
import org.apache.axis2.databinding.types.Name;
import org.apache.axis2.databinding.types.NegativeInteger;
import org.apache.axis2.databinding.types.NonNegativeInteger;
import org.apache.axis2.databinding.types.NonPositiveInteger;
import org.apache.axis2.databinding.types.NormalizedString;
import org.apache.axis2.databinding.types.Notation;
import org.apache.axis2.databinding.types.PositiveInteger;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.types.Token;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.UnsignedByte;
import org.apache.axis2.databinding.types.UnsignedInt;
import org.apache.axis2.databinding.types.UnsignedLong;
import org.apache.axis2.databinding.types.UnsignedShort;
import org.apache.axis2.databinding.types.Year;
import org.apache.axis2.databinding.types.YearMonth;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConverterUtil {
    private static Log log = LogFactory.getLog(ConverterUtil.class);
    private static final String POSITIVE_INFINITY = "INF";
    private static final String NEGATIVE_INFINITY = "-INF";
    public static final String SYSTEM_PROPERTY_ADB_CONVERTERUTIL = "adb.converterutil";
    private static boolean isCustomClassPresent;
    private static Class customClass;

    public static String convertToString(int i) {
        return Integer.toString(i);
    }

    public static String convertToString(float i) {
        return Float.toString(i);
    }

    public static String convertToString(long i) {
        return Long.toString(i);
    }

    public static String convertToString(double i) {
        return Double.toString(i);
    }

    public static String convertToString(byte i) {
        return Byte.toString(i);
    }

    public static String convertToString(char i) {
        return Character.toString(i);
    }

    public static String convertToString(short i) {
        return Short.toString(i);
    }

    public static String convertToString(boolean i) {
        return Boolean.toString(i);
    }

    public static String convertToString(Date value) {
        if (isCustomClassPresent) {
            return ConverterUtil.invokeToStringMethod(value, Date.class);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(value);
        if (!calendar.isSet(15)) {
            calendar.setTimeZone(TimeZone.getDefault());
        }
        StringBuffer dateString = new StringBuffer(16);
        ConverterUtil.appendDate(dateString, calendar);
        ConverterUtil.appendTimeZone(calendar, dateString);
        return dateString.toString();
    }

    public static void appendTimeZone(Calendar calendar, StringBuffer dateString) {
        int timezoneOffSet = calendar.get(15) + calendar.get(16);
        int timezoneOffSetInMinits = timezoneOffSet / 60000;
        if (timezoneOffSetInMinits < 0) {
            dateString.append("-");
            timezoneOffSetInMinits *= -1;
        } else {
            dateString.append("+");
        }
        int hours = timezoneOffSetInMinits / 60;
        int minits = timezoneOffSetInMinits % 60;
        if (hours < 10) {
            dateString.append("0");
        }
        dateString.append(hours).append(":");
        if (minits < 10) {
            dateString.append("0");
        }
        dateString.append(minits);
    }

    public static void appendDate(StringBuffer dateString, Calendar calendar) {
        int year = calendar.get(1);
        if (year < 1000) {
            dateString.append("0");
        }
        if (year < 100) {
            dateString.append("0");
        }
        if (year < 10) {
            dateString.append("0");
        }
        dateString.append(year).append("-");
        int month = calendar.get(2) + 1;
        if (month < 10) {
            dateString.append("0");
        }
        dateString.append(month).append("-");
        if (calendar.get(5) < 10) {
            dateString.append("0");
        }
        dateString.append(calendar.get(5));
    }

    private static String invokeToStringMethod(Object value, Class type) {
        try {
            Method method = customClass.getMethod("convertToString", type);
            String result = (String)method.invoke(null, value);
            return result;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("can not find the method convertToString(" + type.getName() + ") in converter util class " + customClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("can not access the method convertToString(" + type.getName() + ") in converter util class " + customClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("can not invocate the method convertToString(" + type.getName() + ") in converter util class " + customClass.getName(), e);
        }
    }

    public static String convertToString(Calendar value) {
        if (isCustomClassPresent) {
            return ConverterUtil.invokeToStringMethod(value, Calendar.class);
        }
        if (value.get(15) == -1) {
            value.setTimeZone(TimeZone.getDefault());
        }
        StringBuffer dateString = new StringBuffer(28);
        ConverterUtil.appendDate(dateString, value);
        dateString.append("T");
        ConverterUtil.appendTime(value, dateString);
        ConverterUtil.appendTimeZone(value, dateString);
        return dateString.toString();
    }

    public static void appendTime(Calendar value, StringBuffer dateString) {
        if (value.get(11) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(11)).append(":");
        if (value.get(12) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(12)).append(":");
        if (value.get(13) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(13)).append(".");
        if (value.get(14) < 10) {
            dateString.append("0");
        }
        if (value.get(14) < 100) {
            dateString.append("0");
        }
        dateString.append(value.get(14));
    }

    public static String convertToString(Day o) {
        return o.toString();
    }

    public static String convertToString(YearMonth o) {
        return o.toString();
    }

    public static String convertToString(Year o) {
        return o.toString();
    }

    public static String convertToString(HexBinary o) {
        return o.toString();
    }

    public static String convertToString(MonthDay o) {
        return o.toString();
    }

    public static String convertToString(Time o) {
        return o.toString();
    }

    public static String convertToString(Byte o) {
        return o.toString();
    }

    public static String convertToString(BigInteger o) {
        return o.toString();
    }

    public static String convertToString(Integer o) {
        return o.toString();
    }

    public static String convertToString(Long o) {
        return o.toString();
    }

    public static String convertToString(Short o) {
        return o.toString();
    }

    public static String convertToString(UnsignedByte o) {
        return o.toString();
    }

    public static String convertToString(UnsignedInt o) {
        return o.toString();
    }

    public static String convertToString(UnsignedLong o) {
        return o.toString();
    }

    public static String convertToString(QName o) {
        if (o != null) {
            return o.getLocalPart();
        }
        return "";
    }

    public static String convertToString(Object o) {
        return o.toString();
    }

    public static String convertToString(Double o) {
        return o.toString();
    }

    public static String convertToString(Duration o) {
        return o.toString();
    }

    public static String convertToString(Float o) {
        return o.toString();
    }

    public static String convertToString(Month o) {
        return o.toString();
    }

    public static String convertToString(byte[] bytes) {
        return Base64.encode((byte[])bytes);
    }

    public static String convertToString(DataHandler handler) {
        return ConverterUtil.getStringFromDatahandler(handler);
    }

    public static int convertToInt(String s) {
        if (s == null || s.equals("")) {
            return Integer.MIN_VALUE;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return Integer.parseInt(s);
    }

    public static BigDecimal convertToBigDecimal(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new BigDecimal(s);
    }

    public static double convertToDouble(String s) {
        if (s == null || s.equals("")) {
            return Double.NaN;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        if (POSITIVE_INFINITY.equals(s)) {
            return Double.POSITIVE_INFINITY;
        }
        if (NEGATIVE_INFINITY.equals(s)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(s);
    }

    public static BigDecimal convertToDecimal(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new BigDecimal(s);
    }

    public static BigDecimal convertToStandardDecimalNotation(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return BigDecimal.valueOf(Math.pow(10.0, Integer.parseInt(s)));
    }

    public static float convertToFloat(String s) {
        if (s == null || s.equals("")) {
            return Float.NaN;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        if (POSITIVE_INFINITY.equals(s)) {
            return Float.POSITIVE_INFINITY;
        }
        if (NEGATIVE_INFINITY.equals(s)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(s);
    }

    public static String convertToString(String s) {
        return s;
    }

    public static long convertToLong(String s) {
        if (s == null || s.equals("")) {
            return Long.MIN_VALUE;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return Long.parseLong(s);
    }

    public static short convertToShort(String s) {
        if (s == null || s.equals("")) {
            return Short.MIN_VALUE;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return Short.parseShort(s);
    }

    public static boolean convertToBoolean(String s) {
        boolean returnValue = false;
        if (s != null && s.length() > 0) {
            if ("1".equals(s) || s.toLowerCase().equals("true")) {
                returnValue = true;
            } else if (!"0".equals(s) && !s.toLowerCase().equals("false")) {
                throw new RuntimeException("in valid string -" + s + " for boolean value");
            }
        }
        return returnValue;
    }

    public static String convertToAnySimpleType(String s) {
        return s;
    }

    public static OMElement convertToAnyType(String s) {
        try {
            return AXIOMUtil.stringToOM((String)s);
        }
        catch (XMLStreamException e) {
            return null;
        }
    }

    public static YearMonth convertToGYearMonth(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new YearMonth(s);
    }

    public static MonthDay convertToGMonthDay(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new MonthDay(s);
    }

    public static Year convertToGYear(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new Year(s);
    }

    public static Month convertToGMonth(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new Month(s);
    }

    public static Day convertToGDay(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new Day(s);
    }

    public static Duration convertToDuration(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new Duration(s);
    }

    public static HexBinary convertToHexBinary(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new HexBinary(s);
    }

    public static DataHandler convertToBase64Binary(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(Base64.decode((String)s));
        return new DataHandler((DataSource)byteArrayDataSource);
    }

    public static DataHandler convertToDataHandler(String s) {
        return ConverterUtil.convertToBase64Binary(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Date convertToDate(String source) {
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        boolean bc = false;
        if (source.startsWith("-")) {
            source = source.substring(1);
            bc = true;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int timeZoneOffSet = TimeZone.getDefault().getRawOffset();
        if (source.length() < 10) throw new RuntimeException("In valid string to parse");
        if (source.charAt(4) != '-' || source.charAt(7) != '-') {
            throw new RuntimeException("invalid date format (" + source + ") with out - s at correct place ");
        }
        year = Integer.parseInt(source.substring(0, 4));
        month = Integer.parseInt(source.substring(5, 7));
        day = Integer.parseInt(source.substring(8, 10));
        if (source.length() > 10) {
            String restpart = source.substring(10);
            if (restpart.startsWith("Z")) {
                timeZoneOffSet = 0;
            } else {
                if (!restpart.startsWith("+") && !restpart.startsWith("-")) throw new RuntimeException("In valid string sufix");
                if (restpart.charAt(3) != ':') {
                    throw new RuntimeException("invalid time zone format (" + source + ") without : at correct place");
                }
                int hours = Integer.parseInt(restpart.substring(1, 3));
                int minits = Integer.parseInt(restpart.substring(4, 6));
                timeZoneOffSet = (hours * 60 + minits) * 60000;
                if (restpart.startsWith("-")) {
                    timeZoneOffSet *= -1;
                }
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(15, timeZoneOffSet);
        if (source.length() >= 10) {
            calendar.set(16, 0);
        }
        calendar.getTimeInMillis();
        if (!bc) return calendar.getTime();
        calendar.set(0, 0);
        return calendar.getTime();
    }

    public static Date convertXmlToDate(String source) {
        try {
            XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(source);
            return cal.toGregorianCalendar().getTime();
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Time convertToTime(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new Time(s);
    }

    public static Token convertToToken(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new Token(s);
    }

    public static NormalizedString convertToNormalizedString(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new NormalizedString(s);
    }

    public static UnsignedLong convertToUnsignedLong(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new UnsignedLong(s);
    }

    public static UnsignedInt convertToUnsignedInt(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new UnsignedInt(s);
    }

    public static UnsignedShort convertToUnsignedShort(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new UnsignedShort(s);
    }

    public static UnsignedByte convertToUnsignedByte(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new UnsignedByte(s);
    }

    public static NonNegativeInteger convertToNonNegativeInteger(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new NonNegativeInteger(s);
    }

    public static NegativeInteger convertToNegativeInteger(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new NegativeInteger(s);
    }

    public static PositiveInteger convertToPositiveInteger(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new PositiveInteger(s);
    }

    public static NonPositiveInteger convertToNonPositiveInteger(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new NonPositiveInteger(s);
    }

    public static Name convertToName(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new Name(s);
    }

    public static NCName convertToNCName(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new NCName(s);
    }

    public static Id convertToID(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new Id(s);
    }

    public static Id convertToId(String s) {
        return ConverterUtil.convertToID(s);
    }

    public static Language convertToLanguage(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new Language(s);
    }

    public static NMToken convertToNMTOKEN(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new NMToken(s);
    }

    public static NMTokens convertToNMTOKENS(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new NMTokens(s);
    }

    public static Notation convertToNOTATION(String s) {
        return null;
    }

    public static Entity convertToENTITY(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new Entity(s);
    }

    public static Entities convertToENTITIES(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new Entities(s);
    }

    public static IDRef convertToIDREF(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new IDRef(s);
    }

    public static IDRefs convertToIDREFS(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return new IDRefs(s);
    }

    public static URI convertToURI(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return ConverterUtil.convertToAnyURI(s);
    }

    public static URI convertToAnyURI(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        try {
            return new URI(s);
        }
        catch (URI.MalformedURIException e) {
            throw new ObjectConversionException(ADBMessages.getMessage("converter.cannotParse", s), e);
        }
    }

    public static BigInteger convertToInteger(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return new BigInteger(s);
    }

    public static BigInteger convertToBigInteger(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return ConverterUtil.convertToInteger(s);
    }

    public static byte convertToByte(String s) {
        if (s == null || s.equals("")) {
            return -128;
        }
        return Byte.parseByte(s);
    }

    public static Calendar convertToDateTime(String source) {
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        Object date = null;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (source.startsWith("-")) {
            source = source.substring(1);
            calendar.set(0, 0);
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minite = 0;
        int second = 0;
        long miliSecond = 0L;
        int timeZoneOffSet = TimeZone.getDefault().getRawOffset();
        if (source != null && source.length() >= 19) {
            if (source.charAt(4) != '-' || source.charAt(7) != '-' || source.charAt(10) != 'T' || source.charAt(13) != ':' || source.charAt(16) != ':') {
                throw new RuntimeException("invalid date format (" + source + ") with out - s at correct place ");
            }
            year = Integer.parseInt(source.substring(0, 4));
            month = Integer.parseInt(source.substring(5, 7));
            day = Integer.parseInt(source.substring(8, 10));
            hour = Integer.parseInt(source.substring(11, 13));
            minite = Integer.parseInt(source.substring(14, 16));
            second = Integer.parseInt(source.substring(17, 19));
            int milliSecondPartLength = 0;
            if (source.length() > 19) {
                String rest = source.substring(19);
                if (rest.startsWith(".")) {
                    if (rest.endsWith("Z")) {
                        timeZoneOffSet = 0;
                        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                        miliSecond = Integer.parseInt(rest.substring(1, rest.lastIndexOf("Z")));
                        milliSecondPartLength = rest.substring(1, rest.lastIndexOf("Z")).trim().length();
                    } else if (rest.lastIndexOf("+") > 0 || rest.lastIndexOf("-") > 0) {
                        String timeOffSet = null;
                        if (rest.lastIndexOf("+") > 0) {
                            timeOffSet = rest.substring(rest.lastIndexOf("+") + 1);
                            miliSecond = Integer.parseInt(rest.substring(1, rest.lastIndexOf("+")));
                            milliSecondPartLength = rest.substring(1, rest.lastIndexOf("+")).trim().length();
                            timeZoneOffSet = 1;
                        } else if (rest.lastIndexOf("-") > 0) {
                            timeOffSet = rest.substring(rest.lastIndexOf("-") + 1);
                            miliSecond = Integer.parseInt(rest.substring(1, rest.lastIndexOf("-")));
                            milliSecondPartLength = rest.substring(1, rest.lastIndexOf("-")).trim().length();
                            timeZoneOffSet = -1;
                        }
                        if (timeOffSet.charAt(2) != ':') {
                            throw new RuntimeException("invalid time zone format (" + source + ") without : at correct place");
                        }
                        int hours = Integer.parseInt(timeOffSet.substring(0, 2));
                        int minits = Integer.parseInt(timeOffSet.substring(3, 5));
                        timeZoneOffSet = (hours * 60 + minits) * 60000 * timeZoneOffSet;
                    } else {
                        miliSecond = Integer.parseInt(rest.substring(1));
                        milliSecondPartLength = rest.substring(1).trim().length();
                    }
                } else if (rest.startsWith("Z")) {
                    calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                    timeZoneOffSet = 0;
                } else if (rest.startsWith("+") || rest.startsWith("-")) {
                    if (rest.charAt(3) != ':') {
                        throw new RuntimeException("invalid time zone format (" + source + ") without : at correct place");
                    }
                    int hours = Integer.parseInt(rest.substring(1, 3));
                    int minits = Integer.parseInt(rest.substring(4, 6));
                    timeZoneOffSet = (hours * 60 + minits) * 60000;
                    if (rest.startsWith("-")) {
                        timeZoneOffSet *= -1;
                    }
                } else {
                    throw new NumberFormatException("in valid time zone attribute");
                }
            }
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minite);
            calendar.set(13, second);
            if (milliSecondPartLength != 3) {
                miliSecond *= 1000L;
                for (int i = 0; i < milliSecondPartLength; ++i) {
                    miliSecond /= 10L;
                }
            }
            calendar.set(14, (int)miliSecond);
            calendar.set(15, timeZoneOffSet);
            if (source.length() > 19) {
                calendar.set(16, 0);
            }
        } else {
            throw new NumberFormatException("date string can not be less than 19 characters");
        }
        return calendar;
    }

    public static QName convertToQName(String source, String nameSpaceuri) {
        int colon = (source = source.trim()).lastIndexOf(":");
        String localPart = colon < 0 ? source : source.substring(colon + 1);
        String perfix = colon <= 0 ? "" : source.substring(0, colon);
        return new QName(nameSpaceuri, localPart, perfix);
    }

    public static Object convertToObject(String i) {
        return i;
    }

    public static Object convertToObject(boolean i) {
        return i;
    }

    public static Object convertToObject(double i) {
        return new Double(i);
    }

    public static Object convertToObject(byte i) {
        return new Byte(i);
    }

    public static Object convertToObject(char i) {
        return new Character(i);
    }

    public static Object convertToObject(short i) {
        return new Short(i);
    }

    public static Object convertToArray(Class baseArrayClass, String[] valueArray) {
        ArrayList<String> valuesList = new ArrayList<String>(valueArray.length);
        for (int i = 0; i < valueArray.length; ++i) {
            valuesList.add(valueArray[i]);
        }
        return ConverterUtil.convertToArray(baseArrayClass, valuesList);
    }

    public static Object convertToArray(Class baseArrayClass, List objectList) {
        int listSize = objectList.size();
        Object returnArray = null;
        if (Integer.TYPE.equals(baseArrayClass)) {
            int[] array = new int[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Integer.parseInt(o.toString()) : Integer.MIN_VALUE;
            }
            returnArray = array;
        } else if (Float.TYPE.equals(baseArrayClass)) {
            float[] array = new float[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Float.parseFloat(o.toString()) : Float.NaN;
            }
            returnArray = array;
        } else if (Short.TYPE.equals(baseArrayClass)) {
            short[] array = new short[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Short.parseShort(o.toString()) : (short)Short.MIN_VALUE;
            }
            returnArray = array;
        } else if (Byte.TYPE.equals(baseArrayClass)) {
            byte[] array = new byte[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Byte.parseByte(o.toString()) : (byte)-128;
            }
            returnArray = array;
        } else if (Long.TYPE.equals(baseArrayClass)) {
            long[] array = new long[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Long.parseLong(o.toString()) : Long.MIN_VALUE;
            }
            returnArray = array;
        } else if (Boolean.TYPE.equals(baseArrayClass)) {
            boolean[] array = new boolean[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                array[i] = o.toString().equalsIgnoreCase("true");
            }
            returnArray = array;
        } else if (Character.TYPE.equals(baseArrayClass)) {
            char[] array = new char[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                array[i] = o.toString().toCharArray()[0];
            }
            returnArray = array;
        } else if (Double.TYPE.equals(baseArrayClass)) {
            double[] array = new double[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                array[i] = o != null ? Double.parseDouble(o.toString()) : Double.NaN;
            }
            returnArray = array;
        } else if (Calendar.class.equals((Object)baseArrayClass)) {
            Calendar[] array = new Calendar[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                if (o instanceof String) {
                    array[i] = ConverterUtil.convertToDateTime(o.toString());
                    continue;
                }
                if (!(o instanceof Calendar)) continue;
                array[i] = (Calendar)o;
            }
            returnArray = array;
        } else if (Date.class.equals((Object)baseArrayClass)) {
            Date[] array = new Date[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                if (o instanceof String) {
                    array[i] = ConverterUtil.convertToDate(o.toString());
                    continue;
                }
                if (!(o instanceof Date)) continue;
                array[i] = (Date)o;
            }
            returnArray = array;
        } else {
            returnArray = Array.newInstance(baseArrayClass, listSize);
            ConverterUtil.ConvertToArbitraryObjectArray(returnArray, baseArrayClass, objectList);
        }
        return returnArray;
    }

    private static void ConvertToArbitraryObjectArray(Object returnArray, Class baseArrayClass, List objectList) {
        if (!ADBBean.class.isAssignableFrom(baseArrayClass)) {
            try {
                for (int i = 0; i < objectList.size(); ++i) {
                    Object o = objectList.get(i);
                    if (o == null) {
                        Array.set(returnArray, i, null);
                        continue;
                    }
                    Array.set(returnArray, i, ConverterUtil.getObjectForClass(baseArrayClass, o.toString()));
                }
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            objectList.toArray((Object[])returnArray);
        }
        catch (Exception e) {
            throw new ObjectConversionException(e);
        }
    }

    public static List toList(Object[] array) {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static int compare(int intValue, String value) {
        return intValue - Integer.parseInt(value);
    }

    public static double compare(double doubleValue, String value) {
        return doubleValue - Double.parseDouble(value);
    }

    public static float compare(float floatValue, String value) {
        return floatValue - Float.parseFloat(value);
    }

    public static long compare(long longValue, String value) {
        return longValue - Long.parseLong(value);
    }

    public static int compare(short shortValue, String value) {
        return shortValue - Short.parseShort(value);
    }

    public static int compare(byte byteVlaue, String value) {
        return byteVlaue - Byte.parseByte(value);
    }

    public static long compare(BigInteger binBigInteger, String value) {
        return binBigInteger.longValue() - Long.parseLong(value);
    }

    public static double compare(BigDecimal binBigDecimal, String value) {
        return binBigDecimal.doubleValue() - Double.parseDouble(value);
    }

    public static long compare(Duration duration, String value) {
        Duration compareValue = new Duration(value);
        return duration.compare(compareValue);
    }

    public static long compare(Date date, String value) {
        Date newDate = ConverterUtil.convertToDate(value);
        return date.getTime() - newDate.getTime();
    }

    public static long compare(Time time, String value) {
        Time newTime = new Time(value);
        return time.getAsCalendar().getTimeInMillis() - newTime.getAsCalendar().getTimeInMillis();
    }

    public static long compare(Calendar calendar, String value) {
        Calendar newCalendar = ConverterUtil.convertToDateTime(value);
        return calendar.getTimeInMillis() - newCalendar.getTimeInMillis();
    }

    public static long compare(UnsignedLong unsignedLong, String value) {
        return ConverterUtil.compare(unsignedLong.longValue(), value);
    }

    public static String getStringFromDatahandler(DataHandler dataHandler) {
        InputStream inStream = null;
        try {
            if (dataHandler == null) {
                String string = "";
                return string;
            }
            inStream = dataHandler.getDataSource().getInputStream();
            byte[] data = IOUtils.getStreamAsByteArray((InputStream)inStream);
            String string = Base64.encode((byte[])data);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Object getObjectForClass(Class clazz, String value) {
        try {
            Constructor stringConstructor = clazz.getConstructor(String.class);
            return stringConstructor.newInstance(value);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new ObjectConversionException(ADBMessages.getMessage("converter.cannotGenerate", clazz.getName()), e);
        }
        try {
            Method parseMethod = clazz.getMethod("parse", String.class);
            Object instance = clazz.newInstance();
            return parseMethod.invoke(instance, value);
        }
        catch (NoSuchMethodException e) {
            throw new ObjectConversionException(e);
        }
        catch (Exception e) {
            throw new ObjectConversionException(ADBMessages.getMessage("converter.cannotGenerate", clazz.getName()), e);
        }
    }

    public static void serializeAnyType(Object value, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        if (value instanceof String) {
            ConverterUtil.serializeAnyType("string", value.toString(), xmlStreamWriter);
        } else if (value instanceof Integer) {
            ConverterUtil.serializeAnyType("int", value.toString(), xmlStreamWriter);
        } else if (value instanceof Boolean) {
            ConverterUtil.serializeAnyType("boolean", value.toString(), xmlStreamWriter);
        } else if (value instanceof URI) {
            ConverterUtil.serializeAnyType("anyURI", value.toString(), xmlStreamWriter);
        } else if (value instanceof Byte) {
            ConverterUtil.serializeAnyType("byte", value.toString(), xmlStreamWriter);
        } else if (value instanceof Date) {
            ConverterUtil.serializeAnyType("date", ConverterUtil.convertToString((Date)value), xmlStreamWriter);
        } else if (value instanceof Calendar) {
            ConverterUtil.serializeAnyType("dateTime", ConverterUtil.convertToString((Calendar)value), xmlStreamWriter);
        } else if (value instanceof Time) {
            ConverterUtil.serializeAnyType("time", ConverterUtil.convertToString((Time)value), xmlStreamWriter);
        } else if (value instanceof Float) {
            ConverterUtil.serializeAnyType("float", value.toString(), xmlStreamWriter);
        } else if (value instanceof Long) {
            ConverterUtil.serializeAnyType("long", value.toString(), xmlStreamWriter);
        } else if (value instanceof Double) {
            ConverterUtil.serializeAnyType("double", value.toString(), xmlStreamWriter);
        } else if (value instanceof Short) {
            ConverterUtil.serializeAnyType("short", value.toString(), xmlStreamWriter);
        } else if (value instanceof BigDecimal) {
            ConverterUtil.serializeAnyType("decimal", ((BigDecimal)value).toPlainString(), xmlStreamWriter);
        } else if (value instanceof DataHandler) {
            ConverterUtil.addTypeAttribute(xmlStreamWriter, "base64Binary");
            try {
                XMLStreamWriterUtils.writeDataHandler((XMLStreamWriter)xmlStreamWriter, (DataHandler)((DataHandler)value), null, (boolean)true);
            }
            catch (IOException ex) {
                throw new XMLStreamException("Unable to read data handler", ex);
            }
        } else if (value instanceof QName) {
            QName qNameValue = (QName)value;
            String prefix = xmlStreamWriter.getPrefix(qNameValue.getNamespaceURI());
            if (prefix == null) {
                prefix = BeanUtil.getUniquePrefix();
                xmlStreamWriter.writeNamespace(prefix, qNameValue.getNamespaceURI());
                xmlStreamWriter.setPrefix(prefix, qNameValue.getNamespaceURI());
            }
            String attributeValue = qNameValue.getLocalPart();
            if (!prefix.equals("")) {
                attributeValue = prefix + ":" + attributeValue;
            }
            ConverterUtil.serializeAnyType("QName", attributeValue, xmlStreamWriter);
        } else if (value instanceof UnsignedByte) {
            ConverterUtil.serializeAnyType("unsignedByte", ConverterUtil.convertToString((UnsignedByte)value), xmlStreamWriter);
        } else if (value instanceof UnsignedLong) {
            ConverterUtil.serializeAnyType("unsignedLong", ConverterUtil.convertToString((UnsignedLong)value), xmlStreamWriter);
        } else if (value instanceof UnsignedShort) {
            ConverterUtil.serializeAnyType("unsignedShort", ConverterUtil.convertToString((UnsignedShort)value), xmlStreamWriter);
        } else if (value instanceof UnsignedInt) {
            ConverterUtil.serializeAnyType("unsignedInt", ConverterUtil.convertToString((UnsignedInt)value), xmlStreamWriter);
        } else if (value instanceof PositiveInteger) {
            ConverterUtil.serializeAnyType("positiveInteger", ConverterUtil.convertToString((PositiveInteger)value), xmlStreamWriter);
        } else if (value instanceof NegativeInteger) {
            ConverterUtil.serializeAnyType("negativeInteger", ConverterUtil.convertToString((NegativeInteger)value), xmlStreamWriter);
        } else if (value instanceof NonNegativeInteger) {
            ConverterUtil.serializeAnyType("nonNegativeInteger", ConverterUtil.convertToString((NonNegativeInteger)value), xmlStreamWriter);
        } else if (value instanceof NonPositiveInteger) {
            ConverterUtil.serializeAnyType("nonPositiveInteger", ConverterUtil.convertToString((NonPositiveInteger)value), xmlStreamWriter);
        } else {
            throw new XMLStreamException("Unknow type can not serialize");
        }
    }

    private static void serializeAnyType(String type, String value, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        ConverterUtil.addTypeAttribute(xmlStreamWriter, type);
        xmlStreamWriter.writeCharacters(value);
    }

    private static void addTypeAttribute(XMLStreamWriter xmlStreamWriter, String type) throws XMLStreamException {
        String prefix = xmlStreamWriter.getPrefix("http://www.w3.org/2001/XMLSchema-instance");
        if (prefix == null) {
            prefix = BeanUtil.getUniquePrefix();
            xmlStreamWriter.writeNamespace(prefix, "http://www.w3.org/2001/XMLSchema-instance");
            xmlStreamWriter.setPrefix(prefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if ((prefix = xmlStreamWriter.getPrefix("http://www.w3.org/2001/XMLSchema")) == null) {
            prefix = BeanUtil.getUniquePrefix();
            xmlStreamWriter.writeNamespace(prefix, "http://www.w3.org/2001/XMLSchema");
            xmlStreamWriter.setPrefix(prefix, "http://www.w3.org/2001/XMLSchema");
        }
        String attributeValue = null;
        attributeValue = prefix.equals("") ? type : prefix + ":" + type;
        xmlStreamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", attributeValue);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getAnyTypeObject(XMLStreamReader xmlStreamReader, Class extensionMapperClass) throws XMLStreamException {
        NamespaceContext namespaceContext;
        String attributeNameSpace;
        void var2_31;
        Object var2_2 = null;
        while (!xmlStreamReader.isStartElement()) {
            xmlStreamReader.next();
        }
        String nillableValue = xmlStreamReader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if ("true".equals(nillableValue) || "1".equals(nillableValue)) {
            Object var2_3 = null;
            xmlStreamReader.next();
            return var2_31;
        }
        String attributeType = xmlStreamReader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (attributeType == null) throw new ADBException("Any type element type has not been given");
        String attributeTypePrefix = "";
        if (attributeType.indexOf(":") > -1) {
            attributeTypePrefix = attributeType.substring(0, attributeType.indexOf(":"));
            attributeType = attributeType.substring(attributeType.indexOf(":") + 1);
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(attributeNameSpace = (namespaceContext = xmlStreamReader.getNamespaceContext()).getNamespaceURI(attributeTypePrefix))) {
            if ("base64Binary".equals(attributeType)) {
                DataHandler dataHandler = XMLStreamReaderUtils.getDataHandlerFromElement((XMLStreamReader)xmlStreamReader);
                return var2_31;
            } else {
                String attribValue = xmlStreamReader.getElementText();
                if (attribValue == null) throw new ADBException("Attribute value is null");
                if (attributeType.equals("string")) {
                    String string = attribValue;
                    return var2_31;
                } else if (attributeType.equals("int")) {
                    Integer n = new Integer(attribValue);
                    return var2_31;
                } else if (attributeType.equals("QName")) {
                    String namespacePrefix = null;
                    String localPart = null;
                    if (attribValue.indexOf(":") <= -1) return var2_31;
                    namespacePrefix = attribValue.substring(0, attribValue.indexOf(":"));
                    localPart = attribValue.substring(attribValue.indexOf(":") + 1);
                    QName qName = new QName(namespaceContext.getNamespaceURI(namespacePrefix), localPart);
                    return var2_31;
                } else if ("boolean".equals(attributeType)) {
                    Boolean bl = new Boolean(attribValue);
                    return var2_31;
                } else if ("anyURI".equals(attributeType)) {
                    try {
                        URI uRI = new URI(attribValue);
                        return var2_31;
                    }
                    catch (URI.MalformedURIException e) {
                        throw new XMLStreamException("Invalid URI");
                    }
                } else if ("date".equals(attributeType)) {
                    Date date = ConverterUtil.convertXmlToDate(attribValue);
                    return var2_31;
                } else if ("dateTime".equals(attributeType)) {
                    Calendar calendar = ConverterUtil.convertToDateTime(attribValue);
                    return var2_31;
                } else if ("time".equals(attributeType)) {
                    Time time = ConverterUtil.convertToTime(attribValue);
                    return var2_31;
                } else if ("byte".equals(attributeType)) {
                    Byte by = new Byte(attribValue);
                    return var2_31;
                } else if ("short".equals(attributeType)) {
                    Short s = new Short(attribValue);
                    return var2_31;
                } else if ("float".equals(attributeType)) {
                    Float f = new Float(attribValue);
                    return var2_31;
                } else if ("long".equals(attributeType)) {
                    Long l = new Long(attribValue);
                    return var2_31;
                } else if ("double".equals(attributeType)) {
                    Double d = new Double(attribValue);
                    return var2_31;
                } else if ("decimal".equals(attributeType)) {
                    BigDecimal bigDecimal = new BigDecimal(attribValue);
                    return var2_31;
                } else if ("unsignedLong".equals(attributeType)) {
                    UnsignedLong unsignedLong = new UnsignedLong(attribValue);
                    return var2_31;
                } else if ("unsignedInt".equals(attributeType)) {
                    UnsignedInt unsignedInt = new UnsignedInt(attribValue);
                    return var2_31;
                } else if ("unsignedShort".equals(attributeType)) {
                    UnsignedShort unsignedShort = new UnsignedShort(attribValue);
                    return var2_31;
                } else if ("unsignedByte".equals(attributeType)) {
                    UnsignedByte unsignedByte = new UnsignedByte(attribValue);
                    return var2_31;
                } else if ("positiveInteger".equals(attributeType)) {
                    PositiveInteger positiveInteger = new PositiveInteger(attribValue);
                    return var2_31;
                } else if ("negativeInteger".equals(attributeType)) {
                    NegativeInteger negativeInteger = new NegativeInteger(attribValue);
                    return var2_31;
                } else if ("nonNegativeInteger".equals(attributeType)) {
                    NonNegativeInteger nonNegativeInteger = new NonNegativeInteger(attribValue);
                    return var2_31;
                } else {
                    if (!"nonPositiveInteger".equals(attributeType)) throw new ADBException("Unknown type ==> " + attributeType);
                    NonPositiveInteger nonPositiveInteger = new NonPositiveInteger(attribValue);
                }
            }
            return var2_31;
        }
        try {
            Method getObjectMethod = extensionMapperClass.getMethod("getTypeObject", String.class, String.class, XMLStreamReader.class);
            Object object = getObjectMethod.invoke(null, attributeNameSpace, attributeType, xmlStreamReader);
            return var2_31;
        }
        catch (NoSuchMethodException e) {
            throw new ADBException("Can not find the getTypeObject method in the extension mapper class ", e);
        }
        catch (IllegalAccessException e) {
            throw new ADBException("Can not access the getTypeObject method in the extension mapper class ", e);
        }
        catch (InvocationTargetException e) {
            throw new ADBException("Can not invoke the getTypeObject method in the extension mapper class ", e);
        }
    }

    static {
        boolean bl = isCustomClassPresent = System.getProperty(SYSTEM_PROPERTY_ADB_CONVERTERUTIL) != null;
        if (isCustomClassPresent) {
            String className = System.getProperty(SYSTEM_PROPERTY_ADB_CONVERTERUTIL);
            try {
                customClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Can not load the converter util class " + className + " using default org.apache.axis2.databinding.utils.ConverterUtil class"));
                isCustomClassPresent = false;
            }
        }
    }

    public static class ObjectConversionException
    extends RuntimeException {
        public ObjectConversionException() {
        }

        public ObjectConversionException(String message) {
            super(message);
        }

        public ObjectConversionException(Throwable cause) {
            super(cause);
        }

        public ObjectConversionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

