/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.utils;

import coldfusion.cloud.aws.dynamodb.utils.CustomNamingStrategy;
import coldfusion.runtime.CaseSensitiveStruct;
import coldfusion.runtime.Struct;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public enum DynamoDeserializationUtil {
    INSTANCE;

    private static ObjectMapper mapper;

    public <T> T structToBean(Struct struct, Class<T> clazz) {
        return (T)mapper.convertValue((Object)struct, clazz);
    }

    public Struct beanToStruct(Object object) {
        return (Struct)mapper.convertValue(object, Struct.class);
    }

    public CaseSensitiveStruct beanToCaseSensitiveStruct(Object object) {
        return (CaseSensitiveStruct)mapper.convertValue(object, CaseSensitiveStruct.class);
    }

    public String beanToString(Object object) throws Exception {
        return mapper.writeValueAsString(object);
    }

    static {
        mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new CustomNamingStrategy());
    }
}

