/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.util;

import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.gcp.BucketReference;
import coldfusion.gcp.storage.consumer.StorageBucketGetOptionConsumer;
import coldfusion.gcp.storage.consumer.StorageBucketTargetOptionConsumer;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.gcp.storage.request.StorageBucketGetOptionBuilder;
import coldfusion.gcp.storage.request.StorageBucketTargetOptionBuilder;
import coldfusion.util.RB;
import com.google.cloud.Role;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import java.util.Map;

public class StorageUtils {
    private static String bucketName;

    public static String getBucketName() {
        return bucketName;
    }

    public static void setBucketName(String bucketName) {
        StorageUtils.bucketName = bucketName;
    }

    public static Bucket getBucketDetails(Storage client, String bucketName, Map bucketGetOption) {
        Bucket bucket = null;
        if (bucketGetOption != null) {
            Storage.BucketGetOption[] options = StorageUtils.getBucketGetOptions(client, bucketName, bucketGetOption);
            bucket = client.get(bucketName, options);
        } else {
            bucket = client.get(bucketName, new Storage.BucketGetOption[0]);
        }
        return bucket;
    }

    public static Storage.BucketGetOption[] getBucketGetOptions(Storage client, String bucketName, Map bucketGetOption) {
        Storage.BucketGetOption[] options = null;
        if (bucketGetOption != null) {
            StorageBucketGetOptionBuilder bucketOptionBuilder = new StorageBucketGetOptionBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)bucketOptionBuilder, bucketGetOption, StorageBucketGetOptionConsumer.INSTANCE.getConsumerMap());
            Storage.BucketGetOption[] bucketOption = new Storage.BucketGetOption[bucketOptionBuilder.getBucketGetOption().size()];
            options = bucketOptionBuilder.getBucketGetOption().toArray(bucketOption);
        }
        return options;
    }

    public static Storage.BucketTargetOption[] getBucketTargetOptions(Storage client, String bucketName, Map bucketTargetOption) {
        Storage.BucketTargetOption[] options = null;
        if (bucketTargetOption != null) {
            StorageBucketTargetOptionBuilder bucketOptionBuilder = new StorageBucketTargetOptionBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)bucketOptionBuilder, bucketTargetOption, StorageBucketTargetOptionConsumer.INSTANCE.getConsumerMap());
            Storage.BucketTargetOption[] bucketOption = new Storage.BucketTargetOption[bucketOptionBuilder.getBucketTargetOption().size()];
            options = bucketOptionBuilder.getBucketTargetOption().toArray(bucketOption);
        }
        return options;
    }

    public static Role getRole(String policyRole) {
        Role role;
        switch (policyRole.toLowerCase()) {
            case "editor": {
                role = Role.editor();
                break;
            }
            case "owner": {
                role = Role.owner();
                break;
            }
            case "viewer": {
                role = Role.viewer();
                break;
            }
            default: {
                role = Role.of((String)policyRole);
            }
        }
        return role;
    }

    public static Blob getBlob(Storage sClient, String blobName, String userProject) {
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        Blob blob = userProject != null ? sClient.get(blobId, new Storage.BlobGetOption[]{Storage.BlobGetOption.userProject((String)userProject)}) : sClient.get(blobId);
        if (blob == null) {
            throw new CFStorageException(RB.getString(BucketReference.class, (String)"KEY_NOT_FOUND", (Object)blobName, (Object)bucketName));
        }
        return blob;
    }
}

