/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.request;

import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.Storage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SignUrlOptionBuilder {
    private String objectName;
    private long duration;
    private TimeUnit timeunit;
    private HttpMethod httpMethod;
    private ServiceAccountCredentials signer;
    private Storage.SignUrlOption withBucketBoundHostname;
    private boolean withContentType;
    private Map<String, String> extHeaders;
    private String hostName;
    private boolean withMd5;
    private boolean withPathStyle;
    private Map<String, String> queryParams;
    private String signatureVersion;
    private boolean withVirtualHostedStyle;
    List<Storage.SignUrlOption> signUrlOptionList = new ArrayList<Storage.SignUrlOption>();

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public TimeUnit getTimeunit() {
        return this.timeunit;
    }

    public void setTimeunit(TimeUnit timeunit) {
        this.timeunit = timeunit;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        this.signUrlOptionList.add(Storage.SignUrlOption.httpMethod((HttpMethod)httpMethod));
    }

    public ServiceAccountCredentials getSigner() {
        return this.signer;
    }

    public void setSigner(ServiceAccountCredentials signer) {
        this.signer = signer;
    }

    public Storage.SignUrlOption getWithBucketBoundHostname() {
        return this.withBucketBoundHostname;
    }

    public void setWithBucketBoundHostname(Storage.SignUrlOption withBucketBoundHostname) {
        this.withBucketBoundHostname = withBucketBoundHostname;
    }

    public boolean isWithContentType() {
        return this.withContentType;
    }

    public void setWithContentType(boolean withContentType) {
        this.withContentType = withContentType;
        if (withContentType) {
            this.signUrlOptionList.add(Storage.SignUrlOption.withContentType());
        }
    }

    public Map<String, String> getExtHeaders() {
        return this.extHeaders;
    }

    public void setExtHeaders(Map<String, String> extHeaders) {
        this.extHeaders = extHeaders;
        this.signUrlOptionList.add(Storage.SignUrlOption.withExtHeaders(extHeaders));
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
        this.signUrlOptionList.add(Storage.SignUrlOption.withHostName((String)hostName));
    }

    public boolean isWithMd5() {
        return this.withMd5;
    }

    public void setWithMd5(boolean withMd5) {
        this.withMd5 = withMd5;
        if (withMd5) {
            this.signUrlOptionList.add(Storage.SignUrlOption.withMd5());
        }
    }

    public boolean isWithPathStyle() {
        return this.withPathStyle;
    }

    public void setWithPathStyle(boolean withPathStyle) {
        this.withPathStyle = withPathStyle;
        if (withPathStyle) {
            this.signUrlOptionList.add(Storage.SignUrlOption.withPathStyle());
        }
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
        this.signUrlOptionList.add(Storage.SignUrlOption.withQueryParams(queryParams));
    }

    public String getSignatureVersion() {
        return this.signatureVersion;
    }

    public void setSignatureVersion(String signatureVersion) {
        this.signatureVersion = signatureVersion;
        if (signatureVersion.equalsIgnoreCase("v2")) {
            this.signUrlOptionList.add(Storage.SignUrlOption.withV2Signature());
        } else if (signatureVersion.equalsIgnoreCase("v4")) {
            this.signUrlOptionList.add(Storage.SignUrlOption.withV2Signature());
        }
    }

    public boolean isWithVirtualHostedStyle() {
        return this.withVirtualHostedStyle;
    }

    public void setWithVirtualHostedStyle(boolean withVirtualHostedStyle) {
        this.withVirtualHostedStyle = withVirtualHostedStyle;
        this.signUrlOptionList.add(Storage.SignUrlOption.withVirtualHostedStyle());
    }

    public List<Storage.SignUrlOption> getSignUrlOption() {
        return this.signUrlOptionList;
    }
}

