/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.storage.consumer.AclConsumer;
import coldfusion.gcp.storage.consumer.BlobIdBuilderConsumer;
import coldfusion.gcp.storage.request.BlobIdBuilder;
import coldfusion.gcp.storage.util.DataTransformation;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BlobInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UpdateBlobInfoConsumer
extends ConsumerMap<BlobInfo.Builder> {
    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static UpdateBlobInfoConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpdateBlobInfoConsumer getInstance() {
        if (instance != null) return instance;
        Class<UpdateBlobInfoConsumer> clazz = UpdateBlobInfoConsumer.class;
        synchronized (UpdateBlobInfoConsumer.class) {
            if (instance != null) return instance;
            instance = new UpdateBlobInfoConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private UpdateBlobInfoConsumer() {
        this.put("acl", new ConsumerValidator((blobInfoBuilder, value) -> {
            List list = this.cast.getListProperty(value);
            ArrayList<Acl> acl = new ArrayList<Acl>();
            Acl.Builder aclBuilder = Acl.newBuilder(null, null);
            for (int i = 0; i < list.size(); ++i) {
                Map map = this.cast.getStringObjectMapProperty(list.get(i));
                ValidatorFiller.INSTANCE.fillObject((Object)aclBuilder, map, (ConsumerMap)AclConsumer.getInstance());
                acl.add(aclBuilder.build());
            }
            blobInfoBuilder.setAcl(acl);
        }, Collections.singletonList(new EmptyListValidator("acl"))));
        this.put("blobId", new ConsumerValidator((blobInfoBuilder, value) -> {
            BlobIdBuilder blobIdBuilder = new BlobIdBuilder();
            Map blobId = this.cast.getStringObjectMapProperty(value);
            ValidatorFiller.INSTANCE.fillObject((Object)blobIdBuilder, blobId, (ConsumerMap)BlobIdBuilderConsumer.getInstance());
            blobInfoBuilder.setBlobId(blobIdBuilder.getBlobId());
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("cacheControl", new ConsumerValidator((blobInfoBuilder, value) -> {
            String cacheControl = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)cacheControl, (String)"cacheControl");
            blobInfoBuilder.setCacheControl(cacheControl);
        }, Collections.emptyList()));
        this.put("contentDisposition", new ConsumerValidator((blobInfoBuilder, value) -> {
            String contentDisposition = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)contentDisposition, (String)"contentDisposition");
            blobInfoBuilder.setContentDisposition(contentDisposition);
        }, Collections.emptyList()));
        this.put("contentEncoding", new ConsumerValidator((blobInfoBuilder, value) -> {
            String contentEncoding = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)contentEncoding, (String)"contentEncoding");
            blobInfoBuilder.setContentEncoding(contentEncoding);
        }, Collections.emptyList()));
        this.put("contentLanguage", new ConsumerValidator((blobInfoBuilder, value) -> {
            String contentLanguage = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)contentLanguage, (String)"contentLanguage");
            blobInfoBuilder.setContentLanguage(contentLanguage);
        }, Collections.emptyList()));
        this.put("contentType", new ConsumerValidator((blobInfoBuilder, value) -> {
            String contentType = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)contentType, (String)"contentType");
            blobInfoBuilder.setContentType(contentType);
        }, Collections.emptyList()));
        this.put("customTime", new ConsumerValidator((blobInfoBuilder, value) -> blobInfoBuilder.setCustomTime(DataTransformation.INSTANCE.getLongValue(value, "customTime")), Collections.emptyList()));
        this.put("eventBasedHold", new ConsumerValidator((blobInfoBuilder, value) -> {
            boolean eventBasedHold = this.cast.getBooleanProperty(value);
            blobInfoBuilder.setEventBasedHold(Boolean.valueOf(eventBasedHold));
        }, Collections.emptyList()));
        this.put("metadata", new ConsumerValidator((blobInfoBuilder, value) -> {
            Map metadata = this.cast.getStringStringMapProperty(value);
            for (String key : metadata.keySet()) {
                String val = (String)metadata.get(key);
                ValidationUtil.validNonBlankString((String)key, (String)"labels");
                ValidationUtil.validNonEmptyString((String)val, (String)"labels");
            }
            blobInfoBuilder.setMetadata(metadata);
        }, Collections.emptyList()));
        this.put("temporaryHold", new ConsumerValidator((blobInfoBuilder, value) -> {
            Boolean temporaryHold = this.cast.getBooleanProperty(value);
            blobInfoBuilder.setTemporaryHold(temporaryHold);
        }, Collections.emptyList()));
    }
}

