/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.gcp.storage.consumer.AclEntityConsumer;
import coldfusion.gcp.storage.request.AclEntityBuilder;
import coldfusion.gcp.storage.request.AclEntityRoleRequest;
import com.google.cloud.storage.Acl;
import java.util.Collections;
import java.util.Map;

public class AclEntityRoleConsumer
extends ConsumerMap<AclEntityRoleRequest> {
    private static final long serialVersionUID = -9077995796092623898L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static AclEntityRoleConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AclEntityRoleConsumer getInstance() {
        if (instance != null) return instance;
        Class<AclEntityRoleConsumer> clazz = AclEntityRoleConsumer.class;
        synchronized (AclEntityRoleConsumer.class) {
            instance = new AclEntityRoleConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AclEntityRoleConsumer() {
        this.put("entity", new ConsumerValidator((aclBuilder, val) -> {
            if (val instanceof String) {
                if (val.equals("ALL_USERS")) {
                    aclBuilder.setEntity((Acl.Entity)Acl.User.ofAllUsers());
                } else if (val.equals("ALL_AUTHENTICATED_USERS")) {
                    aclBuilder.setEntity((Acl.Entity)Acl.User.ofAllAuthenticatedUsers());
                }
            } else {
                Map map = this.cast.getStringObjectMapProperty(val);
                AclEntityBuilder entityBuilder = new AclEntityBuilder();
                ValidatorFiller.INSTANCE.fillObject((Object)entityBuilder, map, (ConsumerMap)AclEntityConsumer.getInstance());
                aclBuilder.setEntity(entityBuilder.getEntity());
            }
        }, Collections.emptyList()));
        this.put("role", new ConsumerValidator((aclBuilder, val) -> {
            String role = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)role, (String)"role");
            aclBuilder.setRole(Acl.Role.valueOfStrict((String)role));
        }, Collections.emptyList()));
    }
}

