/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.s3.BucketReference;
import coldfusion.util.RB;
import java.time.Instant;
import java.util.Collections;
import java.util.Objects;
import software.amazon.awssdk.services.s3.model.ObjectLockRetention;
import software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode;

public class ObjectLockRetentionConsumer
extends ConsumerMap<ObjectLockRetention.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static ObjectLockRetentionConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectLockRetentionConsumer getInstance() {
        if (instance != null) return instance;
        Class<ObjectLockRetentionConsumer> clazz = ObjectLockRetentionConsumer.class;
        synchronized (ObjectLockRetentionConsumer.class) {
            instance = new ObjectLockRetentionConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ObjectLockRetentionConsumer() {
        this.put("mode", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"mode");
            builder.mode(ObjectLockRetentionMode.valueOf((String)input));
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("retainUntilDate", new ConsumerValidator((builder, value) -> {
            Instant instant = this.cast.getInstantProperty(value);
            if (Objects.isNull(instant) || instant.compareTo(Instant.now()) <= 0) {
                throw new ValidationException(RB.getString(BucketReference.class, (String)"futureDateFor", (Object)"retainUntilDate"));
            }
            builder.retainUntilDate(this.cast.getInstantProperty(value));
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }
}

