/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.Struct;
import coldfusion.s3.consumer.DefaultRetentionConsumer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.DefaultRetention;
import software.amazon.awssdk.services.s3.model.ObjectLockConfiguration;
import software.amazon.awssdk.services.s3.model.ObjectLockEnabled;
import software.amazon.awssdk.services.s3.model.ObjectLockRule;

public class ObjectLockConfigurationConsumer
extends ConsumerMap<ObjectLockConfiguration.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static ObjectLockConfigurationConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectLockConfigurationConsumer getInstance() {
        if (instance != null) return instance;
        Class<ObjectLockConfigurationConsumer> clazz = ObjectLockConfigurationConsumer.class;
        synchronized (ObjectLockConfigurationConsumer.class) {
            instance = new ObjectLockConfigurationConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ObjectLockConfigurationConsumer() {
        this.put("objectLockEnabled", new ConsumerValidator((builder, value) -> builder.objectLockEnabled(ObjectLockEnabled.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("defaultRetention", new ConsumerValidator((builder, value) -> {
            Map map = this.cast.getMapProperty(value);
            DefaultRetention.Builder defaultRetentionBuilder = DefaultRetention.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)defaultRetentionBuilder, map, (ConsumerMap)DefaultRetentionConsumer.getInstance());
            builder.rule((ObjectLockRule)ObjectLockRule.builder().defaultRetention((DefaultRetention)defaultRetentionBuilder.build()).build());
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }

    public Struct getStruct(ObjectLockConfiguration objectLockConfiguration) {
        Struct struct = new Struct();
        if (Objects.isNull(objectLockConfiguration)) {
            return struct;
        }
        struct.put((Object)"objectLockEnabled", Optional.ofNullable(objectLockConfiguration.objectLockEnabled()).orElse(null));
        struct.put((Object)"defaultRetention", null);
        Optional.ofNullable(objectLockConfiguration.rule()).ifPresent(objectLockRule -> struct.put((Object)"defaultRetention", (Object)DefaultRetentionConsumer.getInstance().getStruct(objectLockRule.defaultRetention())));
        return null;
    }
}

