/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractMultiClassCompiler;

public class JRJavacCompiler
extends JRAbstractMultiClassCompiler {
    @Override
    public String compileClasses(File[] sourceFiles, String classpath) throws JRException {
        String[] source = new String[sourceFiles.length + 3];
        source[0] = "javac";
        source[1] = "-classpath";
        source[2] = classpath;
        for (int i = 0; i < sourceFiles.length; ++i) {
            source[i + 3] = sourceFiles[i].getPath();
        }
        try {
            Process compile = Runtime.getRuntime().exec(source);
            InputStream errFile = compile.getErrorStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int count = 0;
            do {
                if ((count = errFile.read(buffer)) <= 0) continue;
                baos.write(buffer, 0, count);
            } while (count >= 0);
            if (baos.toString().indexOf("error") != -1) {
                return baos.toString();
            }
            return null;
        }
        catch (Exception e) {
            StringBuffer files = new StringBuffer();
            for (int i = 0; i < sourceFiles.length; ++i) {
                files.append(sourceFiles[i].getPath());
                files.append(' ');
            }
            throw new JRException("Error compiling report java source files : " + files, e);
        }
    }
}

