/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.internal.wsdl20.DescriptionImpl;
import org.apache.woden.internal.wsdl20.InterfaceFaultImpl;
import org.apache.woden.internal.wsdl20.InterfaceOperationImpl;
import org.apache.woden.internal.wsdl20.WSDLComponentImpl;
import org.apache.woden.types.NCName;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.InterfaceFault;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.editable.EdInterface;
import org.apache.woden.wsdl20.editable.EdInterfaceFault;
import org.apache.woden.wsdl20.editable.EdInterfaceOperation;
import org.apache.woden.wsdl20.fragids.ComponentPart;
import org.apache.woden.wsdl20.fragids.FragmentIdentifier;
import org.apache.woden.wsdl20.fragids.InterfacePart;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultElement;
import org.apache.woden.wsdl20.xml.InterfaceOperationElement;
import org.apache.woden.wsdl20.xml.WSDLElement;

public class InterfaceImpl
extends WSDLComponentImpl
implements Interface,
InterfaceElement,
EdInterface {
    private WSDLElement fParentElem = null;
    private Description fDescriptionComponent = null;
    private NCName fName = null;
    private List fExtends = new Vector();
    private List fStyleDefault = new Vector();
    private List fInterfaceFaultElements = new Vector();
    private List fInterfaceOperationElements = new Vector();

    public QName getName() {
        QName name = null;
        if (this.fName != null) {
            String[] tns = DescriptionImpl.getTargetNamespaceAndPrefix(this);
            name = new QName(tns[0], this.fName.toString(), tns[1]);
        }
        return name;
    }

    public Interface getExtendedInterface(QName qname) {
        Interface intface = this.fDescriptionComponent.getInterface(qname);
        return intface;
    }

    public Interface[] getExtendedInterfaces() {
        Vector<Interface> interfaces = new Vector<Interface>();
        for (QName qn : this.fExtends) {
            Interface intface = this.getExtendedInterface(qn);
            if (intface == null) continue;
            interfaces.add(intface);
        }
        Interface[] array = new Interface[interfaces.size()];
        interfaces.toArray(array);
        return array;
    }

    public InterfaceFault[] getInterfaceFaults() {
        InterfaceFault[] array = new InterfaceFault[this.fInterfaceFaultElements.size()];
        this.fInterfaceFaultElements.toArray(array);
        return array;
    }

    public InterfaceFault getInterfaceFault(QName faultName) {
        return (InterfaceFault)this.getInterfaceFaultElement(faultName);
    }

    public InterfaceFault[] getAllInterfaceFaults() {
        Vector allInterfaces = new Vector();
        Vector allInterfaceFaults = new Vector();
        this.getAllInterfaceFaults(this, allInterfaces, allInterfaceFaults);
        InterfaceFault[] array = new InterfaceFault[allInterfaceFaults.size()];
        allInterfaceFaults.toArray(array);
        return array;
    }

    public InterfaceFault getFromAllInterfaceFaults(QName faultName) {
        InterfaceFault theFault = null;
        if (faultName != null) {
            InterfaceFault[] faults = this.getAllInterfaceFaults();
            for (int i = 0; i < faults.length; ++i) {
                InterfaceFault fault = faults[i];
                if (!faultName.equals(fault.getName())) continue;
                theFault = fault;
                break;
            }
        }
        return theFault;
    }

    public InterfaceOperation[] getInterfaceOperations() {
        InterfaceOperation[] array = new InterfaceOperation[this.fInterfaceOperationElements.size()];
        this.fInterfaceOperationElements.toArray(array);
        return array;
    }

    public InterfaceOperation getInterfaceOperation(QName operName) {
        return (InterfaceOperation)this.getInterfaceOperationElement(operName);
    }

    public InterfaceOperation[] getAllInterfaceOperations() {
        Vector allInterfaces = new Vector();
        Vector allInterfaceOperations = new Vector();
        this.getAllInterfaceOperations(this, allInterfaces, allInterfaceOperations);
        InterfaceOperation[] array = new InterfaceOperation[allInterfaceOperations.size()];
        allInterfaceOperations.toArray(array);
        return array;
    }

    public InterfaceOperation getFromAllInterfaceOperations(QName operName) {
        InterfaceOperation theOper = null;
        if (operName != null) {
            InterfaceOperation[] opers = this.getAllInterfaceOperations();
            for (int i = 0; i < opers.length; ++i) {
                InterfaceOperation oper = opers[i];
                if (!operName.equals(oper.getName())) continue;
                theOper = oper;
                break;
            }
        }
        return theOper;
    }

    public InterfaceElement toElement() {
        return this;
    }

    public boolean isEquivalentTo(WSDLComponent comp) {
        if (this == comp) {
            return true;
        }
        if (!(comp instanceof Interface)) {
            return false;
        }
        Interface other = (Interface)comp;
        QName myName = this.getName();
        if (myName != null && !myName.equals(other.getName())) {
            return false;
        }
        HashSet thisExtendsSet = new HashSet(this.fExtends);
        QName[] otherExtends = ((InterfaceElement)other).getExtendedInterfaceNames();
        HashSet<QName> otherExtendsSet = new HashSet<QName>();
        for (int i = 0; i < otherExtends.length; ++i) {
            otherExtendsSet.add(otherExtends[i]);
        }
        if (thisExtendsSet.size() != otherExtendsSet.size()) {
            return false;
        }
        return thisExtendsSet.containsAll(otherExtendsSet) && otherExtendsSet.containsAll(thisExtendsSet);
    }

    public boolean equals(WSDLComponent comp) {
        if (this == comp) {
            return true;
        }
        if (!(comp instanceof Interface)) {
            return false;
        }
        Interface other = (Interface)comp;
        QName myName = this.getName();
        if (myName != null && !myName.equals(other.getName())) {
            return false;
        }
        HashSet thisExtendsSet = new HashSet(this.fExtends);
        QName[] otherExtends = ((InterfaceElement)other).getExtendedInterfaceNames();
        HashSet<QName> otherExtendsSet = new HashSet<QName>();
        for (int i = 0; i < otherExtends.length; ++i) {
            otherExtendsSet.add(otherExtends[i]);
        }
        if (thisExtendsSet.size() != otherExtendsSet.size()) {
            return false;
        }
        return thisExtendsSet.containsAll(otherExtendsSet) && otherExtendsSet.containsAll(thisExtendsSet);
    }

    public void setName(NCName name) {
        this.fName = name;
    }

    public void addStyleDefaultURI(URI uri) {
        if (uri != null) {
            this.fStyleDefault.add(uri);
        }
    }

    public URI[] getStyleDefault() {
        URI[] array = new URI[this.fStyleDefault.size()];
        this.fStyleDefault.toArray(array);
        return array;
    }

    public void addExtendedInterfaceName(QName interfaceName) {
        if (interfaceName != null) {
            this.fExtends.add(interfaceName);
        }
    }

    public void removeExtendedInterfaceName(QName interfaceName) {
        if (interfaceName != null) {
            this.fExtends.remove(interfaceName);
        }
    }

    public QName[] getExtendedInterfaceNames() {
        QName[] array = new QName[this.fExtends.size()];
        this.fExtends.toArray(array);
        return array;
    }

    public InterfaceElement getExtendedInterfaceElement(QName interfaceName) {
        Description desc = (Description)this.fParentElem;
        InterfaceElement intface = (InterfaceElement)desc.getInterface(interfaceName);
        return intface;
    }

    public InterfaceElement[] getExtendedInterfaceElements() {
        Vector<InterfaceElement> interfaces = new Vector<InterfaceElement>();
        for (QName qn : this.fExtends) {
            InterfaceElement intface = this.getExtendedInterfaceElement(qn);
            if (intface == null) continue;
            interfaces.add(intface);
        }
        InterfaceElement[] array = new InterfaceElement[interfaces.size()];
        interfaces.toArray(array);
        return array;
    }

    public InterfaceFaultElement addInterfaceFaultElement() {
        InterfaceFaultImpl fault = new InterfaceFaultImpl();
        this.fInterfaceFaultElements.add(fault);
        fault.setParentElement(this);
        return fault;
    }

    public InterfaceFaultElement getInterfaceFaultElement(QName faultName) {
        InterfaceFaultElement fault = null;
        if (faultName != null) {
            InterfaceFaultElement tempFault2 = null;
            for (InterfaceFaultElement tempFault2 : this.fInterfaceFaultElements) {
                if (!faultName.equals(tempFault2.getName())) continue;
                fault = tempFault2;
                break;
            }
        }
        return fault;
    }

    public InterfaceFaultElement[] getInterfaceFaultElements() {
        InterfaceFaultElement[] array = new InterfaceFaultElement[this.fInterfaceFaultElements.size()];
        this.fInterfaceFaultElements.toArray(array);
        return array;
    }

    public InterfaceOperationElement addInterfaceOperationElement() {
        InterfaceOperationImpl operation = new InterfaceOperationImpl();
        this.fInterfaceOperationElements.add(operation);
        operation.setParentElement(this);
        return operation;
    }

    public InterfaceOperationElement getInterfaceOperationElement(QName operName) {
        InterfaceOperationElement oper = null;
        if (operName != null) {
            InterfaceOperationElement tempOper2 = null;
            for (InterfaceOperationElement tempOper2 : this.fInterfaceOperationElements) {
                if (!operName.equals(tempOper2.getName())) continue;
                oper = tempOper2;
                break;
            }
        }
        return oper;
    }

    public InterfaceOperationElement[] getInterfaceOperationElements() {
        InterfaceOperationElement[] array = new InterfaceOperationElement[this.fInterfaceOperationElements.size()];
        this.fInterfaceOperationElements.toArray(array);
        return array;
    }

    void setParentElement(WSDLElement parent) {
        this.fParentElem = parent;
    }

    public WSDLElement getParentElement() {
        return this.fParentElem;
    }

    private void getAllInterfaceOperations(Interface interfac, List allInterfaces, List allOpers) {
        if (this.containsComponent((WSDLComponent)interfac, allInterfaces)) {
            return;
        }
        allInterfaces.add(interfac);
        InterfaceOperation[] declaredOpers = interfac.getInterfaceOperations();
        for (int i = 0; i < declaredOpers.length; ++i) {
            InterfaceOperation oper = declaredOpers[i];
            if (this.containsComponent((WSDLComponent)oper, allOpers)) continue;
            allOpers.add(oper);
        }
        Interface[] extInts = interfac.getExtendedInterfaces();
        for (int j = 0; j < extInts.length; ++j) {
            this.getAllInterfaceOperations(extInts[j], allInterfaces, allOpers);
        }
    }

    private void getAllInterfaceFaults(Interface interfac, List allInterfaces, List allFaults) {
        if (this.containsComponent((WSDLComponent)interfac, allInterfaces)) {
            return;
        }
        allInterfaces.add(interfac);
        InterfaceFault[] declaredFaults = interfac.getInterfaceFaults();
        for (int i = 0; i < declaredFaults.length; ++i) {
            InterfaceFault fault = declaredFaults[i];
            if (this.containsComponent((WSDLComponent)fault, allFaults)) continue;
            allFaults.add(fault);
        }
        Interface[] extInts = interfac.getExtendedInterfaces();
        for (int j = 0; j < extInts.length; ++j) {
            this.getAllInterfaceFaults(extInts[j], allInterfaces, allFaults);
        }
    }

    void setDescriptionComponent(Description desc) {
        this.fDescriptionComponent = desc;
    }

    Description getDescriptionComponent() {
        return this.fDescriptionComponent;
    }

    public FragmentIdentifier getFragmentIdentifier() {
        return new FragmentIdentifier((ComponentPart)new InterfacePart(this.fName));
    }

    public void addExtendedInterface(Interface interfaceComp) {
    }

    public EdInterfaceFault addInterfaceFault() {
        return null;
    }

    public EdInterfaceOperation addInterfaceOperation() {
        return null;
    }
}

