/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.VariableScope;
import coldfusion.saml.IdpConfiguration;
import coldfusion.saml.RequestOptions;
import coldfusion.saml.SAMLServiceImpl;
import coldfusion.saml.SamlAuth;
import coldfusion.saml.SamlBindings;
import coldfusion.saml.SamlCacheHelper;
import coldfusion.saml.SamlHelper;
import coldfusion.saml.SamlState;
import coldfusion.saml.SpConfiguration;
import coldfusion.saml.util.SignatureCreator;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.lang.IncludeTag;
import coldfusion.util.RB;
import com.onelogin.saml2.authn.AuthnRequest;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.logout.LogoutRequest;
import com.onelogin.saml2.servlet.ServletUtils;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Util;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;

public class SamlRequestBuilder {
    public final String ssoTemplatePath = "/WEB-INF/saml/login.cfm";
    public final String logoutTemplatePath = "/WEB-INF/saml/logout.cfm";
    public static final String IDP = "IDP";
    public static final String SP = "SP";
    public static final String NAME = "NAME";
    public static final String APPLICATION_SCOPE_SECURITY_KEY = "SECURITY";
    public static final String APPLICATION_SCOPE_SETTINGS_KEY = "SAMLSETTINGS";
    public static final String IDP_URL = "URL";
    public static final String IDP_FILE = "FILE";
    public static final String IDP_RAW = "RAWXML";
    public static final String METADATA_REFRESH_INTERVAL = "REFRESHINTERVAL";
    public static final String ENTITYID = "ENTITYID";
    public static final String SSOURL = "SSOURL";
    public static final String SSOBINDING = "SSOBINDING";
    public static final String SLOURL = "SLOURL";
    public static final String SLOBINDING = "SLOBINDING";
    public static final String LOGOUTRESPONSEURL = "LOGOUTRESPONSEURL";
    public static final String SIGNREQUESTS = "SIGNREQUESTS";
    public static final String ENCRYPTREQUESTS = "ENCRYPTREQUESTS";
    public static final String SIGNCERTIFICATE = "SIGNCERTIFICATE";
    public static final String ENCRYPTCERTIFICATE = "ENCRYPTCERTIFICATE";
    public static final String ACSURL = "ACSURL";
    public static final String ACSBINDING = "ACSBINDING";
    public static final String WANTASSERTIONSSIGNED = "WANTASSERTIONSSIGNED";
    public static final String LOGOUTRESPONSESIGNED = "LOGOUTRESPONSESIGNED";
    public static final String KEYSTORE = "KEYSTORE";
    public static final String PASSWORD = "PASSWORD";
    public static final String KEYSTOREALIAS = "KEYSTOREALIAS";
    public static final String RELAYSTATE = "RELAYSTATE";
    public static final String TEMPLATE = "TEMPLATE";
    public static final String SAMLREQUEST = "SAMLREQUEST";
    public static final String LOGOUTREQUEST = "LOGOUTREQUEST";
    public static final String IDPURL = "IDPURL";
    public static final String LOGIN_NAMEID = "NAMEID";
    public static final String LOGIN_NAMEID_FORMAT = "NAMEIDFORMAT";
    public static final String LOGIN_NAMEIDQUALIFIER = "NAMEIDQUALIFIER";
    public static final String LOGIN_NAMEIDSPQUALIFIER = "NAMEIDSPQUALIFIER";
    public static final String LOGIN_SESSIONINDEX = "SESSIONINDEX";
    public static final String COLDFUSION = "COLDFUSION";
    public static final String LIFETIME = "LIFETIME";
    public static final int DEFAULT_LIFETIME = 300;
    private String idpConfig;
    private String spConfig;
    private static Map<String, RequestOptions> requestMap = new ConcurrentHashMap<String, RequestOptions>();

    public String buildAuthnRequest(Map struct) {
        IdpConfiguration idpConfiguration = this.getIdp(struct);
        SpConfiguration spConfiguration = this.getSp(struct);
        Saml2Settings settings = SamlHelper.getSamlSettings(idpConfiguration, spConfiguration, struct);
        AuthnRequest request = new AuthnRequest(settings);
        return request.getAuthnRequestXml();
    }

    public String buildLogoutRequest(Map struct) {
        SpConfiguration spConfiguration;
        IdpConfiguration idpConfiguration = this.getIdp(struct);
        Saml2Settings settings = SamlHelper.getSamlSettings(idpConfiguration, spConfiguration = this.getSp(struct));
        if (settings.getIdpSingleLogoutServiceUrl() == null) {
            throw new SamlRequestException(RB.getString((Object)this, (String)"LogoutMissingSlo"));
        }
        FusionContext fusionContext = FusionContext.getCurrent();
        LogoutRequest request = null;
        String nameId = this.getStructEmptyValue(LOGIN_NAMEID, struct);
        String nameIdFormat = this.getStructEmptyValue(LOGIN_NAMEID_FORMAT, struct);
        String sessionIndex = this.getStructEmptyValue(LOGIN_SESSIONINDEX, struct);
        String nameIdNameQualifier = this.getStructEmptyValue(LOGIN_NAMEIDQUALIFIER, struct);
        String nameIdSpNameQualifier = this.getStructEmptyValue(LOGIN_NAMEIDSPQUALIFIER, struct);
        try {
            request = new LogoutRequest(settings, ServletUtils.makeHttpRequest((HttpServletRequest)fusionContext.getRequest()), nameId, sessionIndex, nameIdFormat, nameIdNameQualifier, nameIdSpNameQualifier);
            return request.getLogoutRequestXml();
        }
        catch (com.onelogin.saml2.exception.XMLEntityException e) {
            throw new XMLEntityException();
        }
    }

    public void initAuthRequest(Map struct) {
        IdpConfiguration idpConfiguration = this.getIdp(struct);
        SpConfiguration spConfiguration = this.getSp(struct);
        Saml2Settings settings = SamlHelper.getSamlSettings(idpConfiguration, spConfiguration, struct);
        int lifetime = struct.get(LIFETIME) != null ? (Integer)struct.get(LIFETIME) : 300;
        RequestOptions rq = new RequestOptions(this.idpConfig, this.spConfig, SamlState.LOGIN_PENDING, lifetime);
        FusionContext fusionContext = FusionContext.getCurrent();
        SamlAuth auth = null;
        if (StringUtils.equals((CharSequence)settings.getIdpSingleSignOnServiceBinding(), (CharSequence)SamlBindings.REDIRECT.toString())) {
            try {
                auth = new SamlAuth(settings, fusionContext.getRequest(), fusionContext.getResponse(), rq, spConfiguration);
                auth.login((String)struct.get(RELAYSTATE));
            }
            catch (SettingsException | IOException e) {
                throw new SamlRequestException(RB.getString((Object)this, (String)"CannotLoadSPCert"));
            }
        }
        AuthnRequest authnRequest = new AuthnRequest(settings, false, false, true);
        String id = authnRequest.getId();
        SamlCacheHelper.updateCache(id, rq, spConfiguration);
        String requestXml = null;
        try {
            requestXml = authnRequest.getAuthnRequestXml();
            if (settings.getAuthnRequestsSigned()) {
                requestXml = new SignatureCreator().signRequest(requestXml, settings, authnRequest.getId());
            }
            String template = null;
            template = struct.containsKey(TEMPLATE) ? (String)struct.get(TEMPLATE) : "/WEB-INF/saml/login.cfm";
            if (!template.startsWith("/")) {
                template = "/" + template;
            }
            this.checkTemplateFileExists(template);
            String relayState = "";
            if (struct.containsKey(RELAYSTATE)) {
                relayState = (String)struct.get(RELAYSTATE);
            }
            VariableScope varScope = FusionContext.getCurrent().pageContext.getVariableScope();
            varScope.put((Object)SAMLREQUEST, (Object)Util.base64encoder((String)requestXml));
            varScope.put((Object)RELAYSTATE, (Object)relayState);
            varScope.put((Object)IDPURL, (Object)settings.getIdpSingleSignOnServiceUrl().toString());
            IncludeTag includeTag = new IncludeTag();
            includeTag.setPageContext((PageContext)FusionContext.getCurrent().pageContext);
            includeTag.setTemplate(template);
            try {
                includeTag.doStartTag();
            }
            catch (JspException e) {
                throw new SamlRequestException(RB.getString((Object)this, (String)"IncludePageError"));
            }
        }
        catch (Throwable t) {
            throw new SamlRequestException(t.getMessage(), t);
        }
    }

    public void initLogoutRequest(Map struct) {
        SpConfiguration spConfiguration;
        IdpConfiguration idpConfiguration = this.getIdp(struct);
        Saml2Settings settings = SamlHelper.getSamlSettings(idpConfiguration, spConfiguration = this.getSp(struct));
        if (settings.getIdpSingleLogoutServiceUrl() == null) {
            throw new SamlRequestException(RB.getString((Object)this, (String)"LogoutMissingSlo"));
        }
        int lifetime = struct.get(LIFETIME) != null ? (Integer)struct.get(LIFETIME) : 300;
        RequestOptions rq = new RequestOptions(this.idpConfig, this.spConfig, SamlState.LOGOUT_PENDING, lifetime);
        FusionContext fusionContext = FusionContext.getCurrent();
        SamlAuth auth = null;
        String nameId = this.getStructValue(LOGIN_NAMEID, struct);
        String nameIdFormat = this.getStructValue(LOGIN_NAMEID_FORMAT, struct);
        String sessionIndex = this.getStructValue(LOGIN_SESSIONINDEX, struct);
        String nameIdNameQualifier = this.getStructValue(LOGIN_NAMEIDQUALIFIER, struct);
        String nameIdSpNameQualifier = this.getStructValue(LOGIN_NAMEIDSPQUALIFIER, struct);
        String relayState = this.getStructValue(RELAYSTATE, struct);
        if (StringUtils.equals((CharSequence)settings.getIdpSingleLogoutServiceBinding(), (CharSequence)SamlBindings.REDIRECT.toString())) {
            try {
                auth = new SamlAuth(settings, fusionContext.getRequest(), fusionContext.getResponse(), rq, spConfiguration);
                auth.logout(relayState, nameId, sessionIndex, false, nameIdFormat, nameIdNameQualifier, nameIdSpNameQualifier);
            }
            catch (SettingsException | IOException e) {
                throw new SamlRequestException(RB.getString((Object)this, (String)"CannotLoadSPCert"));
            }
            catch (com.onelogin.saml2.exception.XMLEntityException e) {
                throw new XMLEntityException();
            }
        }
        LogoutRequest logoutRequest = null;
        try {
            logoutRequest = new LogoutRequest(settings, ServletUtils.makeHttpRequest((HttpServletRequest)fusionContext.getRequest()), nameId, sessionIndex, nameIdFormat, nameIdNameQualifier, nameIdSpNameQualifier);
            String id = logoutRequest.getId();
            SamlCacheHelper.updateCache(id, rq, spConfiguration);
        }
        catch (com.onelogin.saml2.exception.XMLEntityException e1) {
            throw new XMLEntityException();
        }
        String requestXml = null;
        try {
            requestXml = logoutRequest.getLogoutRequestXml();
            if (settings.getLogoutRequestSigned()) {
                requestXml = new SignatureCreator().signRequest(requestXml, settings, logoutRequest.id);
            }
            String template = null;
            template = struct.containsKey(TEMPLATE) ? (String)struct.get(TEMPLATE) : "/WEB-INF/saml/logout.cfm";
            if (!template.startsWith("/")) {
                template = "/" + template;
            }
            this.checkTemplateFileExists(template);
            relayState = "";
            if (struct.containsKey(RELAYSTATE)) {
                relayState = (String)struct.get(RELAYSTATE);
            }
            VariableScope varScope = FusionContext.getCurrent().pageContext.getVariableScope();
            varScope.put((Object)LOGOUTREQUEST, (Object)Util.base64encoder((String)requestXml));
            varScope.put((Object)RELAYSTATE, (Object)relayState);
            varScope.put((Object)IDPURL, (Object)settings.getIdpSingleLogoutServiceUrl().toString());
            IncludeTag includeTag = new IncludeTag();
            includeTag.setPageContext((PageContext)FusionContext.getCurrent().pageContext);
            includeTag.setTemplate(template);
            try {
                includeTag.doStartTag();
            }
            catch (JspException e) {
                throw new SamlRequestException(RB.getString((Object)this, (String)"IncludePageError"));
            }
        }
        catch (Throwable t) {
            throw new SamlRequestException(t.getMessage(), t);
        }
    }

    private void checkTemplateFileExists(String path) {
        FusionContext fc = FusionContext.getCurrent();
        if (!Files.exists(Paths.get(fc.getRealPath(path), new String[0]), new LinkOption[0])) {
            throw new SamlRequestException(RB.getString((Object)this, (String)"TemplateFileMissing", (Object)path));
        }
    }

    private String getStructValue(String key, Map struct) {
        if (struct.containsKey(key)) {
            return (String)struct.get(key);
        }
        return null;
    }

    private String getStructEmptyValue(String key, Map struct) {
        if (struct.containsKey(key)) {
            return (String)struct.get(key);
        }
        return "";
    }

    public static RequestOptions getRequestOptions(String key) {
        RequestOptions rq = requestMap.get(key);
        return rq;
    }

    private IdpConfiguration getIdp(Map struct) {
        String idpName = null;
        IdpConfiguration config = null;
        Map idpMap = (Map)struct.get(IDP);
        if (idpMap != null) {
            this.idpConfig = idpName = (String)idpMap.get(NAME);
        }
        if (idpName != null) {
            Map appStruct = SamlHelper.getStructFromAppScope(IDP, idpName);
            if (appStruct != null) {
                config = SamlHelper.createIdpConfigFromStruct(appStruct);
            }
            if (config == null) {
                config = (IdpConfiguration)ServiceFactory.getSamlService().getIdpMetadata(idpName);
            }
            if (config == null) {
                throw new SamlRequestException(RB.getString((Object)this, (String)"MissingIDPConfig"));
            }
            List<String> errors = SamlHelper.validateIdpSettings(config);
            if (!errors.isEmpty()) {
                throw new SAMLServiceImpl.IdpException(errors);
            }
        }
        return config;
    }

    private SpConfiguration getSp(Map struct) {
        String spName = null;
        SpConfiguration config = null;
        Map spMap = (Map)struct.get(SP);
        if (spMap != null) {
            this.spConfig = spName = (String)spMap.get(NAME);
        }
        if (spName != null) {
            Map appStruct = SamlHelper.getStructFromAppScope(SP, spName);
            if (appStruct != null) {
                config = SamlHelper.createSpConfigFromStruct(appStruct);
            }
            if (config == null) {
                config = (SpConfiguration)ServiceFactory.getSamlService().getSpMetadata(spName);
            }
            if (config == null) {
                throw new SamlRequestException(RB.getString((Object)this, (String)"MissingSPConfig"));
            }
            List<String> errors = SamlHelper.validateSpSettings(config);
            if (!errors.isEmpty()) {
                throw new SAMLServiceImpl.SpException(errors);
            }
        }
        return config;
    }

    public class SamlRequestException
    extends ApplicationException {
        public String message;

        public SamlRequestException(String message) {
            this.message = "";
            this.message = message;
        }

        public SamlRequestException(String message, Throwable t) {
            super(t);
            this.message = "";
            this.message = message;
        }
    }

    public class XMLEntityException
    extends ApplicationException {
    }
}

