/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.flex;

import coldfusion.eventgateway.CFEvent;
import coldfusion.eventgateway.Gateway;
import coldfusion.eventgateway.GenericGateway;
import coldfusion.eventgateway.Logger;
import coldfusion.eventgateway.flex.CFDataServicesAdapter;
import coldfusion.eventgateway.flex.FlexGatewayExceptions;
import coldfusion.eventgateway.flex.rmi.CFToDataManagementProxy;
import coldfusion.flash.messaging.io.RemotingContext;
import coldfusion.flash.messaging.io.amf.Translator.CFASSerializer;
import coldfusion.flex.rmi.DataServicesRMIRegistry;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.ListFunc;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceException;
import flex.messaging.Destination;
import flex.messaging.MessageBroker;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class FlexDataManagementGateway
extends GenericGateway
implements Gateway {
    private static final String LOG = "flexdatamanagementgateway";
    private String config;
    private String host = null;
    private String destination;
    private Logger log;
    private Properties configProperties;
    private int rmiport = DataServicesRMIRegistry.getDefaultPort();

    public FlexDataManagementGateway(String gatewayID, String conf) throws ServiceException {
        super(gatewayID);
        this.config = conf;
        this.log = this.getGatewayServices().getLogger(LOG);
        this.readConfig();
    }

    protected void startGateway() throws Exception {
        this.status = 1;
        this.readConfig();
        this.status = 2;
    }

    protected void stopGateway() throws Exception {
        this.status = 4;
    }

    public String outgoingMessage(CFEvent cfmsg) {
        Object o;
        String ret = "TRUE";
        this.log.debug("+++++++++++++++Entering outgoingMessage+++++++++++++++++=");
        String dest = this.destination;
        if (dest == null && (o = cfmsg.getData().get("destination")) instanceof String) {
            dest = (String)o;
        }
        if (dest == null) {
            throw new UnknownDestinationException();
        }
        this.log.debug("+++++++++++++++Found destination: " + dest + "+++++++++++++++");
        if (this.host == null) {
            MessageBroker mb = MessageBroker.getMessageBroker(null);
            if (mb == null) {
                throw new FlexGatewayExceptions.CantFindFlexException();
            }
            Service service = mb.getService("data-service");
            if (service == null) {
                throw new FlexGatewayExceptions.CantFindFlexService("data-service");
            }
            Destination d = service.getDestination(dest);
            if (d == null) {
                throw new FlexGatewayExceptions.CantFindFlexDestination("Data Management", dest);
            }
            ServiceAdapter a = d.getAdapter();
            if (a == null || !(a instanceof CFDataServicesAdapter)) {
                throw new FlexGatewayExceptions.NotCFDestination("Data Management", dest);
            }
            CFDataServicesAdapter adapter = (CFDataServicesAdapter)a;
            Map msg = this.convertToFlexMessage(cfmsg);
            try {
                adapter.performDataServiceTransaction(msg);
            }
            catch (Exception e) {
                throw new BadEventStructException(e.getMessage());
            }
        }
        CFToDataManagementProxy proxy = this.findFlexProxy(dest);
        this.log.debug("+++++++++++++++Found RMI proxy+++++++++++++++");
        try {
            Map msg = this.convertToFlexMessage(cfmsg);
            boolean ok = proxy.performDataServiceTransaction(msg);
            if (!ok) {
                ret = "FALSE: Flex Server returned failure, see Flex server log messages for details.";
            }
        }
        catch (ServerException se) {
            this.log.debug("+++++++++++++++Caught Server Exception while sending message: " + se.toString() + "+++++++++++++++");
            throw new BadEventStructException(se.detail.getMessage());
        }
        catch (RemoteException e) {
            this.log.debug("+++++++++++++++Caught exception while converting or sending message: " + e.toString() + "+++++++++++++++");
            throw new BadEventStructException(e.detail.getMessage());
        }
        return ret;
    }

    private void readConfig() throws ServiceException {
        if (this.config == null || this.config.trim().length() == 0) {
            return;
        }
        try {
            this.configProperties = new Properties();
            FileInputStream propsFile = new FileInputStream(this.config);
            this.configProperties.load(propsFile);
            propsFile.close();
        }
        catch (IOException e) {
            throw new ServiceException("Unable to read configuration file: " + e.toString());
        }
        this.destination = this.configProperties.getProperty("destination");
        this.host = this.configProperties.getProperty("host");
        this.host = this.host != null ? this.host.trim() : null;
    }

    private synchronized CFToDataManagementProxy findFlexProxy(String destination) throws UnableToFindProxyException, UnableToContactRMIRegistryException {
        String name = "//" + this.host + ":" + this.rmiport + "/" + "cfdataserviceadapter/" + destination;
        try {
            return (CFToDataManagementProxy)Naming.lookup(name);
        }
        catch (NotBoundException nbe) {
            throw new UnableToFindProxyException(destination, this.host, this.rmiport);
        }
        catch (RemoteException remex) {
            throw new UnableToContactRMIRegistryException(destination, this.host, this.rmiport, remex);
        }
        catch (Exception e) {
            throw new UnableToFindProxyException(destination, this.host, this.rmiport);
        }
    }

    private Map convertToFlexMessage(CFEvent cfmsg) throws MissingActionException, BadChangesException, BadBatchException, BadBatchEntryException {
        RemotingContext rContext;
        HashMap<String, Object> out = new HashMap<String, Object>();
        Map data = cfmsg.getData();
        String action = (String)data.get("action");
        if (action == null) {
            throw new MissingActionException();
        }
        if (action.equalsIgnoreCase("update")) {
            Object o = data.get("changes");
            if (o instanceof String) {
                data.put("changes", ListFunc.ListToArray((String)((String)o), (String)","));
            } else if (o != null && !(o instanceof FastArray)) {
                throw new BadChangesException();
            }
        } else if (action.equalsIgnoreCase("batch")) {
            Object list = data.get("changes");
            if (!(list instanceof Array)) {
                throw new BadBatchException();
            }
            Array listArray = (Array)list;
            for (int i = 0; i < listArray.size(); ++i) {
                Object ae = listArray.get(i);
                if (!(ae instanceof Struct)) {
                    throw new BadBatchEntryException(i);
                }
                Map change = (Map)ae;
                for (String key : change.keySet()) {
                    Object val = change.remove(key);
                    change.put(key.toLowerCase(), val);
                }
            }
        }
        if ((rContext = RemotingContext.getCurrent()) == null) {
            rContext = new RemotingContext();
            RemotingContext.setCurrent((RemotingContext)rContext);
        }
        CFASSerializer serializer = null;
        if (!rContext.isCallthroughCFSpecificEndPoint()) {
            serializer = new CFASSerializer();
        }
        if (this.configProperties != null) {
            rContext.setProperties((Map)this.configProperties);
        }
        rContext.setProperties(data);
        for (String key : data.keySet()) {
            if (rContext.isCallthroughCFSpecificEndPoint()) {
                out.put(key.toLowerCase(), data.get(key));
                continue;
            }
            out.put(key.toLowerCase(), serializer.translate(data.get(key)));
        }
        return out;
    }

    public class BadEventStructException
    extends ApplicationException {
        public String err;

        public BadEventStructException(String err) {
            this.err = err;
        }
    }

    public class BadBatchEntryException
    extends ApplicationException {
        public int index;

        public BadBatchEntryException(int i) {
            this.index = i;
        }
    }

    public class BadBatchException
    extends ApplicationException {
    }

    public class BadChangesException
    extends ApplicationException {
    }

    public class MissingActionException
    extends ApplicationException {
    }

    public class UnknownDestinationException
    extends ApplicationException {
    }

    public class UnableToContactRMIRegistryException
    extends ApplicationException {
        public String msg;
        public String destination;
        public String host;

        public UnableToContactRMIRegistryException(String destination, String host, int port, Throwable throwable) {
            this.msg = throwable.toString();
            this.destination = destination;
            this.host = host + ":" + port;
        }
    }

    public class UnableToFindProxyException
    extends ApplicationException {
        public String destination;
        public String host;

        public UnableToFindProxyException(String destination, String host, int port) {
            this.destination = destination;
            this.host = (host != null ? host : "localhost") + ":" + port;
        }
    }
}

