/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server;

import coldfusion.log.CFLogs;
import coldfusion.server.WebSocketService;
import coldfusion.tagext.net.websocket.server.cluster.WebSocketClusterManager;
import coldfusion.tagext.net.websocket.server.netty.WSNettyPipelineFactory;
import coldfusion.tagext.net.websocket.server.proxy.WSProxyServer;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class WebSocketEngine {
    private boolean isRunning;
    private Channel serverSocketChannel;
    private Channel serverSecureSocketChannel;
    private static Logger mLog = Logger.getLogger(WebSocketEngine.class);
    private int listenerPort;
    private int sslPort;
    private WebSocketService webSocketService;
    private WSProxyServer proxyServer;

    public void start(WebSocketService webSocketService) {
        ServerBootstrap bootstrap;
        NioServerSocketChannelFactory factory;
        this.webSocketService = webSocketService;
        if (webSocketService.isProxyEnabled()) {
            this.proxyServer = new WSProxyServer(webSocketService.getPort());
            this.proxyServer.start();
            CFLogs.SERVER_LOG.info((Object)("WebSocket proxy server listens on port: " + webSocketService.getPort()));
            this.isRunning = true;
            return;
        }
        if (webSocketService.isNormalPortListenerEnabled() && webSocketService.getPort() != 0) {
            factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
            bootstrap = new ServerBootstrap((ChannelFactory)factory);
            bootstrap.setPipelineFactory((ChannelPipelineFactory)new WSNettyPipelineFactory(false));
            this.listenerPort = webSocketService.getPort();
            try {
                this.serverSocketChannel = bootstrap.bind((SocketAddress)new InetSocketAddress(webSocketService.getPort()));
            }
            catch (ChannelException ex) {
                if (ex.getCause() instanceof BindException) {
                    CFLogs.SERVER_LOG.info((Object)("WebSocket Server could not be started. The assigned port " + this.listenerPort + " is already in use."));
                }
                return;
            }
            this.serverSocketChannel.getConfig().setConnectTimeoutMillis(webSocketService.getSocketTimeOut() * 1000);
            CFLogs.SERVER_LOG.info((Object)("WebSocket server listens on port: " + this.listenerPort));
            this.isRunning = true;
        }
        if (webSocketService.isSSLEnabled() && webSocketService.getSSLPort() != 0) {
            block8: {
                factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
                bootstrap = new ServerBootstrap((ChannelFactory)factory);
                bootstrap.setPipelineFactory((ChannelPipelineFactory)new WSNettyPipelineFactory(true));
                this.sslPort = webSocketService.getSSLPort();
                try {
                    this.serverSecureSocketChannel = bootstrap.bind((SocketAddress)new InetSocketAddress(webSocketService.getSSLPort()));
                }
                catch (ChannelException ex) {
                    if (!(ex.getCause() instanceof BindException)) break block8;
                    CFLogs.SERVER_LOG.info((Object)("WebSocket Server could not be started. The assigned port " + this.sslPort + " is already in use."));
                }
            }
            this.serverSecureSocketChannel.getConfig().setConnectTimeoutMillis(webSocketService.getSocketTimeOut() * 1000);
            CFLogs.SERVER_LOG.info((Object)("WebSocket  secure (SSL) server listens on port: " + this.sslPort));
            this.isRunning = true;
        }
    }

    public void stop() {
        this.isRunning = false;
        if (this.webSocketService != null && this.webSocketService.isProxyEnabled() && this.proxyServer != null) {
            this.proxyServer.shutdown();
        }
        if (this.serverSocketChannel != null) {
            this.serverSocketChannel.close();
            this.serverSocketChannel.getFactory().releaseExternalResources();
        }
        if (this.serverSecureSocketChannel != null) {
            this.serverSecureSocketChannel.close();
            this.serverSecureSocketChannel.getFactory().releaseExternalResources();
        }
        if (this.webSocketService != null && this.webSocketService.isEnterpriseClusterEnabled()) {
            WebSocketClusterManager clusterManager = WebSocketClusterManager.getInstance();
            clusterManager.stopCluster();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

