/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.field;

import com.lowagie.text.Font;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfField;
import java.io.IOException;
import java.io.OutputStream;

public class RtfTOCEntry
extends RtfField {
    private static final byte[] TEXT_HIDDEN_ON = "\\v".getBytes();
    private static final byte[] TEXT_HIDDEN_OFF = "\\v0".getBytes();
    private static final byte[] TOC_ENTRY_PAGE_NUMBER = "\\tc".getBytes();
    private static final byte[] TOC_ENTRY_NO_PAGE_NUMBER = "\\tcn".getBytes();
    private String entry = "";
    private boolean showPageNumber = true;

    public RtfTOCEntry(String string) {
        super((RtfDocument)null, new Font());
        if (string != null) {
            this.entry = string;
        }
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(TEXT_HIDDEN_ON);
        outputStream.write(OPEN_GROUP);
        if (this.showPageNumber) {
            outputStream.write(TOC_ENTRY_PAGE_NUMBER);
        } else {
            outputStream.write(TOC_ENTRY_NO_PAGE_NUMBER);
        }
        outputStream.write(DELIMITER);
        this.document.filterSpecialChar(outputStream, this.entry, true, false);
        outputStream.write(CLOSE_GROUP);
        outputStream.write(TEXT_HIDDEN_OFF);
    }

    public void setShowPageNumber(boolean bl) {
        this.showPageNumber = bl;
    }

    protected void writeFieldInstContent(OutputStream outputStream) throws IOException {
    }

    protected void writeFieldResultContent(OutputStream outputStream) throws IOException {
    }
}

