/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PdfImage
extends PdfStream {
    static final int TRANSFERSIZE = 4096;
    protected PdfName name = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PdfImage(Image image, String string, PdfIndirectReference pdfIndirectReference) throws BadPdfFormatException {
        this.name = new PdfName(string);
        this.put(PdfName.TYPE, PdfName.XOBJECT);
        this.put(PdfName.SUBTYPE, PdfName.IMAGE);
        this.put(PdfName.WIDTH, new PdfNumber(image.getWidth()));
        this.put(PdfName.HEIGHT, new PdfNumber(image.getHeight()));
        if (image.getLayer() != null) {
            this.put(PdfName.OC, image.getLayer().getRef());
        }
        if (image.isMask() && (image.getBpc() == 1 || image.getBpc() > 255)) {
            this.put(PdfName.IMAGEMASK, PdfBoolean.PDFTRUE);
        }
        if (pdfIndirectReference != null) {
            if (image.isSmask()) {
                this.put(PdfName.SMASK, pdfIndirectReference);
            } else {
                this.put(PdfName.MASK, pdfIndirectReference);
            }
        }
        if (image.isMask() && image.isInverted()) {
            this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
        }
        if (image.isInterpolation()) {
            this.put(PdfName.INTERPOLATE, PdfBoolean.PDFTRUE);
        }
        InputStream inputStream = null;
        try {
            String string2;
            if (image.isImgRaw()) {
                PdfDictionary pdfDictionary;
                int n;
                int n2 = image.getColorspace();
                int[] nArray = image.getTransparency();
                if (nArray != null && !image.isMask() && pdfIndirectReference == null) {
                    String string3 = "[";
                    for (n = 0; n < nArray.length; ++n) {
                        string3 = string3 + nArray[n] + " ";
                    }
                    string3 = string3 + "]";
                    this.put(PdfName.MASK, new PdfLiteral(string3));
                }
                this.bytes = image.getRawData();
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                int n3 = image.getBpc();
                if (n3 > 255) {
                    if (!image.isMask()) {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                    }
                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(1));
                    this.put(PdfName.FILTER, PdfName.CCITTFAXDECODE);
                    n = n3 - 257;
                    PdfDictionary pdfDictionary2 = new PdfDictionary();
                    if (n != 0) {
                        pdfDictionary2.put(PdfName.K, new PdfNumber(n));
                    }
                    if ((n2 & 1) != 0) {
                        pdfDictionary2.put(PdfName.BLACKIS1, PdfBoolean.PDFTRUE);
                    }
                    if ((n2 & 2) != 0) {
                        pdfDictionary2.put(PdfName.ENCODEDBYTEALIGN, PdfBoolean.PDFTRUE);
                    }
                    if ((n2 & 4) != 0) {
                        pdfDictionary2.put(PdfName.ENDOFLINE, PdfBoolean.PDFTRUE);
                    }
                    if ((n2 & 8) != 0) {
                        pdfDictionary2.put(PdfName.ENDOFBLOCK, PdfBoolean.PDFFALSE);
                    }
                    pdfDictionary2.put(PdfName.COLUMNS, new PdfNumber(image.getWidth()));
                    pdfDictionary2.put(PdfName.ROWS, new PdfNumber(image.getHeight()));
                    this.put(PdfName.DECODEPARMS, pdfDictionary2);
                    return;
                }
                switch (n2) {
                    case 1: {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                        if (!image.isInverted()) break;
                        this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
                        break;
                    }
                    case 3: {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                        if (!image.isInverted()) break;
                        this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0]"));
                        break;
                    }
                    default: {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                        if (!image.isInverted()) break;
                        this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                    }
                }
                if ((pdfDictionary = image.getAdditional()) != null) {
                    this.putAll(pdfDictionary);
                }
                if (image.isMask() && (image.getBpc() == 1 || image.getBpc() > 8)) {
                    this.remove(PdfName.COLORSPACE);
                }
                this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(image.getBpc()));
                if (image.isDeflated()) {
                    this.put(PdfName.FILTER, PdfName.FLATEDECODE);
                    return;
                }
                this.flateCompress();
                return;
            }
            if (image.getRawData() == null) {
                inputStream = image.getUrl().openStream();
                string2 = image.getUrl().toString();
            } else {
                inputStream = new ByteArrayInputStream(image.getRawData());
                string2 = "Byte array";
            }
            switch (image.type()) {
                case 32: {
                    this.put(PdfName.FILTER, PdfName.DCTDECODE);
                    switch (image.getColorspace()) {
                        case 1: {
                            this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                            break;
                        }
                        case 3: {
                            this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                            break;
                        }
                        default: {
                            this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                            if (!image.isInverted()) break;
                            this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                        }
                    }
                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                    if (image.getRawData() != null) {
                        this.bytes = image.getRawData();
                        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                        return;
                    }
                    this.streamBytes = new ByteArrayOutputStream();
                    PdfImage.transferBytes(inputStream, this.streamBytes, -1);
                    break;
                }
                case 33: {
                    this.put(PdfName.FILTER, PdfName.JPXDECODE);
                    if (image.getColorspace() > 0) {
                        switch (image.getColorspace()) {
                            case 1: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                break;
                            }
                            case 3: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                break;
                            }
                            default: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                            }
                        }
                        this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(image.getBpc()));
                    }
                    if (image.getRawData() != null) {
                        this.bytes = image.getRawData();
                        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                        return;
                    }
                    this.streamBytes = new ByteArrayOutputStream();
                    PdfImage.transferBytes(inputStream, this.streamBytes, -1);
                    break;
                }
                default: {
                    throw new BadPdfFormatException(string2 + " is an unknown Image format.");
                }
            }
            this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            return;
        }
        catch (IOException iOException) {
            throw new BadPdfFormatException(iOException.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public PdfName name() {
        return this.name;
    }

    static void transferBytes(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[4096];
        if (n < 0) {
            n = 0x7FFFFFF;
        }
        while (n != 0) {
            int n2 = inputStream.read(byArray, 0, Math.min(n, 4096));
            if (n2 < 0) {
                return;
            }
            outputStream.write(byArray, 0, n2);
            n -= n2;
        }
    }

    protected void importAll(PdfImage pdfImage) {
        this.name = pdfImage.name;
        this.compressed = pdfImage.compressed;
        this.streamBytes = pdfImage.streamBytes;
        this.bytes = pdfImage.bytes;
        this.hashMap = pdfImage.hashMap;
    }
}

