/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.org.json;

public class JSONMLParserConfiguration {
    public static final int UNDEFINED_MAXIMUM_NESTING_DEPTH = -1;
    public static final int DEFAULT_MAXIMUM_NESTING_DEPTH = 512;
    public static final JSONMLParserConfiguration ORIGINAL = new JSONMLParserConfiguration();
    public static final JSONMLParserConfiguration KEEP_STRINGS = new JSONMLParserConfiguration().withKeepStrings(true);
    private boolean keepStrings;
    private int maxNestingDepth = 512;

    public JSONMLParserConfiguration() {
        this.keepStrings = false;
    }

    private JSONMLParserConfiguration(boolean bl2, int n2) {
        this.keepStrings = bl2;
        this.maxNestingDepth = n2;
    }

    protected JSONMLParserConfiguration clone() {
        return new JSONMLParserConfiguration(this.keepStrings, this.maxNestingDepth);
    }

    public boolean isKeepStrings() {
        return this.keepStrings;
    }

    public JSONMLParserConfiguration withKeepStrings(boolean bl2) {
        JSONMLParserConfiguration jSONMLParserConfiguration = this.clone();
        jSONMLParserConfiguration.keepStrings = bl2;
        return jSONMLParserConfiguration;
    }

    public int getMaxNestingDepth() {
        return this.maxNestingDepth;
    }

    public JSONMLParserConfiguration withMaxNestingDepth(int n2) {
        JSONMLParserConfiguration jSONMLParserConfiguration = this.clone();
        jSONMLParserConfiguration.maxNestingDepth = n2 > -1 ? n2 : -1;
        return jSONMLParserConfiguration;
    }
}

