/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.net.minidev.json.writer;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.JsonReader;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.JsonReaderI;

public class ArraysMapper<T>
extends JsonReaderI<T> {
    public static JsonReaderI<int[]> MAPPER_PRIM_INT = new ArraysMapper<int[]>(null){

        @Override
        public int[] convert(Object object) {
            int n2 = 0;
            int[] nArray = new int[((List)object).size()];
            for (Object e2 : (List)object) {
                nArray[n2++] = ((Number)e2).intValue();
            }
            return nArray;
        }
    };
    public static JsonReaderI<Integer[]> MAPPER_INT = new ArraysMapper<Integer[]>(null){

        @Override
        public Integer[] convert(Object object) {
            int n2 = 0;
            Integer[] integerArray = new Integer[((List)object).size()];
            for (Object e2 : (List)object) {
                if (e2 == null) continue;
                integerArray[n2] = e2 instanceof Integer ? (Integer)e2 : Integer.valueOf(((Number)e2).intValue());
                ++n2;
            }
            return integerArray;
        }
    };
    public static JsonReaderI<short[]> MAPPER_PRIM_SHORT = new ArraysMapper<short[]>(null){

        @Override
        public short[] convert(Object object) {
            int n2 = 0;
            short[] sArray = new short[((List)object).size()];
            for (Object e2 : (List)object) {
                sArray[n2++] = ((Number)e2).shortValue();
            }
            return sArray;
        }
    };
    public static JsonReaderI<Short[]> MAPPER_SHORT = new ArraysMapper<Short[]>(null){

        @Override
        public Short[] convert(Object object) {
            int n2 = 0;
            Short[] shortArray = new Short[((List)object).size()];
            for (Object e2 : (List)object) {
                if (e2 == null) continue;
                shortArray[n2] = e2 instanceof Short ? (Short)e2 : Short.valueOf(((Number)e2).shortValue());
                ++n2;
            }
            return shortArray;
        }
    };
    public static JsonReaderI<byte[]> MAPPER_PRIM_BYTE = new ArraysMapper<byte[]>(null){

        @Override
        public byte[] convert(Object object) {
            int n2 = 0;
            byte[] byArray = new byte[((List)object).size()];
            for (Object e2 : (List)object) {
                byArray[n2++] = ((Number)e2).byteValue();
            }
            return byArray;
        }
    };
    public static JsonReaderI<Byte[]> MAPPER_BYTE = new ArraysMapper<Byte[]>(null){

        @Override
        public Byte[] convert(Object object) {
            int n2 = 0;
            Byte[] byteArray = new Byte[((List)object).size()];
            for (Object e2 : (List)object) {
                if (e2 == null) continue;
                byteArray[n2] = e2 instanceof Byte ? (Byte)e2 : Byte.valueOf(((Number)e2).byteValue());
                ++n2;
            }
            return byteArray;
        }
    };
    public static JsonReaderI<char[]> MAPPER_PRIM_CHAR = new ArraysMapper<char[]>(null){

        @Override
        public char[] convert(Object object) {
            int n2 = 0;
            char[] cArray = new char[((List)object).size()];
            for (Object e2 : (List)object) {
                cArray[n2++] = e2.toString().charAt(0);
            }
            return cArray;
        }
    };
    public static JsonReaderI<Character[]> MAPPER_CHAR = new ArraysMapper<Character[]>(null){

        @Override
        public Character[] convert(Object object) {
            int n2 = 0;
            Character[] characterArray = new Character[((List)object).size()];
            for (Object e2 : (List)object) {
                if (e2 == null) continue;
                characterArray[n2] = Character.valueOf(e2.toString().charAt(0));
                ++n2;
            }
            return characterArray;
        }
    };
    public static JsonReaderI<long[]> MAPPER_PRIM_LONG = new ArraysMapper<long[]>(null){

        @Override
        public long[] convert(Object object) {
            int n2 = 0;
            long[] lArray = new long[((List)object).size()];
            for (Object e2 : (List)object) {
                lArray[n2++] = ((Number)e2).intValue();
            }
            return lArray;
        }
    };
    public static JsonReaderI<Long[]> MAPPER_LONG = new ArraysMapper<Long[]>(null){

        @Override
        public Long[] convert(Object object) {
            int n2 = 0;
            Long[] longArray = new Long[((List)object).size()];
            for (Object e2 : (List)object) {
                if (e2 == null) continue;
                longArray[n2] = e2 instanceof Float ? (Long)e2 : Long.valueOf(((Number)e2).longValue());
                ++n2;
            }
            return longArray;
        }
    };
    public static JsonReaderI<float[]> MAPPER_PRIM_FLOAT = new ArraysMapper<float[]>(null){

        @Override
        public float[] convert(Object object) {
            int n2 = 0;
            float[] fArray = new float[((List)object).size()];
            for (Object e2 : (List)object) {
                fArray[n2++] = ((Number)e2).floatValue();
            }
            return fArray;
        }
    };
    public static JsonReaderI<Float[]> MAPPER_FLOAT = new ArraysMapper<Float[]>(null){

        @Override
        public Float[] convert(Object object) {
            int n2 = 0;
            Float[] floatArray = new Float[((List)object).size()];
            for (Object e2 : (List)object) {
                if (e2 == null) continue;
                floatArray[n2] = e2 instanceof Float ? (Float)e2 : Float.valueOf(((Number)e2).floatValue());
                ++n2;
            }
            return floatArray;
        }
    };
    public static JsonReaderI<double[]> MAPPER_PRIM_DOUBLE = new ArraysMapper<double[]>(null){

        @Override
        public double[] convert(Object object) {
            int n2 = 0;
            double[] dArray = new double[((List)object).size()];
            for (Object e2 : (List)object) {
                dArray[n2++] = ((Number)e2).doubleValue();
            }
            return dArray;
        }
    };
    public static JsonReaderI<Double[]> MAPPER_DOUBLE = new ArraysMapper<Double[]>(null){

        @Override
        public Double[] convert(Object object) {
            int n2 = 0;
            Double[] doubleArray = new Double[((List)object).size()];
            for (Object e2 : (List)object) {
                if (e2 == null) continue;
                doubleArray[n2] = e2 instanceof Double ? (Double)e2 : Double.valueOf(((Number)e2).doubleValue());
                ++n2;
            }
            return doubleArray;
        }
    };
    public static JsonReaderI<boolean[]> MAPPER_PRIM_BOOL = new ArraysMapper<boolean[]>(null){

        @Override
        public boolean[] convert(Object object) {
            int n2 = 0;
            boolean[] blArray = new boolean[((List)object).size()];
            for (Object e2 : (List)object) {
                blArray[n2++] = (Boolean)e2;
            }
            return blArray;
        }
    };
    public static JsonReaderI<Boolean[]> MAPPER_BOOL = new ArraysMapper<Boolean[]>(null){

        @Override
        public Boolean[] convert(Object object) {
            int n2 = 0;
            Boolean[] booleanArray = new Boolean[((List)object).size()];
            for (Object e2 : (List)object) {
                if (e2 == null) continue;
                if (e2 instanceof Boolean) {
                    booleanArray[n2] = (boolean)((Boolean)e2);
                } else if (e2 instanceof Number) {
                    booleanArray[n2] = ((Number)e2).intValue() != 0;
                } else {
                    throw new RuntimeException("can not convert " + e2 + " toBoolean");
                }
                ++n2;
            }
            return booleanArray;
        }
    };

    public ArraysMapper(JsonReader jsonReader) {
        super(jsonReader);
    }

    @Override
    public Object createArray() {
        return new ArrayList();
    }

    @Override
    public void addValue(Object object, Object object2) {
        ((List)object).add(object2);
    }

    @Override
    public T convert(Object object) {
        return (T)object;
    }

    public static class GenericMapper<T>
    extends ArraysMapper<T> {
        final Class<?> componentType;
        JsonReaderI<?> subMapper;

        public GenericMapper(JsonReader jsonReader, Class<T> clazz) {
            super(jsonReader);
            this.componentType = clazz.getComponentType();
        }

        @Override
        public T convert(Object object) {
            int n2 = 0;
            Object[] objectArray = (Object[])Array.newInstance(this.componentType, ((List)object).size());
            for (Object e2 : (List)object) {
                objectArray[n2++] = e2;
            }
            return (T)objectArray;
        }

        @Override
        public JsonReaderI<?> startArray(String string) {
            if (this.subMapper == null) {
                this.subMapper = this.base.getMapper(this.componentType);
            }
            return this.subMapper;
        }

        @Override
        public JsonReaderI<?> startObject(String string) {
            if (this.subMapper == null) {
                this.subMapper = this.base.getMapper(this.componentType);
            }
            return this.subMapper;
        }
    }
}

