/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators;

import java.text.ParseException;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators.BadJWTExceptions;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class LogoutTokenClaimsVerifier
implements JWTClaimsSetVerifier {
    private final Issuer expectedIssuer;
    private final ClientID expectedClientID;

    public LogoutTokenClaimsVerifier(Issuer issuer, ClientID clientID) {
        if (issuer == null) {
            throw new IllegalArgumentException("The expected ID token issuer must not be null");
        }
        this.expectedIssuer = issuer;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.expectedClientID = clientID;
    }

    public Issuer getExpectedIssuer() {
        return this.expectedIssuer;
    }

    public ClientID getClientID() {
        return this.expectedClientID;
    }

    public void verify(JWTClaimsSet jWTClaimsSet, SecurityContext securityContext) throws BadJWTException {
        Object object;
        try {
            object = jWTClaimsSet.getJSONObjectClaim("events");
            if (object == null) {
                throw new BadJWTException("Missing JWT events (events) claim");
            }
            if (JSONObjectUtils.getJSONObject(object, "http://schemas.openid.net/event/backchannel-logout") == null) {
                throw new BadJWTException("Missing event type, required http://schemas.openid.net/event/backchannel-logout");
            }
        }
        catch (ParseException parseException) {
            throw new BadJWTException("Invalid JWT events (events) claim", parseException);
        }
        object = jWTClaimsSet.getIssuer();
        if (object == null) {
            throw BadJWTExceptions.MISSING_ISS_CLAIM_EXCEPTION;
        }
        if (!this.getExpectedIssuer().getValue().equals(object)) {
            throw new BadJWTException("Unexpected JWT issuer: " + (String)object);
        }
        List<String> list = jWTClaimsSet.getAudience();
        if (list == null || list.isEmpty()) {
            throw BadJWTExceptions.MISSING_AUD_CLAIM_EXCEPTION;
        }
        if (!list.contains(this.expectedClientID.getValue())) {
            throw new BadJWTException("Unexpected JWT audience: " + list);
        }
        if (jWTClaimsSet.getIssueTime() == null) {
            throw BadJWTExceptions.MISSING_IAT_CLAIM_EXCEPTION;
        }
        if (jWTClaimsSet.getJWTID() == null) {
            throw new BadJWTException("Missing JWT ID (jti) claim");
        }
        try {
            if (jWTClaimsSet.getSubject() == null && jWTClaimsSet.getStringClaim("sid") == null) {
                throw new BadJWTException("Missing subject (sub) and / or session ID (sid) claim(s)");
            }
        }
        catch (ParseException parseException) {
            throw new BadJWTException("Invalid session ID (sid) claim");
        }
        if (jWTClaimsSet.getClaim("nonce") != null) {
            throw new BadJWTException("Found illegal nonce (nonce) claim");
        }
    }
}

