/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.ClockSkewAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Nonce;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators.BadJWTExceptions;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class IDTokenClaimsVerifier
implements ClockSkewAware,
JWTClaimsSetVerifier {
    private final Issuer expectedIssuer;
    private final ClientID expectedClientID;
    private final Nonce expectedNonce;
    private int maxClockSkew;

    public IDTokenClaimsVerifier(Issuer issuer, ClientID clientID, Nonce nonce, int n2) {
        if (issuer == null) {
            throw new IllegalArgumentException("The expected ID token issuer must not be null");
        }
        this.expectedIssuer = issuer;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.expectedClientID = clientID;
        this.expectedNonce = nonce;
        this.setMaxClockSkew(n2);
    }

    public Issuer getExpectedIssuer() {
        return this.expectedIssuer;
    }

    public ClientID getClientID() {
        return this.expectedClientID;
    }

    public Nonce getExpectedNonce() {
        return this.expectedNonce;
    }

    @Override
    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    @Override
    public void setMaxClockSkew(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The max clock skew must be zero or positive");
        }
        this.maxClockSkew = n2;
    }

    public void verify(JWTClaimsSet jWTClaimsSet, SecurityContext securityContext) throws BadJWTException {
        Object object;
        String string = jWTClaimsSet.getIssuer();
        if (string == null) {
            throw BadJWTExceptions.MISSING_ISS_CLAIM_EXCEPTION;
        }
        if (!this.expectedIssuer.getValue().equals(string)) {
            throw new BadJWTException("Unexpected JWT issuer: " + string);
        }
        if (jWTClaimsSet.getSubject() == null) {
            throw BadJWTExceptions.MISSING_SUB_CLAIM_EXCEPTION;
        }
        List<String> list = jWTClaimsSet.getAudience();
        if (CollectionUtils.isEmpty(list)) {
            throw BadJWTExceptions.MISSING_AUD_CLAIM_EXCEPTION;
        }
        if (!list.contains(this.expectedClientID.getValue())) {
            throw new BadJWTException("Unexpected JWT audience: " + list);
        }
        if (list.size() > 1) {
            try {
                object = jWTClaimsSet.getStringClaim("azp");
            }
            catch (ParseException parseException) {
                throw new BadJWTException("Invalid JWT authorized party (azp) claim: " + parseException.getMessage());
            }
            if (object == null) {
                throw new BadJWTException("JWT authorized party (azp) claim required when multiple (aud) audiences present");
            }
            if (!this.expectedClientID.getValue().equals(object)) {
                throw new BadJWTException("Unexpected JWT authorized party (azp) claim: " + (String)object);
            }
        }
        if ((object = jWTClaimsSet.getExpirationTime()) == null) {
            throw BadJWTExceptions.MISSING_EXP_CLAIM_EXCEPTION;
        }
        Date date = jWTClaimsSet.getIssueTime();
        if (date == null) {
            throw BadJWTExceptions.MISSING_IAT_CLAIM_EXCEPTION;
        }
        Date date2 = new Date();
        if (!DateUtils.isAfter((Date)object, date2, this.maxClockSkew)) {
            throw BadJWTExceptions.EXPIRED_EXCEPTION;
        }
        if (!date.equals(date2) && !DateUtils.isBefore(date, date2, this.maxClockSkew)) {
            throw BadJWTExceptions.IAT_CLAIM_AHEAD_EXCEPTION;
        }
        if (this.expectedNonce != null) {
            String string2;
            try {
                string2 = jWTClaimsSet.getStringClaim("nonce");
            }
            catch (ParseException parseException) {
                throw new BadJWTException("Invalid JWT nonce (nonce) claim: " + parseException.getMessage());
            }
            if (string2 == null) {
                throw BadJWTExceptions.MISSING_NONCE_CLAIM_EXCEPTION;
            }
            if (!this.expectedNonce.getValue().equals(string2)) {
                throw new BadJWTException("Unexpected JWT nonce (nonce) claim: " + string2);
            }
        }
    }
}

