/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.id;

import java.util.AbstractMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.id.InvalidPairwiseSubjectException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.id.PairwiseSubjectCodec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.id.SectorID;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;
import org.cryptomator.siv.SivMode;

@ThreadSafe
public class SIVAESBasedPairwiseSubjectCodec
extends PairwiseSubjectCodec {
    private static final SivMode AES_SIV = new SivMode();
    private final byte[] aesCtrKey;
    private final byte[] macKey;
    private final int padSubjectToLength;

    public SIVAESBasedPairwiseSubjectCodec(SecretKey secretKey) {
        this(secretKey, -1);
    }

    public SIVAESBasedPairwiseSubjectCodec(SecretKey secretKey, int n2) {
        super(null);
        if (secretKey == null) {
            throw new IllegalArgumentException("The SIV AES secret key must not be null");
        }
        byte[] byArray = secretKey.getEncoded();
        switch (byArray.length) {
            case 32: {
                this.aesCtrKey = ByteUtils.subArray(byArray, 0, 16);
                this.macKey = ByteUtils.subArray(byArray, 16, 16);
                break;
            }
            case 48: {
                this.aesCtrKey = ByteUtils.subArray(byArray, 0, 24);
                this.macKey = ByteUtils.subArray(byArray, 24, 24);
                break;
            }
            case 64: {
                this.aesCtrKey = ByteUtils.subArray(byArray, 0, 32);
                this.macKey = ByteUtils.subArray(byArray, 32, 32);
                break;
            }
            default: {
                throw new IllegalArgumentException("The SIV AES secret key length must be 256, 384 or 512 bits");
            }
        }
        this.padSubjectToLength = n2;
    }

    public SecretKey getSecretKey() {
        return new SecretKeySpec(ByteUtils.concat(this.aesCtrKey, this.macKey), "AES");
    }

    public int getPadSubjectToLength() {
        return this.padSubjectToLength;
    }

    private static String escapeSeparator(String string) {
        return string.replace("|", "\\|");
    }

    @Override
    public Subject encode(SectorID sectorID, Subject subject) {
        String string = SIVAESBasedPairwiseSubjectCodec.escapeSeparator(sectorID.getValue());
        String string2 = SIVAESBasedPairwiseSubjectCodec.escapeSeparator(subject.getValue());
        StringBuilder stringBuilder = new StringBuilder();
        if (this.padSubjectToLength > 0) {
            int n2 = this.padSubjectToLength - string2.length();
            if (n2 == 1) {
                stringBuilder = new StringBuilder("|");
            } else if (n2 > 1) {
                stringBuilder = new StringBuilder("|");
                int n3 = n2;
                while (--n3 > 0) {
                    stringBuilder.append("0");
                }
            }
        }
        String string3 = string + '|' + string2 + stringBuilder;
        byte[] byArray = string3.getBytes(CHARSET);
        byte[] byArray2 = AES_SIV.encrypt(this.aesCtrKey, this.macKey, byArray, (byte[][])new byte[0][]);
        return new Subject(Base64URL.encode(byArray2).toString());
    }

    @Override
    public Map.Entry<SectorID, Subject> decode(Subject subject) throws InvalidPairwiseSubjectException {
        byte[] byArray;
        byte[] byArray2 = new Base64URL(subject.getValue()).decode();
        try {
            byArray = AES_SIV.decrypt(this.aesCtrKey, this.macKey, byArray2, (byte[][])new byte[0][]);
        }
        catch (Exception exception) {
            throw new InvalidPairwiseSubjectException("Decryption failed: " + exception.getMessage(), exception);
        }
        String[] stringArray = new String(byArray, CHARSET).split("(?<!\\\\)\\|");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = stringArray[i2].replace("\\|", "|");
        }
        if (stringArray.length > 3) {
            throw new InvalidPairwiseSubjectException("Invalid format: Unexpected number of tokens: " + stringArray.length);
        }
        return new AbstractMap.SimpleImmutableEntry<SectorID, Subject>(new SectorID(stringArray[0]), new Subject(stringArray[1]));
    }
}

