/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust;

import java.security.ProviderException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.FederationMetadataType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicyEntry;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.PolicyOperationCombinationValidator;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class TrustChain {
    private final EntityStatement leaf;
    private final List<EntityStatement> superiors;
    private Date exp;

    public TrustChain(EntityStatement entityStatement, List<EntityStatement> list) {
        if (entityStatement == null) {
            throw new IllegalArgumentException("The leaf statement must not be null");
        }
        this.leaf = entityStatement;
        if (CollectionUtils.isEmpty(list)) {
            throw new IllegalArgumentException("There must be at least one superior statement (issued by the trust anchor)");
        }
        this.superiors = list;
        if (!TrustChain.hasValidIssuerSubjectChain(entityStatement, list)) {
            throw new IllegalArgumentException("Broken subject - issuer chain");
        }
    }

    private static boolean hasValidIssuerSubjectChain(EntityStatement entityStatement, List<EntityStatement> list) {
        Subject subject = entityStatement.getClaimsSet().getSubject();
        for (EntityStatement entityStatement2 : list) {
            if (!subject.equals(entityStatement2.getClaimsSet().getSubject())) {
                return false;
            }
            subject = new Subject(entityStatement2.getClaimsSet().getIssuer().getValue());
        }
        return true;
    }

    public EntityStatement getLeafSelfStatement() {
        return this.leaf;
    }

    public List<EntityStatement> getSuperiorStatements() {
        return this.superiors;
    }

    public EntityID getTrustAnchorEntityID() {
        return this.getSuperiorStatements().get(this.getSuperiorStatements().size() - 1).getClaimsSet().getIssuerEntityID();
    }

    public int length() {
        return this.getSuperiorStatements().size();
    }

    public MetadataPolicy resolveCombinedMetadataPolicy(FederationMetadataType federationMetadataType) throws PolicyViolationException {
        return this.resolveCombinedMetadataPolicy(federationMetadataType, MetadataPolicyEntry.DEFAULT_POLICY_COMBINATION_VALIDATOR);
    }

    public MetadataPolicy resolveCombinedMetadataPolicy(FederationMetadataType federationMetadataType, PolicyOperationCombinationValidator policyOperationCombinationValidator) throws PolicyViolationException {
        LinkedList<MetadataPolicy> linkedList = new LinkedList<MetadataPolicy>();
        for (EntityStatement entityStatement : this.getSuperiorStatements()) {
            MetadataPolicy metadataPolicy = entityStatement.getClaimsSet().getMetadataPolicy(federationMetadataType);
            if (metadataPolicy == null) continue;
            linkedList.add(metadataPolicy);
        }
        return MetadataPolicy.combine(linkedList, policyOperationCombinationValidator);
    }

    public Iterator<EntityStatement> iteratorFromLeaf() {
        final AtomicReference<EntityStatement> atomicReference = new AtomicReference<EntityStatement>(this.getLeafSelfStatement());
        final Iterator<EntityStatement> iterator = this.getSuperiorStatements().iterator();
        return new Iterator<EntityStatement>(){

            @Override
            public boolean hasNext() {
                return atomicReference.get() != null;
            }

            @Override
            public EntityStatement next() {
                EntityStatement entityStatement = (EntityStatement)atomicReference.get();
                if (entityStatement == null) {
                    return null;
                }
                if (entityStatement.equals(TrustChain.this.getLeafSelfStatement())) {
                    atomicReference.set(iterator.next());
                } else if (iterator.hasNext()) {
                    atomicReference.set(iterator.next());
                } else {
                    atomicReference.set(null);
                }
                return entityStatement;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Date resolveExpirationTime() {
        if (this.exp != null) {
            return this.exp;
        }
        Iterator<EntityStatement> iterator = this.iteratorFromLeaf();
        Date date = null;
        while (iterator.hasNext()) {
            Date date2 = iterator.next().getClaimsSet().getExpirationTime();
            if (date == null) {
                date = date2;
                continue;
            }
            if (!date2.before(date)) continue;
            date = date2;
        }
        this.exp = date;
        return this.exp;
    }

    public void verifySignatures(JWKSet jWKSet) throws BadJOSEException, JOSEException {
        Base64URL base64URL;
        try {
            base64URL = this.leaf.verifySignatureOfSelfStatement();
        }
        catch (BadJOSEException badJOSEException) {
            throw new BadJOSEException("Invalid leaf statement: " + badJOSEException.getMessage(), badJOSEException);
        }
        for (int i2 = 0; i2 < this.superiors.size(); ++i2) {
            EntityStatement entityStatement = this.superiors.get(i2);
            JWKSet jWKSet2 = i2 + 1 == this.superiors.size() ? jWKSet : this.superiors.get(i2 + 1).getClaimsSet().getJWKSet();
            if (!TrustChain.hasJWKWithThumbprint(entityStatement.getClaimsSet().getJWKSet(), base64URL)) {
                throw new BadJOSEException("Signing JWK with thumbprint " + base64URL + " not found in entity statement issued from superior " + entityStatement.getClaimsSet().getIssuerEntityID());
            }
            try {
                base64URL = entityStatement.verifySignature(jWKSet2);
                continue;
            }
            catch (BadJOSEException badJOSEException) {
                throw new BadJOSEException("Invalid statement from " + entityStatement.getClaimsSet().getIssuer() + ": " + badJOSEException.getMessage(), badJOSEException);
            }
        }
    }

    private static boolean hasJWKWithThumbprint(JWKSet jWKSet, Base64URL base64URL) {
        if (jWKSet == null) {
            return false;
        }
        for (JWK jWK : jWKSet.getKeys()) {
            try {
                if (!base64URL.equals(jWK.computeThumbprint())) continue;
                return true;
            }
            catch (JOSEException jOSEException) {
                throw new ProviderException(jOSEException.getMessage(), jOSEException);
            }
        }
        return false;
    }
}

